@echo off
:: RepairIQ Sync Agent - Windows Service Uninstaller v1.3.7
:: Removes service AND scheduled task
:: Double-click this file (Run as Administrator) to uninstall

setlocal enabledelayedexpansion

set "INSTALL_DIR=C:\Program Files\RepairIQ"

echo =====================================
echo RepairIQ Sync Agent - Service Uninstaller
echo Version 1.3.7
echo =====================================
echo.

:: Check for Administrator privileges
net session >nul 2>&1
if %errorLevel% neq 0 (
    echo ERROR: Administrator privileges required!
    echo.
    echo Please right-click this file and select "Run as administrator"
    echo.
    pause
    exit /b 1
)

echo WARNING: This will remove the RepairIQ Sync Agent Windows Service
echo          and the auto-update scheduled task.
echo.
echo Your data folders will NOT be deleted:
echo   - C:\RepairIQ-EMS
echo   - C:\RepairIQ-EMS\Processed
echo   - C:\RepairIQ-EMS\logs
echo.
set /p confirm="Are you sure you want to continue? (Y/N): "
if /i not "%confirm%"=="Y" (
    echo.
    echo Uninstallation cancelled.
    echo.
    pause
    exit /b 0
)

echo.
echo [1/4] Stopping service...
sc stop RepairIQSyncAgent >nul 2>&1
timeout /t 3 /nobreak >nul
echo       Service stopped
echo.

echo [2/4] Removing Windows Service...
:: Try node-windows uninstall first
if exist "%INSTALL_DIR%\service-uninstall.js" (
    cd /d "%INSTALL_DIR%"
    node service-uninstall.js >nul 2>&1
)
:: Also try sc delete as fallback
sc delete RepairIQSyncAgent >nul 2>&1
timeout /t 2 /nobreak >nul
echo       Service removed
echo.

echo [3/4] Removing Scheduled Task...
schtasks /Delete /TN "RepairIQUpdater" /F >nul 2>&1
echo       Scheduled task removed
echo.

echo [4/4] Cleaning up installation directory...
set /p cleanup="Delete %INSTALL_DIR%? (Y/N): "
if /i "%cleanup%"=="Y" (
    rd /s /q "%INSTALL_DIR%" >nul 2>&1
    echo       Installation directory deleted
) else (
    echo       Keeping installation directory
)
echo.

echo =====================================
echo     UNINSTALLATION COMPLETE!
echo =====================================
echo.
echo The RepairIQ Sync Agent service has been removed.
echo The RepairIQUpdater scheduled task has been removed.
echo.
echo Your data is still saved at:
echo   C:\RepairIQ-EMS
echo.
echo To delete your data, manually delete the C:\RepairIQ-EMS folder.
echo.
echo =====================================
echo.
pause
