/**
 * Auto-Updater for RepairIQ Sync Agent v1.0.9
 *
 * Enterprise-grade auto-update using Windows Scheduled Task:
 * - Downloads update ZIP to fixed location
 * - Verifies SHA256 hash
 * - Triggers scheduled task (runs as SYSTEM)
 * - Task has permission to stop/start services
 * - Automatic rollback on failure
 *
 * Architecture:
 * 1. Service detects update available
 * 2. Service downloads ZIP and verifies hash
 * 3. Service triggers "RepairIQUpdater" scheduled task
 * 4. Task stops service, updates files, starts service
 */
/**
 * Get current local version - ALWAYS reads from package.json (source of truth)
 */
export declare function getCurrentVersion(): string;
/**
 * Start auto-update checker
 */
export declare function startAutoUpdater(apiUrl: string): void;
//# sourceMappingURL=auto-updater.d.ts.map