/**
 * EMS File Parser v1.3.6
 *
 * Parses CCC ONE EMS export files to extract customer/vehicle data.
 * Supports .veh, .own, .clm, .ad1, .ad2 file formats.
 *
 * IMPORTANT: CCC ONE files contain multiple contacts:
 * - Vehicle Owner (OWNR_*) - Who owns the car being repaired
 * - Insured (INSD_*) - Who is on the insurance policy
 *
 * We ALWAYS prioritize Vehicle Owner because that's who the shop contacts.
 */
import { ExcelRowData } from './excel-writer';
/**
 * Extract Excel row data from EMS files
 */
export declare function extractExcelData(baseName: string, watchFolder: string): ExcelRowData | null;
//# sourceMappingURL=ems-parser.d.ts.map