/**
 * Excel Dual-Feed Writer v1.2.1
 *
 * Writes customer/vehicle data to Excel file after successful API upload.
 * Features:
 * - FLEXIBLE COLUMN MAPPING: Works with existing Excel files (any column layout)
 * - Append or update based on VIN (unique identifier)
 * - Preserves all existing data and structure
 * - File locking handling with retry
 * - Background retry queue for locked files
 * - Max row limit (default 1000) - only for NEW files
 */
export interface ExcelRowData {
    customerName: string;
    phone: string;
    email: string;
    year: string;
    make: string;
    model: string;
    vin: string;
    color: string;
    licensePlate: string;
    insuranceCompany: string;
    checkInDate: string;
}
/**
 * Check if Excel feature is enabled
 */
export declare function isExcelEnabled(): boolean;
/**
 * Start background retry processor
 */
export declare function startRetryProcessor(): void;
/**
 * Stop background retry processor
 */
export declare function stopRetryProcessor(): void;
/**
 * Main function to write data to Excel
 * Returns immediately, queues for retry if file is locked
 */
export declare function writeToExcel(data: ExcelRowData): Promise<void>;
/**
 * Initialize Excel writer
 */
export declare function initExcelWriter(): void;
//# sourceMappingURL=excel-writer.d.ts.map