"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var bound_1 = require("./bound");
var deferred_1 = require("./deferred");
function createLock(count, promise) {
    if (promise === void 0) { promise = Promise; }
    return new Semaphore(count, promise);
}
exports.createLock = createLock;
var Semaphore = /** @class */ (function () {
    function Semaphore(size, promise) {
        if (size === void 0) { size = 1; }
        if (promise === void 0) { promise = Promise; }
        this.size = size;
        this.promise = promise;
        this.waiting = [];
        this.locks = 0;
        this.requestedLockCount = 0;
        this.createDeferred = this.promise !== Promise
            ? deferred_1.createDeferredFactory(this.promise)
            : deferred_1.createDeferred;
        if (!size || size < 1) {
            throw new Error('Cannot create Semaphore with size of "' + size + '"');
        }
    }
    Object.defineProperty(Semaphore.prototype, "count", {
        get: function () { return this.locks; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Semaphore.prototype, "pending", {
        get: function () { return this.waiting.length; },
        enumerable: true,
        configurable: true
    });
    Semaphore.prototype.acquire = function (arg) {
        ++this.requestedLockCount;
        arg = (typeof arg !== 'undefined' ? arg : this.requestedLockCount);
        if (this.locks < this.size) {
            this.locks++;
            return this.promise.resolve(arg);
        }
        var lock = this.createDeferred();
        lock.value = arg;
        this.waiting.push(lock);
        return lock.promise;
    };
    Semaphore.prototype.release = function () {
        var lock = this.waiting.shift();
        if (lock) {
            lock.resolve(lock.value);
        }
        else if (--this.locks < 0) {
            throw new Error('Nothing to release...');
        }
    };
    __decorate([
        bound_1.bound
    ], Semaphore.prototype, "release", null);
    return Semaphore;
}());
exports.Semaphore = Semaphore;
