# Installation
> `npm install --save @types/global-agent`

# Summary
This package contains type definitions for global-agent (https://github.com/gajus/global-agent#readme).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/global-agent.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/global-agent/index.d.ts)
````ts
export interface ProxyAgentConfigurationInputType {
    environmentVariableNamespace?: string | undefined;
    forceGlobalAgent?: boolean | undefined;
    socketConnectionTimeout?: number | undefined;
}

export interface ProxyAgentConfigurationType {
    HTTP_PROXY: string | null;
    HTTPS_PROXY: string | null;
    NO_PROXY: string | null;
}

export function bootstrap(configurationInput?: ProxyAgentConfigurationInputType): boolean;
export function createGlobalProxyAgent(
    configurationInput?: ProxyAgentConfigurationInputType,
): ProxyAgentConfigurationType;

````

### Additional Details
 * Last updated: Fri, 21 Feb 2025 17:32:49 GMT
 * Dependencies: none

# Credits
These definitions were written by [Jamie Magee](https://github.com/JamieMagee).
