"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.prepBuildPath = exports.fetchExtractApply = void 0;
var zlib_1 = require("zlib");
var crypto_1 = __importDefault(require("crypto"));
var fs_1 = require("fs");
var promises_1 = require("fs/promises");
var os_1 = __importDefault(require("os"));
var path_1 = __importDefault(require("path"));
var stream_1 = require("stream");
var util_1 = require("util");
var tar_fs_1 = __importDefault(require("tar-fs"));
var places_1 = require("./places");
var utils_1 = require("./utils");
var system_1 = require("./system");
var log_1 = require("./log");
var patches_json_1 = __importDefault(require("../patches/patches.json"));
var buildPath = path_1.default.resolve(process.env.PKG_BUILD_PATH ||
    path_1.default.join(os_1.default.tmpdir(), "pkg.".concat(crypto_1.default.randomBytes(12).toString('hex'))));
var nodePath = path_1.default.join(buildPath, 'node');
var patchesPath = path_1.default.resolve(__dirname, '../patches');
var nodeRepo = 'https://nodejs.org/dist';
var nodeArchivePath = path_1.default.join(places_1.cachePath, 'node');
function getMajor(nodeVersion) {
    var _a = nodeVersion.match(/^v?(\d+)/) || ['', 0], version = _a[1];
    return Number(version) | 0;
}
function getConfigureArgs(major, targetPlatform, targetArch) {
    var args = [];
    // first of all v8_inspector introduces the use
    // of `prime_rehash_policy` symbol that requires
    // GLIBCXX_3.4.18 on some systems
    // also we don't support any kind of debugging
    // against packaged apps, hence v8_inspector is useless
    args.push('--without-inspector');
    if (system_1.hostPlatform === 'alpine') {
        // Statically Link against libgcc and libstdc++ libraries. See vercel/pkg#555.
        // libgcc and libstdc++ grant GCC Runtime Library Exception of GPL
        args.push('--partly-static');
    }
    if (targetPlatform === 'linuxstatic') {
        args.push('--fully-static');
    }
    // Link Time Optimization
    if (major >= 12) {
        if (system_1.hostPlatform !== 'win') {
            args.push('--enable-lto');
        }
    }
    // production binaries do NOT take NODE_OPTIONS from end-users
    args.push('--without-node-options');
    // The dtrace and etw support was removed in https://github.com/nodejs/node/commit/aa3a572e6bee116cde69508dc29478b40f40551a
    if (major <= 18) {
        // DTrace
        args.push('--without-dtrace');
    }
    // bundled npm package manager
    args.push('--without-npm');
    // Small ICU
    if (system_1.hostPlatform !== 'win' || major < 24) {
        args.push('--with-intl=small-icu');
    }
    // Workaround for nodejs/node#39313
    // All supported macOS versions have zlib as a system library
    if (targetPlatform === 'macos') {
        args.push('--shared-zlib');
    }
    // macos cross-build from arm64 to x64
    if (targetPlatform === 'macos' && system_1.hostArch === 'arm64' && targetArch === 'x64') {
        args.push('--dest-os=mac');
        args.push('--dest-cpu=x64');
    }
    return args;
}
function tarFetch(nodeVersion) {
    return __awaiter(this, void 0, void 0, function () {
        var distUrl, tarName, archivePath, hashPath, _a, _b;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0:
                    log_1.log.info('Fetching Node.js source archive from nodejs.org...');
                    distUrl = "".concat(nodeRepo, "/").concat(nodeVersion);
                    tarName = "node-".concat(nodeVersion, ".tar.gz");
                    archivePath = path_1.default.join(nodeArchivePath, tarName);
                    hashPath = path_1.default.join(nodeArchivePath, "".concat(tarName, ".sha256sum"));
                    if ((0, fs_1.existsSync)(hashPath) && (0, fs_1.existsSync)(archivePath)) {
                        return [2 /*return*/];
                    }
                    return [4 /*yield*/, (0, promises_1.rm)(hashPath, { recursive: true, force: true }).catch(function () { return undefined; })];
                case 1:
                    _c.sent();
                    return [4 /*yield*/, (0, promises_1.rm)(archivePath, { recursive: true, force: true }).catch(function () { return undefined; })];
                case 2:
                    _c.sent();
                    return [4 /*yield*/, (0, utils_1.downloadUrl)("".concat(distUrl, "/SHASUMS256.txt"), hashPath)];
                case 3:
                    _c.sent();
                    _a = promises_1.writeFile;
                    _b = [hashPath];
                    return [4 /*yield*/, (0, promises_1.readFile)(hashPath, 'utf8')];
                case 4: return [4 /*yield*/, _a.apply(void 0, _b.concat([(_c.sent())
                            .split('\n')
                            .filter(function (l) { return l.includes(tarName); })[0]]))];
                case 5:
                    _c.sent();
                    return [4 /*yield*/, (0, utils_1.downloadUrl)("".concat(distUrl, "/").concat(tarName), archivePath)];
                case 6:
                    _c.sent();
                    return [2 /*return*/];
            }
        });
    });
}
function tarExtract(nodeVersion, suppressTarOutput) {
    return __awaiter(this, void 0, void 0, function () {
        var tarName, expectedHash, actualHash, pipe, source, gunzip, extract;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    log_1.log.info('Extracting Node.js source archive...');
                    tarName = "node-".concat(nodeVersion, ".tar.gz");
                    return [4 /*yield*/, (0, promises_1.readFile)(path_1.default.join(nodeArchivePath, "".concat(tarName, ".sha256sum")), 'utf8')];
                case 1:
                    expectedHash = (_a.sent()).split(' ')[0];
                    return [4 /*yield*/, (0, utils_1.hash)(path_1.default.join(nodeArchivePath, tarName))];
                case 2:
                    actualHash = _a.sent();
                    if (!(expectedHash !== actualHash)) return [3 /*break*/, 5];
                    return [4 /*yield*/, (0, promises_1.rm)(path_1.default.join(nodeArchivePath, tarName), {
                            recursive: true,
                            force: true,
                        })];
                case 3:
                    _a.sent();
                    return [4 /*yield*/, (0, promises_1.rm)(path_1.default.join(nodeArchivePath, "".concat(tarName, ".sha256sum")), {
                            recursive: true,
                            force: true,
                        })];
                case 4:
                    _a.sent();
                    throw (0, log_1.wasReported)("Hash mismatch for ".concat(tarName));
                case 5:
                    pipe = (0, util_1.promisify)(stream_1.pipeline);
                    source = (0, fs_1.createReadStream)(path_1.default.join(nodeArchivePath, tarName));
                    gunzip = (0, zlib_1.createGunzip)();
                    extract = tar_fs_1.default.extract(nodePath, {
                        strip: 1,
                        map: function (header) {
                            if (!suppressTarOutput) {
                                // disabled for now - can't get cmdline flag to work with all builds
                                // log.info(header.name);
                            }
                            return header;
                        },
                    });
                    return [4 /*yield*/, pipe(source, gunzip, extract)];
                case 6:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
function applyPatches(nodeVersion) {
    return __awaiter(this, void 0, void 0, function () {
        var storedPatches, storedPatch, patches, _i, patches_1, patch, patchPath, args;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    log_1.log.info('Applying patches');
                    storedPatches = patches_json_1.default[nodeVersion];
                    storedPatch = 'patches' in storedPatches ? storedPatches.patches : storedPatches;
                    patches = 'sameAs' in storedPatch
                        ? patches_json_1.default[storedPatch.sameAs]
                        : storedPatch;
                    _i = 0, patches_1 = patches;
                    _a.label = 1;
                case 1:
                    if (!(_i < patches_1.length)) return [3 /*break*/, 4];
                    patch = patches_1[_i];
                    patchPath = path_1.default.join(patchesPath, patch);
                    args = ['-p1', '-i', patchPath];
                    return [4 /*yield*/, (0, utils_1.spawn)('patch', args, { cwd: nodePath, stdio: 'inherit' })];
                case 2:
                    _a.sent();
                    _a.label = 3;
                case 3:
                    _i++;
                    return [3 /*break*/, 1];
                case 4: return [2 /*return*/];
            }
        });
    });
}
function fetchExtractApply(nodeVersion, quietExtraction) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, tarFetch(nodeVersion)];
                case 1:
                    _a.sent();
                    return [4 /*yield*/, tarExtract(nodeVersion, quietExtraction)];
                case 2:
                    _a.sent();
                    return [4 /*yield*/, applyPatches(nodeVersion)];
                case 3:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.fetchExtractApply = fetchExtractApply;
function compileOnWindows(nodeVersion, targetArch, targetPlatform) {
    return __awaiter(this, void 0, void 0, function () {
        var args, major, config_flags;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    args = ['/c', 'vcbuild.bat', targetArch];
                    major = getMajor(nodeVersion);
                    config_flags = getConfigureArgs(major, targetPlatform, targetArch);
                    // The dtrace and etw support was removed in https://github.com/nodejs/node/commit/aa3a572e6bee116cde69508dc29478b40f40551a
                    if (major <= 18) {
                        // Event Tracing for Windows
                        args.push('noetw');
                    }
                    // Performance counters on Windows
                    if (major <= 10) {
                        args.push('noperfctr');
                    }
                    // Link Time Code Generation
                    if (major >= 12) {
                        args.push('ltcg');
                    }
                    // Node24 builds on Windows crash with small-icu at icudat codegen
                    // workaround for now is to enable full-icu
                    // TODO check with newer node/tooling/gh-image versions
                    if (major >= 24) {
                        args.push('full-icu');
                    }
                    // Can't cross compile for arm64 with small-icu
                    if (major < 24 &&
                        system_1.hostArch !== targetArch &&
                        !config_flags.includes('--with-intl=full-icu')) {
                        config_flags.push('--without-intl');
                    }
                    return [4 /*yield*/, (0, utils_1.spawn)('cmd', args, {
                            cwd: nodePath,
                            env: __assign(__assign({}, process.env), { config_flags: config_flags.join(' ') }),
                            stdio: 'inherit',
                        })];
                case 1:
                    _a.sent();
                    if (major <= 10) {
                        return [2 /*return*/, path_1.default.join(nodePath, 'Release/node.exe')];
                    }
                    return [2 /*return*/, path_1.default.join(nodePath, 'out/Release/node.exe')];
            }
        });
    });
}
var _a = process.env.MAKE_JOB_COUNT, MAKE_JOB_COUNT = _a === void 0 ? os_1.default.cpus().length : _a;
function compileOnUnix(nodeVersion, targetArch, targetPlatform) {
    return __awaiter(this, void 0, void 0, function () {
        var args, cpu, _a, _b, CFLAGS, _c, CXXFLAGS, _d, _e, CFLAGS, _f, CXXFLAGS, _g, LDFLAGS, output;
        return __generator(this, function (_h) {
            switch (_h.label) {
                case 0:
                    args = [];
                    cpu = {
                        x86: 'ia32',
                        x64: 'x64',
                        armv6: 'arm',
                        armv7: 'arm',
                        arm64: 'arm64',
                        ppc64: 'ppc64',
                        s390x: 's390x',
                    }[targetArch];
                    if (cpu) {
                        args.push('--dest-cpu', cpu);
                    }
                    if (targetArch === 'armv7') {
                        _a = process.env, _b = _a.CFLAGS, CFLAGS = _b === void 0 ? '' : _b, _c = _a.CXXFLAGS, CXXFLAGS = _c === void 0 ? '' : _c;
                        process.env.CFLAGS = "".concat(CFLAGS, " -marm -mcpu=cortex-a7 -mfpu=vfpv3");
                        process.env.CXXFLAGS = "".concat(CXXFLAGS, " -marm -mcpu=cortex-a7 -mfpu=vfpv3");
                        args.push('--with-arm-float-abi=hard');
                        args.push('--with-arm-fpu=vfpv3');
                    }
                    // macos cross-build from arm64 to x64
                    if (targetPlatform === "macos" && system_1.hostArch === 'arm64' && targetArch === 'x64') {
                        _d = process.env, _e = _d.CFLAGS, CFLAGS = _e === void 0 ? '' : _e, _f = _d.CXXFLAGS, CXXFLAGS = _f === void 0 ? '' : _f, _g = _d.LDFLAGS, LDFLAGS = _g === void 0 ? '' : _g;
                        process.env.CFLAGS = "".concat(CFLAGS, " -arch x86_64");
                        process.env.CXXFLAGS = "".concat(CXXFLAGS, " -arch x86_64");
                        process.env.LDFLAGS = "".concat(LDFLAGS, " -arch x86_64");
                    }
                    if (system_1.hostArch !== targetArch) {
                        log_1.log.warn('Cross compiling!');
                        log_1.log.warn('You are responsible for appropriate env like CC, CC_host, etc.');
                        args.push('--cross-compiling');
                    }
                    args.push.apply(args, getConfigureArgs(getMajor(nodeVersion), targetPlatform, targetArch));
                    log_1.log.info("Running configure with: ", args.join(" "));
                    // TODO same for windows?
                    return [4 /*yield*/, (0, utils_1.spawn)('/bin/sh', __spreadArray(['./configure'], args, true), {
                            cwd: nodePath,
                            stdio: 'inherit',
                        })];
                case 1:
                    // TODO same for windows?
                    _h.sent();
                    return [4 /*yield*/, (0, utils_1.spawn)(system_1.hostPlatform === 'freebsd' ? 'gmake' : 'make', ['-j', String(MAKE_JOB_COUNT)], {
                            cwd: nodePath,
                            stdio: 'inherit',
                        })];
                case 2:
                    _h.sent();
                    output = path_1.default.join(nodePath, 'out/Release/node');
                    return [4 /*yield*/, (0, utils_1.spawn)(process.env.STRIP || 'strip', __spreadArray(__spreadArray([], (targetPlatform === 'macos' ? ['-x'] : []), true), [output], false), {
                            stdio: 'inherit',
                        })];
                case 3:
                    _h.sent();
                    if (!(targetPlatform === 'macos')) return [3 /*break*/, 5];
                    // Newer versions of Apple Clang automatically ad-hoc sign the compiled executable.
                    // However, for final executable to be signable, base binary MUST NOT have an existing signature.
                    return [4 /*yield*/, (0, utils_1.spawn)('codesign', ['--remove-signature', output], {
                            stdio: 'inherit',
                        })];
                case 4:
                    // Newer versions of Apple Clang automatically ad-hoc sign the compiled executable.
                    // However, for final executable to be signable, base binary MUST NOT have an existing signature.
                    _h.sent();
                    _h.label = 5;
                case 5: return [2 /*return*/, output];
            }
        });
    });
}
function compile(nodeVersion, targetArch, targetPlatform) {
    return __awaiter(this, void 0, void 0, function () {
        var win;
        return __generator(this, function (_a) {
            log_1.log.info('Compiling Node.js from sources...');
            win = system_1.hostPlatform === 'win';
            if (win) {
                return [2 /*return*/, compileOnWindows(nodeVersion, targetArch, targetPlatform)];
            }
            return [2 /*return*/, compileOnUnix(nodeVersion, targetArch, targetPlatform)];
        });
    });
}
function prepBuildPath() {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, (0, promises_1.rm)(buildPath, { recursive: true, force: true })];
                case 1:
                    _a.sent();
                    return [4 /*yield*/, (0, promises_1.mkdir)(nodePath, { recursive: true })];
                case 2:
                    _a.sent();
                    return [4 /*yield*/, (0, promises_1.mkdir)(nodeArchivePath, { recursive: true })];
                case 3:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.prepBuildPath = prepBuildPath;
function build(nodeVersion, targetArch, targetPlatform, local) {
    return __awaiter(this, void 0, void 0, function () {
        var output, outputHash;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, prepBuildPath()];
                case 1:
                    _a.sent();
                    return [4 /*yield*/, fetchExtractApply(nodeVersion, false)];
                case 2:
                    _a.sent();
                    return [4 /*yield*/, compile(nodeVersion, targetArch, targetPlatform)];
                case 3:
                    output = _a.sent();
                    return [4 /*yield*/, (0, utils_1.hash)(output)];
                case 4:
                    outputHash = _a.sent();
                    return [4 /*yield*/, (0, promises_1.mkdir)(path_1.default.dirname(local), { recursive: true })];
                case 5:
                    _a.sent();
                    return [4 /*yield*/, (0, promises_1.cp)(output, local)];
                case 6:
                    _a.sent();
                    return [4 /*yield*/, (0, promises_1.writeFile)("".concat(local, ".sha256sum"), "".concat(outputHash, "  ").concat(path_1.default.basename(local), "\n"))];
                case 7:
                    _a.sent();
                    return [4 /*yield*/, (0, promises_1.rm)(buildPath, { recursive: true, force: true })];
                case 8:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.default = build;
//# sourceMappingURL=build.js.map