import { BigIntStats, Stats } from 'fs';
import { WatchOptions, WatchCallback, Watcher, StatOptions, StatSyncOptions, DirentNoPath, RmOptions } from './FakeFS';
import { FakeFS, MkdirOptions, RmdirOptions, WriteFileOptions, OpendirOptions } from './FakeFS';
import { Dirent, SymlinkType } from './FakeFS';
import { CreateReadStreamOptions, CreateWriteStreamOptions, BasePortableFakeFS, ExtractHintOptions, WatchFileOptions, WatchFileCallback, StatWatcher } from './FakeFS';
import { Filename, FSPath, PortablePath } from './path';
export type GetMountPointFn = (path: PortablePath, prefixPath: PortablePath) => PortablePath | null;
export interface MountableFS extends FakeFS<PortablePath> {
    hasOpenFileHandles?(): boolean;
    saveAndClose?(): void;
    discardAndClose?(): void;
}
export type MountFSOptions<MountedFS extends MountableFS> = {
    baseFs?: FakeFS<PortablePath>;
    filter?: RegExp | null;
    magicByte?: number;
    maxOpenFiles?: number;
    typeCheck?: number | null;
    useCache?: boolean;
    /**
     * Functions used to create the sub-filesystem to use when accessing specific paths.
     */
    factorySync: (baseFs: FakeFS<PortablePath>, path: PortablePath) => MountedFS;
    factoryPromise: (baseFs: FakeFS<PortablePath>, path: PortablePath) => Promise<() => MountedFS>;
    /**
     * A function that will be called to figure out the segment of a path that represents a mount point.
     *
     * It must return a strict prefix of the original path, or `null` if the path isn't part of a mount archive.
     */
    getMountPoint: GetMountPointFn;
    /**
     * Maximum age of the child filesystem, after which they will be discarded. Each new access resets this time.
     *
     * Only used if `useCache` is set to `true`.
     */
    maxAge?: number;
};
export declare class MountFS<MountedFS extends MountableFS> extends BasePortableFakeFS {
    private readonly baseFs;
    private readonly mountInstances;
    private readonly fdMap;
    private nextFd;
    private readonly factoryPromise;
    private readonly factorySync;
    private readonly filter;
    private readonly getMountPoint;
    private readonly magic;
    private readonly maxAge;
    private readonly maxOpenFiles;
    private readonly typeCheck;
    private isMount;
    private notMount;
    private realPaths;
    constructor({ baseFs, filter, magicByte, maxOpenFiles, useCache, maxAge, typeCheck, getMountPoint, factoryPromise, factorySync }: MountFSOptions<MountedFS>);
    getExtractHint(hints: ExtractHintOptions): boolean;
    getRealPath(): PortablePath;
    saveAndClose(): void;
    discardAndClose(): void;
    resolve(p: PortablePath): PortablePath;
    private remapFd;
    openPromise(p: PortablePath, flags: string, mode?: number): Promise<number>;
    openSync(p: PortablePath, flags: string, mode?: number): number;
    opendirPromise(p: PortablePath, opts?: OpendirOptions): Promise<import("./FakeFS").Dir<PortablePath>>;
    opendirSync(p: PortablePath, opts?: OpendirOptions): import("./FakeFS").Dir<PortablePath>;
    readPromise(fd: number, buffer: Buffer, offset: number, length: number, position: number): Promise<number>;
    readSync(fd: number, buffer: Buffer, offset: number, length: number, position: number): number;
    writePromise(fd: number, buffer: Buffer, offset?: number, length?: number, position?: number): Promise<number>;
    writePromise(fd: number, buffer: string, position?: number): Promise<number>;
    writeSync(fd: number, buffer: Buffer, offset?: number, length?: number, position?: number): number;
    writeSync(fd: number, buffer: string, position?: number): number;
    closePromise(fd: number): Promise<void>;
    closeSync(fd: number): void;
    createReadStream(p: PortablePath | null, opts?: CreateReadStreamOptions): import("fs").ReadStream;
    createWriteStream(p: PortablePath | null, opts?: CreateWriteStreamOptions): import("fs").WriteStream;
    realpathPromise(p: PortablePath): Promise<PortablePath>;
    realpathSync(p: PortablePath): PortablePath;
    existsPromise(p: PortablePath): Promise<boolean>;
    existsSync(p: PortablePath): boolean;
    accessPromise(p: PortablePath, mode?: number): Promise<void>;
    accessSync(p: PortablePath, mode?: number): void;
    statPromise(p: PortablePath): Promise<Stats>;
    statPromise(p: PortablePath, opts: (StatOptions & {
        bigint?: false | undefined;
    }) | undefined): Promise<Stats>;
    statPromise(p: PortablePath, opts: StatOptions & {
        bigint: true;
    }): Promise<BigIntStats>;
    statPromise(p: PortablePath, opts?: StatOptions): Promise<Stats | BigIntStats>;
    statSync(p: PortablePath): Stats;
    statSync(p: PortablePath, opts?: StatSyncOptions & {
        bigint?: false | undefined;
        throwIfNoEntry: false;
    }): Stats | undefined;
    statSync(p: PortablePath, opts: StatSyncOptions & {
        bigint: true;
        throwIfNoEntry: false;
    }): BigIntStats | undefined;
    statSync(p: PortablePath, opts?: StatSyncOptions & {
        bigint?: false | undefined;
    }): Stats;
    statSync(p: PortablePath, opts: StatSyncOptions & {
        bigint: true;
    }): BigIntStats;
    statSync(p: PortablePath, opts: StatSyncOptions & {
        bigint: boolean;
        throwIfNoEntry?: false | undefined;
    }): Stats | BigIntStats;
    fstatPromise(fd: number): Promise<Stats>;
    fstatPromise(fd: number, opts: {
        bigint: true;
    }): Promise<BigIntStats>;
    fstatPromise(fd: number, opts?: {
        bigint: boolean;
    }): Promise<BigIntStats | Stats>;
    fstatSync(fd: number): Stats;
    fstatSync(fd: number, opts: {
        bigint: true;
    }): BigIntStats;
    fstatSync(fd: number, opts?: {
        bigint: boolean;
    }): BigIntStats | Stats;
    lstatPromise(p: PortablePath): Promise<Stats>;
    lstatPromise(p: PortablePath, opts: (StatOptions & {
        bigint?: false | undefined;
    }) | undefined): Promise<Stats>;
    lstatPromise(p: PortablePath, opts: StatOptions & {
        bigint: true;
    }): Promise<BigIntStats>;
    lstatSync(p: PortablePath): Stats;
    lstatSync(p: PortablePath, opts?: StatSyncOptions & {
        bigint?: false | undefined;
        throwIfNoEntry: false;
    }): Stats | undefined;
    lstatSync(p: PortablePath, opts: StatSyncOptions & {
        bigint: true;
        throwIfNoEntry: false;
    }): BigIntStats | undefined;
    lstatSync(p: PortablePath, opts?: StatSyncOptions & {
        bigint?: false | undefined;
    }): Stats;
    lstatSync(p: PortablePath, opts: StatSyncOptions & {
        bigint: true;
    }): BigIntStats;
    lstatSync(p: PortablePath, opts: StatSyncOptions & {
        bigint: boolean;
        throwIfNoEntry?: false | undefined;
    }): Stats | BigIntStats;
    fchmodPromise(fd: number, mask: number): Promise<void>;
    fchmodSync(fd: number, mask: number): void;
    chmodPromise(p: PortablePath, mask: number): Promise<void>;
    chmodSync(p: PortablePath, mask: number): void;
    fchownPromise(fd: number, uid: number, gid: number): Promise<void>;
    fchownSync(fd: number, uid: number, gid: number): void;
    chownPromise(p: PortablePath, uid: number, gid: number): Promise<void>;
    chownSync(p: PortablePath, uid: number, gid: number): void;
    renamePromise(oldP: PortablePath, newP: PortablePath): Promise<void>;
    renameSync(oldP: PortablePath, newP: PortablePath): void;
    copyFilePromise(sourceP: PortablePath, destP: PortablePath, flags?: number): Promise<void>;
    copyFileSync(sourceP: PortablePath, destP: PortablePath, flags?: number): void;
    appendFilePromise(p: FSPath<PortablePath>, content: string | Uint8Array, opts?: WriteFileOptions): Promise<void>;
    appendFileSync(p: FSPath<PortablePath>, content: string | Uint8Array, opts?: WriteFileOptions): void;
    writeFilePromise(p: FSPath<PortablePath>, content: string | NodeJS.ArrayBufferView, opts?: WriteFileOptions): Promise<void>;
    writeFileSync(p: FSPath<PortablePath>, content: string | NodeJS.ArrayBufferView, opts?: WriteFileOptions): void;
    unlinkPromise(p: PortablePath): Promise<void>;
    unlinkSync(p: PortablePath): void;
    utimesPromise(p: PortablePath, atime: Date | string | number, mtime: Date | string | number): Promise<void>;
    utimesSync(p: PortablePath, atime: Date | string | number, mtime: Date | string | number): void;
    lutimesPromise(p: PortablePath, atime: Date | string | number, mtime: Date | string | number): Promise<void>;
    lutimesSync(p: PortablePath, atime: Date | string | number, mtime: Date | string | number): void;
    mkdirPromise(p: PortablePath, opts?: MkdirOptions): Promise<string | undefined>;
    mkdirSync(p: PortablePath, opts?: MkdirOptions): string | undefined;
    rmdirPromise(p: PortablePath, opts?: RmdirOptions): Promise<void>;
    rmdirSync(p: PortablePath, opts?: RmdirOptions): void;
    rmPromise(p: PortablePath, opts?: RmOptions): Promise<void>;
    rmSync(p: PortablePath, opts?: RmOptions): void;
    linkPromise(existingP: PortablePath, newP: PortablePath): Promise<void>;
    linkSync(existingP: PortablePath, newP: PortablePath): void;
    symlinkPromise(target: PortablePath, p: PortablePath, type?: SymlinkType): Promise<void>;
    symlinkSync(target: PortablePath, p: PortablePath, type?: SymlinkType): void;
    readFilePromise(p: FSPath<PortablePath>, encoding?: null): Promise<NonSharedBuffer>;
    readFilePromise(p: FSPath<PortablePath>, encoding: BufferEncoding): Promise<string>;
    readFilePromise(p: FSPath<PortablePath>, encoding?: BufferEncoding | null): Promise<NonSharedBuffer | string>;
    readFileSync(p: FSPath<PortablePath>, encoding?: null): NonSharedBuffer;
    readFileSync(p: FSPath<PortablePath>, encoding: BufferEncoding): string;
    readFileSync(p: FSPath<PortablePath>, encoding?: BufferEncoding | null): NonSharedBuffer | string;
    readdirPromise(p: PortablePath, opts?: null): Promise<Array<Filename>>;
    readdirPromise(p: PortablePath, opts: {
        recursive?: false;
        withFileTypes: true;
    }): Promise<Array<DirentNoPath>>;
    readdirPromise(p: PortablePath, opts: {
        recursive?: false;
        withFileTypes?: false;
    }): Promise<Array<Filename>>;
    readdirPromise(p: PortablePath, opts: {
        recursive?: false;
        withFileTypes: boolean;
    }): Promise<Array<DirentNoPath | Filename>>;
    readdirPromise(p: PortablePath, opts: {
        recursive: true;
        withFileTypes: true;
    }): Promise<Array<Dirent<PortablePath>>>;
    readdirPromise(p: PortablePath, opts: {
        recursive: true;
        withFileTypes?: false;
    }): Promise<Array<PortablePath>>;
    readdirPromise(p: PortablePath, opts: {
        recursive: true;
        withFileTypes: boolean;
    }): Promise<Array<Dirent<PortablePath> | PortablePath>>;
    readdirPromise(p: PortablePath, opts: {
        recursive: boolean;
        withFileTypes: true;
    }): Promise<Array<Dirent<PortablePath> | DirentNoPath>>;
    readdirPromise(p: PortablePath, opts: {
        recursive: boolean;
        withFileTypes?: false;
    }): Promise<Array<PortablePath>>;
    readdirPromise(p: PortablePath, opts: {
        recursive: boolean;
        withFileTypes: boolean;
    }): Promise<Array<Dirent<PortablePath> | DirentNoPath | PortablePath>>;
    readdirSync(p: PortablePath, opts?: null): Array<Filename>;
    readdirSync(p: PortablePath, opts: {
        recursive?: false;
        withFileTypes: true;
    }): Array<DirentNoPath>;
    readdirSync(p: PortablePath, opts: {
        recursive?: false;
        withFileTypes?: false;
    }): Array<Filename>;
    readdirSync(p: PortablePath, opts: {
        recursive?: false;
        withFileTypes: boolean;
    }): Array<DirentNoPath | Filename>;
    readdirSync(p: PortablePath, opts: {
        recursive: true;
        withFileTypes: true;
    }): Array<Dirent<PortablePath>>;
    readdirSync(p: PortablePath, opts: {
        recursive: true;
        withFileTypes?: false;
    }): Array<PortablePath>;
    readdirSync(p: PortablePath, opts: {
        recursive: true;
        withFileTypes: boolean;
    }): Array<Dirent<PortablePath> | PortablePath>;
    readdirSync(p: PortablePath, opts: {
        recursive: boolean;
        withFileTypes: true;
    }): Array<Dirent<PortablePath> | DirentNoPath>;
    readdirSync(p: PortablePath, opts: {
        recursive: boolean;
        withFileTypes?: false;
    }): Array<PortablePath>;
    readdirSync(p: PortablePath, opts: {
        recursive: boolean;
        withFileTypes: boolean;
    }): Array<Dirent<PortablePath> | DirentNoPath | PortablePath>;
    readlinkPromise(p: PortablePath): Promise<PortablePath>;
    readlinkSync(p: PortablePath): PortablePath;
    truncatePromise(p: PortablePath, len?: number): Promise<void>;
    truncateSync(p: PortablePath, len?: number): void;
    ftruncatePromise(fd: number, len?: number): Promise<void>;
    ftruncateSync(fd: number, len?: number): void;
    watch(p: PortablePath, cb?: WatchCallback): Watcher;
    watch(p: PortablePath, opts: WatchOptions, cb?: WatchCallback): Watcher;
    watchFile(p: PortablePath, cb: WatchFileCallback): StatWatcher;
    watchFile(p: PortablePath, opts: WatchFileOptions, cb: WatchFileCallback): StatWatcher;
    unwatchFile(p: PortablePath, cb?: WatchFileCallback): void;
    private makeCallPromise;
    private makeCallSync;
    private findMount;
    private limitOpenFilesTimeout;
    private limitOpenFiles;
    private getMountPromise;
    private getMountSync;
}
