"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NodePathFS = void 0;
const tslib_1 = require("tslib");
const buffer_1 = tslib_1.__importDefault(require("buffer"));
const url_1 = require("url");
const util_1 = require("util");
const ProxiedFS_1 = require("./ProxiedFS");
const path_1 = require("./path");
/**
 * Adds support for file URLs and Buffers to the wrapped `baseFs`, but *not* inside the typings.
 *
 * Only exists for compatibility with Node's behavior.
 *
 * Automatically wraps all FS instances passed to `patchFs` & `extendFs`.
 *
 * Don't use it!
 */
class NodePathFS extends ProxiedFS_1.ProxiedFS {
    constructor(baseFs) {
        super(path_1.npath);
        this.baseFs = baseFs;
    }
    mapFromBase(path) {
        return path;
    }
    mapToBase(path) {
        if (typeof path === `string`)
            return path;
        if (path instanceof URL)
            return (0, url_1.fileURLToPath)(path);
        if (Buffer.isBuffer(path)) {
            const str = path.toString();
            if (!isUtf8(path, str))
                throw new Error(`Non-utf8 buffers are not supported at the moment. Please upvote the following issue if you encounter this error: https://github.com/yarnpkg/berry/issues/4942`);
            return str;
        }
        throw new Error(`Unsupported path type: ${(0, util_1.inspect)(path)}`);
    }
}
exports.NodePathFS = NodePathFS;
// TODO: remove the fallback when dropping support for Node.js < 18.14.0
function isUtf8(buf, str) {
    if (typeof buffer_1.default.isUtf8 !== `undefined`)
        return buffer_1.default.isUtf8(buf);
    return Buffer.byteLength(str) === buf.byteLength;
}
