"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EBUSY = EBUSY;
exports.ENOSYS = ENOSYS;
exports.EINVAL = EINVAL;
exports.EBADF = EBADF;
exports.ENOENT = ENOENT;
exports.ENOTDIR = ENOTDIR;
exports.EISDIR = EISDIR;
exports.EEXIST = EEXIST;
exports.EROFS = EROFS;
exports.ENOTEMPTY = ENOTEMPTY;
exports.EOPNOTSUPP = EOPNOTSUPP;
exports.ERR_DIR_CLOSED = ERR_DIR_CLOSED;
function makeError(code, message) {
    return Object.assign(new Error(`${code}: ${message}`), { code });
}
function EBUSY(message) {
    return makeError(`EBUSY`, message);
}
function ENOSYS(message, reason) {
    return makeError(`ENOSYS`, `${message}, ${reason}`);
}
function EINVAL(reason) {
    return makeError(`EINVAL`, `invalid argument, ${reason}`);
}
function EBADF(reason) {
    return makeError(`EBADF`, `bad file descriptor, ${reason}`);
}
function ENOENT(reason) {
    return makeError(`ENOENT`, `no such file or directory, ${reason}`);
}
function ENOTDIR(reason) {
    return makeError(`ENOTDIR`, `not a directory, ${reason}`);
}
function EISDIR(reason) {
    return makeError(`EISDIR`, `illegal operation on a directory, ${reason}`);
}
function EEXIST(reason) {
    return makeError(`EEXIST`, `file already exists, ${reason}`);
}
function EROFS(reason) {
    return makeError(`EROFS`, `read-only filesystem, ${reason}`);
}
function ENOTEMPTY(reason) {
    return makeError(`ENOTEMPTY`, `directory not empty, ${reason}`);
}
function EOPNOTSUPP(reason) {
    return makeError(`EOPNOTSUPP`, `operation not supported, ${reason}`);
}
// ------------------------------------------------------------------------
function ERR_DIR_CLOSED() {
    return makeError(`ERR_DIR_CLOSED`, `Directory handle was closed`);
}
