import type { Abortable } from 'events';
import type { FlagAndOpenMode, FileReadResult, FileReadOptions } from 'fs/promises';
import type { CreateReadStreamOptions, CreateWriteStreamOptions, FakeFS } from '../FakeFS';
import type { Path } from '../path';
import type { BigIntStats, ObjectEncodingOptions, OpenMode, ReadStream, ReadVResult, StatOptions, Stats, WriteStream, WriteVResult } from 'fs';
type WriteArgsBuffer<TBuffer extends Uint8Array> = [
    buffer: TBuffer,
    offset?: number | null,
    length?: number | null,
    position?: number | null
];
type WriteArgsString = [
    data: string,
    position?: number | null,
    encoding?: BufferEncoding | null
];
declare const kBaseFs: unique symbol;
declare const kFd: unique symbol;
declare const kClosePromise: unique symbol;
declare const kCloseResolve: unique symbol;
declare const kCloseReject: unique symbol;
declare const kRefs: unique symbol;
declare const kRef: unique symbol;
declare const kUnref: unique symbol;
export declare class FileHandle<P extends Path> {
    [kBaseFs]: FakeFS<P>;
    [kFd]: number;
    [kRefs]: number;
    [kClosePromise]: Promise<void> | undefined;
    [kCloseResolve]: (() => void) | undefined;
    [kCloseReject]: (() => void) | undefined;
    constructor(fd: number, baseFs: FakeFS<P>);
    get fd(): number;
    appendFile(data: string | Uint8Array, options?: (ObjectEncodingOptions & FlagAndOpenMode) | BufferEncoding | null): Promise<void>;
    chown(uid: number, gid: number): Promise<void>;
    chmod(mode: number): Promise<void>;
    createReadStream(options?: CreateReadStreamOptions): ReadStream;
    createWriteStream(options?: CreateWriteStreamOptions): WriteStream;
    datasync(): Promise<void>;
    sync(): Promise<void>;
    read<T extends NodeJS.ArrayBufferView>(buffer: T, offset?: number | null, length?: number | null, position?: number | null): Promise<FileReadResult<T>>;
    read<T extends NodeJS.ArrayBufferView>(buffer: T, options?: Omit<FileReadOptions<T>, `buffer`>): Promise<FileReadResult<T>>;
    read<T extends NodeJS.ArrayBufferView = NonSharedBuffer>(options: FileReadOptions<T> & {
        buffer: T;
    }): Promise<FileReadResult<T>>;
    read(options?: FileReadOptions<NonSharedBuffer> & {
        buffer?: never;
    }): Promise<FileReadResult<NonSharedBuffer>>;
    readFile(options?: {
        encoding?: null | undefined;
        flag?: OpenMode | undefined;
    } | null): Promise<Buffer>;
    readFile(options: {
        encoding: BufferEncoding;
        flag?: OpenMode | undefined;
    } | BufferEncoding): Promise<string>;
    readLines(options?: CreateReadStreamOptions): import("readline").Interface;
    stat(opts?: StatOptions & {
        bigint?: false | undefined;
    }): Promise<Stats>;
    stat(opts: StatOptions & {
        bigint: true;
    }): Promise<BigIntStats>;
    truncate(len?: number): Promise<void>;
    utimes(atime: string | number | Date, mtime: string | number | Date): Promise<void>;
    writeFile(data: string | Uint8Array, options?: (ObjectEncodingOptions & FlagAndOpenMode & Abortable) | BufferEncoding | null): Promise<void>;
    write(...args: WriteArgsString): Promise<{
        bytesWritten: number;
        buffer: string;
    }>;
    write<TBuffer extends Uint8Array>(...args: WriteArgsBuffer<TBuffer>): Promise<{
        bytesWritten: number;
        buffer: TBuffer;
    }>;
    writev(buffers: Array<NodeJS.ArrayBufferView>, position?: number): Promise<WriteVResult>;
    readv(buffers: ReadonlyArray<NodeJS.ArrayBufferView>, position?: number): Promise<ReadVResult>;
    close(): Promise<void>;
    [kRef](caller: Function): void;
    [kUnref](): void;
}
export {};
