import { MountFS, MountFSOptions } from '@yarnpkg/fslib';
import { PortablePath } from '@yarnpkg/fslib';
import { Libzip } from '@yarnpkg/libzip';
import { ZipFS } from '@yarnpkg/libzip';
import { ZipImplementationClass } from './ZipFS';
/**
 * Extracts the archive part (ending in the first instance of `extension`) from a path.
 *
 * The indexOf-based implementation is ~3.7x faster than a RegExp-based implementation.
 */
export declare function getArchivePart(path: string, extension: string): PortablePath | null;
export type ZipOpenFSOptions = Omit<MountFSOptions<ZipFS>, `factoryPromise` | `factorySync` | `getMountPoint`> & {
    libzip?: Libzip | (() => Libzip);
    readOnlyArchives?: boolean;
    customZipImplementation?: ZipImplementationClass;
    /**
     * Which file extensions will be interpreted as zip files. Useful for supporting other formats
     * packaged as zips, such as .docx.
     *
     * If not provided, defaults to only accepting `.zip`.
     */
    fileExtensions?: Array<string> | null;
};
export declare class ZipOpenFS extends MountFS<ZipFS> {
    static openPromise<T>(fn: (zipOpenFs: ZipOpenFS) => Promise<T>, opts?: ZipOpenFSOptions): Promise<T>;
    constructor(opts?: ZipOpenFSOptions);
}
