import { PortablePath } from '@yarnpkg/fslib';
import { ZipImplInput, type CompressionData, type Stat, type ZipImpl } from './ZipFS';
export declare class LibzipError extends Error {
    code: string;
    constructor(message: string, code: string);
}
export declare class LibZipImpl implements ZipImpl {
    private readonly libzip;
    private readonly lzSource;
    private readonly zip;
    private readonly listings;
    private readonly symlinkCount;
    filesShouldBeCached: boolean;
    constructor(opts: ZipImplInput);
    getSymlinkCount(): number;
    getListings(): Array<string>;
    stat(entry: number): Stat;
    makeLibzipError(error: number): LibzipError;
    setFileSource(target: PortablePath, compression: CompressionData, buffer: Buffer): number;
    setMtime(entry: number, mtime: number): void;
    getExternalAttributes(index: number): [number, number];
    setExternalAttributes(index: number, opsys: number, attributes: number): void;
    locate(name: string): number;
    getFileSource(index: number): {
        data: Buffer<ArrayBuffer>;
        compressionMethod: number;
    };
    deleteEntry(index: number): void;
    addDirectory(path: string): number;
    getBufferAndClose(): Buffer<ArrayBuffer>;
    private allocateBuffer;
    private allocateUnattachedSource;
    private allocateSource;
    discard(): void;
}
