"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.functionList = exports.compose = exports.AppBuilder = void 0;
const compose_js_1 = require("./compose.js");
Object.defineProperty(exports, "compose", { enumerable: true, get: function () { return compose_js_1.compose; } });
Object.defineProperty(exports, "functionList", { enumerable: true, get: function () { return compose_js_1.functionList; } });
class AppBuilder {
    constructor() {
        this.middleware = [];
    }
    build() {
        if (!this.middleware.length) {
            throw new Error('Usage error: must have at least one middleware');
        }
        return compose_js_1.compose(this.middleware);
    }
    use(mw) {
        if ('function' !== typeof mw) {
            throw new TypeError(`${mw}, must be a middleware function accpeting (context, next) arguments`);
        }
        this.middleware.push(mw);
        return this;
    }
}
exports.AppBuilder = AppBuilder;
function createAppBuilder() {
    return new AppBuilder();
}
exports.default = createAppBuilder;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBwLWJ1aWxkZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvYXBwLWJ1aWxkZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsNkNBQXdGO0FBMkIvRSx3RkEzQkEsb0JBQU8sT0EyQkE7QUFBRSw2RkEzQm9DLHlCQUFZLE9BMkJwQztBQXpCOUIsTUFBYSxVQUFVO0lBQXZCO1FBQ1UsZUFBVSxHQUF5QixFQUFFLENBQUE7SUFrQi9DLENBQUM7SUFoQkMsS0FBSztRQUNILElBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLE1BQU0sRUFBRTtZQUMzQixNQUFNLElBQUksS0FBSyxDQUFDLGdEQUFnRCxDQUFDLENBQUE7U0FDbEU7UUFDRCxPQUFPLG9CQUFPLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFBO0lBQ2pDLENBQUM7SUFFRCxHQUFHLENBQUMsRUFBaUI7UUFDbkIsSUFBSSxVQUFVLEtBQUssT0FBTyxFQUFFLEVBQUU7WUFDNUIsTUFBTSxJQUFJLFNBQVMsQ0FDakIsR0FBRyxFQUFFLHFFQUFxRSxDQUMzRSxDQUFBO1NBQ0Y7UUFDRCxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUMsQ0FBQTtRQUN4QixPQUFPLElBQUksQ0FBQTtJQUNiLENBQUM7Q0FDRjtBQW5CRCxnQ0FtQkM7QUFFRCxTQUF3QixnQkFBZ0I7SUFDdEMsT0FBTyxJQUFJLFVBQVUsRUFBSyxDQUFBO0FBQzVCLENBQUM7QUFGRCxtQ0FFQyJ9