export interface Middleware<T> {
    (context: T, next: ContinuationMiddleware<T>): any;
}
export interface ContinuationMiddleware<T> {
    (context?: T, next?: Middleware<T>): any;
}
export declare type Func<T = any> = (...args: any[]) => T;
export declare function functionList<T = any>(list: Func | Iterable<Func>, ...args: any[]): Middleware<T>[];
/**
 * Create a function to invoke all passed middleware functions
 * with a single argument <T>context
 * @param middleware
 */
export declare function compose<T = any>(...middleware: (Middleware<T> | Middleware<T>[])[]): ContinuationMiddleware<T>;
