import { compose, functionList } from './compose.js';
export class AppBuilder {
    constructor() {
        this.middleware = [];
    }
    build() {
        if (!this.middleware.length) {
            throw new Error('Usage error: must have at least one middleware');
        }
        return compose(this.middleware);
    }
    use(mw) {
        if ('function' !== typeof mw) {
            throw new TypeError(`${mw}, must be a middleware function accpeting (context, next) arguments`);
        }
        this.middleware.push(mw);
        return this;
    }
}
export default function createAppBuilder() {
    return new AppBuilder();
}
export { compose, functionList };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBwLWJ1aWxkZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvYXBwLWJ1aWxkZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFFLE9BQU8sRUFBc0MsWUFBWSxFQUFFLE1BQU0sY0FBYyxDQUFBO0FBRXhGLE1BQU0sT0FBTyxVQUFVO0lBQXZCO1FBQ1UsZUFBVSxHQUF5QixFQUFFLENBQUE7SUFrQi9DLENBQUM7SUFoQkMsS0FBSztRQUNILElBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLE1BQU0sRUFBRTtZQUMzQixNQUFNLElBQUksS0FBSyxDQUFDLGdEQUFnRCxDQUFDLENBQUE7U0FDbEU7UUFDRCxPQUFPLE9BQU8sQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUE7SUFDakMsQ0FBQztJQUVELEdBQUcsQ0FBQyxFQUFpQjtRQUNuQixJQUFJLFVBQVUsS0FBSyxPQUFPLEVBQUUsRUFBRTtZQUM1QixNQUFNLElBQUksU0FBUyxDQUNqQixHQUFHLEVBQUUscUVBQXFFLENBQzNFLENBQUE7U0FDRjtRQUNELElBQUksQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxDQUFBO1FBQ3hCLE9BQU8sSUFBSSxDQUFBO0lBQ2IsQ0FBQztDQUNGO0FBRUQsTUFBTSxDQUFDLE9BQU8sVUFBVSxnQkFBZ0I7SUFDdEMsT0FBTyxJQUFJLFVBQVUsRUFBSyxDQUFBO0FBQzVCLENBQUM7QUFFRCxPQUFPLEVBQUUsT0FBTyxFQUFFLFlBQVksRUFBc0MsQ0FBQSJ9