import { ParserState } from './common';
export declare const enum Errors {
    Unexpected = 0,
    StrictOctalEscape = 1,
    TemplateOctalLiteral = 2,
    InvalidPrivateIdentifier = 3,
    InvalidUnicodeEscapeSequence = 4,
    InvalidCodePoint = 5,
    InvalidHexEscapeSequence = 6,
    StrictDecimalWithLeadingZero = 7,
    StrictOctalLiteral = 8,
    ExpectedNumberInRadix = 9,
    MissingExponent = 10,
    InvalidBigInt = 11,
    IDStartAfterNumber = 12,
    InvalidEightAndNine = 13,
    UnterminatedString = 14,
    UnterminatedTemplate = 15,
    UnterminatedComment = 16,
    InvalidDynamicUnicode = 17,
    IllegalCharacter = 18,
    MissingHexDigits = 19,
    InvalidImplicitOctals = 20,
    InvalidStringLT = 21,
    InvalidEscapeIdentifier = 22,
    ExpectedToken = 23,
    CantAssignTo = 24,
    InvalidLHSAsyncArrow = 25,
    SuperNoConstructor = 26,
    InvalidSuperProperty = 27,
    UnexpectedToken = 28,
    AwaitInParameter = 29,
    YieldInParameter = 30,
    InvalidExponentiationLHS = 31,
    UnterminatedRegExp = 32,
    UnexpectedTokenRegExpFlag = 33,
    DuplicateRegExpFlag = 34,
    AccessorWrongArgs = 35,
    BadSetterRestParameter = 36,
    DeclNoName = 37,
    StrictFunctionName = 38,
    RestMissingArg = 39,
    InvalidGeneratorGetter = 40,
    InvalidGeneratorSetter = 41,
    InvalidComputedPropName = 42,
    InvalidGetSetGenerator = 43,
    InvalidAsyncGetter = 44,
    InvalidGenMethodShorthand = 45,
    InvalidLineBreak = 46,
    InvalidArrowDestructLHS = 47,
    InvalidBindingDestruct = 48,
    InvalidAsyncArrow = 49,
    StaticPrototype = 50,
    InvalidConstructor = 51,
    DuplicateConstructor = 52,
    InvalidIncDecTarget = 53,
    InvalidIncDecNew = 54,
    InvalidAssignmentTarget = 55,
    InvalidRestTrailing = 56,
    DeclarationMissingInitializer = 57,
    ForInOfLoopInitializer = 58,
    ForInOfLoopMultiBindings = 59,
    InvalidShorthandPropInit = 60,
    DuplicateProto = 61,
    InvalidLetBoundName = 62,
    InvalidNewUnary = 63,
    IllegalUseStrict = 64,
    DisallowedLetInStrict = 65,
    IllegalContinue = 66,
    IllegalBreak = 67,
    InvalidLetBracket = 68,
    InvalidDestructuringTarget = 69,
    RestDefaultInitializer = 70,
    InvalidRestNotLast = 71,
    InvalidRestArg = 72,
    InvalidRestDefault = 73,
    StrictFunction = 74,
    SloppyFunction = 75,
    WebCompatFunction = 76,
    ClassForbiddenAsStatement = 77,
    CantAssignToInOfForLoop = 78,
    InvalidAssignmentInOfForLoop = 79,
    InvalidForAwait = 80,
    InvalidTemplateContinuation = 81,
    RestrictedLetProduction = 82,
    UnexpectedLetStrictReserved = 83,
    InvalidCatchParams = 84,
    InvalidCatchParamDefault = 85,
    NoCatchOrFinally = 86,
    MultipleDefaultsInSwitch = 87,
    NewlineAfterThrow = 88,
    StrictWith = 89,
    IllegalReturn = 90,
    InvalidForLHSBinding = 91,
    InvalidNewTarget = 92,
    InvalidEscapedKeyword = 93,
    MissingPrivateIdentifier = 94,
    DisallowedInContext = 95,
    AwaitOutsideAsync = 96,
    InvalidStrictLet = 97,
    InvalidLetConstBinding = 98,
    InvalidLetClassName = 99,
    KeywordNotId = 100,
    InvalidImportExportSloppy = 101,
    UnicodeOverflow = 102,
    InvalidExportImportSource = 103,
    InvalidKeywordAsAlias = 104,
    InvalidDefaultImport = 105,
    TrailingDecorators = 106,
    GeneratorConstructor = 107,
    AwaitOrYieldIdentInModule = 108,
    HtmlCommentInWebCompat = 109,
    StrictInvalidLetInExprPos = 110,
    NotAssignableLetArgs = 111,
    ForOfLet = 112,
    InvalidInvokedBlockBodyArrow = 113,
    InvalidAccessedBlockBodyArrow = 114,
    UnexpectedStrictReserved = 115,
    StrictEvalArguments = 116,
    InvalidDecoratorSemicolon = 117,
    StrictDelete = 118,
    InvalidPatternTail = 119,
    AsyncFunctionInSingleStatementContext = 120,
    InvalidTernaryYield = 121,
    InvalidArrowPostfix = 122,
    InvalidObjLitKeyStar = 123,
    DeletePrivateField = 124,
    InvalidStaticClassFieldConstructor = 125,
    InvalidClassFieldConstructor = 126,
    InvalidClassFieldArgEval = 127,
    InvalidGeneratorFunction = 128,
    AsyncRestrictedProd = 129,
    UnexpectedCharAfterObjLit = 130,
    InvalidObjLitKey = 131,
    InvalidKeyToken = 132,
    LabelRedeclaration = 133,
    InvalidNestedStatement = 134,
    UnknownLabel = 135,
    InvalidImportTail = 136,
    ImportNotOneArg = 137,
    InvalidImportNew = 138,
    InvalidSpreadInImport = 139,
    UncompleteArrow = 140,
    DuplicateBinding = 141,
    DuplicateExportBinding = 142,
    UndeclaredExportedBinding = 143,
    UnexpectedPrivateField = 144,
    DuplicateLetConstBinding = 145,
    CantAssignToValidRHS = 146,
    ContinuousNumericSeparator = 147,
    TrailingNumericSeparator = 148,
    InvalidJSXAttributeValue = 149,
    ExpectedJSXClosingTag = 150,
    AdjacentJSXElements = 151,
    InvalidNonEmptyJSXExpr = 152,
    DuplicateIdentifier = 153,
    ShadowedCatchClause = 154,
    InvalidDotProperty = 155,
    UnclosedSpreadElement = 156,
    CatchWithoutTry = 157,
    FinallyWithoutTry = 158,
    UnCorrespondingFragmentTag = 159,
    InvalidCoalescing = 160,
    OptionalChainingNoTemplate = 161,
    OptionalChainingNoSuper = 162,
    OptionalChainingNoNew = 163,
    ImportMetaOutsideModule = 164,
    InvalidLeadingDecorator = 165
}
export declare const errorMessages: {
    [key: string]: string;
};
export declare class ParseError extends SyntaxError {
    loc: {
        line: ParseError['line'];
        column: ParseError['column'];
    };
    index: number;
    line: number;
    column: number;
    description: string;
    constructor(startindex: number, line: number, column: number, type: Errors, ...params: string[]);
}
export declare function report(parser: ParserState, type: Errors, ...params: string[]): never;
export declare function reportScopeError(scope: any): never;
export declare function reportMessageAt(index: number, line: number, column: number, type: Errors, ...params: string[]): never;
export declare function reportScannerError(index: number, line: number, column: number, type: Errors): never;
//# sourceMappingURL=errors.d.ts.map