/// <reference types="node" />
/// <reference types="node" />
/// <reference types="node" />
import { Libzip } from '@yarnpkg/libzip';
import { FakeFS, PortablePath, RmdirOptions, OpendirOptions, BasePortableFakeFS, Dirent, MkdirOptions, FSPath, Filename, CustomDir } from '@yarnpkg/fslib';
import { ZipFS } from '@yarnpkg/libzip';
export type SnapshotZipFSOptions = {
    baseFs: FakeFS<PortablePath>;
    libzip: Libzip | (() => Libzip);
    zipFs: ZipFS;
    root: string;
};
export declare class SnapshotZipFS extends BasePortableFakeFS {
    zipFs: ZipFS;
    baseFs: FakeFS<PortablePath>;
    root: string;
    magic: number;
    constructor(opts: SnapshotZipFSOptions);
    private readonly fdMap;
    private nextFd;
    makeCallPromise<T>(p: FSPath<PortablePath>, discard: () => Promise<T>, accept: (zipFS: ZipFS, zipInfo: {
        subPath: PortablePath;
    }) => Promise<T>, { requireSubpath }?: {
        requireSubpath?: boolean;
    }): Promise<T>;
    makeCallSync<T>(p: FSPath<PortablePath>, discard: () => T, accept: (zipFS: ZipFS, zipInfo: {
        subPath: PortablePath;
        archivePath: string;
    }) => T, { requireSubpath }?: {
        requireSubpath?: boolean;
    }): T;
    realpathPromise(p: PortablePath): Promise<PortablePath>;
    realpathSync(p: PortablePath): PortablePath;
    findZip(p: PortablePath): {
        subPath: PortablePath;
    } | undefined;
    copyFilePromise(sourceP: PortablePath, destP: PortablePath, flags?: number): Promise<void>;
    copyFileSync(sourceP: PortablePath, destP: PortablePath, flags?: number): void;
    readdirPromise(p: PortablePath): Promise<Array<Filename>>;
    readdirPromise(p: PortablePath, opts: {
        withFileTypes: false;
    } | null): Promise<Array<Filename>>;
    readdirPromise(p: PortablePath, opts: {
        withFileTypes: true;
    }): Promise<Array<Dirent>>;
    readdirPromise(p: PortablePath, opts: {
        withFileTypes: boolean;
    }): Promise<Array<Filename> | Array<Dirent>>;
    readdirSync(p: PortablePath): Array<Filename>;
    readdirSync(p: PortablePath, opts: {
        withFileTypes: false;
    } | null): Array<Filename>;
    readdirSync(p: PortablePath, opts: {
        withFileTypes: true;
    }): Array<Dirent>;
    readdirSync(p: PortablePath, opts: {
        withFileTypes: boolean;
    }): Array<Filename> | Array<Dirent>;
    mkdirPromise(p: PortablePath, opts?: MkdirOptions): Promise<string | undefined>;
    mkdirSync(p: PortablePath, opts?: MkdirOptions): string | undefined;
    rmdirPromise(p: PortablePath, opts?: RmdirOptions): Promise<void>;
    rmdirSync(p: PortablePath, opts?: RmdirOptions): void;
    opendirPromise(p: PortablePath, opts?: OpendirOptions): Promise<CustomDir<PortablePath>>;
    opendirSync(p: PortablePath, opts?: OpendirOptions): CustomDir<PortablePath>;
    accessPromise: (p: PortablePath, mode?: number | undefined) => Promise<void>;
    accessSync: (p: PortablePath, mode?: number | undefined) => void;
    appendFilePromise: (p: FSPath<PortablePath>, content: string | Uint8Array, opts?: import("@yarnpkg/fslib").WriteFileOptions | undefined) => Promise<void>;
    appendFileSync: (p: FSPath<PortablePath>, content: string | Uint8Array, opts?: import("@yarnpkg/fslib").WriteFileOptions | undefined) => void;
    chmodPromise: (p: PortablePath, mask: number) => Promise<void>;
    chmodSync: (p: PortablePath, mask: number) => void;
    fchmodPromise: (fd: number, mask: number) => Promise<void>;
    fchmodSync: (fd: number, mask: number) => void;
    chownPromise: (p: PortablePath, uid: number, gid: number) => Promise<void>;
    chownSync: (p: PortablePath, uid: number, gid: number) => void;
    fchownPromise: (fd: number, uid: number, gid: number) => Promise<void>;
    fchownSync: (fd: number, uid: number, gid: number) => void;
    closePromise: (fd: number) => Promise<void>;
    closeSync: (fd: number) => void;
    createReadStream: (p: PortablePath | null, opts?: Partial<{
        encoding: BufferEncoding;
        fd: number;
    }> | undefined) => import("fs").ReadStream;
    createWriteStream: (p: PortablePath | null, opts?: Partial<{
        encoding: BufferEncoding;
        fd: number;
        flags: "a";
    }> | undefined) => import("fs").WriteStream;
    existsPromise: (p: PortablePath) => Promise<boolean>;
    existsSync: (p: PortablePath) => boolean;
    fstatPromise: {
        (fd: number): Promise<import("fs").Stats>;
        (fd: number, opts: {
            bigint: true;
        }): Promise<import("fs").BigIntStats>;
        (fd: number, opts?: {
            bigint: boolean;
        } | undefined): Promise<import("fs").Stats | import("fs").BigIntStats>;
    };
    fstatSync: {
        (fd: number): import("fs").Stats;
        (fd: number, opts: {
            bigint: true;
        }): import("fs").BigIntStats;
        (fd: number, opts?: {
            bigint: boolean;
        } | undefined): import("fs").Stats | import("fs").BigIntStats;
    };
    getExtractHint: (hints: import("@yarnpkg/fslib").ExtractHintOptions) => boolean;
    getRealPath: () => PortablePath;
    linkPromise: (existingP: PortablePath, newP: PortablePath) => Promise<void>;
    linkSync: (existingP: PortablePath, newP: PortablePath) => void;
    lstatPromise: {
        (p: PortablePath): Promise<import("fs").Stats>;
        (p: PortablePath, opts: (import("@yarnpkg/fslib").StatOptions & {
            bigint?: false | undefined;
        }) | undefined): Promise<import("fs").Stats>;
        (p: PortablePath, opts: import("@yarnpkg/fslib").StatOptions & {
            bigint: true;
        }): Promise<import("fs").BigIntStats>;
    };
    lstatSync: {
        (p: PortablePath): import("fs").Stats;
        (p: PortablePath, opts?: (import("@yarnpkg/fslib").StatSyncOptions & {
            bigint?: false | undefined;
            throwIfNoEntry: false;
        }) | undefined): import("fs").Stats | undefined;
        (p: PortablePath, opts: import("@yarnpkg/fslib").StatSyncOptions & {
            bigint: true;
            throwIfNoEntry: false;
        }): import("fs").BigIntStats | undefined;
        (p: PortablePath, opts?: (import("@yarnpkg/fslib").StatSyncOptions & {
            bigint?: false | undefined;
        }) | undefined): import("fs").Stats;
        (p: PortablePath, opts: import("@yarnpkg/fslib").StatSyncOptions & {
            bigint: true;
        }): import("fs").BigIntStats;
        (p: PortablePath, opts: import("@yarnpkg/fslib").StatSyncOptions & {
            bigint: boolean;
            throwIfNoEntry?: false | undefined;
        }): import("fs").Stats | import("fs").BigIntStats;
    };
    openPromise: (p: PortablePath, flags: string, mode?: number | undefined) => Promise<number>;
    openSync: (p: PortablePath, flags: string, mode?: number | undefined) => number;
    readFilePromise: {
        (p: FSPath<PortablePath>, encoding?: null | undefined): Promise<Buffer>;
        (p: FSPath<PortablePath>, encoding: BufferEncoding): Promise<string>;
        (p: FSPath<PortablePath>, encoding?: BufferEncoding | null | undefined): Promise<string | Buffer>;
    };
    readFileSync: {
        (p: FSPath<PortablePath>, encoding?: null | undefined): Buffer;
        (p: FSPath<PortablePath>, encoding: BufferEncoding): string;
        (p: FSPath<PortablePath>, encoding?: BufferEncoding | null | undefined): string | Buffer;
    };
    readlinkPromise: (p: PortablePath) => Promise<PortablePath>;
    readlinkSync: (p: PortablePath) => PortablePath;
    readPromise: (fd: number, buffer: Buffer, offset: number, length: number, position: number) => Promise<number>;
    readSync: (fd: number, buffer: Buffer, offset: number, length: number, position: number) => number;
    renamePromise: (oldP: PortablePath, newP: PortablePath) => Promise<void>;
    renameSync: (oldP: PortablePath, newP: PortablePath) => void;
    resolve: (p: PortablePath) => PortablePath;
    statPromise: {
        (p: PortablePath): Promise<import("fs").Stats>;
        (p: PortablePath, opts: (import("@yarnpkg/fslib").StatOptions & {
            bigint?: false | undefined;
        }) | undefined): Promise<import("fs").Stats>;
        (p: PortablePath, opts: import("@yarnpkg/fslib").StatOptions & {
            bigint: true;
        }): Promise<import("fs").BigIntStats>;
        (p: PortablePath, opts?: import("@yarnpkg/fslib").StatOptions | undefined): Promise<import("fs").Stats | import("fs").BigIntStats>;
    };
    statSync: {
        (p: PortablePath): import("fs").Stats;
        (p: PortablePath, opts?: (import("@yarnpkg/fslib").StatSyncOptions & {
            bigint?: false | undefined;
            throwIfNoEntry: false;
        }) | undefined): import("fs").Stats | undefined;
        (p: PortablePath, opts: import("@yarnpkg/fslib").StatSyncOptions & {
            bigint: true;
            throwIfNoEntry: false;
        }): import("fs").BigIntStats | undefined;
        (p: PortablePath, opts?: (import("@yarnpkg/fslib").StatSyncOptions & {
            bigint?: false | undefined;
        }) | undefined): import("fs").Stats;
        (p: PortablePath, opts: import("@yarnpkg/fslib").StatSyncOptions & {
            bigint: true;
        }): import("fs").BigIntStats;
        (p: PortablePath, opts: import("@yarnpkg/fslib").StatSyncOptions & {
            bigint: boolean;
            throwIfNoEntry?: false | undefined;
        }): import("fs").Stats | import("fs").BigIntStats;
    };
    symlinkPromise: (target: PortablePath, p: PortablePath, type?: import("@yarnpkg/fslib").SymlinkType | undefined) => Promise<void>;
    symlinkSync: (target: PortablePath, p: PortablePath, type?: import("@yarnpkg/fslib").SymlinkType | undefined) => void;
    truncatePromise: (p: PortablePath, len?: number | undefined) => Promise<void>;
    truncateSync: (p: PortablePath, len?: number | undefined) => void;
    ftruncatePromise: (fd: number, len?: number | undefined) => Promise<void>;
    ftruncateSync: (fd: number, len?: number | undefined) => void;
    unlinkPromise: (p: PortablePath) => Promise<void>;
    unlinkSync: (p: PortablePath) => void;
    unwatchFile: (p: PortablePath, cb?: import("@yarnpkg/fslib").WatchFileCallback | undefined) => void;
    utimesPromise: (p: PortablePath, atime: string | number | Date, mtime: string | number | Date) => Promise<void>;
    utimesSync: (p: PortablePath, atime: string | number | Date, mtime: string | number | Date) => void;
    lutimesPromise: (p: PortablePath, atime: string | number | Date, mtime: string | number | Date) => Promise<void>;
    lutimesSync: (p: PortablePath, atime: string | number | Date, mtime: string | number | Date) => void;
    watch: {
        (p: PortablePath, cb?: import("@yarnpkg/fslib").WatchCallback | undefined): import("@yarnpkg/fslib").Watcher;
        (p: PortablePath, opts: import("@yarnpkg/fslib").WatchOptions, cb?: import("@yarnpkg/fslib").WatchCallback | undefined): import("@yarnpkg/fslib").Watcher;
    };
    watchFile: {
        (p: PortablePath, cb: import("@yarnpkg/fslib").WatchFileCallback): import("@yarnpkg/fslib").StatWatcher;
        (p: PortablePath, opts: Partial<{
            bigint: boolean;
            persistent: boolean;
            interval: number;
        }>, cb: import("@yarnpkg/fslib").WatchFileCallback): import("@yarnpkg/fslib").StatWatcher;
    };
    writeFilePromise: (p: FSPath<PortablePath>, content: string | NodeJS.ArrayBufferView, opts?: import("@yarnpkg/fslib").WriteFileOptions | undefined) => Promise<void>;
    writeFileSync: (p: FSPath<PortablePath>, content: string | NodeJS.ArrayBufferView, opts?: import("@yarnpkg/fslib").WriteFileOptions | undefined) => void;
    writePromise: {
        (fd: number, buffer: Buffer, offset?: number | undefined, length?: number | undefined, position?: number | undefined): Promise<number>;
        (fd: number, buffer: string, position?: number | undefined): Promise<number>;
    };
    writeSync: {
        (fd: number, buffer: Buffer, offset?: number | undefined, length?: number | undefined, position?: number | undefined): number;
        (fd: number, buffer: string, position?: number | undefined): number;
    };
    remapFd: any;
}
