"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Bundle = exports.toStream = void 0;
const path_1 = require("path");
const stream_1 = require("stream");
const archiver_1 = __importDefault(require("archiver"));
function makeRelativeToZip(cwd, path) {
    return '/snapshot/' + (0, path_1.relative)(cwd, path);
}
function toStream(content) {
    const readable = new stream_1.Readable({
        read() {
            this.push(content);
            this.push(null);
        },
    });
    return readable;
}
exports.toStream = toStream;
class Bundle {
    constructor({ cwd } = { cwd: process.cwd() }) {
        this.files = new Set();
        this.cwd = cwd;
        this.zip = (0, archiver_1.default)('zip');
    }
    get list() {
        return Array.from(this.files);
    }
    addResource(absoluteFileName, content) {
        const destPath = makeRelativeToZip(this.cwd, absoluteFileName);
        if (!this.files.has(destPath)) {
            if (content == null) {
                this.zip.file(absoluteFileName, { name: destPath });
            }
            else {
                this.zip.append(content, { name: destPath });
            }
            this.files.add(destPath);
        }
    }
    finalize() {
        return this.zip.finalize();
    }
    toStream() {
        return this.zip;
    }
}
exports.Bundle = Bundle;
