"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const util_1 = require("../util");
function default_1(compiler, next) {
    return __awaiter(this, void 0, void 0, function* () {
        yield next();
        compiler.shims.push((0, util_1.wrap)([
            'process.__nexe = {};',
            'const fsPatcher = (function() {',
            'const module = {exports: {}};',
            'const exports = module.exports;',
            "var __node_require__ = require, __node_module__ = module;\n/******/ (() => { // webpackBootstrap\n/******/ \tvar __webpack_modules__ = ({\n\n/***/ 5:\n/***/ ((__unused_webpack_module, exports, __webpack_require__) => {\n\n\"use strict\";\n\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.AliasFS = void 0;\nconst ProxiedFS_1 = __webpack_require__(105);\nclass AliasFS extends ProxiedFS_1.ProxiedFS {\n    constructor(target, { baseFs, pathUtils }) {\n        super(pathUtils);\n        this.target = target;\n        this.baseFs = baseFs;\n    }\n    getRealPath() {\n        return this.target;\n    }\n    getBaseFs() {\n        return this.baseFs;\n    }\n    mapFromBase(p) {\n        return p;\n    }\n    mapToBase(p) {\n        return p;\n    }\n}\nexports.AliasFS = AliasFS;\n\n\n/***/ }),\n\n/***/ 472:\n/***/ ((__unused_webpack_module, exports, __webpack_require__) => {\n\n\"use strict\";\n\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.CwdFS = void 0;\nconst NodeFS_1 = __webpack_require__(843);\nconst ProxiedFS_1 = __webpack_require__(105);\nconst path_1 = __webpack_require__(905);\nclass CwdFS extends ProxiedFS_1.ProxiedFS {\n    constructor(target, { baseFs = new NodeFS_1.NodeFS() } = {}) {\n        super(path_1.ppath);\n        this.target = this.pathUtils.normalize(target);\n        this.baseFs = baseFs;\n    }\n    getRealPath() {\n        return this.pathUtils.resolve(this.baseFs.getRealPath(), this.target);\n    }\n    resolve(p) {\n        if (this.pathUtils.isAbsolute(p)) {\n            return path_1.ppath.normalize(p);\n        }\n        else {\n            return this.baseFs.resolve(path_1.ppath.join(this.target, p));\n        }\n    }\n    mapFromBase(path) {\n        return path;\n    }\n    mapToBase(path) {\n        if (this.pathUtils.isAbsolute(path)) {\n            return path;\n        }\n        else {\n            return this.pathUtils.join(this.target, path);\n        }\n    }\n}\nexports.CwdFS = CwdFS;\n\n\n/***/ }),\n\n/***/ 498:\n/***/ ((__unused_webpack_module, exports, __webpack_require__) => {\n\n\"use strict\";\n\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.normalizeLineEndings = exports.BasePortableFakeFS = exports.FakeFS = void 0;\nconst crypto_1 = __webpack_require__(113);\nconst os_1 = __webpack_require__(37);\nconst copyPromise_1 = __webpack_require__(142);\nconst path_1 = __webpack_require__(905);\nclass FakeFS {\n    constructor(pathUtils) {\n        this.pathUtils = pathUtils;\n    }\n    async *genTraversePromise(init, { stableSort = false } = {}) {\n        const stack = [init];\n        while (stack.length > 0) {\n            const p = stack.shift();\n            const entry = await this.lstatPromise(p);\n            if (entry.isDirectory()) {\n                const entries = await this.readdirPromise(p);\n                if (stableSort) {\n                    for (const entry of entries.sort()) {\n                        stack.push(this.pathUtils.join(p, entry));\n                    }\n                }\n                else {\n                    throw new Error(`Not supported`);\n                }\n            }\n            else {\n                yield p;\n            }\n        }\n    }\n    async checksumFilePromise(path, { algorithm = `sha512` } = {}) {\n        const fd = await this.openPromise(path, `r`);\n        try {\n            const CHUNK_SIZE = 65536;\n            const chunk = Buffer.allocUnsafeSlow(CHUNK_SIZE);\n            const hash = (0, crypto_1.createHash)(algorithm);\n            let bytesRead = 0;\n            while ((bytesRead = await this.readPromise(fd, chunk, 0, CHUNK_SIZE)) !== 0)\n                hash.update(bytesRead === CHUNK_SIZE ? chunk : chunk.slice(0, bytesRead));\n            return hash.digest(`hex`);\n        }\n        finally {\n            await this.closePromise(fd);\n        }\n    }\n    async removePromise(p, { recursive = true, maxRetries = 5 } = {}) {\n        let stat;\n        try {\n            stat = await this.lstatPromise(p);\n        }\n        catch (error) {\n            if (error.code === `ENOENT`) {\n                return;\n            }\n            else {\n                throw error;\n            }\n        }\n        if (stat.isDirectory()) {\n            if (recursive) {\n                const entries = await this.readdirPromise(p);\n                await Promise.all(entries.map(entry => {\n                    return this.removePromise(this.pathUtils.resolve(p, entry));\n                }));\n            }\n            // 5 gives 1s worth of retries at worst\n            for (let t = 0; t <= maxRetries; t++) {\n                try {\n                    await this.rmdirPromise(p);\n                    break;\n                }\n                catch (error) {\n                    if (error.code !== `EBUSY` && error.code !== `ENOTEMPTY`) {\n                        throw error;\n                    }\n                    else if (t < maxRetries) {\n                        await new Promise(resolve => setTimeout(resolve, t * 100));\n                    }\n                }\n            }\n        }\n        else {\n            await this.unlinkPromise(p);\n        }\n    }\n    removeSync(p, { recursive = true } = {}) {\n        let stat;\n        try {\n            stat = this.lstatSync(p);\n        }\n        catch (error) {\n            if (error.code === `ENOENT`) {\n                return;\n            }\n            else {\n                throw error;\n            }\n        }\n        if (stat.isDirectory()) {\n            if (recursive)\n                for (const entry of this.readdirSync(p))\n                    this.removeSync(this.pathUtils.resolve(p, entry));\n            this.rmdirSync(p);\n        }\n        else {\n            this.unlinkSync(p);\n        }\n    }\n    async mkdirpPromise(p, { chmod, utimes } = {}) {\n        p = this.resolve(p);\n        if (p === this.pathUtils.dirname(p))\n            return undefined;\n        const parts = p.split(this.pathUtils.sep);\n        let createdDirectory;\n        for (let u = 2; u <= parts.length; ++u) {\n            const subPath = parts.slice(0, u).join(this.pathUtils.sep);\n            if (!this.existsSync(subPath)) {\n                try {\n                    await this.mkdirPromise(subPath);\n                }\n                catch (error) {\n                    if (error.code === `EEXIST`) {\n                        continue;\n                    }\n                    else {\n                        throw error;\n                    }\n                }\n                createdDirectory !== null && createdDirectory !== void 0 ? createdDirectory : (createdDirectory = subPath);\n                if (chmod != null)\n                    await this.chmodPromise(subPath, chmod);\n                if (utimes != null) {\n                    await this.utimesPromise(subPath, utimes[0], utimes[1]);\n                }\n                else {\n                    const parentStat = await this.statPromise(this.pathUtils.dirname(subPath));\n                    await this.utimesPromise(subPath, parentStat.atime, parentStat.mtime);\n                }\n            }\n        }\n        return createdDirectory;\n    }\n    mkdirpSync(p, { chmod, utimes } = {}) {\n        p = this.resolve(p);\n        if (p === this.pathUtils.dirname(p))\n            return undefined;\n        const parts = p.split(this.pathUtils.sep);\n        let createdDirectory;\n        for (let u = 2; u <= parts.length; ++u) {\n            const subPath = parts.slice(0, u).join(this.pathUtils.sep);\n            if (!this.existsSync(subPath)) {\n                try {\n                    this.mkdirSync(subPath);\n                }\n                catch (error) {\n                    if (error.code === `EEXIST`) {\n                        continue;\n                    }\n                    else {\n                        throw error;\n                    }\n                }\n                createdDirectory !== null && createdDirectory !== void 0 ? createdDirectory : (createdDirectory = subPath);\n                if (chmod != null)\n                    this.chmodSync(subPath, chmod);\n                if (utimes != null) {\n                    this.utimesSync(subPath, utimes[0], utimes[1]);\n                }\n                else {\n                    const parentStat = this.statSync(this.pathUtils.dirname(subPath));\n                    this.utimesSync(subPath, parentStat.atime, parentStat.mtime);\n                }\n            }\n        }\n        return createdDirectory;\n    }\n    async copyPromise(destination, source, { baseFs = this, overwrite = true, stableSort = false, stableTime = false, linkStrategy = null } = {}) {\n        return await (0, copyPromise_1.copyPromise)(this, destination, baseFs, source, { overwrite, stableSort, stableTime, linkStrategy });\n    }\n    copySync(destination, source, { baseFs = this, overwrite = true } = {}) {\n        const stat = baseFs.lstatSync(source);\n        const exists = this.existsSync(destination);\n        if (stat.isDirectory()) {\n            this.mkdirpSync(destination);\n            const directoryListing = baseFs.readdirSync(source);\n            for (const entry of directoryListing) {\n                this.copySync(this.pathUtils.join(destination, entry), baseFs.pathUtils.join(source, entry), { baseFs, overwrite });\n            }\n        }\n        else if (stat.isFile()) {\n            if (!exists || overwrite) {\n                if (exists)\n                    this.removeSync(destination);\n                const content = baseFs.readFileSync(source);\n                this.writeFileSync(destination, content);\n            }\n        }\n        else if (stat.isSymbolicLink()) {\n            if (!exists || overwrite) {\n                if (exists)\n                    this.removeSync(destination);\n                const target = baseFs.readlinkSync(source);\n                this.symlinkSync((0, path_1.convertPath)(this.pathUtils, target), destination);\n            }\n        }\n        else {\n            throw new Error(`Unsupported file type (file: ${source}, mode: 0o${stat.mode.toString(8).padStart(6, `0`)})`);\n        }\n        const mode = stat.mode & 0o777;\n        this.chmodSync(destination, mode);\n    }\n    async changeFilePromise(p, content, opts = {}) {\n        if (Buffer.isBuffer(content)) {\n            return this.changeFileBufferPromise(p, content, opts);\n        }\n        else {\n            return this.changeFileTextPromise(p, content, opts);\n        }\n    }\n    async changeFileBufferPromise(p, content, { mode } = {}) {\n        let current = Buffer.alloc(0);\n        try {\n            current = await this.readFilePromise(p);\n        }\n        catch (error) {\n            // ignore errors, no big deal\n        }\n        if (Buffer.compare(current, content) === 0)\n            return;\n        await this.writeFilePromise(p, content, { mode });\n    }\n    async changeFileTextPromise(p, content, { automaticNewlines, mode } = {}) {\n        let current = ``;\n        try {\n            current = await this.readFilePromise(p, `utf8`);\n        }\n        catch (error) {\n            // ignore errors, no big deal\n        }\n        const normalizedContent = automaticNewlines\n            ? normalizeLineEndings(current, content)\n            : content;\n        if (current === normalizedContent)\n            return;\n        await this.writeFilePromise(p, normalizedContent, { mode });\n    }\n    changeFileSync(p, content, opts = {}) {\n        if (Buffer.isBuffer(content)) {\n            return this.changeFileBufferSync(p, content, opts);\n        }\n        else {\n            return this.changeFileTextSync(p, content, opts);\n        }\n    }\n    changeFileBufferSync(p, content, { mode } = {}) {\n        let current = Buffer.alloc(0);\n        try {\n            current = this.readFileSync(p);\n        }\n        catch (error) {\n            // ignore errors, no big deal\n        }\n        if (Buffer.compare(current, content) === 0)\n            return;\n        this.writeFileSync(p, content, { mode });\n    }\n    changeFileTextSync(p, content, { automaticNewlines = false, mode } = {}) {\n        let current = ``;\n        try {\n            current = this.readFileSync(p, `utf8`);\n        }\n        catch (error) {\n            // ignore errors, no big deal\n        }\n        const normalizedContent = automaticNewlines\n            ? normalizeLineEndings(current, content)\n            : content;\n        if (current === normalizedContent)\n            return;\n        this.writeFileSync(p, normalizedContent, { mode });\n    }\n    async movePromise(fromP, toP) {\n        try {\n            await this.renamePromise(fromP, toP);\n        }\n        catch (error) {\n            if (error.code === `EXDEV`) {\n                await this.copyPromise(toP, fromP);\n                await this.removePromise(fromP);\n            }\n            else {\n                throw error;\n            }\n        }\n    }\n    moveSync(fromP, toP) {\n        try {\n            this.renameSync(fromP, toP);\n        }\n        catch (error) {\n            if (error.code === `EXDEV`) {\n                this.copySync(toP, fromP);\n                this.removeSync(fromP);\n            }\n            else {\n                throw error;\n            }\n        }\n    }\n    async lockPromise(affectedPath, callback) {\n        const lockPath = `${affectedPath}.flock`;\n        const interval = 1000 / 60;\n        const startTime = Date.now();\n        let fd = null;\n        // Even when we detect that a lock file exists, we still look inside to see\n        // whether the pid that created it is still alive. It's not foolproof\n        // (there are false positive), but there are no false negative and that's\n        // all that matters in 99% of the cases.\n        const isAlive = async () => {\n            let pid;\n            try {\n                ([pid] = await this.readJsonPromise(lockPath));\n            }\n            catch (error) {\n                // If we can't read the file repeatedly, we assume the process was\n                // aborted before even writing finishing writing the payload.\n                return Date.now() - startTime < 500;\n            }\n            try {\n                // \"As a special case, a signal of 0 can be used to test for the\n                // existence of a process\" - so we check whether it's alive.\n                process.kill(pid, 0);\n                return true;\n            }\n            catch (error) {\n                return false;\n            }\n        };\n        while (fd === null) {\n            try {\n                fd = await this.openPromise(lockPath, `wx`);\n            }\n            catch (error) {\n                if (error.code === `EEXIST`) {\n                    if (!await isAlive()) {\n                        try {\n                            await this.unlinkPromise(lockPath);\n                            continue;\n                        }\n                        catch (error) {\n                            // No big deal if we can't remove it. Just fallback to wait for\n                            // it to be eventually released by its owner.\n                        }\n                    }\n                    if (Date.now() - startTime < 60 * 1000) {\n                        await new Promise(resolve => setTimeout(resolve, interval));\n                    }\n                    else {\n                        throw new Error(`Couldn't acquire a lock in a reasonable time (via ${lockPath})`);\n                    }\n                }\n                else {\n                    throw error;\n                }\n            }\n        }\n        await this.writePromise(fd, JSON.stringify([process.pid]));\n        try {\n            return await callback();\n        }\n        finally {\n            try {\n                // closePromise needs to come before unlinkPromise otherwise another process can attempt\n                // to get the file handle after the unlink but before close resuling in\n                // EPERM: operation not permitted, open\n                await this.closePromise(fd);\n                await this.unlinkPromise(lockPath);\n            }\n            catch (error) {\n                // noop\n            }\n        }\n    }\n    async readJsonPromise(p) {\n        const content = await this.readFilePromise(p, `utf8`);\n        try {\n            return JSON.parse(content);\n        }\n        catch (error) {\n            error.message += ` (in ${p})`;\n            throw error;\n        }\n    }\n    readJsonSync(p) {\n        const content = this.readFileSync(p, `utf8`);\n        try {\n            return JSON.parse(content);\n        }\n        catch (error) {\n            error.message += ` (in ${p})`;\n            throw error;\n        }\n    }\n    async writeJsonPromise(p, data) {\n        return await this.writeFilePromise(p, `${JSON.stringify(data, null, 2)}\\n`);\n    }\n    writeJsonSync(p, data) {\n        return this.writeFileSync(p, `${JSON.stringify(data, null, 2)}\\n`);\n    }\n    async preserveTimePromise(p, cb) {\n        const stat = await this.lstatPromise(p);\n        const result = await cb();\n        if (typeof result !== `undefined`)\n            p = result;\n        await this.lutimesPromise(p, stat.atime, stat.mtime);\n    }\n    async preserveTimeSync(p, cb) {\n        const stat = this.lstatSync(p);\n        const result = cb();\n        if (typeof result !== `undefined`)\n            p = result;\n        this.lutimesSync(p, stat.atime, stat.mtime);\n    }\n}\nexports.FakeFS = FakeFS;\nclass BasePortableFakeFS extends FakeFS {\n    constructor() {\n        super(path_1.ppath);\n    }\n}\nexports.BasePortableFakeFS = BasePortableFakeFS;\nfunction getEndOfLine(content) {\n    const matches = content.match(/\\r?\\n/g);\n    if (matches === null)\n        return os_1.EOL;\n    const crlf = matches.filter(nl => nl === `\\r\\n`).length;\n    const lf = matches.length - crlf;\n    return crlf > lf ? `\\r\\n` : `\\n`;\n}\nfunction normalizeLineEndings(originalContent, newContent) {\n    return newContent.replace(/\\r?\\n/g, getEndOfLine(originalContent));\n}\nexports.normalizeLineEndings = normalizeLineEndings;\n\n\n/***/ }),\n\n/***/ 238:\n/***/ ((__unused_webpack_module, exports, __webpack_require__) => {\n\n\"use strict\";\n\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.JailFS = void 0;\nconst NodeFS_1 = __webpack_require__(843);\nconst ProxiedFS_1 = __webpack_require__(105);\nconst path_1 = __webpack_require__(905);\nconst JAIL_ROOT = path_1.PortablePath.root;\nclass JailFS extends ProxiedFS_1.ProxiedFS {\n    constructor(target, { baseFs = new NodeFS_1.NodeFS() } = {}) {\n        super(path_1.ppath);\n        this.target = this.pathUtils.resolve(path_1.PortablePath.root, target);\n        this.baseFs = baseFs;\n    }\n    getRealPath() {\n        return this.pathUtils.resolve(this.baseFs.getRealPath(), this.pathUtils.relative(path_1.PortablePath.root, this.target));\n    }\n    getTarget() {\n        return this.target;\n    }\n    getBaseFs() {\n        return this.baseFs;\n    }\n    mapToBase(p) {\n        const normalized = this.pathUtils.normalize(p);\n        if (this.pathUtils.isAbsolute(p))\n            return this.pathUtils.resolve(this.target, this.pathUtils.relative(JAIL_ROOT, p));\n        if (normalized.match(/^\\.\\.\\/?/))\n            throw new Error(`Resolving this path (${p}) would escape the jail`);\n        return this.pathUtils.resolve(this.target, p);\n    }\n    mapFromBase(p) {\n        return this.pathUtils.resolve(JAIL_ROOT, this.pathUtils.relative(this.target, p));\n    }\n}\nexports.JailFS = JailFS;\n\n\n/***/ }),\n\n/***/ 130:\n/***/ ((__unused_webpack_module, exports, __webpack_require__) => {\n\n\"use strict\";\n\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.LazyFS = void 0;\nconst ProxiedFS_1 = __webpack_require__(105);\nclass LazyFS extends ProxiedFS_1.ProxiedFS {\n    constructor(factory, pathUtils) {\n        super(pathUtils);\n        this.instance = null;\n        this.factory = factory;\n    }\n    get baseFs() {\n        if (!this.instance)\n            this.instance = this.factory();\n        return this.instance;\n    }\n    set baseFs(value) {\n        this.instance = value;\n    }\n    mapFromBase(p) {\n        return p;\n    }\n    mapToBase(p) {\n        return p;\n    }\n}\nexports.LazyFS = LazyFS;\n\n\n/***/ }),\n\n/***/ 547:\n/***/ ((__unused_webpack_module, exports, __webpack_require__) => {\n\n\"use strict\";\n\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MountFS = void 0;\nconst tslib_1 = __webpack_require__(177);\nconst fs_1 = __webpack_require__(147);\nconst FakeFS_1 = __webpack_require__(498);\nconst NodeFS_1 = __webpack_require__(843);\nconst watchFile_1 = __webpack_require__(126);\nconst errors = tslib_1.__importStar(__webpack_require__(377));\nconst path_1 = __webpack_require__(905);\n// Only file descriptors prefixed by those values will be forwarded to the MountFS\n// instances. Note that the highest MOUNT_MAGIC bit MUST NOT be set, otherwise the\n// resulting fd becomes a negative integer, which isn't supposed to happen per\n// the unix rules (caused problems w/ Go).\n//\n// Those values must be synced with packages/yarnpkg-pnp/sources/esm-loader/fspatch.ts\n//\nconst MOUNT_MASK = 0xff000000;\nclass MountFS extends FakeFS_1.BasePortableFakeFS {\n    constructor({ baseFs = new NodeFS_1.NodeFS(), filter = null, magicByte = 0x2a, maxOpenFiles = Infinity, useCache = true, maxAge = 5000, typeCheck = fs_1.constants.S_IFREG, getMountPoint, factoryPromise, factorySync }) {\n        if (Math.floor(magicByte) !== magicByte || !(magicByte > 1 && magicByte <= 127))\n            throw new Error(`The magic byte must be set to a round value between 1 and 127 included`);\n        super();\n        this.fdMap = new Map();\n        this.nextFd = 3;\n        this.isMount = new Set();\n        this.notMount = new Set();\n        this.realPaths = new Map();\n        this.limitOpenFilesTimeout = null;\n        this.baseFs = baseFs;\n        this.mountInstances = useCache ? new Map() : null;\n        this.factoryPromise = factoryPromise;\n        this.factorySync = factorySync;\n        this.filter = filter;\n        this.getMountPoint = getMountPoint;\n        this.magic = magicByte << 24;\n        this.maxAge = maxAge;\n        this.maxOpenFiles = maxOpenFiles;\n        this.typeCheck = typeCheck;\n    }\n    getExtractHint(hints) {\n        return this.baseFs.getExtractHint(hints);\n    }\n    getRealPath() {\n        return this.baseFs.getRealPath();\n    }\n    saveAndClose() {\n        var _a;\n        (0, watchFile_1.unwatchAllFiles)(this);\n        if (this.mountInstances) {\n            for (const [path, { childFs }] of this.mountInstances.entries()) {\n                (_a = childFs.saveAndClose) === null || _a === void 0 ? void 0 : _a.call(childFs);\n                this.mountInstances.delete(path);\n            }\n        }\n    }\n    discardAndClose() {\n        var _a;\n        (0, watchFile_1.unwatchAllFiles)(this);\n        if (this.mountInstances) {\n            for (const [path, { childFs }] of this.mountInstances.entries()) {\n                (_a = childFs.discardAndClose) === null || _a === void 0 ? void 0 : _a.call(childFs);\n                this.mountInstances.delete(path);\n            }\n        }\n    }\n    resolve(p) {\n        return this.baseFs.resolve(p);\n    }\n    remapFd(mountFs, fd) {\n        const remappedFd = this.nextFd++ | this.magic;\n        this.fdMap.set(remappedFd, [mountFs, fd]);\n        return remappedFd;\n    }\n    async openPromise(p, flags, mode) {\n        return await this.makeCallPromise(p, async () => {\n            return await this.baseFs.openPromise(p, flags, mode);\n        }, async (mountFs, { subPath }) => {\n            return this.remapFd(mountFs, await mountFs.openPromise(subPath, flags, mode));\n        });\n    }\n    openSync(p, flags, mode) {\n        return this.makeCallSync(p, () => {\n            return this.baseFs.openSync(p, flags, mode);\n        }, (mountFs, { subPath }) => {\n            return this.remapFd(mountFs, mountFs.openSync(subPath, flags, mode));\n        });\n    }\n    async opendirPromise(p, opts) {\n        return await this.makeCallPromise(p, async () => {\n            return await this.baseFs.opendirPromise(p, opts);\n        }, async (mountFs, { subPath }) => {\n            return await mountFs.opendirPromise(subPath, opts);\n        }, {\n            requireSubpath: false,\n        });\n    }\n    opendirSync(p, opts) {\n        return this.makeCallSync(p, () => {\n            return this.baseFs.opendirSync(p, opts);\n        }, (mountFs, { subPath }) => {\n            return mountFs.opendirSync(subPath, opts);\n        }, {\n            requireSubpath: false,\n        });\n    }\n    async readPromise(fd, buffer, offset, length, position) {\n        if ((fd & MOUNT_MASK) !== this.magic)\n            return await this.baseFs.readPromise(fd, buffer, offset, length, position);\n        const entry = this.fdMap.get(fd);\n        if (typeof entry === `undefined`)\n            throw errors.EBADF(`read`);\n        const [mountFs, realFd] = entry;\n        return await mountFs.readPromise(realFd, buffer, offset, length, position);\n    }\n    readSync(fd, buffer, offset, length, position) {\n        if ((fd & MOUNT_MASK) !== this.magic)\n            return this.baseFs.readSync(fd, buffer, offset, length, position);\n        const entry = this.fdMap.get(fd);\n        if (typeof entry === `undefined`)\n            throw errors.EBADF(`readSync`);\n        const [mountFs, realFd] = entry;\n        return mountFs.readSync(realFd, buffer, offset, length, position);\n    }\n    async writePromise(fd, buffer, offset, length, position) {\n        if ((fd & MOUNT_MASK) !== this.magic) {\n            if (typeof buffer === `string`) {\n                return await this.baseFs.writePromise(fd, buffer, offset);\n            }\n            else {\n                return await this.baseFs.writePromise(fd, buffer, offset, length, position);\n            }\n        }\n        const entry = this.fdMap.get(fd);\n        if (typeof entry === `undefined`)\n            throw errors.EBADF(`write`);\n        const [mountFs, realFd] = entry;\n        if (typeof buffer === `string`) {\n            return await mountFs.writePromise(realFd, buffer, offset);\n        }\n        else {\n            return await mountFs.writePromise(realFd, buffer, offset, length, position);\n        }\n    }\n    writeSync(fd, buffer, offset, length, position) {\n        if ((fd & MOUNT_MASK) !== this.magic) {\n            if (typeof buffer === `string`) {\n                return this.baseFs.writeSync(fd, buffer, offset);\n            }\n            else {\n                return this.baseFs.writeSync(fd, buffer, offset, length, position);\n            }\n        }\n        const entry = this.fdMap.get(fd);\n        if (typeof entry === `undefined`)\n            throw errors.EBADF(`writeSync`);\n        const [mountFs, realFd] = entry;\n        if (typeof buffer === `string`) {\n            return mountFs.writeSync(realFd, buffer, offset);\n        }\n        else {\n            return mountFs.writeSync(realFd, buffer, offset, length, position);\n        }\n    }\n    async closePromise(fd) {\n        if ((fd & MOUNT_MASK) !== this.magic)\n            return await this.baseFs.closePromise(fd);\n        const entry = this.fdMap.get(fd);\n        if (typeof entry === `undefined`)\n            throw errors.EBADF(`close`);\n        this.fdMap.delete(fd);\n        const [mountFs, realFd] = entry;\n        return await mountFs.closePromise(realFd);\n    }\n    closeSync(fd) {\n        if ((fd & MOUNT_MASK) !== this.magic)\n            return this.baseFs.closeSync(fd);\n        const entry = this.fdMap.get(fd);\n        if (typeof entry === `undefined`)\n            throw errors.EBADF(`closeSync`);\n        this.fdMap.delete(fd);\n        const [mountFs, realFd] = entry;\n        return mountFs.closeSync(realFd);\n    }\n    createReadStream(p, opts) {\n        if (p === null)\n            return this.baseFs.createReadStream(p, opts);\n        return this.makeCallSync(p, () => {\n            return this.baseFs.createReadStream(p, opts);\n        }, (mountFs, { archivePath, subPath }) => {\n            const stream = mountFs.createReadStream(subPath, opts);\n            // This is a very hacky workaround. `MountOpenFS` shouldn't have to work with `NativePath`s.\n            // Ref: https://github.com/yarnpkg/berry/pull/3774\n            // TODO: think of a better solution\n            stream.path = path_1.npath.fromPortablePath(this.pathUtils.join(archivePath, subPath));\n            return stream;\n        });\n    }\n    createWriteStream(p, opts) {\n        if (p === null)\n            return this.baseFs.createWriteStream(p, opts);\n        return this.makeCallSync(p, () => {\n            return this.baseFs.createWriteStream(p, opts);\n        }, (mountFs, { subPath }) => {\n            return mountFs.createWriteStream(subPath, opts);\n        });\n    }\n    async realpathPromise(p) {\n        return await this.makeCallPromise(p, async () => {\n            return await this.baseFs.realpathPromise(p);\n        }, async (mountFs, { archivePath, subPath }) => {\n            let realArchivePath = this.realPaths.get(archivePath);\n            if (typeof realArchivePath === `undefined`) {\n                realArchivePath = await this.baseFs.realpathPromise(archivePath);\n                this.realPaths.set(archivePath, realArchivePath);\n            }\n            return this.pathUtils.join(realArchivePath, this.pathUtils.relative(path_1.PortablePath.root, await mountFs.realpathPromise(subPath)));\n        });\n    }\n    realpathSync(p) {\n        return this.makeCallSync(p, () => {\n            return this.baseFs.realpathSync(p);\n        }, (mountFs, { archivePath, subPath }) => {\n            let realArchivePath = this.realPaths.get(archivePath);\n            if (typeof realArchivePath === `undefined`) {\n                realArchivePath = this.baseFs.realpathSync(archivePath);\n                this.realPaths.set(archivePath, realArchivePath);\n            }\n            return this.pathUtils.join(realArchivePath, this.pathUtils.relative(path_1.PortablePath.root, mountFs.realpathSync(subPath)));\n        });\n    }\n    async existsPromise(p) {\n        return await this.makeCallPromise(p, async () => {\n            return await this.baseFs.existsPromise(p);\n        }, async (mountFs, { subPath }) => {\n            return await mountFs.existsPromise(subPath);\n        });\n    }\n    existsSync(p) {\n        return this.makeCallSync(p, () => {\n            return this.baseFs.existsSync(p);\n        }, (mountFs, { subPath }) => {\n            return mountFs.existsSync(subPath);\n        });\n    }\n    async accessPromise(p, mode) {\n        return await this.makeCallPromise(p, async () => {\n            return await this.baseFs.accessPromise(p, mode);\n        }, async (mountFs, { subPath }) => {\n            return await mountFs.accessPromise(subPath, mode);\n        });\n    }\n    accessSync(p, mode) {\n        return this.makeCallSync(p, () => {\n            return this.baseFs.accessSync(p, mode);\n        }, (mountFs, { subPath }) => {\n            return mountFs.accessSync(subPath, mode);\n        });\n    }\n    async statPromise(p, opts) {\n        return await this.makeCallPromise(p, async () => {\n            return await this.baseFs.statPromise(p, opts);\n        }, async (mountFs, { subPath }) => {\n            return await mountFs.statPromise(subPath, opts);\n        });\n    }\n    statSync(p, opts) {\n        return this.makeCallSync(p, () => {\n            return this.baseFs.statSync(p, opts);\n        }, (mountFs, { subPath }) => {\n            return mountFs.statSync(subPath, opts);\n        });\n    }\n    async fstatPromise(fd, opts) {\n        if ((fd & MOUNT_MASK) !== this.magic)\n            return this.baseFs.fstatPromise(fd, opts);\n        const entry = this.fdMap.get(fd);\n        if (typeof entry === `undefined`)\n            throw errors.EBADF(`fstat`);\n        const [mountFs, realFd] = entry;\n        return mountFs.fstatPromise(realFd, opts);\n    }\n    fstatSync(fd, opts) {\n        if ((fd & MOUNT_MASK) !== this.magic)\n            return this.baseFs.fstatSync(fd, opts);\n        const entry = this.fdMap.get(fd);\n        if (typeof entry === `undefined`)\n            throw errors.EBADF(`fstatSync`);\n        const [mountFs, realFd] = entry;\n        return mountFs.fstatSync(realFd, opts);\n    }\n    async lstatPromise(p, opts) {\n        return await this.makeCallPromise(p, async () => {\n            return await this.baseFs.lstatPromise(p, opts);\n        }, async (mountFs, { subPath }) => {\n            return await mountFs.lstatPromise(subPath, opts);\n        });\n    }\n    lstatSync(p, opts) {\n        return this.makeCallSync(p, () => {\n            return this.baseFs.lstatSync(p, opts);\n        }, (mountFs, { subPath }) => {\n            return mountFs.lstatSync(subPath, opts);\n        });\n    }\n    async fchmodPromise(fd, mask) {\n        if ((fd & MOUNT_MASK) !== this.magic)\n            return this.baseFs.fchmodPromise(fd, mask);\n        const entry = this.fdMap.get(fd);\n        if (typeof entry === `undefined`)\n            throw errors.EBADF(`fchmod`);\n        const [mountFs, realFd] = entry;\n        return mountFs.fchmodPromise(realFd, mask);\n    }\n    fchmodSync(fd, mask) {\n        if ((fd & MOUNT_MASK) !== this.magic)\n            return this.baseFs.fchmodSync(fd, mask);\n        const entry = this.fdMap.get(fd);\n        if (typeof entry === `undefined`)\n            throw errors.EBADF(`fchmodSync`);\n        const [mountFs, realFd] = entry;\n        return mountFs.fchmodSync(realFd, mask);\n    }\n    async chmodPromise(p, mask) {\n        return await this.makeCallPromise(p, async () => {\n            return await this.baseFs.chmodPromise(p, mask);\n        }, async (mountFs, { subPath }) => {\n            return await mountFs.chmodPromise(subPath, mask);\n        });\n    }\n    chmodSync(p, mask) {\n        return this.makeCallSync(p, () => {\n            return this.baseFs.chmodSync(p, mask);\n        }, (mountFs, { subPath }) => {\n            return mountFs.chmodSync(subPath, mask);\n        });\n    }\n    async fchownPromise(fd, uid, gid) {\n        if ((fd & MOUNT_MASK) !== this.magic)\n            return this.baseFs.fchownPromise(fd, uid, gid);\n        const entry = this.fdMap.get(fd);\n        if (typeof entry === `undefined`)\n            throw errors.EBADF(`fchown`);\n        const [zipFs, realFd] = entry;\n        return zipFs.fchownPromise(realFd, uid, gid);\n    }\n    fchownSync(fd, uid, gid) {\n        if ((fd & MOUNT_MASK) !== this.magic)\n            return this.baseFs.fchownSync(fd, uid, gid);\n        const entry = this.fdMap.get(fd);\n        if (typeof entry === `undefined`)\n            throw errors.EBADF(`fchownSync`);\n        const [zipFs, realFd] = entry;\n        return zipFs.fchownSync(realFd, uid, gid);\n    }\n    async chownPromise(p, uid, gid) {\n        return await this.makeCallPromise(p, async () => {\n            return await this.baseFs.chownPromise(p, uid, gid);\n        }, async (mountFs, { subPath }) => {\n            return await mountFs.chownPromise(subPath, uid, gid);\n        });\n    }\n    chownSync(p, uid, gid) {\n        return this.makeCallSync(p, () => {\n            return this.baseFs.chownSync(p, uid, gid);\n        }, (mountFs, { subPath }) => {\n            return mountFs.chownSync(subPath, uid, gid);\n        });\n    }\n    async renamePromise(oldP, newP) {\n        return await this.makeCallPromise(oldP, async () => {\n            return await this.makeCallPromise(newP, async () => {\n                return await this.baseFs.renamePromise(oldP, newP);\n            }, async () => {\n                throw Object.assign(new Error(`EEXDEV: cross-device link not permitted`), { code: `EEXDEV` });\n            });\n        }, async (mountFsO, { subPath: subPathO }) => {\n            return await this.makeCallPromise(newP, async () => {\n                throw Object.assign(new Error(`EEXDEV: cross-device link not permitted`), { code: `EEXDEV` });\n            }, async (mountFsN, { subPath: subPathN }) => {\n                if (mountFsO !== mountFsN) {\n                    throw Object.assign(new Error(`EEXDEV: cross-device link not permitted`), { code: `EEXDEV` });\n                }\n                else {\n                    return await mountFsO.renamePromise(subPathO, subPathN);\n                }\n            });\n        });\n    }\n    renameSync(oldP, newP) {\n        return this.makeCallSync(oldP, () => {\n            return this.makeCallSync(newP, () => {\n                return this.baseFs.renameSync(oldP, newP);\n            }, () => {\n                throw Object.assign(new Error(`EEXDEV: cross-device link not permitted`), { code: `EEXDEV` });\n            });\n        }, (mountFsO, { subPath: subPathO }) => {\n            return this.makeCallSync(newP, () => {\n                throw Object.assign(new Error(`EEXDEV: cross-device link not permitted`), { code: `EEXDEV` });\n            }, (mountFsN, { subPath: subPathN }) => {\n                if (mountFsO !== mountFsN) {\n                    throw Object.assign(new Error(`EEXDEV: cross-device link not permitted`), { code: `EEXDEV` });\n                }\n                else {\n                    return mountFsO.renameSync(subPathO, subPathN);\n                }\n            });\n        });\n    }\n    async copyFilePromise(sourceP, destP, flags = 0) {\n        const fallback = async (sourceFs, sourceP, destFs, destP) => {\n            if ((flags & fs_1.constants.COPYFILE_FICLONE_FORCE) !== 0)\n                throw Object.assign(new Error(`EXDEV: cross-device clone not permitted, copyfile '${sourceP}' -> ${destP}'`), { code: `EXDEV` });\n            if ((flags & fs_1.constants.COPYFILE_EXCL) && await this.existsPromise(sourceP))\n                throw Object.assign(new Error(`EEXIST: file already exists, copyfile '${sourceP}' -> '${destP}'`), { code: `EEXIST` });\n            let content;\n            try {\n                content = await sourceFs.readFilePromise(sourceP);\n            }\n            catch (error) {\n                throw Object.assign(new Error(`EINVAL: invalid argument, copyfile '${sourceP}' -> '${destP}'`), { code: `EINVAL` });\n            }\n            await destFs.writeFilePromise(destP, content);\n        };\n        return await this.makeCallPromise(sourceP, async () => {\n            return await this.makeCallPromise(destP, async () => {\n                return await this.baseFs.copyFilePromise(sourceP, destP, flags);\n            }, async (mountFsD, { subPath: subPathD }) => {\n                return await fallback(this.baseFs, sourceP, mountFsD, subPathD);\n            });\n        }, async (mountFsS, { subPath: subPathS }) => {\n            return await this.makeCallPromise(destP, async () => {\n                return await fallback(mountFsS, subPathS, this.baseFs, destP);\n            }, async (mountFsD, { subPath: subPathD }) => {\n                if (mountFsS !== mountFsD) {\n                    return await fallback(mountFsS, subPathS, mountFsD, subPathD);\n                }\n                else {\n                    return await mountFsS.copyFilePromise(subPathS, subPathD, flags);\n                }\n            });\n        });\n    }\n    copyFileSync(sourceP, destP, flags = 0) {\n        const fallback = (sourceFs, sourceP, destFs, destP) => {\n            if ((flags & fs_1.constants.COPYFILE_FICLONE_FORCE) !== 0)\n                throw Object.assign(new Error(`EXDEV: cross-device clone not permitted, copyfile '${sourceP}' -> ${destP}'`), { code: `EXDEV` });\n            if ((flags & fs_1.constants.COPYFILE_EXCL) && this.existsSync(sourceP))\n                throw Object.assign(new Error(`EEXIST: file already exists, copyfile '${sourceP}' -> '${destP}'`), { code: `EEXIST` });\n            let content;\n            try {\n                content = sourceFs.readFileSync(sourceP);\n            }\n            catch (error) {\n                throw Object.assign(new Error(`EINVAL: invalid argument, copyfile '${sourceP}' -> '${destP}'`), { code: `EINVAL` });\n            }\n            destFs.writeFileSync(destP, content);\n        };\n        return this.makeCallSync(sourceP, () => {\n            return this.makeCallSync(destP, () => {\n                return this.baseFs.copyFileSync(sourceP, destP, flags);\n            }, (mountFsD, { subPath: subPathD }) => {\n                return fallback(this.baseFs, sourceP, mountFsD, subPathD);\n            });\n        }, (mountFsS, { subPath: subPathS }) => {\n            return this.makeCallSync(destP, () => {\n                return fallback(mountFsS, subPathS, this.baseFs, destP);\n            }, (mountFsD, { subPath: subPathD }) => {\n                if (mountFsS !== mountFsD) {\n                    return fallback(mountFsS, subPathS, mountFsD, subPathD);\n                }\n                else {\n                    return mountFsS.copyFileSync(subPathS, subPathD, flags);\n                }\n            });\n        });\n    }\n    async appendFilePromise(p, content, opts) {\n        return await this.makeCallPromise(p, async () => {\n            return await this.baseFs.appendFilePromise(p, content, opts);\n        }, async (mountFs, { subPath }) => {\n            return await mountFs.appendFilePromise(subPath, content, opts);\n        });\n    }\n    appendFileSync(p, content, opts) {\n        return this.makeCallSync(p, () => {\n            return this.baseFs.appendFileSync(p, content, opts);\n        }, (mountFs, { subPath }) => {\n            return mountFs.appendFileSync(subPath, content, opts);\n        });\n    }\n    async writeFilePromise(p, content, opts) {\n        return await this.makeCallPromise(p, async () => {\n            return await this.baseFs.writeFilePromise(p, content, opts);\n        }, async (mountFs, { subPath }) => {\n            return await mountFs.writeFilePromise(subPath, content, opts);\n        });\n    }\n    writeFileSync(p, content, opts) {\n        return this.makeCallSync(p, () => {\n            return this.baseFs.writeFileSync(p, content, opts);\n        }, (mountFs, { subPath }) => {\n            return mountFs.writeFileSync(subPath, content, opts);\n        });\n    }\n    async unlinkPromise(p) {\n        return await this.makeCallPromise(p, async () => {\n            return await this.baseFs.unlinkPromise(p);\n        }, async (mountFs, { subPath }) => {\n            return await mountFs.unlinkPromise(subPath);\n        });\n    }\n    unlinkSync(p) {\n        return this.makeCallSync(p, () => {\n            return this.baseFs.unlinkSync(p);\n        }, (mountFs, { subPath }) => {\n            return mountFs.unlinkSync(subPath);\n        });\n    }\n    async utimesPromise(p, atime, mtime) {\n        return await this.makeCallPromise(p, async () => {\n            return await this.baseFs.utimesPromise(p, atime, mtime);\n        }, async (mountFs, { subPath }) => {\n            return await mountFs.utimesPromise(subPath, atime, mtime);\n        });\n    }\n    utimesSync(p, atime, mtime) {\n        return this.makeCallSync(p, () => {\n            return this.baseFs.utimesSync(p, atime, mtime);\n        }, (mountFs, { subPath }) => {\n            return mountFs.utimesSync(subPath, atime, mtime);\n        });\n    }\n    async lutimesPromise(p, atime, mtime) {\n        return await this.makeCallPromise(p, async () => {\n            return await this.baseFs.lutimesPromise(p, atime, mtime);\n        }, async (mountFs, { subPath }) => {\n            return await mountFs.lutimesPromise(subPath, atime, mtime);\n        });\n    }\n    lutimesSync(p, atime, mtime) {\n        return this.makeCallSync(p, () => {\n            return this.baseFs.lutimesSync(p, atime, mtime);\n        }, (mountFs, { subPath }) => {\n            return mountFs.lutimesSync(subPath, atime, mtime);\n        });\n    }\n    async mkdirPromise(p, opts) {\n        return await this.makeCallPromise(p, async () => {\n            return await this.baseFs.mkdirPromise(p, opts);\n        }, async (mountFs, { subPath }) => {\n            return await mountFs.mkdirPromise(subPath, opts);\n        });\n    }\n    mkdirSync(p, opts) {\n        return this.makeCallSync(p, () => {\n            return this.baseFs.mkdirSync(p, opts);\n        }, (mountFs, { subPath }) => {\n            return mountFs.mkdirSync(subPath, opts);\n        });\n    }\n    async rmdirPromise(p, opts) {\n        return await this.makeCallPromise(p, async () => {\n            return await this.baseFs.rmdirPromise(p, opts);\n        }, async (mountFs, { subPath }) => {\n            return await mountFs.rmdirPromise(subPath, opts);\n        });\n    }\n    rmdirSync(p, opts) {\n        return this.makeCallSync(p, () => {\n            return this.baseFs.rmdirSync(p, opts);\n        }, (mountFs, { subPath }) => {\n            return mountFs.rmdirSync(subPath, opts);\n        });\n    }\n    async linkPromise(existingP, newP) {\n        return await this.makeCallPromise(newP, async () => {\n            return await this.baseFs.linkPromise(existingP, newP);\n        }, async (mountFs, { subPath }) => {\n            return await mountFs.linkPromise(existingP, subPath);\n        });\n    }\n    linkSync(existingP, newP) {\n        return this.makeCallSync(newP, () => {\n            return this.baseFs.linkSync(existingP, newP);\n        }, (mountFs, { subPath }) => {\n            return mountFs.linkSync(existingP, subPath);\n        });\n    }\n    async symlinkPromise(target, p, type) {\n        return await this.makeCallPromise(p, async () => {\n            return await this.baseFs.symlinkPromise(target, p, type);\n        }, async (mountFs, { subPath }) => {\n            return await mountFs.symlinkPromise(target, subPath);\n        });\n    }\n    symlinkSync(target, p, type) {\n        return this.makeCallSync(p, () => {\n            return this.baseFs.symlinkSync(target, p, type);\n        }, (mountFs, { subPath }) => {\n            return mountFs.symlinkSync(target, subPath);\n        });\n    }\n    async readFilePromise(p, encoding) {\n        return this.makeCallPromise(p, async () => {\n            return await this.baseFs.readFilePromise(p, encoding);\n        }, async (mountFs, { subPath }) => {\n            return await mountFs.readFilePromise(subPath, encoding);\n        });\n    }\n    readFileSync(p, encoding) {\n        return this.makeCallSync(p, () => {\n            return this.baseFs.readFileSync(p, encoding);\n        }, (mountFs, { subPath }) => {\n            return mountFs.readFileSync(subPath, encoding);\n        });\n    }\n    async readdirPromise(p, opts) {\n        return await this.makeCallPromise(p, async () => {\n            return await this.baseFs.readdirPromise(p, opts);\n        }, async (mountFs, { subPath }) => {\n            return await mountFs.readdirPromise(subPath, opts);\n        }, {\n            requireSubpath: false,\n        });\n    }\n    readdirSync(p, opts) {\n        return this.makeCallSync(p, () => {\n            return this.baseFs.readdirSync(p, opts);\n        }, (mountFs, { subPath }) => {\n            return mountFs.readdirSync(subPath, opts);\n        }, {\n            requireSubpath: false,\n        });\n    }\n    async readlinkPromise(p) {\n        return await this.makeCallPromise(p, async () => {\n            return await this.baseFs.readlinkPromise(p);\n        }, async (mountFs, { subPath }) => {\n            return await mountFs.readlinkPromise(subPath);\n        });\n    }\n    readlinkSync(p) {\n        return this.makeCallSync(p, () => {\n            return this.baseFs.readlinkSync(p);\n        }, (mountFs, { subPath }) => {\n            return mountFs.readlinkSync(subPath);\n        });\n    }\n    async truncatePromise(p, len) {\n        return await this.makeCallPromise(p, async () => {\n            return await this.baseFs.truncatePromise(p, len);\n        }, async (mountFs, { subPath }) => {\n            return await mountFs.truncatePromise(subPath, len);\n        });\n    }\n    truncateSync(p, len) {\n        return this.makeCallSync(p, () => {\n            return this.baseFs.truncateSync(p, len);\n        }, (mountFs, { subPath }) => {\n            return mountFs.truncateSync(subPath, len);\n        });\n    }\n    async ftruncatePromise(fd, len) {\n        if ((fd & MOUNT_MASK) !== this.magic)\n            return this.baseFs.ftruncatePromise(fd, len);\n        const entry = this.fdMap.get(fd);\n        if (typeof entry === `undefined`)\n            throw errors.EBADF(`ftruncate`);\n        const [mountFs, realFd] = entry;\n        return mountFs.ftruncatePromise(realFd, len);\n    }\n    ftruncateSync(fd, len) {\n        if ((fd & MOUNT_MASK) !== this.magic)\n            return this.baseFs.ftruncateSync(fd, len);\n        const entry = this.fdMap.get(fd);\n        if (typeof entry === `undefined`)\n            throw errors.EBADF(`ftruncateSync`);\n        const [mountFs, realFd] = entry;\n        return mountFs.ftruncateSync(realFd, len);\n    }\n    watch(p, a, b) {\n        return this.makeCallSync(p, () => {\n            return this.baseFs.watch(p, \n            // @ts-expect-error\n            a, b);\n        }, (mountFs, { subPath }) => {\n            return mountFs.watch(subPath, \n            // @ts-expect-error\n            a, b);\n        });\n    }\n    watchFile(p, a, b) {\n        return this.makeCallSync(p, () => {\n            return this.baseFs.watchFile(p, \n            // @ts-expect-error\n            a, b);\n        }, () => {\n            return (0, watchFile_1.watchFile)(this, p, a, b);\n        });\n    }\n    unwatchFile(p, cb) {\n        return this.makeCallSync(p, () => {\n            return this.baseFs.unwatchFile(p, cb);\n        }, () => {\n            return (0, watchFile_1.unwatchFile)(this, p, cb);\n        });\n    }\n    async makeCallPromise(p, discard, accept, { requireSubpath = true } = {}) {\n        if (typeof p !== `string`)\n            return await discard();\n        const normalizedP = this.resolve(p);\n        const mountInfo = this.findMount(normalizedP);\n        if (!mountInfo)\n            return await discard();\n        if (requireSubpath && mountInfo.subPath === `/`)\n            return await discard();\n        return await this.getMountPromise(mountInfo.archivePath, async (mountFs) => await accept(mountFs, mountInfo));\n    }\n    makeCallSync(p, discard, accept, { requireSubpath = true } = {}) {\n        if (typeof p !== `string`)\n            return discard();\n        const normalizedP = this.resolve(p);\n        const mountInfo = this.findMount(normalizedP);\n        if (!mountInfo)\n            return discard();\n        if (requireSubpath && mountInfo.subPath === `/`)\n            return discard();\n        return this.getMountSync(mountInfo.archivePath, mountFs => accept(mountFs, mountInfo));\n    }\n    findMount(p) {\n        if (this.filter && !this.filter.test(p))\n            return null;\n        let filePath = ``;\n        while (true) {\n            const pathPartWithArchive = p.substring(filePath.length);\n            const mountPoint = this.getMountPoint(pathPartWithArchive, filePath);\n            if (!mountPoint)\n                return null;\n            filePath = this.pathUtils.join(filePath, mountPoint);\n            if (!this.isMount.has(filePath)) {\n                if (this.notMount.has(filePath))\n                    continue;\n                try {\n                    if (this.typeCheck !== null && (this.baseFs.lstatSync(filePath).mode & fs_1.constants.S_IFMT) !== this.typeCheck) {\n                        this.notMount.add(filePath);\n                        continue;\n                    }\n                }\n                catch {\n                    return null;\n                }\n                this.isMount.add(filePath);\n            }\n            return {\n                archivePath: filePath,\n                subPath: this.pathUtils.join(path_1.PortablePath.root, p.substring(filePath.length)),\n            };\n        }\n    }\n    limitOpenFiles(max) {\n        var _a, _b, _c;\n        if (this.mountInstances === null)\n            return;\n        const now = Date.now();\n        let nextExpiresAt = now + this.maxAge;\n        let closeCount = max === null ? 0 : this.mountInstances.size - max;\n        for (const [path, { childFs, expiresAt, refCount }] of this.mountInstances.entries()) {\n            if (refCount !== 0 || ((_a = childFs.hasOpenFileHandles) === null || _a === void 0 ? void 0 : _a.call(childFs))) {\n                continue;\n            }\n            else if (now >= expiresAt) {\n                (_b = childFs.saveAndClose) === null || _b === void 0 ? void 0 : _b.call(childFs);\n                this.mountInstances.delete(path);\n                closeCount -= 1;\n                continue;\n            }\n            else if (max === null || closeCount <= 0) {\n                nextExpiresAt = expiresAt;\n                break;\n            }\n            (_c = childFs.saveAndClose) === null || _c === void 0 ? void 0 : _c.call(childFs);\n            this.mountInstances.delete(path);\n            closeCount -= 1;\n        }\n        if (this.limitOpenFilesTimeout === null && ((max === null && this.mountInstances.size > 0) || max !== null) && isFinite(nextExpiresAt)) {\n            this.limitOpenFilesTimeout = setTimeout(() => {\n                this.limitOpenFilesTimeout = null;\n                this.limitOpenFiles(null);\n            }, nextExpiresAt - now).unref();\n        }\n    }\n    async getMountPromise(p, accept) {\n        var _a;\n        if (this.mountInstances) {\n            let cachedMountFs = this.mountInstances.get(p);\n            if (!cachedMountFs) {\n                const createFsInstance = await this.factoryPromise(this.baseFs, p);\n                // We need to recheck because concurrent getMountPromise calls may\n                // have instantiated the mount archive while we were waiting\n                cachedMountFs = this.mountInstances.get(p);\n                if (!cachedMountFs) {\n                    cachedMountFs = {\n                        childFs: createFsInstance(),\n                        expiresAt: 0,\n                        refCount: 0,\n                    };\n                }\n            }\n            // Removing then re-adding the field allows us to easily implement\n            // a basic LRU garbage collection strategy\n            this.mountInstances.delete(p);\n            this.limitOpenFiles(this.maxOpenFiles - 1);\n            this.mountInstances.set(p, cachedMountFs);\n            cachedMountFs.expiresAt = Date.now() + this.maxAge;\n            cachedMountFs.refCount += 1;\n            try {\n                return await accept(cachedMountFs.childFs);\n            }\n            finally {\n                cachedMountFs.refCount -= 1;\n            }\n        }\n        else {\n            const mountFs = (await this.factoryPromise(this.baseFs, p))();\n            try {\n                return await accept(mountFs);\n            }\n            finally {\n                (_a = mountFs.saveAndClose) === null || _a === void 0 ? void 0 : _a.call(mountFs);\n            }\n        }\n    }\n    getMountSync(p, accept) {\n        var _a;\n        if (this.mountInstances) {\n            let cachedMountFs = this.mountInstances.get(p);\n            if (!cachedMountFs) {\n                cachedMountFs = {\n                    childFs: this.factorySync(this.baseFs, p),\n                    expiresAt: 0,\n                    refCount: 0,\n                };\n            }\n            // Removing then re-adding the field allows us to easily implement\n            // a basic LRU garbage collection strategy\n            this.mountInstances.delete(p);\n            this.limitOpenFiles(this.maxOpenFiles - 1);\n            this.mountInstances.set(p, cachedMountFs);\n            cachedMountFs.expiresAt = Date.now() + this.maxAge;\n            return accept(cachedMountFs.childFs);\n        }\n        else {\n            const childFs = this.factorySync(this.baseFs, p);\n            try {\n                return accept(childFs);\n            }\n            finally {\n                (_a = childFs.saveAndClose) === null || _a === void 0 ? void 0 : _a.call(childFs);\n            }\n        }\n    }\n}\nexports.MountFS = MountFS;\n\n\n/***/ }),\n\n/***/ 904:\n/***/ ((__unused_webpack_module, exports, __webpack_require__) => {\n\n\"use strict\";\n\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.NoFS = void 0;\nconst FakeFS_1 = __webpack_require__(498);\nconst path_1 = __webpack_require__(905);\nconst makeError = () => Object.assign(new Error(`ENOSYS: unsupported filesystem access`), { code: `ENOSYS` });\nclass NoFS extends FakeFS_1.FakeFS {\n    constructor() {\n        super(path_1.ppath);\n    }\n    getExtractHint() {\n        throw makeError();\n    }\n    getRealPath() {\n        throw makeError();\n    }\n    resolve() {\n        throw makeError();\n    }\n    async openPromise() {\n        throw makeError();\n    }\n    openSync() {\n        throw makeError();\n    }\n    async opendirPromise() {\n        throw makeError();\n    }\n    opendirSync() {\n        throw makeError();\n    }\n    async readPromise() {\n        throw makeError();\n    }\n    readSync() {\n        throw makeError();\n    }\n    async writePromise() {\n        throw makeError();\n    }\n    writeSync() {\n        throw makeError();\n    }\n    async closePromise() {\n        throw makeError();\n    }\n    closeSync() {\n        throw makeError();\n    }\n    createWriteStream() {\n        throw makeError();\n    }\n    createReadStream() {\n        throw makeError();\n    }\n    async realpathPromise() {\n        throw makeError();\n    }\n    realpathSync() {\n        throw makeError();\n    }\n    async readdirPromise() {\n        throw makeError();\n    }\n    readdirSync() {\n        throw makeError();\n    }\n    async existsPromise(p) {\n        throw makeError();\n    }\n    existsSync(p) {\n        throw makeError();\n    }\n    async accessPromise() {\n        throw makeError();\n    }\n    accessSync() {\n        throw makeError();\n    }\n    async statPromise() {\n        throw makeError();\n    }\n    statSync() {\n        throw makeError();\n    }\n    async fstatPromise(fd) {\n        throw makeError();\n    }\n    fstatSync(fd) {\n        throw makeError();\n    }\n    async lstatPromise(p) {\n        throw makeError();\n    }\n    lstatSync(p) {\n        throw makeError();\n    }\n    async fchmodPromise() {\n        throw makeError();\n    }\n    fchmodSync() {\n        throw makeError();\n    }\n    async chmodPromise() {\n        throw makeError();\n    }\n    chmodSync() {\n        throw makeError();\n    }\n    async fchownPromise() {\n        throw makeError();\n    }\n    fchownSync() {\n        throw makeError();\n    }\n    async chownPromise() {\n        throw makeError();\n    }\n    chownSync() {\n        throw makeError();\n    }\n    async mkdirPromise() {\n        throw makeError();\n    }\n    mkdirSync() {\n        throw makeError();\n    }\n    async rmdirPromise() {\n        throw makeError();\n    }\n    rmdirSync() {\n        throw makeError();\n    }\n    async linkPromise() {\n        throw makeError();\n    }\n    linkSync() {\n        throw makeError();\n    }\n    async symlinkPromise() {\n        throw makeError();\n    }\n    symlinkSync() {\n        throw makeError();\n    }\n    async renamePromise() {\n        throw makeError();\n    }\n    renameSync() {\n        throw makeError();\n    }\n    async copyFilePromise() {\n        throw makeError();\n    }\n    copyFileSync() {\n        throw makeError();\n    }\n    async appendFilePromise() {\n        throw makeError();\n    }\n    appendFileSync() {\n        throw makeError();\n    }\n    async writeFilePromise() {\n        throw makeError();\n    }\n    writeFileSync() {\n        throw makeError();\n    }\n    async unlinkPromise() {\n        throw makeError();\n    }\n    unlinkSync() {\n        throw makeError();\n    }\n    async utimesPromise() {\n        throw makeError();\n    }\n    utimesSync() {\n        throw makeError();\n    }\n    async lutimesPromise() {\n        throw makeError();\n    }\n    lutimesSync() {\n        throw makeError();\n    }\n    async readFilePromise() {\n        throw makeError();\n    }\n    readFileSync() {\n        throw makeError();\n    }\n    async readlinkPromise() {\n        throw makeError();\n    }\n    readlinkSync() {\n        throw makeError();\n    }\n    async truncatePromise() {\n        throw makeError();\n    }\n    truncateSync() {\n        throw makeError();\n    }\n    async ftruncatePromise(fd, len) {\n        throw makeError();\n    }\n    ftruncateSync(fd, len) {\n        throw makeError();\n    }\n    watch() {\n        throw makeError();\n    }\n    watchFile() {\n        throw makeError();\n    }\n    unwatchFile() {\n        throw makeError();\n    }\n}\nNoFS.instance = new NoFS();\nexports.NoFS = NoFS;\n\n\n/***/ }),\n\n/***/ 843:\n/***/ ((__unused_webpack_module, exports, __webpack_require__) => {\n\n\"use strict\";\n\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.NodeFS = void 0;\nconst tslib_1 = __webpack_require__(177);\nconst fs_1 = tslib_1.__importDefault(__webpack_require__(147));\nconst FakeFS_1 = __webpack_require__(498);\nconst path_1 = __webpack_require__(905);\nclass NodeFS extends FakeFS_1.BasePortableFakeFS {\n    constructor(realFs = fs_1.default) {\n        super();\n        this.realFs = realFs;\n    }\n    getExtractHint() {\n        return false;\n    }\n    getRealPath() {\n        return path_1.PortablePath.root;\n    }\n    resolve(p) {\n        return path_1.ppath.resolve(p);\n    }\n    async openPromise(p, flags, mode) {\n        return await new Promise((resolve, reject) => {\n            this.realFs.open(path_1.npath.fromPortablePath(p), flags, mode, this.makeCallback(resolve, reject));\n        });\n    }\n    openSync(p, flags, mode) {\n        return this.realFs.openSync(path_1.npath.fromPortablePath(p), flags, mode);\n    }\n    async opendirPromise(p, opts) {\n        return await new Promise((resolve, reject) => {\n            if (typeof opts !== `undefined`) {\n                this.realFs.opendir(path_1.npath.fromPortablePath(p), opts, this.makeCallback(resolve, reject));\n            }\n            else {\n                this.realFs.opendir(path_1.npath.fromPortablePath(p), this.makeCallback(resolve, reject));\n            }\n        }).then(dir => {\n            return Object.defineProperty(dir, `path`, { value: p, configurable: true, writable: true });\n        });\n    }\n    opendirSync(p, opts) {\n        const dir = typeof opts !== `undefined`\n            ? this.realFs.opendirSync(path_1.npath.fromPortablePath(p), opts)\n            : this.realFs.opendirSync(path_1.npath.fromPortablePath(p));\n        return Object.defineProperty(dir, `path`, { value: p, configurable: true, writable: true });\n    }\n    async readPromise(fd, buffer, offset = 0, length = 0, position = -1) {\n        return await new Promise((resolve, reject) => {\n            this.realFs.read(fd, buffer, offset, length, position, (error, bytesRead) => {\n                if (error) {\n                    reject(error);\n                }\n                else {\n                    resolve(bytesRead);\n                }\n            });\n        });\n    }\n    readSync(fd, buffer, offset, length, position) {\n        return this.realFs.readSync(fd, buffer, offset, length, position);\n    }\n    async writePromise(fd, buffer, offset, length, position) {\n        return await new Promise((resolve, reject) => {\n            if (typeof buffer === `string`) {\n                return this.realFs.write(fd, buffer, offset, this.makeCallback(resolve, reject));\n            }\n            else {\n                return this.realFs.write(fd, buffer, offset, length, position, this.makeCallback(resolve, reject));\n            }\n        });\n    }\n    writeSync(fd, buffer, offset, length, position) {\n        if (typeof buffer === `string`) {\n            return this.realFs.writeSync(fd, buffer, offset);\n        }\n        else {\n            return this.realFs.writeSync(fd, buffer, offset, length, position);\n        }\n    }\n    async closePromise(fd) {\n        await new Promise((resolve, reject) => {\n            this.realFs.close(fd, this.makeCallback(resolve, reject));\n        });\n    }\n    closeSync(fd) {\n        this.realFs.closeSync(fd);\n    }\n    createReadStream(p, opts) {\n        const realPath = (p !== null ? path_1.npath.fromPortablePath(p) : p);\n        return this.realFs.createReadStream(realPath, opts);\n    }\n    createWriteStream(p, opts) {\n        const realPath = (p !== null ? path_1.npath.fromPortablePath(p) : p);\n        return this.realFs.createWriteStream(realPath, opts);\n    }\n    async realpathPromise(p) {\n        return await new Promise((resolve, reject) => {\n            this.realFs.realpath(path_1.npath.fromPortablePath(p), {}, this.makeCallback(resolve, reject));\n        }).then(path => {\n            return path_1.npath.toPortablePath(path);\n        });\n    }\n    realpathSync(p) {\n        return path_1.npath.toPortablePath(this.realFs.realpathSync(path_1.npath.fromPortablePath(p), {}));\n    }\n    async existsPromise(p) {\n        return await new Promise(resolve => {\n            this.realFs.exists(path_1.npath.fromPortablePath(p), resolve);\n        });\n    }\n    accessSync(p, mode) {\n        return this.realFs.accessSync(path_1.npath.fromPortablePath(p), mode);\n    }\n    async accessPromise(p, mode) {\n        return await new Promise((resolve, reject) => {\n            this.realFs.access(path_1.npath.fromPortablePath(p), mode, this.makeCallback(resolve, reject));\n        });\n    }\n    existsSync(p) {\n        return this.realFs.existsSync(path_1.npath.fromPortablePath(p));\n    }\n    async statPromise(p, opts) {\n        return await new Promise((resolve, reject) => {\n            if (opts) {\n                this.realFs.stat(path_1.npath.fromPortablePath(p), opts, this.makeCallback(resolve, reject));\n            }\n            else {\n                this.realFs.stat(path_1.npath.fromPortablePath(p), this.makeCallback(resolve, reject));\n            }\n        });\n    }\n    statSync(p, opts) {\n        if (opts) {\n            return this.realFs.statSync(path_1.npath.fromPortablePath(p), opts);\n        }\n        else {\n            return this.realFs.statSync(path_1.npath.fromPortablePath(p));\n        }\n    }\n    async fstatPromise(fd, opts) {\n        return await new Promise((resolve, reject) => {\n            if (opts) {\n                this.realFs.fstat(fd, opts, this.makeCallback(resolve, reject));\n            }\n            else {\n                this.realFs.fstat(fd, this.makeCallback(resolve, reject));\n            }\n        });\n    }\n    fstatSync(fd, opts) {\n        if (opts) {\n            return this.realFs.fstatSync(fd, opts);\n        }\n        else {\n            return this.realFs.fstatSync(fd);\n        }\n    }\n    async lstatPromise(p, opts) {\n        return await new Promise((resolve, reject) => {\n            if (opts) {\n                this.realFs.lstat(path_1.npath.fromPortablePath(p), opts, this.makeCallback(resolve, reject));\n            }\n            else {\n                this.realFs.lstat(path_1.npath.fromPortablePath(p), this.makeCallback(resolve, reject));\n            }\n        });\n    }\n    lstatSync(p, opts) {\n        if (opts) {\n            return this.realFs.lstatSync(path_1.npath.fromPortablePath(p), opts);\n        }\n        else {\n            return this.realFs.lstatSync(path_1.npath.fromPortablePath(p));\n        }\n    }\n    async fchmodPromise(fd, mask) {\n        return await new Promise((resolve, reject) => {\n            this.realFs.fchmod(fd, mask, this.makeCallback(resolve, reject));\n        });\n    }\n    fchmodSync(fd, mask) {\n        return this.realFs.fchmodSync(fd, mask);\n    }\n    async chmodPromise(p, mask) {\n        return await new Promise((resolve, reject) => {\n            this.realFs.chmod(path_1.npath.fromPortablePath(p), mask, this.makeCallback(resolve, reject));\n        });\n    }\n    chmodSync(p, mask) {\n        return this.realFs.chmodSync(path_1.npath.fromPortablePath(p), mask);\n    }\n    async fchownPromise(fd, uid, gid) {\n        return await new Promise((resolve, reject) => {\n            this.realFs.fchown(fd, uid, gid, this.makeCallback(resolve, reject));\n        });\n    }\n    fchownSync(fd, uid, gid) {\n        return this.realFs.fchownSync(fd, uid, gid);\n    }\n    async chownPromise(p, uid, gid) {\n        return await new Promise((resolve, reject) => {\n            this.realFs.chown(path_1.npath.fromPortablePath(p), uid, gid, this.makeCallback(resolve, reject));\n        });\n    }\n    chownSync(p, uid, gid) {\n        return this.realFs.chownSync(path_1.npath.fromPortablePath(p), uid, gid);\n    }\n    async renamePromise(oldP, newP) {\n        return await new Promise((resolve, reject) => {\n            this.realFs.rename(path_1.npath.fromPortablePath(oldP), path_1.npath.fromPortablePath(newP), this.makeCallback(resolve, reject));\n        });\n    }\n    renameSync(oldP, newP) {\n        return this.realFs.renameSync(path_1.npath.fromPortablePath(oldP), path_1.npath.fromPortablePath(newP));\n    }\n    async copyFilePromise(sourceP, destP, flags = 0) {\n        return await new Promise((resolve, reject) => {\n            this.realFs.copyFile(path_1.npath.fromPortablePath(sourceP), path_1.npath.fromPortablePath(destP), flags, this.makeCallback(resolve, reject));\n        });\n    }\n    copyFileSync(sourceP, destP, flags = 0) {\n        return this.realFs.copyFileSync(path_1.npath.fromPortablePath(sourceP), path_1.npath.fromPortablePath(destP), flags);\n    }\n    async appendFilePromise(p, content, opts) {\n        return await new Promise((resolve, reject) => {\n            const fsNativePath = typeof p === `string` ? path_1.npath.fromPortablePath(p) : p;\n            if (opts) {\n                this.realFs.appendFile(fsNativePath, content, opts, this.makeCallback(resolve, reject));\n            }\n            else {\n                this.realFs.appendFile(fsNativePath, content, this.makeCallback(resolve, reject));\n            }\n        });\n    }\n    appendFileSync(p, content, opts) {\n        const fsNativePath = typeof p === `string` ? path_1.npath.fromPortablePath(p) : p;\n        if (opts) {\n            this.realFs.appendFileSync(fsNativePath, content, opts);\n        }\n        else {\n            this.realFs.appendFileSync(fsNativePath, content);\n        }\n    }\n    async writeFilePromise(p, content, opts) {\n        return await new Promise((resolve, reject) => {\n            const fsNativePath = typeof p === `string` ? path_1.npath.fromPortablePath(p) : p;\n            if (opts) {\n                this.realFs.writeFile(fsNativePath, content, opts, this.makeCallback(resolve, reject));\n            }\n            else {\n                this.realFs.writeFile(fsNativePath, content, this.makeCallback(resolve, reject));\n            }\n        });\n    }\n    writeFileSync(p, content, opts) {\n        const fsNativePath = typeof p === `string` ? path_1.npath.fromPortablePath(p) : p;\n        if (opts) {\n            this.realFs.writeFileSync(fsNativePath, content, opts);\n        }\n        else {\n            this.realFs.writeFileSync(fsNativePath, content);\n        }\n    }\n    async unlinkPromise(p) {\n        return await new Promise((resolve, reject) => {\n            this.realFs.unlink(path_1.npath.fromPortablePath(p), this.makeCallback(resolve, reject));\n        });\n    }\n    unlinkSync(p) {\n        return this.realFs.unlinkSync(path_1.npath.fromPortablePath(p));\n    }\n    async utimesPromise(p, atime, mtime) {\n        return await new Promise((resolve, reject) => {\n            this.realFs.utimes(path_1.npath.fromPortablePath(p), atime, mtime, this.makeCallback(resolve, reject));\n        });\n    }\n    utimesSync(p, atime, mtime) {\n        this.realFs.utimesSync(path_1.npath.fromPortablePath(p), atime, mtime);\n    }\n    async lutimesPromise(p, atime, mtime) {\n        return await new Promise((resolve, reject) => {\n            this.realFs.lutimes(path_1.npath.fromPortablePath(p), atime, mtime, this.makeCallback(resolve, reject));\n        });\n    }\n    lutimesSync(p, atime, mtime) {\n        this.realFs.lutimesSync(path_1.npath.fromPortablePath(p), atime, mtime);\n    }\n    async mkdirPromise(p, opts) {\n        return await new Promise((resolve, reject) => {\n            this.realFs.mkdir(path_1.npath.fromPortablePath(p), opts, this.makeCallback(resolve, reject));\n        });\n    }\n    mkdirSync(p, opts) {\n        return this.realFs.mkdirSync(path_1.npath.fromPortablePath(p), opts);\n    }\n    async rmdirPromise(p, opts) {\n        return await new Promise((resolve, reject) => {\n            // TODO: always pass opts when min node version is 12.10+\n            if (opts) {\n                this.realFs.rmdir(path_1.npath.fromPortablePath(p), opts, this.makeCallback(resolve, reject));\n            }\n            else {\n                this.realFs.rmdir(path_1.npath.fromPortablePath(p), this.makeCallback(resolve, reject));\n            }\n        });\n    }\n    rmdirSync(p, opts) {\n        return this.realFs.rmdirSync(path_1.npath.fromPortablePath(p), opts);\n    }\n    async linkPromise(existingP, newP) {\n        return await new Promise((resolve, reject) => {\n            this.realFs.link(path_1.npath.fromPortablePath(existingP), path_1.npath.fromPortablePath(newP), this.makeCallback(resolve, reject));\n        });\n    }\n    linkSync(existingP, newP) {\n        return this.realFs.linkSync(path_1.npath.fromPortablePath(existingP), path_1.npath.fromPortablePath(newP));\n    }\n    async symlinkPromise(target, p, type) {\n        return await new Promise((resolve, reject) => {\n            this.realFs.symlink(path_1.npath.fromPortablePath(target.replace(/\\/+$/, ``)), path_1.npath.fromPortablePath(p), type, this.makeCallback(resolve, reject));\n        });\n    }\n    symlinkSync(target, p, type) {\n        return this.realFs.symlinkSync(path_1.npath.fromPortablePath(target.replace(/\\/+$/, ``)), path_1.npath.fromPortablePath(p), type);\n    }\n    async readFilePromise(p, encoding) {\n        return await new Promise((resolve, reject) => {\n            const fsNativePath = typeof p === `string` ? path_1.npath.fromPortablePath(p) : p;\n            this.realFs.readFile(fsNativePath, encoding, this.makeCallback(resolve, reject));\n        });\n    }\n    readFileSync(p, encoding) {\n        const fsNativePath = typeof p === `string` ? path_1.npath.fromPortablePath(p) : p;\n        return this.realFs.readFileSync(fsNativePath, encoding);\n    }\n    async readdirPromise(p, opts) {\n        return await new Promise((resolve, reject) => {\n            if (opts === null || opts === void 0 ? void 0 : opts.withFileTypes) {\n                this.realFs.readdir(path_1.npath.fromPortablePath(p), { withFileTypes: true }, this.makeCallback(resolve, reject));\n            }\n            else {\n                this.realFs.readdir(path_1.npath.fromPortablePath(p), this.makeCallback(value => resolve(value), reject));\n            }\n        });\n    }\n    readdirSync(p, opts) {\n        if (opts === null || opts === void 0 ? void 0 : opts.withFileTypes) {\n            return this.realFs.readdirSync(path_1.npath.fromPortablePath(p), { withFileTypes: true });\n        }\n        else {\n            return this.realFs.readdirSync(path_1.npath.fromPortablePath(p));\n        }\n    }\n    async readlinkPromise(p) {\n        return await new Promise((resolve, reject) => {\n            this.realFs.readlink(path_1.npath.fromPortablePath(p), this.makeCallback(resolve, reject));\n        }).then(path => {\n            return path_1.npath.toPortablePath(path);\n        });\n    }\n    readlinkSync(p) {\n        return path_1.npath.toPortablePath(this.realFs.readlinkSync(path_1.npath.fromPortablePath(p)));\n    }\n    async truncatePromise(p, len) {\n        return await new Promise((resolve, reject) => {\n            this.realFs.truncate(path_1.npath.fromPortablePath(p), len, this.makeCallback(resolve, reject));\n        });\n    }\n    truncateSync(p, len) {\n        return this.realFs.truncateSync(path_1.npath.fromPortablePath(p), len);\n    }\n    async ftruncatePromise(fd, len) {\n        return await new Promise((resolve, reject) => {\n            this.realFs.ftruncate(fd, len, this.makeCallback(resolve, reject));\n        });\n    }\n    ftruncateSync(fd, len) {\n        return this.realFs.ftruncateSync(fd, len);\n    }\n    watch(p, a, b) {\n        return this.realFs.watch(path_1.npath.fromPortablePath(p), \n        // @ts-expect-error\n        a, b);\n    }\n    watchFile(p, a, b) {\n        return this.realFs.watchFile(path_1.npath.fromPortablePath(p), \n        // @ts-expect-error\n        a, b);\n    }\n    unwatchFile(p, cb) {\n        return this.realFs.unwatchFile(path_1.npath.fromPortablePath(p), cb);\n    }\n    makeCallback(resolve, reject) {\n        return (err, result) => {\n            if (err) {\n                reject(err);\n            }\n            else {\n                resolve(result);\n            }\n        };\n    }\n}\nexports.NodeFS = NodeFS;\n\n\n/***/ }),\n\n/***/ 732:\n/***/ ((__unused_webpack_module, exports, __webpack_require__) => {\n\n\"use strict\";\n\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.NodePathFS = void 0;\nconst url_1 = __webpack_require__(310);\nconst util_1 = __webpack_require__(837);\nconst ProxiedFS_1 = __webpack_require__(105);\nconst path_1 = __webpack_require__(905);\n/**\n * Adds support for file URLs and Buffers to the wrapped `baseFs`, but *not* inside the typings.\n *\n * Only exists for compatibility with Node's behavior.\n *\n * Automatically wraps all FS instances passed to `patchFs` & `extendFs`.\n *\n * Don't use it!\n */\nclass NodePathFS extends ProxiedFS_1.ProxiedFS {\n    constructor(baseFs) {\n        super(path_1.npath);\n        this.baseFs = baseFs;\n    }\n    mapFromBase(path) {\n        return path;\n    }\n    mapToBase(path) {\n        if (typeof path === `string`)\n            return path;\n        if (path instanceof url_1.URL)\n            return (0, url_1.fileURLToPath)(path);\n        if (Buffer.isBuffer(path)) {\n            const str = path.toString();\n            if (Buffer.byteLength(str) !== path.byteLength)\n                throw new Error(`Non-utf8 buffers are not supported at the moment. Please upvote the following issue if you encounter this error: https://github.com/yarnpkg/berry/issues/4942`);\n            return str;\n        }\n        throw new Error(`Unsupported path type: ${(0, util_1.inspect)(path)}`);\n    }\n}\nexports.NodePathFS = NodePathFS;\n\n\n/***/ }),\n\n/***/ 103:\n/***/ ((__unused_webpack_module, exports, __webpack_require__) => {\n\n\"use strict\";\n\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.PosixFS = void 0;\nconst ProxiedFS_1 = __webpack_require__(105);\nconst path_1 = __webpack_require__(905);\nclass PosixFS extends ProxiedFS_1.ProxiedFS {\n    constructor(baseFs) {\n        super(path_1.npath);\n        this.baseFs = baseFs;\n    }\n    mapFromBase(path) {\n        return path_1.npath.fromPortablePath(path);\n    }\n    mapToBase(path) {\n        return path_1.npath.toPortablePath(path);\n    }\n}\nexports.PosixFS = PosixFS;\n\n\n/***/ }),\n\n/***/ 105:\n/***/ ((__unused_webpack_module, exports, __webpack_require__) => {\n\n\"use strict\";\n\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.ProxiedFS = void 0;\nconst FakeFS_1 = __webpack_require__(498);\nclass ProxiedFS extends FakeFS_1.FakeFS {\n    getExtractHint(hints) {\n        return this.baseFs.getExtractHint(hints);\n    }\n    resolve(path) {\n        return this.mapFromBase(this.baseFs.resolve(this.mapToBase(path)));\n    }\n    getRealPath() {\n        return this.mapFromBase(this.baseFs.getRealPath());\n    }\n    async openPromise(p, flags, mode) {\n        return this.baseFs.openPromise(this.mapToBase(p), flags, mode);\n    }\n    openSync(p, flags, mode) {\n        return this.baseFs.openSync(this.mapToBase(p), flags, mode);\n    }\n    async opendirPromise(p, opts) {\n        return Object.assign(await this.baseFs.opendirPromise(this.mapToBase(p), opts), { path: p });\n    }\n    opendirSync(p, opts) {\n        return Object.assign(this.baseFs.opendirSync(this.mapToBase(p), opts), { path: p });\n    }\n    async readPromise(fd, buffer, offset, length, position) {\n        return await this.baseFs.readPromise(fd, buffer, offset, length, position);\n    }\n    readSync(fd, buffer, offset, length, position) {\n        return this.baseFs.readSync(fd, buffer, offset, length, position);\n    }\n    async writePromise(fd, buffer, offset, length, position) {\n        if (typeof buffer === `string`) {\n            return await this.baseFs.writePromise(fd, buffer, offset);\n        }\n        else {\n            return await this.baseFs.writePromise(fd, buffer, offset, length, position);\n        }\n    }\n    writeSync(fd, buffer, offset, length, position) {\n        if (typeof buffer === `string`) {\n            return this.baseFs.writeSync(fd, buffer, offset);\n        }\n        else {\n            return this.baseFs.writeSync(fd, buffer, offset, length, position);\n        }\n    }\n    async closePromise(fd) {\n        return this.baseFs.closePromise(fd);\n    }\n    closeSync(fd) {\n        this.baseFs.closeSync(fd);\n    }\n    createReadStream(p, opts) {\n        return this.baseFs.createReadStream(p !== null ? this.mapToBase(p) : p, opts);\n    }\n    createWriteStream(p, opts) {\n        return this.baseFs.createWriteStream(p !== null ? this.mapToBase(p) : p, opts);\n    }\n    async realpathPromise(p) {\n        return this.mapFromBase(await this.baseFs.realpathPromise(this.mapToBase(p)));\n    }\n    realpathSync(p) {\n        return this.mapFromBase(this.baseFs.realpathSync(this.mapToBase(p)));\n    }\n    async existsPromise(p) {\n        return this.baseFs.existsPromise(this.mapToBase(p));\n    }\n    existsSync(p) {\n        return this.baseFs.existsSync(this.mapToBase(p));\n    }\n    accessSync(p, mode) {\n        return this.baseFs.accessSync(this.mapToBase(p), mode);\n    }\n    async accessPromise(p, mode) {\n        return this.baseFs.accessPromise(this.mapToBase(p), mode);\n    }\n    async statPromise(p, opts) {\n        return this.baseFs.statPromise(this.mapToBase(p), opts);\n    }\n    statSync(p, opts) {\n        return this.baseFs.statSync(this.mapToBase(p), opts);\n    }\n    async fstatPromise(fd, opts) {\n        return this.baseFs.fstatPromise(fd, opts);\n    }\n    fstatSync(fd, opts) {\n        return this.baseFs.fstatSync(fd, opts);\n    }\n    lstatPromise(p, opts) {\n        return this.baseFs.lstatPromise(this.mapToBase(p), opts);\n    }\n    lstatSync(p, opts) {\n        return this.baseFs.lstatSync(this.mapToBase(p), opts);\n    }\n    async fchmodPromise(fd, mask) {\n        return this.baseFs.fchmodPromise(fd, mask);\n    }\n    fchmodSync(fd, mask) {\n        return this.baseFs.fchmodSync(fd, mask);\n    }\n    async chmodPromise(p, mask) {\n        return this.baseFs.chmodPromise(this.mapToBase(p), mask);\n    }\n    chmodSync(p, mask) {\n        return this.baseFs.chmodSync(this.mapToBase(p), mask);\n    }\n    async fchownPromise(fd, uid, gid) {\n        return this.baseFs.fchownPromise(fd, uid, gid);\n    }\n    fchownSync(fd, uid, gid) {\n        return this.baseFs.fchownSync(fd, uid, gid);\n    }\n    async chownPromise(p, uid, gid) {\n        return this.baseFs.chownPromise(this.mapToBase(p), uid, gid);\n    }\n    chownSync(p, uid, gid) {\n        return this.baseFs.chownSync(this.mapToBase(p), uid, gid);\n    }\n    async renamePromise(oldP, newP) {\n        return this.baseFs.renamePromise(this.mapToBase(oldP), this.mapToBase(newP));\n    }\n    renameSync(oldP, newP) {\n        return this.baseFs.renameSync(this.mapToBase(oldP), this.mapToBase(newP));\n    }\n    async copyFilePromise(sourceP, destP, flags = 0) {\n        return this.baseFs.copyFilePromise(this.mapToBase(sourceP), this.mapToBase(destP), flags);\n    }\n    copyFileSync(sourceP, destP, flags = 0) {\n        return this.baseFs.copyFileSync(this.mapToBase(sourceP), this.mapToBase(destP), flags);\n    }\n    async appendFilePromise(p, content, opts) {\n        return this.baseFs.appendFilePromise(this.fsMapToBase(p), content, opts);\n    }\n    appendFileSync(p, content, opts) {\n        return this.baseFs.appendFileSync(this.fsMapToBase(p), content, opts);\n    }\n    async writeFilePromise(p, content, opts) {\n        return this.baseFs.writeFilePromise(this.fsMapToBase(p), content, opts);\n    }\n    writeFileSync(p, content, opts) {\n        return this.baseFs.writeFileSync(this.fsMapToBase(p), content, opts);\n    }\n    async unlinkPromise(p) {\n        return this.baseFs.unlinkPromise(this.mapToBase(p));\n    }\n    unlinkSync(p) {\n        return this.baseFs.unlinkSync(this.mapToBase(p));\n    }\n    async utimesPromise(p, atime, mtime) {\n        return this.baseFs.utimesPromise(this.mapToBase(p), atime, mtime);\n    }\n    utimesSync(p, atime, mtime) {\n        return this.baseFs.utimesSync(this.mapToBase(p), atime, mtime);\n    }\n    async lutimesPromise(p, atime, mtime) {\n        return this.baseFs.lutimesPromise(this.mapToBase(p), atime, mtime);\n    }\n    lutimesSync(p, atime, mtime) {\n        return this.baseFs.lutimesSync(this.mapToBase(p), atime, mtime);\n    }\n    async mkdirPromise(p, opts) {\n        return this.baseFs.mkdirPromise(this.mapToBase(p), opts);\n    }\n    mkdirSync(p, opts) {\n        return this.baseFs.mkdirSync(this.mapToBase(p), opts);\n    }\n    async rmdirPromise(p, opts) {\n        return this.baseFs.rmdirPromise(this.mapToBase(p), opts);\n    }\n    rmdirSync(p, opts) {\n        return this.baseFs.rmdirSync(this.mapToBase(p), opts);\n    }\n    async linkPromise(existingP, newP) {\n        return this.baseFs.linkPromise(this.mapToBase(existingP), this.mapToBase(newP));\n    }\n    linkSync(existingP, newP) {\n        return this.baseFs.linkSync(this.mapToBase(existingP), this.mapToBase(newP));\n    }\n    async symlinkPromise(target, p, type) {\n        const mappedP = this.mapToBase(p);\n        if (this.pathUtils.isAbsolute(target))\n            return this.baseFs.symlinkPromise(this.mapToBase(target), mappedP, type);\n        const mappedAbsoluteTarget = this.mapToBase(this.pathUtils.join(this.pathUtils.dirname(p), target));\n        const mappedTarget = this.baseFs.pathUtils.relative(this.baseFs.pathUtils.dirname(mappedP), mappedAbsoluteTarget);\n        return this.baseFs.symlinkPromise(mappedTarget, mappedP, type);\n    }\n    symlinkSync(target, p, type) {\n        const mappedP = this.mapToBase(p);\n        if (this.pathUtils.isAbsolute(target))\n            return this.baseFs.symlinkSync(this.mapToBase(target), mappedP, type);\n        const mappedAbsoluteTarget = this.mapToBase(this.pathUtils.join(this.pathUtils.dirname(p), target));\n        const mappedTarget = this.baseFs.pathUtils.relative(this.baseFs.pathUtils.dirname(mappedP), mappedAbsoluteTarget);\n        return this.baseFs.symlinkSync(mappedTarget, mappedP, type);\n    }\n    async readFilePromise(p, encoding) {\n        return this.baseFs.readFilePromise(this.fsMapToBase(p), encoding);\n    }\n    readFileSync(p, encoding) {\n        return this.baseFs.readFileSync(this.fsMapToBase(p), encoding);\n    }\n    async readdirPromise(p, opts) {\n        return this.baseFs.readdirPromise(this.mapToBase(p), opts);\n    }\n    readdirSync(p, opts) {\n        return this.baseFs.readdirSync(this.mapToBase(p), opts);\n    }\n    async readlinkPromise(p) {\n        return this.mapFromBase(await this.baseFs.readlinkPromise(this.mapToBase(p)));\n    }\n    readlinkSync(p) {\n        return this.mapFromBase(this.baseFs.readlinkSync(this.mapToBase(p)));\n    }\n    async truncatePromise(p, len) {\n        return this.baseFs.truncatePromise(this.mapToBase(p), len);\n    }\n    truncateSync(p, len) {\n        return this.baseFs.truncateSync(this.mapToBase(p), len);\n    }\n    async ftruncatePromise(fd, len) {\n        return this.baseFs.ftruncatePromise(fd, len);\n    }\n    ftruncateSync(fd, len) {\n        return this.baseFs.ftruncateSync(fd, len);\n    }\n    watch(p, a, b) {\n        return this.baseFs.watch(this.mapToBase(p), \n        // @ts-expect-error\n        a, b);\n    }\n    watchFile(p, a, b) {\n        return this.baseFs.watchFile(this.mapToBase(p), \n        // @ts-expect-error\n        a, b);\n    }\n    unwatchFile(p, cb) {\n        return this.baseFs.unwatchFile(this.mapToBase(p), cb);\n    }\n    fsMapToBase(p) {\n        if (typeof p === `number`) {\n            return p;\n        }\n        else {\n            return this.mapToBase(p);\n        }\n    }\n}\nexports.ProxiedFS = ProxiedFS;\n\n\n/***/ }),\n\n/***/ 735:\n/***/ ((__unused_webpack_module, exports, __webpack_require__) => {\n\n\"use strict\";\n\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.VirtualFS = void 0;\nconst NodeFS_1 = __webpack_require__(843);\nconst ProxiedFS_1 = __webpack_require__(105);\nconst path_1 = __webpack_require__(905);\nconst NUMBER_REGEXP = /^[0-9]+$/;\n// $0: full path\n// $1: virtual folder\n// $2: virtual segment\n// $3: hash\n// $4: depth\n// $5: subpath\nconst VIRTUAL_REGEXP = /^(\\/(?:[^/]+\\/)*?(?:\\$\\$virtual|__virtual__))((?:\\/((?:[^/]+-)?[a-f0-9]+)(?:\\/([^/]+))?)?((?:\\/.*)?))$/;\nconst VALID_COMPONENT = /^([^/]+-)?[a-f0-9]+$/;\nclass VirtualFS extends ProxiedFS_1.ProxiedFS {\n    static makeVirtualPath(base, component, to) {\n        if (path_1.ppath.basename(base) !== `__virtual__`)\n            throw new Error(`Assertion failed: Virtual folders must be named \"__virtual__\"`);\n        if (!path_1.ppath.basename(component).match(VALID_COMPONENT))\n            throw new Error(`Assertion failed: Virtual components must be ended by an hexadecimal hash`);\n        // Obtains the relative distance between the virtual path and its actual target\n        const target = path_1.ppath.relative(path_1.ppath.dirname(base), to);\n        const segments = target.split(`/`);\n        // Counts how many levels we need to go back to start applying the rest of the path\n        let depth = 0;\n        while (depth < segments.length && segments[depth] === `..`)\n            depth += 1;\n        const finalSegments = segments.slice(depth);\n        const fullVirtualPath = path_1.ppath.join(base, component, String(depth), ...finalSegments);\n        return fullVirtualPath;\n    }\n    static resolveVirtual(p) {\n        const match = p.match(VIRTUAL_REGEXP);\n        if (!match || (!match[3] && match[5]))\n            return p;\n        const target = path_1.ppath.dirname(match[1]);\n        if (!match[3] || !match[4])\n            return target;\n        const isnum = NUMBER_REGEXP.test(match[4]);\n        if (!isnum)\n            return p;\n        const depth = Number(match[4]);\n        const backstep = `../`.repeat(depth);\n        const subpath = (match[5] || `.`);\n        return VirtualFS.resolveVirtual(path_1.ppath.join(target, backstep, subpath));\n    }\n    constructor({ baseFs = new NodeFS_1.NodeFS() } = {}) {\n        super(path_1.ppath);\n        this.baseFs = baseFs;\n    }\n    getExtractHint(hints) {\n        return this.baseFs.getExtractHint(hints);\n    }\n    getRealPath() {\n        return this.baseFs.getRealPath();\n    }\n    realpathSync(p) {\n        const match = p.match(VIRTUAL_REGEXP);\n        if (!match)\n            return this.baseFs.realpathSync(p);\n        if (!match[5])\n            return p;\n        const realpath = this.baseFs.realpathSync(this.mapToBase(p));\n        return VirtualFS.makeVirtualPath(match[1], match[3], realpath);\n    }\n    async realpathPromise(p) {\n        const match = p.match(VIRTUAL_REGEXP);\n        if (!match)\n            return await this.baseFs.realpathPromise(p);\n        if (!match[5])\n            return p;\n        const realpath = await this.baseFs.realpathPromise(this.mapToBase(p));\n        return VirtualFS.makeVirtualPath(match[1], match[3], realpath);\n    }\n    mapToBase(p) {\n        if (p === ``)\n            return p;\n        if (this.pathUtils.isAbsolute(p))\n            return VirtualFS.resolveVirtual(p);\n        const resolvedRoot = VirtualFS.resolveVirtual(this.baseFs.resolve(path_1.PortablePath.dot));\n        const resolvedP = VirtualFS.resolveVirtual(this.baseFs.resolve(p));\n        return path_1.ppath.relative(resolvedRoot, resolvedP) || path_1.PortablePath.dot;\n    }\n    mapFromBase(p) {\n        return p;\n    }\n}\nexports.VirtualFS = VirtualFS;\n\n\n/***/ }),\n\n/***/ 142:\n/***/ ((__unused_webpack_module, exports, __webpack_require__) => {\n\n\"use strict\";\n\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.copyPromise = exports.setupCopyIndex = void 0;\nconst tslib_1 = __webpack_require__(177);\nconst constants = tslib_1.__importStar(__webpack_require__(78));\nconst path_1 = __webpack_require__(905);\nconst defaultTime = new Date(constants.SAFE_TIME * 1000);\nconst defaultTimeMs = defaultTime.getTime();\nasync function setupCopyIndex(destinationFs, linkStrategy) {\n    const hexCharacters = `0123456789abcdef`;\n    await destinationFs.mkdirPromise(linkStrategy.indexPath, { recursive: true });\n    const promises = [];\n    for (const l1 of hexCharacters)\n        for (const l2 of hexCharacters)\n            promises.push(destinationFs.mkdirPromise(destinationFs.pathUtils.join(linkStrategy.indexPath, `${l1}${l2}`), { recursive: true }));\n    await Promise.all(promises);\n    return linkStrategy.indexPath;\n}\nexports.setupCopyIndex = setupCopyIndex;\nasync function copyPromise(destinationFs, destination, sourceFs, source, opts) {\n    const normalizedDestination = destinationFs.pathUtils.normalize(destination);\n    const normalizedSource = sourceFs.pathUtils.normalize(source);\n    const prelayout = [];\n    const postlayout = [];\n    const { atime, mtime } = opts.stableTime\n        ? { atime: defaultTime, mtime: defaultTime }\n        : await sourceFs.lstatPromise(normalizedSource);\n    await destinationFs.mkdirpPromise(destinationFs.pathUtils.dirname(destination), { utimes: [atime, mtime] });\n    await copyImpl(prelayout, postlayout, destinationFs, normalizedDestination, sourceFs, normalizedSource, { ...opts, didParentExist: true });\n    for (const operation of prelayout)\n        await operation();\n    await Promise.all(postlayout.map(operation => {\n        return operation();\n    }));\n}\nexports.copyPromise = copyPromise;\nasync function copyImpl(prelayout, postlayout, destinationFs, destination, sourceFs, source, opts) {\n    var _a, _b, _c;\n    const destinationStat = opts.didParentExist ? await maybeLStat(destinationFs, destination) : null;\n    const sourceStat = await sourceFs.lstatPromise(source);\n    const { atime, mtime } = opts.stableTime\n        ? { atime: defaultTime, mtime: defaultTime }\n        : sourceStat;\n    let updated;\n    switch (true) {\n        case sourceStat.isDirectory():\n            {\n                updated = await copyFolder(prelayout, postlayout, destinationFs, destination, destinationStat, sourceFs, source, sourceStat, opts);\n            }\n            break;\n        case sourceStat.isFile():\n            {\n                updated = await copyFile(prelayout, postlayout, destinationFs, destination, destinationStat, sourceFs, source, sourceStat, opts);\n            }\n            break;\n        case sourceStat.isSymbolicLink():\n            {\n                updated = await copySymlink(prelayout, postlayout, destinationFs, destination, destinationStat, sourceFs, source, sourceStat, opts);\n            }\n            break;\n        default:\n            {\n                throw new Error(`Unsupported file type (${sourceStat.mode})`);\n            }\n            break;\n    }\n    // We aren't allowed to modify the destination if we work with the index,\n    // since otherwise we'd accidentally propagate the changes to all projects.\n    if (((_a = opts.linkStrategy) === null || _a === void 0 ? void 0 : _a.type) !== `HardlinkFromIndex` || !sourceStat.isFile()) {\n        if (updated || ((_b = destinationStat === null || destinationStat === void 0 ? void 0 : destinationStat.mtime) === null || _b === void 0 ? void 0 : _b.getTime()) !== mtime.getTime() || ((_c = destinationStat === null || destinationStat === void 0 ? void 0 : destinationStat.atime) === null || _c === void 0 ? void 0 : _c.getTime()) !== atime.getTime()) {\n            postlayout.push(() => destinationFs.lutimesPromise(destination, atime, mtime));\n            updated = true;\n        }\n        if (destinationStat === null || (destinationStat.mode & 0o777) !== (sourceStat.mode & 0o777)) {\n            postlayout.push(() => destinationFs.chmodPromise(destination, sourceStat.mode & 0o777));\n            updated = true;\n        }\n    }\n    return updated;\n}\nasync function maybeLStat(baseFs, p) {\n    try {\n        return await baseFs.lstatPromise(p);\n    }\n    catch (e) {\n        return null;\n    }\n}\nasync function copyFolder(prelayout, postlayout, destinationFs, destination, destinationStat, sourceFs, source, sourceStat, opts) {\n    if (destinationStat !== null && !destinationStat.isDirectory()) {\n        if (opts.overwrite) {\n            prelayout.push(async () => destinationFs.removePromise(destination));\n            destinationStat = null;\n        }\n        else {\n            return false;\n        }\n    }\n    let updated = false;\n    if (destinationStat === null) {\n        prelayout.push(async () => {\n            try {\n                await destinationFs.mkdirPromise(destination, { mode: sourceStat.mode });\n            }\n            catch (err) {\n                if (err.code !== `EEXIST`) {\n                    throw err;\n                }\n            }\n        });\n        updated = true;\n    }\n    const entries = await sourceFs.readdirPromise(source);\n    const nextOpts = opts.didParentExist && !destinationStat ? { ...opts, didParentExist: false } : opts;\n    if (opts.stableSort) {\n        for (const entry of entries.sort()) {\n            if (await copyImpl(prelayout, postlayout, destinationFs, destinationFs.pathUtils.join(destination, entry), sourceFs, sourceFs.pathUtils.join(source, entry), nextOpts)) {\n                updated = true;\n            }\n        }\n    }\n    else {\n        const entriesUpdateStatus = await Promise.all(entries.map(async (entry) => {\n            await copyImpl(prelayout, postlayout, destinationFs, destinationFs.pathUtils.join(destination, entry), sourceFs, sourceFs.pathUtils.join(source, entry), nextOpts);\n        }));\n        if (entriesUpdateStatus.some(status => status)) {\n            updated = true;\n        }\n    }\n    return updated;\n}\nasync function copyFileViaIndex(prelayout, postlayout, destinationFs, destination, destinationStat, sourceFs, source, sourceStat, opts, linkStrategy) {\n    const sourceHash = await sourceFs.checksumFilePromise(source, { algorithm: `sha1` });\n    const indexPath = destinationFs.pathUtils.join(linkStrategy.indexPath, sourceHash.slice(0, 2), `${sourceHash}.dat`);\n    let AtomicBehavior;\n    (function (AtomicBehavior) {\n        AtomicBehavior[AtomicBehavior[\"Lock\"] = 0] = \"Lock\";\n        AtomicBehavior[AtomicBehavior[\"Rename\"] = 1] = \"Rename\";\n    })(AtomicBehavior || (AtomicBehavior = {}));\n    let atomicBehavior = AtomicBehavior.Rename;\n    let indexStat = await maybeLStat(destinationFs, indexPath);\n    if (destinationStat) {\n        const isDestinationHardlinkedFromIndex = indexStat && destinationStat.dev === indexStat.dev && destinationStat.ino === indexStat.ino;\n        const isIndexModified = (indexStat === null || indexStat === void 0 ? void 0 : indexStat.mtimeMs) !== defaultTimeMs;\n        if (isDestinationHardlinkedFromIndex) {\n            // If the index is modified, we will want to repair it. However, the\n            // default logic ensuring atomicity (creating a file in a temporary\n            // place before atomically moving it into its final location) won't\n            // work: we'd lose all the existing hardlinks.\n            //\n            // To avoid that, when repairing a file, we fallback to the slow but\n            // safer `lockPromise`-based mutex, which will prevent multiple\n            // processes to modify the file without impacting their inode.\n            //\n            // Give that the repair mechanism should be very rarely needed in\n            // situation where performance is critical, it should be ok.\n            //\n            if (isIndexModified && linkStrategy.autoRepair) {\n                atomicBehavior = AtomicBehavior.Lock;\n                indexStat = null;\n            }\n        }\n        if (!isDestinationHardlinkedFromIndex) {\n            if (opts.overwrite) {\n                prelayout.push(async () => destinationFs.removePromise(destination));\n                destinationStat = null;\n            }\n            else {\n                return false;\n            }\n        }\n    }\n    const tempPath = !indexStat && atomicBehavior === AtomicBehavior.Rename\n        ? `${indexPath}.${Math.floor(Math.random() * 0x100000000).toString(16).padStart(8, `0`)}`\n        : null;\n    let tempPathCleaned = false;\n    prelayout.push(async () => {\n        if (!indexStat) {\n            if (atomicBehavior === AtomicBehavior.Lock) {\n                await destinationFs.lockPromise(indexPath, async () => {\n                    const content = await sourceFs.readFilePromise(source);\n                    await destinationFs.writeFilePromise(indexPath, content);\n                });\n            }\n            if (atomicBehavior === AtomicBehavior.Rename && tempPath) {\n                const content = await sourceFs.readFilePromise(source);\n                await destinationFs.writeFilePromise(tempPath, content);\n                // We use `linkPromise` rather than `renamePromise` because the later\n                // overwrites the destination if it already exists; usually this\n                // wouldn't be a problem, but since we care about preserving the\n                // hardlink identity of the destination, we can't do that.\n                //\n                // So instead we create a hardlink of the source file (which will\n                // fail with EEXIST if the destination already exists), and we remove\n                // the source in the postlayout steps.\n                //\n                try {\n                    await destinationFs.linkPromise(tempPath, indexPath);\n                }\n                catch (err) {\n                    if (err.code === `EEXIST`) {\n                        tempPathCleaned = true;\n                        await destinationFs.unlinkPromise(tempPath);\n                    }\n                    else {\n                        throw err;\n                    }\n                }\n            }\n        }\n        if (!destinationStat) {\n            await destinationFs.linkPromise(indexPath, destination);\n        }\n    });\n    postlayout.push(async () => {\n        if (!indexStat)\n            await destinationFs.lutimesPromise(indexPath, defaultTime, defaultTime);\n        if (tempPath && !tempPathCleaned) {\n            await destinationFs.unlinkPromise(tempPath);\n        }\n    });\n    return false;\n}\nasync function copyFileDirect(prelayout, postlayout, destinationFs, destination, destinationStat, sourceFs, source, sourceStat, opts) {\n    if (destinationStat !== null) {\n        if (opts.overwrite) {\n            prelayout.push(async () => destinationFs.removePromise(destination));\n            destinationStat = null;\n        }\n        else {\n            return false;\n        }\n    }\n    // TODO: Add support for file cloning, by adding a flag inside the FakeFS\n    // instances to detect which \"namespace\" they're part of (for example, the\n    // NodeFS and the ZipFS would be different namespaces since you can't clone\n    // from one disk to the other; on the other hand, a CwdFS would share the\n    // namespace from its base FS and thus would support cloning).\n    prelayout.push(async () => {\n        const content = await sourceFs.readFilePromise(source);\n        await destinationFs.writeFilePromise(destination, content);\n    });\n    return true;\n}\nasync function copyFile(prelayout, postlayout, destinationFs, destination, destinationStat, sourceFs, source, sourceStat, opts) {\n    var _a;\n    if (((_a = opts.linkStrategy) === null || _a === void 0 ? void 0 : _a.type) === `HardlinkFromIndex`) {\n        return copyFileViaIndex(prelayout, postlayout, destinationFs, destination, destinationStat, sourceFs, source, sourceStat, opts, opts.linkStrategy);\n    }\n    else {\n        return copyFileDirect(prelayout, postlayout, destinationFs, destination, destinationStat, sourceFs, source, sourceStat, opts);\n    }\n}\nasync function copySymlink(prelayout, postlayout, destinationFs, destination, destinationStat, sourceFs, source, sourceStat, opts) {\n    if (destinationStat !== null) {\n        if (opts.overwrite) {\n            prelayout.push(async () => destinationFs.removePromise(destination));\n            destinationStat = null;\n        }\n        else {\n            return false;\n        }\n    }\n    prelayout.push(async () => {\n        await destinationFs.symlinkPromise((0, path_1.convertPath)(destinationFs.pathUtils, await sourceFs.readlinkPromise(source)), destination);\n    });\n    return true;\n}\n\n\n/***/ }),\n\n/***/ 109:\n/***/ ((__unused_webpack_module, exports, __webpack_require__) => {\n\n\"use strict\";\n\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.opendir = exports.CustomDir = void 0;\nconst tslib_1 = __webpack_require__(177);\nconst errors = tslib_1.__importStar(__webpack_require__(377));\nclass CustomDir {\n    constructor(path, nextDirent, opts = {}) {\n        this.path = path;\n        this.nextDirent = nextDirent;\n        this.opts = opts;\n        this.closed = false;\n    }\n    throwIfClosed() {\n        if (this.closed) {\n            throw errors.ERR_DIR_CLOSED();\n        }\n    }\n    async *[Symbol.asyncIterator]() {\n        try {\n            let dirent;\n            // eslint-disable-next-line no-cond-assign\n            while ((dirent = await this.read()) !== null) {\n                yield dirent;\n            }\n        }\n        finally {\n            await this.close();\n        }\n    }\n    read(cb) {\n        const dirent = this.readSync();\n        if (typeof cb !== `undefined`)\n            return cb(null, dirent);\n        return Promise.resolve(dirent);\n    }\n    readSync() {\n        this.throwIfClosed();\n        return this.nextDirent();\n    }\n    close(cb) {\n        this.closeSync();\n        if (typeof cb !== `undefined`)\n            return cb(null);\n        return Promise.resolve();\n    }\n    closeSync() {\n        var _a, _b;\n        this.throwIfClosed();\n        (_b = (_a = this.opts).onClose) === null || _b === void 0 ? void 0 : _b.call(_a);\n        this.closed = true;\n    }\n}\nexports.CustomDir = CustomDir;\nfunction opendir(fakeFs, path, entries, opts) {\n    const nextDirent = () => {\n        const filename = entries.shift();\n        if (typeof filename === `undefined`)\n            return null;\n        return Object.assign(fakeFs.statSync(fakeFs.pathUtils.join(path, filename)), {\n            name: filename,\n        });\n    };\n    return new CustomDir(path, nextDirent, opts);\n}\nexports.opendir = opendir;\n\n\n/***/ }),\n\n/***/ 126:\n/***/ ((__unused_webpack_module, exports, __webpack_require__) => {\n\n\"use strict\";\n\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.unwatchAllFiles = exports.unwatchFile = exports.watchFile = void 0;\nconst CustomStatWatcher_1 = __webpack_require__(75);\nconst statWatchersByFakeFS = new WeakMap();\nfunction watchFile(fakeFs, path, a, b) {\n    let bigint;\n    let persistent;\n    let interval;\n    let listener;\n    switch (typeof a) {\n        case `function`:\n            {\n                bigint = false;\n                persistent = true;\n                interval = 5007;\n                listener = a;\n            }\n            break;\n        default:\n            {\n                ({\n                    bigint = false,\n                    persistent = true,\n                    interval = 5007,\n                } = a);\n                listener = b;\n            }\n            break;\n    }\n    let statWatchers = statWatchersByFakeFS.get(fakeFs);\n    if (typeof statWatchers === `undefined`)\n        statWatchersByFakeFS.set(fakeFs, statWatchers = new Map());\n    let statWatcher = statWatchers.get(path);\n    if (typeof statWatcher === `undefined`) {\n        statWatcher = CustomStatWatcher_1.CustomStatWatcher.create(fakeFs, path, { bigint });\n        statWatchers.set(path, statWatcher);\n    }\n    statWatcher.registerChangeListener(listener, { persistent, interval });\n    return statWatcher;\n}\nexports.watchFile = watchFile;\nfunction unwatchFile(fakeFs, path, cb) {\n    const statWatchers = statWatchersByFakeFS.get(fakeFs);\n    if (typeof statWatchers === `undefined`)\n        return;\n    const statWatcher = statWatchers.get(path);\n    if (typeof statWatcher === `undefined`)\n        return;\n    if (typeof cb === `undefined`)\n        statWatcher.unregisterAllChangeListeners();\n    else\n        statWatcher.unregisterChangeListener(cb);\n    if (!statWatcher.hasChangeListeners()) {\n        statWatcher.stop();\n        statWatchers.delete(path);\n    }\n}\nexports.unwatchFile = unwatchFile;\nfunction unwatchAllFiles(fakeFs) {\n    const statWatchers = statWatchersByFakeFS.get(fakeFs);\n    if (typeof statWatchers === `undefined`)\n        return;\n    for (const path of statWatchers.keys()) {\n        unwatchFile(fakeFs, path);\n    }\n}\nexports.unwatchAllFiles = unwatchAllFiles;\n\n\n/***/ }),\n\n/***/ 75:\n/***/ ((__unused_webpack_module, exports, __webpack_require__) => {\n\n\"use strict\";\n\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.CustomStatWatcher = exports.assertStatus = exports.Status = exports.Event = void 0;\nconst tslib_1 = __webpack_require__(177);\nconst events_1 = __webpack_require__(361);\nconst statUtils = tslib_1.__importStar(__webpack_require__(64));\nvar Event;\n(function (Event) {\n    Event[\"Change\"] = \"change\";\n    Event[\"Stop\"] = \"stop\";\n})(Event = exports.Event || (exports.Event = {}));\nvar Status;\n(function (Status) {\n    Status[\"Ready\"] = \"ready\";\n    Status[\"Running\"] = \"running\";\n    Status[\"Stopped\"] = \"stopped\";\n})(Status = exports.Status || (exports.Status = {}));\nfunction assertStatus(current, expected) {\n    if (current !== expected) {\n        throw new Error(`Invalid StatWatcher status: expected '${expected}', got '${current}'`);\n    }\n}\nexports.assertStatus = assertStatus;\nclass CustomStatWatcher extends events_1.EventEmitter {\n    static create(fakeFs, path, opts) {\n        const statWatcher = new CustomStatWatcher(fakeFs, path, opts);\n        statWatcher.start();\n        return statWatcher;\n    }\n    constructor(fakeFs, path, { bigint = false } = {}) {\n        super();\n        this.status = Status.Ready;\n        this.changeListeners = new Map();\n        this.startTimeout = null;\n        this.fakeFs = fakeFs;\n        this.path = path;\n        this.bigint = bigint;\n        this.lastStats = this.stat();\n    }\n    start() {\n        assertStatus(this.status, Status.Ready);\n        this.status = Status.Running;\n        // Node allows other listeners to be registered up to 3 milliseconds\n        // after the watcher has been started, so that's what we're doing too\n        this.startTimeout = setTimeout(() => {\n            this.startTimeout = null;\n            // Per the Node FS docs:\n            // \"When an fs.watchFile operation results in an ENOENT error,\n            // it will invoke the listener once, with all the fields zeroed\n            // (or, for dates, the Unix Epoch).\"\n            if (!this.fakeFs.existsSync(this.path)) {\n                this.emit(Event.Change, this.lastStats, this.lastStats);\n            }\n        }, 3);\n    }\n    stop() {\n        assertStatus(this.status, Status.Running);\n        this.status = Status.Stopped;\n        if (this.startTimeout !== null) {\n            clearTimeout(this.startTimeout);\n            this.startTimeout = null;\n        }\n        this.emit(Event.Stop);\n    }\n    stat() {\n        try {\n            return this.fakeFs.statSync(this.path, { bigint: this.bigint });\n        }\n        catch (error) {\n            // From observation, all errors seem to be mostly ignored by Node.\n            // Checked with ENOENT, ENOTDIR, EPERM\n            const statInstance = this.bigint\n                ? new statUtils.BigIntStatsEntry()\n                : new statUtils.StatEntry();\n            return statUtils.clearStats(statInstance);\n        }\n    }\n    /**\n     * Creates an interval whose callback compares the current stats with the previous stats and notifies all listeners in case of changes.\n     *\n     * @param opts.persistent Decides whether the interval should be immediately unref-ed.\n     */\n    makeInterval(opts) {\n        const interval = setInterval(() => {\n            const currentStats = this.stat();\n            const previousStats = this.lastStats;\n            if (statUtils.areStatsEqual(currentStats, previousStats))\n                return;\n            this.lastStats = currentStats;\n            this.emit(Event.Change, currentStats, previousStats);\n        }, opts.interval);\n        return opts.persistent ? interval : interval.unref();\n    }\n    /**\n     * Registers a listener and assigns it an interval.\n     */\n    registerChangeListener(listener, opts) {\n        this.addListener(Event.Change, listener);\n        this.changeListeners.set(listener, this.makeInterval(opts));\n    }\n    /**\n     * Unregisters the listener and clears the assigned interval.\n     */\n    unregisterChangeListener(listener) {\n        this.removeListener(Event.Change, listener);\n        const interval = this.changeListeners.get(listener);\n        if (typeof interval !== `undefined`)\n            clearInterval(interval);\n        this.changeListeners.delete(listener);\n    }\n    /**\n     * Unregisters all listeners and clears all assigned intervals.\n     */\n    unregisterAllChangeListeners() {\n        for (const listener of this.changeListeners.keys()) {\n            this.unregisterChangeListener(listener);\n        }\n    }\n    hasChangeListeners() {\n        return this.changeListeners.size > 0;\n    }\n    /**\n     * Refs all stored intervals.\n     */\n    ref() {\n        for (const interval of this.changeListeners.values())\n            interval.ref();\n        return this;\n    }\n    /**\n     * Unrefs all stored intervals.\n     */\n    unref() {\n        for (const interval of this.changeListeners.values())\n            interval.unref();\n        return this;\n    }\n}\nexports.CustomStatWatcher = CustomStatWatcher;\n\n\n/***/ }),\n\n/***/ 78:\n/***/ ((__unused_webpack_module, exports) => {\n\n\"use strict\";\n\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.SAFE_TIME = exports.S_IFLNK = exports.S_IFREG = exports.S_IFDIR = exports.S_IFMT = void 0;\nexports.S_IFMT = 0o170000;\nexports.S_IFDIR = 0o040000;\nexports.S_IFREG = 0o100000;\nexports.S_IFLNK = 0o120000;\n/**\n * Unix timestamp for `1984-06-22T21:50:00.000Z`\n *\n * It needs to be after 1980-01-01 because that's what Zip supports, and it\n * needs to have a slight offset to account for different timezones (because\n * zip assumes that all times are local to whoever writes the file, which is\n * really silly).\n */\nexports.SAFE_TIME = 456789000;\n\n\n/***/ }),\n\n/***/ 377:\n/***/ ((__unused_webpack_module, exports) => {\n\n\"use strict\";\n\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.ERR_DIR_CLOSED = exports.EOPNOTSUPP = exports.ENOTEMPTY = exports.EROFS = exports.EEXIST = exports.EISDIR = exports.ENOTDIR = exports.ENOENT = exports.EBADF = exports.EINVAL = exports.ENOSYS = exports.EBUSY = void 0;\nfunction makeError(code, message) {\n    return Object.assign(new Error(`${code}: ${message}`), { code });\n}\nfunction EBUSY(message) {\n    return makeError(`EBUSY`, message);\n}\nexports.EBUSY = EBUSY;\nfunction ENOSYS(message, reason) {\n    return makeError(`ENOSYS`, `${message}, ${reason}`);\n}\nexports.ENOSYS = ENOSYS;\nfunction EINVAL(reason) {\n    return makeError(`EINVAL`, `invalid argument, ${reason}`);\n}\nexports.EINVAL = EINVAL;\nfunction EBADF(reason) {\n    return makeError(`EBADF`, `bad file descriptor, ${reason}`);\n}\nexports.EBADF = EBADF;\nfunction ENOENT(reason) {\n    return makeError(`ENOENT`, `no such file or directory, ${reason}`);\n}\nexports.ENOENT = ENOENT;\nfunction ENOTDIR(reason) {\n    return makeError(`ENOTDIR`, `not a directory, ${reason}`);\n}\nexports.ENOTDIR = ENOTDIR;\nfunction EISDIR(reason) {\n    return makeError(`EISDIR`, `illegal operation on a directory, ${reason}`);\n}\nexports.EISDIR = EISDIR;\nfunction EEXIST(reason) {\n    return makeError(`EEXIST`, `file already exists, ${reason}`);\n}\nexports.EEXIST = EEXIST;\nfunction EROFS(reason) {\n    return makeError(`EROFS`, `read-only filesystem, ${reason}`);\n}\nexports.EROFS = EROFS;\nfunction ENOTEMPTY(reason) {\n    return makeError(`ENOTEMPTY`, `directory not empty, ${reason}`);\n}\nexports.ENOTEMPTY = ENOTEMPTY;\nfunction EOPNOTSUPP(reason) {\n    return makeError(`EOPNOTSUPP`, `operation not supported, ${reason}`);\n}\nexports.EOPNOTSUPP = EOPNOTSUPP;\n// ------------------------------------------------------------------------\nfunction ERR_DIR_CLOSED() {\n    return makeError(`ERR_DIR_CLOSED`, `Directory handle was closed`);\n}\nexports.ERR_DIR_CLOSED = ERR_DIR_CLOSED;\n\n\n/***/ }),\n\n/***/ 382:\n/***/ ((__unused_webpack_module, exports, __webpack_require__) => {\n\n\"use strict\";\n\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.xfs = exports.extendFs = exports.patchFs = exports.VirtualFS = exports.ProxiedFS = exports.PosixFS = exports.NodeFS = exports.NoFS = exports.MountFS = exports.LazyFS = exports.JailFS = exports.CwdFS = exports.BasePortableFakeFS = exports.FakeFS = exports.AliasFS = exports.toFilename = exports.ppath = exports.npath = exports.Filename = exports.PortablePath = exports.normalizeLineEndings = exports.unwatchAllFiles = exports.unwatchFile = exports.watchFile = exports.CustomDir = exports.opendir = exports.setupCopyIndex = exports.statUtils = exports.errors = exports.constants = void 0;\nconst tslib_1 = __webpack_require__(177);\nconst constants = tslib_1.__importStar(__webpack_require__(78));\nexports.constants = constants;\nconst errors = tslib_1.__importStar(__webpack_require__(377));\nexports.errors = errors;\nconst statUtils = tslib_1.__importStar(__webpack_require__(64));\nexports.statUtils = statUtils;\nvar copyPromise_1 = __webpack_require__(142);\nObject.defineProperty(exports, \"setupCopyIndex\", ({ enumerable: true, get: function () { return copyPromise_1.setupCopyIndex; } }));\nvar opendir_1 = __webpack_require__(109);\nObject.defineProperty(exports, \"opendir\", ({ enumerable: true, get: function () { return opendir_1.opendir; } }));\nObject.defineProperty(exports, \"CustomDir\", ({ enumerable: true, get: function () { return opendir_1.CustomDir; } }));\nvar watchFile_1 = __webpack_require__(126);\nObject.defineProperty(exports, \"watchFile\", ({ enumerable: true, get: function () { return watchFile_1.watchFile; } }));\nObject.defineProperty(exports, \"unwatchFile\", ({ enumerable: true, get: function () { return watchFile_1.unwatchFile; } }));\nObject.defineProperty(exports, \"unwatchAllFiles\", ({ enumerable: true, get: function () { return watchFile_1.unwatchAllFiles; } }));\nvar FakeFS_1 = __webpack_require__(498);\nObject.defineProperty(exports, \"normalizeLineEndings\", ({ enumerable: true, get: function () { return FakeFS_1.normalizeLineEndings; } }));\nvar path_1 = __webpack_require__(905);\nObject.defineProperty(exports, \"PortablePath\", ({ enumerable: true, get: function () { return path_1.PortablePath; } }));\nObject.defineProperty(exports, \"Filename\", ({ enumerable: true, get: function () { return path_1.Filename; } }));\nvar path_2 = __webpack_require__(905);\nObject.defineProperty(exports, \"npath\", ({ enumerable: true, get: function () { return path_2.npath; } }));\nObject.defineProperty(exports, \"ppath\", ({ enumerable: true, get: function () { return path_2.ppath; } }));\nObject.defineProperty(exports, \"toFilename\", ({ enumerable: true, get: function () { return path_2.toFilename; } }));\nvar AliasFS_1 = __webpack_require__(5);\nObject.defineProperty(exports, \"AliasFS\", ({ enumerable: true, get: function () { return AliasFS_1.AliasFS; } }));\nvar FakeFS_2 = __webpack_require__(498);\nObject.defineProperty(exports, \"FakeFS\", ({ enumerable: true, get: function () { return FakeFS_2.FakeFS; } }));\nObject.defineProperty(exports, \"BasePortableFakeFS\", ({ enumerable: true, get: function () { return FakeFS_2.BasePortableFakeFS; } }));\nvar CwdFS_1 = __webpack_require__(472);\nObject.defineProperty(exports, \"CwdFS\", ({ enumerable: true, get: function () { return CwdFS_1.CwdFS; } }));\nvar JailFS_1 = __webpack_require__(238);\nObject.defineProperty(exports, \"JailFS\", ({ enumerable: true, get: function () { return JailFS_1.JailFS; } }));\nvar LazyFS_1 = __webpack_require__(130);\nObject.defineProperty(exports, \"LazyFS\", ({ enumerable: true, get: function () { return LazyFS_1.LazyFS; } }));\nvar MountFS_1 = __webpack_require__(547);\nObject.defineProperty(exports, \"MountFS\", ({ enumerable: true, get: function () { return MountFS_1.MountFS; } }));\nvar NoFS_1 = __webpack_require__(904);\nObject.defineProperty(exports, \"NoFS\", ({ enumerable: true, get: function () { return NoFS_1.NoFS; } }));\nvar NodeFS_1 = __webpack_require__(843);\nObject.defineProperty(exports, \"NodeFS\", ({ enumerable: true, get: function () { return NodeFS_1.NodeFS; } }));\nvar PosixFS_1 = __webpack_require__(103);\nObject.defineProperty(exports, \"PosixFS\", ({ enumerable: true, get: function () { return PosixFS_1.PosixFS; } }));\nvar ProxiedFS_1 = __webpack_require__(105);\nObject.defineProperty(exports, \"ProxiedFS\", ({ enumerable: true, get: function () { return ProxiedFS_1.ProxiedFS; } }));\nvar VirtualFS_1 = __webpack_require__(735);\nObject.defineProperty(exports, \"VirtualFS\", ({ enumerable: true, get: function () { return VirtualFS_1.VirtualFS; } }));\nvar patchFs_1 = __webpack_require__(781);\nObject.defineProperty(exports, \"patchFs\", ({ enumerable: true, get: function () { return patchFs_1.patchFs; } }));\nObject.defineProperty(exports, \"extendFs\", ({ enumerable: true, get: function () { return patchFs_1.extendFs; } }));\nvar xfs_1 = __webpack_require__(743);\nObject.defineProperty(exports, \"xfs\", ({ enumerable: true, get: function () { return xfs_1.xfs; } }));\n\n\n/***/ }),\n\n/***/ 893:\n/***/ ((__unused_webpack_module, exports, __webpack_require__) => {\n\n\"use strict\";\n\nvar _a, _b, _c, _d;\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.FileHandle = void 0;\nconst readline_1 = __webpack_require__(521);\nconst kBaseFs = Symbol(`kBaseFs`);\nconst kFd = Symbol(`kFd`);\nconst kClosePromise = Symbol(`kClosePromise`);\nconst kCloseResolve = Symbol(`kCloseResolve`);\nconst kCloseReject = Symbol(`kCloseReject`);\nconst kRefs = Symbol(`kRefs`);\nconst kRef = Symbol(`kRef`);\nconst kUnref = Symbol(`kUnref`);\nclass FileHandle {\n    constructor(fd, baseFs) {\n        this[_a] = 1;\n        this[_b] = undefined;\n        this[_c] = undefined;\n        this[_d] = undefined;\n        this[kBaseFs] = baseFs;\n        this[kFd] = fd;\n    }\n    get fd() {\n        return this[kFd];\n    }\n    async appendFile(data, options) {\n        var _e;\n        try {\n            this[kRef](this.appendFile);\n            const encoding = (_e = (typeof options === `string` ? options : options === null || options === void 0 ? void 0 : options.encoding)) !== null && _e !== void 0 ? _e : undefined;\n            return await this[kBaseFs].appendFilePromise(this.fd, data, encoding ? { encoding } : undefined);\n        }\n        finally {\n            this[kUnref]();\n        }\n    }\n    async chown(uid, gid) {\n        try {\n            this[kRef](this.chown);\n            return await this[kBaseFs].fchownPromise(this.fd, uid, gid);\n        }\n        finally {\n            this[kUnref]();\n        }\n    }\n    async chmod(mode) {\n        try {\n            this[kRef](this.chmod);\n            return await this[kBaseFs].fchmodPromise(this.fd, mode);\n        }\n        finally {\n            this[kUnref]();\n        }\n    }\n    createReadStream(options) {\n        return this[kBaseFs].createReadStream(null, { ...options, fd: this.fd });\n    }\n    createWriteStream(options) {\n        return this[kBaseFs].createWriteStream(null, { ...options, fd: this.fd });\n    }\n    // FIXME: Missing FakeFS version\n    datasync() {\n        throw new Error(`Method not implemented.`);\n    }\n    // FIXME: Missing FakeFS version\n    sync() {\n        throw new Error(`Method not implemented.`);\n    }\n    async read(bufferOrOptions, offset, length, position) {\n        var _e, _f, _g;\n        try {\n            this[kRef](this.read);\n            let buffer;\n            if (!Buffer.isBuffer(bufferOrOptions)) {\n                bufferOrOptions !== null && bufferOrOptions !== void 0 ? bufferOrOptions : (bufferOrOptions = {});\n                buffer = (_e = bufferOrOptions.buffer) !== null && _e !== void 0 ? _e : Buffer.alloc(16384);\n                offset = bufferOrOptions.offset || 0;\n                length = (_f = bufferOrOptions.length) !== null && _f !== void 0 ? _f : buffer.byteLength;\n                position = (_g = bufferOrOptions.position) !== null && _g !== void 0 ? _g : null;\n            }\n            else {\n                buffer = bufferOrOptions;\n            }\n            offset !== null && offset !== void 0 ? offset : (offset = 0);\n            length !== null && length !== void 0 ? length : (length = 0);\n            if (length === 0) {\n                return {\n                    bytesRead: length,\n                    buffer,\n                };\n            }\n            const bytesRead = await this[kBaseFs].readPromise(this.fd, buffer, offset, length, position);\n            return {\n                bytesRead,\n                buffer,\n            };\n        }\n        finally {\n            this[kUnref]();\n        }\n    }\n    async readFile(options) {\n        var _e;\n        try {\n            this[kRef](this.readFile);\n            const encoding = (_e = (typeof options === `string` ? options : options === null || options === void 0 ? void 0 : options.encoding)) !== null && _e !== void 0 ? _e : undefined;\n            return await this[kBaseFs].readFilePromise(this.fd, encoding);\n        }\n        finally {\n            this[kUnref]();\n        }\n    }\n    readLines(options) {\n        return (0, readline_1.createInterface)({\n            input: this.createReadStream(options),\n            crlfDelay: Infinity,\n        });\n    }\n    async stat(opts) {\n        try {\n            this[kRef](this.stat);\n            return await this[kBaseFs].fstatPromise(this.fd, opts);\n        }\n        finally {\n            this[kUnref]();\n        }\n    }\n    async truncate(len) {\n        try {\n            this[kRef](this.truncate);\n            return await this[kBaseFs].ftruncatePromise(this.fd, len);\n        }\n        finally {\n            this[kUnref]();\n        }\n    }\n    // FIXME: Missing FakeFS version\n    utimes(atime, mtime) {\n        throw new Error(`Method not implemented.`);\n    }\n    async writeFile(data, options) {\n        var _e;\n        try {\n            this[kRef](this.writeFile);\n            const encoding = (_e = (typeof options === `string` ? options : options === null || options === void 0 ? void 0 : options.encoding)) !== null && _e !== void 0 ? _e : undefined;\n            await this[kBaseFs].writeFilePromise(this.fd, data, encoding);\n        }\n        finally {\n            this[kUnref]();\n        }\n    }\n    async write(...args) {\n        try {\n            this[kRef](this.write);\n            if (ArrayBuffer.isView(args[0])) {\n                const [buffer, offset, length, position] = args;\n                const bytesWritten = await this[kBaseFs].writePromise(this.fd, buffer, offset !== null && offset !== void 0 ? offset : undefined, length !== null && length !== void 0 ? length : undefined, position !== null && position !== void 0 ? position : undefined);\n                return { bytesWritten, buffer };\n            }\n            else {\n                const [data, position, encoding] = args;\n                // @ts-expect-error - FIXME: Types/implementation need to be updated in FakeFS\n                const bytesWritten = await this[kBaseFs].writePromise(this.fd, data, position, encoding);\n                return { bytesWritten, buffer: data };\n            }\n        }\n        finally {\n            this[kUnref]();\n        }\n    }\n    // TODO: Use writev from FakeFS when that is implemented\n    async writev(buffers, position) {\n        try {\n            this[kRef](this.writev);\n            let bytesWritten = 0;\n            if (typeof position !== `undefined`) {\n                for (const buffer of buffers) {\n                    const writeResult = await this.write(buffer, undefined, undefined, position);\n                    bytesWritten += writeResult.bytesWritten;\n                    position += writeResult.bytesWritten;\n                }\n            }\n            else {\n                for (const buffer of buffers) {\n                    const writeResult = await this.write(buffer);\n                    bytesWritten += writeResult.bytesWritten;\n                }\n            }\n            return {\n                buffers,\n                bytesWritten,\n            };\n        }\n        finally {\n            this[kUnref]();\n        }\n    }\n    // FIXME: Missing FakeFS version\n    readv(buffers, position) {\n        throw new Error(`Method not implemented.`);\n    }\n    close() {\n        if (this[kFd] === -1)\n            return Promise.resolve();\n        if (this[kClosePromise])\n            return this[kClosePromise];\n        this[kRefs]--;\n        if (this[kRefs] === 0) {\n            const fd = this[kFd];\n            this[kFd] = -1;\n            this[kClosePromise] = this[kBaseFs].closePromise(fd).finally(() => {\n                this[kClosePromise] = undefined;\n            });\n        }\n        else {\n            this[kClosePromise] =\n                new Promise((resolve, reject) => {\n                    this[kCloseResolve] = resolve;\n                    this[kCloseReject] = reject;\n                }).finally(() => {\n                    this[kClosePromise] = undefined;\n                    this[kCloseReject] = undefined;\n                    this[kCloseResolve] = undefined;\n                });\n        }\n        return this[kClosePromise];\n    }\n    [(_a = kRefs, _b = kClosePromise, _c = kCloseResolve, _d = kCloseReject, kRef)](caller) {\n        if (this[kFd] === -1) {\n            const err = new Error(`file closed`);\n            err.code = `EBADF`;\n            err.syscall = caller.name;\n            throw err;\n        }\n        this[kRefs]++;\n    }\n    [kUnref]() {\n        this[kRefs]--;\n        if (this[kRefs] === 0) {\n            const fd = this[kFd];\n            this[kFd] = -1;\n            this[kBaseFs].closePromise(fd).then(this[kCloseResolve], this[kCloseReject]);\n        }\n    }\n}\nexports.FileHandle = FileHandle;\n\n\n/***/ }),\n\n/***/ 781:\n/***/ ((__unused_webpack_module, exports, __webpack_require__) => {\n\n\"use strict\";\n\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.extendFs = exports.patchFs = void 0;\nconst util_1 = __webpack_require__(837);\nconst NodePathFS_1 = __webpack_require__(732);\nconst FileHandle_1 = __webpack_require__(893);\nconst SYNC_IMPLEMENTATIONS = new Set([\n    `accessSync`,\n    `appendFileSync`,\n    `createReadStream`,\n    `createWriteStream`,\n    `chmodSync`,\n    `fchmodSync`,\n    `chownSync`,\n    `fchownSync`,\n    `closeSync`,\n    `copyFileSync`,\n    `linkSync`,\n    `lstatSync`,\n    `fstatSync`,\n    `lutimesSync`,\n    `mkdirSync`,\n    `openSync`,\n    `opendirSync`,\n    `readlinkSync`,\n    `readFileSync`,\n    `readdirSync`,\n    `readlinkSync`,\n    `realpathSync`,\n    `renameSync`,\n    `rmdirSync`,\n    `statSync`,\n    `symlinkSync`,\n    `truncateSync`,\n    `ftruncateSync`,\n    `unlinkSync`,\n    `unwatchFile`,\n    `utimesSync`,\n    `watch`,\n    `watchFile`,\n    `writeFileSync`,\n    `writeSync`,\n]);\nconst ASYNC_IMPLEMENTATIONS = new Set([\n    `accessPromise`,\n    `appendFilePromise`,\n    `fchmodPromise`,\n    `chmodPromise`,\n    `fchownPromise`,\n    `chownPromise`,\n    `closePromise`,\n    `copyFilePromise`,\n    `linkPromise`,\n    `fstatPromise`,\n    `lstatPromise`,\n    `lutimesPromise`,\n    `mkdirPromise`,\n    `openPromise`,\n    `opendirPromise`,\n    `readdirPromise`,\n    `realpathPromise`,\n    `readFilePromise`,\n    `readdirPromise`,\n    `readlinkPromise`,\n    `renamePromise`,\n    `rmdirPromise`,\n    `statPromise`,\n    `symlinkPromise`,\n    `truncatePromise`,\n    `ftruncatePromise`,\n    `unlinkPromise`,\n    `utimesPromise`,\n    `writeFilePromise`,\n    `writeSync`,\n]);\n//#endregion\nfunction patchFs(patchedFs, fakeFs) {\n    // We wrap the `fakeFs` with a `NodePathFS` to add support for all path types supported by Node\n    fakeFs = new NodePathFS_1.NodePathFS(fakeFs);\n    const setupFn = (target, name, replacement) => {\n        const orig = target[name];\n        target[name] = replacement;\n        // Preserve any util.promisify implementations\n        if (typeof (orig === null || orig === void 0 ? void 0 : orig[util_1.promisify.custom]) !== `undefined`) {\n            replacement[util_1.promisify.custom] = orig[util_1.promisify.custom];\n        }\n    };\n    /** Callback implementations */\n    {\n        setupFn(patchedFs, `exists`, (p, ...args) => {\n            const hasCallback = typeof args[args.length - 1] === `function`;\n            const callback = hasCallback ? args.pop() : () => { };\n            process.nextTick(() => {\n                fakeFs.existsPromise(p).then(exists => {\n                    callback(exists);\n                }, () => {\n                    callback(false);\n                });\n            });\n        });\n        // Adapted from https://github.com/nodejs/node/blob/e5c1fd7a2a1801fd75bdde23b260488e85453eb2/lib/fs.js#L603-L667\n        setupFn(patchedFs, `read`, (...args) => {\n            let [fd, buffer, offset, length, position, callback] = args;\n            if (args.length <= 3) {\n                // Assume fs.read(fd, options, callback)\n                let options = {};\n                if (args.length < 3) {\n                    // This is fs.read(fd, callback)\n                    callback = args[1];\n                }\n                else {\n                    // This is fs.read(fd, {}, callback)\n                    options = args[1];\n                    callback = args[2];\n                }\n                ({\n                    buffer = Buffer.alloc(16384),\n                    offset = 0,\n                    length = buffer.byteLength,\n                    position,\n                } = options);\n            }\n            if (offset == null)\n                offset = 0;\n            length |= 0;\n            if (length === 0) {\n                process.nextTick(() => {\n                    callback(null, 0, buffer);\n                });\n                return;\n            }\n            if (position == null)\n                position = -1;\n            process.nextTick(() => {\n                fakeFs.readPromise(fd, buffer, offset, length, position).then(bytesRead => {\n                    callback(null, bytesRead, buffer);\n                }, error => {\n                    // https://github.com/nodejs/node/blob/1317252dfe8824fd9cfee125d2aaa94004db2f3b/lib/fs.js#L655-L658\n                    // Known issue: bytesRead could theoretically be > than 0, but we currently always return 0\n                    callback(error, 0, buffer);\n                });\n            });\n        });\n        for (const fnName of ASYNC_IMPLEMENTATIONS) {\n            const origName = fnName.replace(/Promise$/, ``);\n            if (typeof patchedFs[origName] === `undefined`)\n                continue;\n            const fakeImpl = fakeFs[fnName];\n            if (typeof fakeImpl === `undefined`)\n                continue;\n            const wrapper = (...args) => {\n                const hasCallback = typeof args[args.length - 1] === `function`;\n                const callback = hasCallback ? args.pop() : () => { };\n                process.nextTick(() => {\n                    fakeImpl.apply(fakeFs, args).then((result) => {\n                        callback(null, result);\n                    }, (error) => {\n                        callback(error);\n                    });\n                });\n            };\n            setupFn(patchedFs, origName, wrapper);\n        }\n        patchedFs.realpath.native = patchedFs.realpath;\n    }\n    /** Sync implementations */\n    {\n        setupFn(patchedFs, `existsSync`, (p) => {\n            try {\n                return fakeFs.existsSync(p);\n            }\n            catch (error) {\n                return false;\n            }\n        });\n        // Adapted from https://github.com/nodejs/node/blob/e5c1fd7a2a1801fd75bdde23b260488e85453eb2/lib/fs.js#L684-L725\n        setupFn(patchedFs, `readSync`, (...args) => {\n            let [fd, buffer, offset, length, position] = args;\n            if (args.length <= 3) {\n                // Assume fs.read(fd, buffer, options)\n                const options = args[2] || {};\n                ({ offset = 0, length = buffer.byteLength, position } = options);\n            }\n            if (offset == null)\n                offset = 0;\n            length |= 0;\n            if (length === 0)\n                return 0;\n            if (position == null)\n                position = -1;\n            return fakeFs.readSync(fd, buffer, offset, length, position);\n        });\n        for (const fnName of SYNC_IMPLEMENTATIONS) {\n            const origName = fnName;\n            if (typeof patchedFs[origName] === `undefined`)\n                continue;\n            const fakeImpl = fakeFs[fnName];\n            if (typeof fakeImpl === `undefined`)\n                continue;\n            setupFn(patchedFs, origName, fakeImpl.bind(fakeFs));\n        }\n        patchedFs.realpathSync.native = patchedFs.realpathSync;\n    }\n    /** Promise implementations */\n    {\n        // `fs.promises` is a getter that returns a reference to require(`fs/promises`),\n        // so we can just patch `fs.promises` and both will be updated\n        const patchedFsPromises = patchedFs.promises;\n        // `fs.promises.exists` doesn't exist\n        for (const fnName of ASYNC_IMPLEMENTATIONS) {\n            const origName = fnName.replace(/Promise$/, ``);\n            if (typeof patchedFsPromises[origName] === `undefined`)\n                continue;\n            const fakeImpl = fakeFs[fnName];\n            if (typeof fakeImpl === `undefined`)\n                continue;\n            // Open is a bit particular with fs.promises: it returns a file handle\n            // instance instead of the traditional file descriptor number\n            if (fnName === `open`)\n                continue;\n            setupFn(patchedFsPromises, origName, (pathLike, ...args) => {\n                if (pathLike instanceof FileHandle_1.FileHandle) {\n                    return pathLike[origName].apply(pathLike, args);\n                }\n                else {\n                    return fakeImpl.call(fakeFs, pathLike, ...args);\n                }\n            });\n        }\n        setupFn(patchedFsPromises, `open`, async (...args) => {\n            // @ts-expect-error\n            const fd = await fakeFs.openPromise(...args);\n            return new FileHandle_1.FileHandle(fd, fakeFs);\n        });\n        // `fs.promises.realpath` doesn't have a `native` property\n    }\n    /** util.promisify implementations */\n    {\n        // TODO add promisified `fs.readv` and `fs.writev`, once they are implemented\n        // Override the promisified versions of `fs.read` and `fs.write` to return an object as per\n        // https://github.com/nodejs/node/blob/dc79f3f37caf6f25b8efee4623bec31e2c20f595/lib/fs.js#L559-L560\n        // and\n        // https://github.com/nodejs/node/blob/dc79f3f37caf6f25b8efee4623bec31e2c20f595/lib/fs.js#L690-L691\n        // and\n        // https://github.com/nodejs/node/blob/ba684805b6c0eded76e5cd89ee00328ac7a59365/lib/internal/util.js#L293\n        // @ts-expect-error\n        patchedFs.read[util_1.promisify.custom] = async (fd, buffer, ...args) => {\n            const res = fakeFs.readPromise(fd, buffer, ...args);\n            return { bytesRead: await res, buffer };\n        };\n        // @ts-expect-error\n        patchedFs.write[util_1.promisify.custom] = async (fd, buffer, ...args) => {\n            const res = fakeFs.writePromise(fd, buffer, ...args);\n            return { bytesWritten: await res, buffer };\n        };\n    }\n}\nexports.patchFs = patchFs;\nfunction extendFs(realFs, fakeFs) {\n    const patchedFs = Object.create(realFs);\n    patchFs(patchedFs, fakeFs);\n    return patchedFs;\n}\nexports.extendFs = extendFs;\n\n\n/***/ }),\n\n/***/ 905:\n/***/ ((__unused_webpack_module, exports, __webpack_require__) => {\n\n\"use strict\";\n\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.toFilename = exports.convertPath = exports.ppath = exports.npath = exports.Filename = exports.PortablePath = void 0;\nconst tslib_1 = __webpack_require__(177);\nconst path_1 = tslib_1.__importDefault(__webpack_require__(17));\nvar PathType;\n(function (PathType) {\n    PathType[PathType[\"File\"] = 0] = \"File\";\n    PathType[PathType[\"Portable\"] = 1] = \"Portable\";\n    PathType[PathType[\"Native\"] = 2] = \"Native\";\n})(PathType || (PathType = {}));\nexports.PortablePath = {\n    root: `/`,\n    dot: `.`,\n    parent: `..`,\n};\nexports.Filename = {\n    home: `~`,\n    nodeModules: `node_modules`,\n    manifest: `package.json`,\n    lockfile: `yarn.lock`,\n    virtual: `__virtual__`,\n    /**\n     * @deprecated\n     */\n    pnpJs: `.pnp.js`,\n    pnpCjs: `.pnp.cjs`,\n    pnpData: `.pnp.data.json`,\n    pnpEsmLoader: `.pnp.loader.mjs`,\n    rc: `.yarnrc.yml`,\n};\nexports.npath = Object.create(path_1.default);\nexports.ppath = Object.create(path_1.default.posix);\nexports.npath.cwd = () => process.cwd();\nexports.ppath.cwd = () => toPortablePath(process.cwd());\nexports.ppath.resolve = (...segments) => {\n    if (segments.length > 0 && exports.ppath.isAbsolute(segments[0])) {\n        return path_1.default.posix.resolve(...segments);\n    }\n    else {\n        return path_1.default.posix.resolve(exports.ppath.cwd(), ...segments);\n    }\n};\nconst contains = function (pathUtils, from, to) {\n    from = pathUtils.normalize(from);\n    to = pathUtils.normalize(to);\n    if (from === to)\n        return `.`;\n    if (!from.endsWith(pathUtils.sep))\n        from = (from + pathUtils.sep);\n    if (to.startsWith(from)) {\n        return to.slice(from.length);\n    }\n    else {\n        return null;\n    }\n};\nexports.npath.fromPortablePath = fromPortablePath;\nexports.npath.toPortablePath = toPortablePath;\nexports.npath.contains = (from, to) => contains(exports.npath, from, to);\nexports.ppath.contains = (from, to) => contains(exports.ppath, from, to);\nconst WINDOWS_PATH_REGEXP = /^([a-zA-Z]:.*)$/;\nconst UNC_WINDOWS_PATH_REGEXP = /^\\/\\/(\\.\\/)?(.*)$/;\nconst PORTABLE_PATH_REGEXP = /^\\/([a-zA-Z]:.*)$/;\nconst UNC_PORTABLE_PATH_REGEXP = /^\\/unc\\/(\\.dot\\/)?(.*)$/;\n// Path should look like \"/N:/berry/scripts/plugin-pack.js\"\n// And transform to \"N:\\berry\\scripts\\plugin-pack.js\"\nfunction fromPortablePath(p) {\n    if (process.platform !== `win32`)\n        return p;\n    let portablePathMatch, uncPortablePathMatch;\n    if ((portablePathMatch = p.match(PORTABLE_PATH_REGEXP)))\n        p = portablePathMatch[1];\n    else if ((uncPortablePathMatch = p.match(UNC_PORTABLE_PATH_REGEXP)))\n        p = `\\\\\\\\${uncPortablePathMatch[1] ? `.\\\\` : ``}${uncPortablePathMatch[2]}`;\n    else\n        return p;\n    return p.replace(/\\//g, `\\\\`);\n}\n// Path should look like \"N:/berry/scripts/plugin-pack.js\"\n// And transform to \"/N:/berry/scripts/plugin-pack.js\"\nfunction toPortablePath(p) {\n    if (process.platform !== `win32`)\n        return p;\n    p = p.replace(/\\\\/g, `/`);\n    let windowsPathMatch, uncWindowsPathMatch;\n    if ((windowsPathMatch = p.match(WINDOWS_PATH_REGEXP)))\n        p = `/${windowsPathMatch[1]}`;\n    else if ((uncWindowsPathMatch = p.match(UNC_WINDOWS_PATH_REGEXP)))\n        p = `/unc/${uncWindowsPathMatch[1] ? `.dot/` : ``}${uncWindowsPathMatch[2]}`;\n    return p;\n}\nfunction convertPath(targetPathUtils, sourcePath) {\n    return (targetPathUtils === exports.npath ? fromPortablePath(sourcePath) : toPortablePath(sourcePath));\n}\nexports.convertPath = convertPath;\nfunction toFilename(filename) {\n    if (exports.npath.parse(filename).dir !== `` || exports.ppath.parse(filename).dir !== ``)\n        throw new Error(`Invalid filename: \"${filename}\"`);\n    return filename;\n}\nexports.toFilename = toFilename;\n\n\n/***/ }),\n\n/***/ 64:\n/***/ ((__unused_webpack_module, exports, __webpack_require__) => {\n\n\"use strict\";\n\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.areStatsEqual = exports.convertToBigIntStats = exports.clearStats = exports.makeEmptyStats = exports.makeDefaultStats = exports.BigIntStatsEntry = exports.StatEntry = exports.DirEntry = exports.DEFAULT_MODE = void 0;\nconst tslib_1 = __webpack_require__(177);\nconst nodeUtils = tslib_1.__importStar(__webpack_require__(837));\nconst constants_1 = __webpack_require__(78);\nexports.DEFAULT_MODE = constants_1.S_IFREG | 0o644;\nclass DirEntry {\n    constructor() {\n        this.name = ``;\n        this.mode = 0;\n    }\n    isBlockDevice() {\n        return false;\n    }\n    isCharacterDevice() {\n        return false;\n    }\n    isDirectory() {\n        return (this.mode & constants_1.S_IFMT) === constants_1.S_IFDIR;\n    }\n    isFIFO() {\n        return false;\n    }\n    isFile() {\n        return (this.mode & constants_1.S_IFMT) === constants_1.S_IFREG;\n    }\n    isSocket() {\n        return false;\n    }\n    isSymbolicLink() {\n        return (this.mode & constants_1.S_IFMT) === constants_1.S_IFLNK;\n    }\n}\nexports.DirEntry = DirEntry;\nclass StatEntry {\n    constructor() {\n        this.uid = 0;\n        this.gid = 0;\n        this.size = 0;\n        this.blksize = 0;\n        this.atimeMs = 0;\n        this.mtimeMs = 0;\n        this.ctimeMs = 0;\n        this.birthtimeMs = 0;\n        this.atime = new Date(0);\n        this.mtime = new Date(0);\n        this.ctime = new Date(0);\n        this.birthtime = new Date(0);\n        this.dev = 0;\n        this.ino = 0;\n        this.mode = exports.DEFAULT_MODE;\n        this.nlink = 1;\n        this.rdev = 0;\n        this.blocks = 1;\n    }\n    isBlockDevice() {\n        return false;\n    }\n    isCharacterDevice() {\n        return false;\n    }\n    isDirectory() {\n        return (this.mode & constants_1.S_IFMT) === constants_1.S_IFDIR;\n    }\n    isFIFO() {\n        return false;\n    }\n    isFile() {\n        return (this.mode & constants_1.S_IFMT) === constants_1.S_IFREG;\n    }\n    isSocket() {\n        return false;\n    }\n    isSymbolicLink() {\n        return (this.mode & constants_1.S_IFMT) === constants_1.S_IFLNK;\n    }\n}\nexports.StatEntry = StatEntry;\nclass BigIntStatsEntry {\n    constructor() {\n        this.uid = BigInt(0);\n        this.gid = BigInt(0);\n        this.size = BigInt(0);\n        this.blksize = BigInt(0);\n        this.atimeMs = BigInt(0);\n        this.mtimeMs = BigInt(0);\n        this.ctimeMs = BigInt(0);\n        this.birthtimeMs = BigInt(0);\n        this.atimeNs = BigInt(0);\n        this.mtimeNs = BigInt(0);\n        this.ctimeNs = BigInt(0);\n        this.birthtimeNs = BigInt(0);\n        this.atime = new Date(0);\n        this.mtime = new Date(0);\n        this.ctime = new Date(0);\n        this.birthtime = new Date(0);\n        this.dev = BigInt(0);\n        this.ino = BigInt(0);\n        this.mode = BigInt(exports.DEFAULT_MODE);\n        this.nlink = BigInt(1);\n        this.rdev = BigInt(0);\n        this.blocks = BigInt(1);\n    }\n    isBlockDevice() {\n        return false;\n    }\n    isCharacterDevice() {\n        return false;\n    }\n    isDirectory() {\n        return (this.mode & BigInt(constants_1.S_IFMT)) === BigInt(constants_1.S_IFDIR);\n    }\n    isFIFO() {\n        return false;\n    }\n    isFile() {\n        return (this.mode & BigInt(constants_1.S_IFMT)) === BigInt(constants_1.S_IFREG);\n    }\n    isSocket() {\n        return false;\n    }\n    isSymbolicLink() {\n        return (this.mode & BigInt(constants_1.S_IFMT)) === BigInt(constants_1.S_IFLNK);\n    }\n}\nexports.BigIntStatsEntry = BigIntStatsEntry;\nfunction makeDefaultStats() {\n    return new StatEntry();\n}\nexports.makeDefaultStats = makeDefaultStats;\nfunction makeEmptyStats() {\n    return clearStats(makeDefaultStats());\n}\nexports.makeEmptyStats = makeEmptyStats;\n/**\n * Mutates the provided stats object to zero it out then returns it for convenience\n */\nfunction clearStats(stats) {\n    for (const key in stats) {\n        if (Object.prototype.hasOwnProperty.call(stats, key)) {\n            const element = stats[key];\n            if (typeof element === `number`) {\n                // @ts-expect-error Typescript can't tell that stats[key] is a number\n                stats[key] = 0;\n            }\n            else if (typeof element === `bigint`) {\n                // @ts-expect-error Typescript can't tell that stats[key] is a bigint\n                stats[key] = BigInt(0);\n            }\n            else if (nodeUtils.types.isDate(element)) {\n                // @ts-expect-error Typescript can't tell that stats[key] is a bigint\n                stats[key] = new Date(0);\n            }\n        }\n    }\n    return stats;\n}\nexports.clearStats = clearStats;\nfunction convertToBigIntStats(stats) {\n    const bigintStats = new BigIntStatsEntry();\n    for (const key in stats) {\n        if (Object.prototype.hasOwnProperty.call(stats, key)) {\n            const element = stats[key];\n            if (typeof element === `number`) {\n                // @ts-expect-error Typescript isn't able to tell this is valid\n                bigintStats[key] = BigInt(element);\n            }\n            else if (nodeUtils.types.isDate(element)) {\n                // @ts-expect-error Typescript isn't able to tell this is valid\n                bigintStats[key] = new Date(element);\n            }\n        }\n    }\n    bigintStats.atimeNs = bigintStats.atimeMs * BigInt(1e6);\n    bigintStats.mtimeNs = bigintStats.mtimeMs * BigInt(1e6);\n    bigintStats.ctimeNs = bigintStats.ctimeMs * BigInt(1e6);\n    bigintStats.birthtimeNs = bigintStats.birthtimeMs * BigInt(1e6);\n    return bigintStats;\n}\nexports.convertToBigIntStats = convertToBigIntStats;\nfunction areStatsEqual(a, b) {\n    if (a.atimeMs !== b.atimeMs)\n        return false;\n    if (a.birthtimeMs !== b.birthtimeMs)\n        return false;\n    if (a.blksize !== b.blksize)\n        return false;\n    if (a.blocks !== b.blocks)\n        return false;\n    if (a.ctimeMs !== b.ctimeMs)\n        return false;\n    if (a.dev !== b.dev)\n        return false;\n    if (a.gid !== b.gid)\n        return false;\n    if (a.ino !== b.ino)\n        return false;\n    if (a.isBlockDevice() !== b.isBlockDevice())\n        return false;\n    if (a.isCharacterDevice() !== b.isCharacterDevice())\n        return false;\n    if (a.isDirectory() !== b.isDirectory())\n        return false;\n    if (a.isFIFO() !== b.isFIFO())\n        return false;\n    if (a.isFile() !== b.isFile())\n        return false;\n    if (a.isSocket() !== b.isSocket())\n        return false;\n    if (a.isSymbolicLink() !== b.isSymbolicLink())\n        return false;\n    if (a.mode !== b.mode)\n        return false;\n    if (a.mtimeMs !== b.mtimeMs)\n        return false;\n    if (a.nlink !== b.nlink)\n        return false;\n    if (a.rdev !== b.rdev)\n        return false;\n    if (a.size !== b.size)\n        return false;\n    if (a.uid !== b.uid)\n        return false;\n    const aN = a;\n    const bN = b;\n    if (aN.atimeNs !== bN.atimeNs)\n        return false;\n    if (aN.mtimeNs !== bN.mtimeNs)\n        return false;\n    if (aN.ctimeNs !== bN.ctimeNs)\n        return false;\n    if (aN.birthtimeNs !== bN.birthtimeNs)\n        return false;\n    return true;\n}\nexports.areStatsEqual = areStatsEqual;\n\n\n/***/ }),\n\n/***/ 743:\n/***/ ((__unused_webpack_module, exports, __webpack_require__) => {\n\n\"use strict\";\n\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.xfs = void 0;\nconst tslib_1 = __webpack_require__(177);\nconst os_1 = tslib_1.__importDefault(__webpack_require__(37));\nconst NodeFS_1 = __webpack_require__(843);\nconst path_1 = __webpack_require__(905);\nfunction getTempName(prefix) {\n    const hash = Math.ceil(Math.random() * 0x100000000).toString(16).padStart(8, `0`);\n    return `${prefix}${hash}`;\n}\nconst tmpdirs = new Set();\nlet tmpEnv = null;\nfunction initTmpEnv() {\n    if (tmpEnv)\n        return tmpEnv;\n    const tmpdir = path_1.npath.toPortablePath(os_1.default.tmpdir());\n    const realTmpdir = exports.xfs.realpathSync(tmpdir);\n    process.once(`exit`, () => {\n        exports.xfs.rmtempSync();\n    });\n    return tmpEnv = {\n        tmpdir,\n        realTmpdir,\n    };\n}\nexports.xfs = Object.assign(new NodeFS_1.NodeFS(), {\n    detachTemp(p) {\n        tmpdirs.delete(p);\n    },\n    mktempSync(cb) {\n        const { tmpdir, realTmpdir } = initTmpEnv();\n        while (true) {\n            const name = getTempName(`xfs-`);\n            try {\n                this.mkdirSync(path_1.ppath.join(tmpdir, name));\n            }\n            catch (error) {\n                if (error.code === `EEXIST`) {\n                    continue;\n                }\n                else {\n                    throw error;\n                }\n            }\n            const realP = path_1.ppath.join(realTmpdir, name);\n            tmpdirs.add(realP);\n            if (typeof cb === `undefined`)\n                return realP;\n            try {\n                return cb(realP);\n            }\n            finally {\n                if (tmpdirs.has(realP)) {\n                    tmpdirs.delete(realP);\n                    try {\n                        this.removeSync(realP);\n                    }\n                    catch {\n                        // Too bad if there's an error\n                    }\n                }\n            }\n        }\n    },\n    async mktempPromise(cb) {\n        const { tmpdir, realTmpdir } = initTmpEnv();\n        while (true) {\n            const name = getTempName(`xfs-`);\n            try {\n                await this.mkdirPromise(path_1.ppath.join(tmpdir, name));\n            }\n            catch (error) {\n                if (error.code === `EEXIST`) {\n                    continue;\n                }\n                else {\n                    throw error;\n                }\n            }\n            const realP = path_1.ppath.join(realTmpdir, name);\n            tmpdirs.add(realP);\n            if (typeof cb === `undefined`)\n                return realP;\n            try {\n                return await cb(realP);\n            }\n            finally {\n                if (tmpdirs.has(realP)) {\n                    tmpdirs.delete(realP);\n                    try {\n                        await this.removePromise(realP);\n                    }\n                    catch {\n                        // Too bad if there's an error\n                    }\n                }\n            }\n        }\n    },\n    async rmtempPromise() {\n        await Promise.all(Array.from(tmpdirs.values()).map(async (p) => {\n            try {\n                await exports.xfs.removePromise(p, { maxRetries: 0 });\n                tmpdirs.delete(p);\n            }\n            catch {\n                // Too bad if there's an error\n            }\n        }));\n    },\n    rmtempSync() {\n        for (const p of tmpdirs) {\n            try {\n                exports.xfs.removeSync(p);\n                tmpdirs.delete(p);\n            }\n            catch {\n                // Too bad if there's an error\n            }\n        }\n    },\n});\n\n\n/***/ }),\n\n/***/ 177:\n/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {\n\n\"use strict\";\n__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"__assign\": () => (/* binding */ __assign),\n/* harmony export */   \"__asyncDelegator\": () => (/* binding */ __asyncDelegator),\n/* harmony export */   \"__asyncGenerator\": () => (/* binding */ __asyncGenerator),\n/* harmony export */   \"__asyncValues\": () => (/* binding */ __asyncValues),\n/* harmony export */   \"__await\": () => (/* binding */ __await),\n/* harmony export */   \"__awaiter\": () => (/* binding */ __awaiter),\n/* harmony export */   \"__classPrivateFieldGet\": () => (/* binding */ __classPrivateFieldGet),\n/* harmony export */   \"__classPrivateFieldIn\": () => (/* binding */ __classPrivateFieldIn),\n/* harmony export */   \"__classPrivateFieldSet\": () => (/* binding */ __classPrivateFieldSet),\n/* harmony export */   \"__createBinding\": () => (/* binding */ __createBinding),\n/* harmony export */   \"__decorate\": () => (/* binding */ __decorate),\n/* harmony export */   \"__esDecorate\": () => (/* binding */ __esDecorate),\n/* harmony export */   \"__exportStar\": () => (/* binding */ __exportStar),\n/* harmony export */   \"__extends\": () => (/* binding */ __extends),\n/* harmony export */   \"__generator\": () => (/* binding */ __generator),\n/* harmony export */   \"__importDefault\": () => (/* binding */ __importDefault),\n/* harmony export */   \"__importStar\": () => (/* binding */ __importStar),\n/* harmony export */   \"__makeTemplateObject\": () => (/* binding */ __makeTemplateObject),\n/* harmony export */   \"__metadata\": () => (/* binding */ __metadata),\n/* harmony export */   \"__param\": () => (/* binding */ __param),\n/* harmony export */   \"__propKey\": () => (/* binding */ __propKey),\n/* harmony export */   \"__read\": () => (/* binding */ __read),\n/* harmony export */   \"__rest\": () => (/* binding */ __rest),\n/* harmony export */   \"__runInitializers\": () => (/* binding */ __runInitializers),\n/* harmony export */   \"__setFunctionName\": () => (/* binding */ __setFunctionName),\n/* harmony export */   \"__spread\": () => (/* binding */ __spread),\n/* harmony export */   \"__spreadArray\": () => (/* binding */ __spreadArray),\n/* harmony export */   \"__spreadArrays\": () => (/* binding */ __spreadArrays),\n/* harmony export */   \"__values\": () => (/* binding */ __values)\n/* harmony export */ });\n/******************************************************************************\r\nCopyright (c) Microsoft Corporation.\r\n\r\nPermission to use, copy, modify, and/or distribute this software for any\r\npurpose with or without fee is hereby granted.\r\n\r\nTHE SOFTWARE IS PROVIDED \"AS IS\" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH\r\nREGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY\r\nAND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,\r\nINDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM\r\nLOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR\r\nOTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR\r\nPERFORMANCE OF THIS SOFTWARE.\r\n***************************************************************************** */\r\n/* global Reflect, Promise */\r\n\r\nvar extendStatics = function(d, b) {\r\n    extendStatics = Object.setPrototypeOf ||\r\n        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||\r\n        function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };\r\n    return extendStatics(d, b);\r\n};\r\n\r\nfunction __extends(d, b) {\r\n    if (typeof b !== \"function\" && b !== null)\r\n        throw new TypeError(\"Class extends value \" + String(b) + \" is not a constructor or null\");\r\n    extendStatics(d, b);\r\n    function __() { this.constructor = d; }\r\n    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());\r\n}\r\n\r\nvar __assign = function() {\r\n    __assign = Object.assign || function __assign(t) {\r\n        for (var s, i = 1, n = arguments.length; i < n; i++) {\r\n            s = arguments[i];\r\n            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];\r\n        }\r\n        return t;\r\n    }\r\n    return __assign.apply(this, arguments);\r\n}\r\n\r\nfunction __rest(s, e) {\r\n    var t = {};\r\n    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)\r\n        t[p] = s[p];\r\n    if (s != null && typeof Object.getOwnPropertySymbols === \"function\")\r\n        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {\r\n            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))\r\n                t[p[i]] = s[p[i]];\r\n        }\r\n    return t;\r\n}\r\n\r\nfunction __decorate(decorators, target, key, desc) {\r\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\r\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\r\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\r\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\r\n}\r\n\r\nfunction __param(paramIndex, decorator) {\r\n    return function (target, key) { decorator(target, key, paramIndex); }\r\n}\r\n\r\nfunction __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {\r\n    function accept(f) { if (f !== void 0 && typeof f !== \"function\") throw new TypeError(\"Function expected\"); return f; }\r\n    var kind = contextIn.kind, key = kind === \"getter\" ? \"get\" : kind === \"setter\" ? \"set\" : \"value\";\r\n    var target = !descriptorIn && ctor ? contextIn[\"static\"] ? ctor : ctor.prototype : null;\r\n    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});\r\n    var _, done = false;\r\n    for (var i = decorators.length - 1; i >= 0; i--) {\r\n        var context = {};\r\n        for (var p in contextIn) context[p] = p === \"access\" ? {} : contextIn[p];\r\n        for (var p in contextIn.access) context.access[p] = contextIn.access[p];\r\n        context.addInitializer = function (f) { if (done) throw new TypeError(\"Cannot add initializers after decoration has completed\"); extraInitializers.push(accept(f || null)); };\r\n        var result = (0, decorators[i])(kind === \"accessor\" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);\r\n        if (kind === \"accessor\") {\r\n            if (result === void 0) continue;\r\n            if (result === null || typeof result !== \"object\") throw new TypeError(\"Object expected\");\r\n            if (_ = accept(result.get)) descriptor.get = _;\r\n            if (_ = accept(result.set)) descriptor.set = _;\r\n            if (_ = accept(result.init)) initializers.push(_);\r\n        }\r\n        else if (_ = accept(result)) {\r\n            if (kind === \"field\") initializers.push(_);\r\n            else descriptor[key] = _;\r\n        }\r\n    }\r\n    if (target) Object.defineProperty(target, contextIn.name, descriptor);\r\n    done = true;\r\n};\r\n\r\nfunction __runInitializers(thisArg, initializers, value) {\r\n    var useValue = arguments.length > 2;\r\n    for (var i = 0; i < initializers.length; i++) {\r\n        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);\r\n    }\r\n    return useValue ? value : void 0;\r\n};\r\n\r\nfunction __propKey(x) {\r\n    return typeof x === \"symbol\" ? x : \"\".concat(x);\r\n};\r\n\r\nfunction __setFunctionName(f, name, prefix) {\r\n    if (typeof name === \"symbol\") name = name.description ? \"[\".concat(name.description, \"]\") : \"\";\r\n    return Object.defineProperty(f, \"name\", { configurable: true, value: prefix ? \"\".concat(prefix, \" \", name) : name });\r\n};\r\n\r\nfunction __metadata(metadataKey, metadataValue) {\r\n    if (typeof Reflect === \"object\" && typeof Reflect.metadata === \"function\") return Reflect.metadata(metadataKey, metadataValue);\r\n}\r\n\r\nfunction __awaiter(thisArg, _arguments, P, generator) {\r\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\r\n    return new (P || (P = Promise))(function (resolve, reject) {\r\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\r\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\r\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\r\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\r\n    });\r\n}\r\n\r\nfunction __generator(thisArg, body) {\r\n    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;\r\n    return g = { next: verb(0), \"throw\": verb(1), \"return\": verb(2) }, typeof Symbol === \"function\" && (g[Symbol.iterator] = function() { return this; }), g;\r\n    function verb(n) { return function (v) { return step([n, v]); }; }\r\n    function step(op) {\r\n        if (f) throw new TypeError(\"Generator is already executing.\");\r\n        while (g && (g = 0, op[0] && (_ = 0)), _) try {\r\n            if (f = 1, y && (t = op[0] & 2 ? y[\"return\"] : op[0] ? y[\"throw\"] || ((t = y[\"return\"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;\r\n            if (y = 0, t) op = [op[0] & 2, t.value];\r\n            switch (op[0]) {\r\n                case 0: case 1: t = op; break;\r\n                case 4: _.label++; return { value: op[1], done: false };\r\n                case 5: _.label++; y = op[1]; op = [0]; continue;\r\n                case 7: op = _.ops.pop(); _.trys.pop(); continue;\r\n                default:\r\n                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }\r\n                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }\r\n                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }\r\n                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }\r\n                    if (t[2]) _.ops.pop();\r\n                    _.trys.pop(); continue;\r\n            }\r\n            op = body.call(thisArg, _);\r\n        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }\r\n        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };\r\n    }\r\n}\r\n\r\nvar __createBinding = Object.create ? (function(o, m, k, k2) {\r\n    if (k2 === undefined) k2 = k;\r\n    var desc = Object.getOwnPropertyDescriptor(m, k);\r\n    if (!desc || (\"get\" in desc ? !m.__esModule : desc.writable || desc.configurable)) {\r\n        desc = { enumerable: true, get: function() { return m[k]; } };\r\n    }\r\n    Object.defineProperty(o, k2, desc);\r\n}) : (function(o, m, k, k2) {\r\n    if (k2 === undefined) k2 = k;\r\n    o[k2] = m[k];\r\n});\r\n\r\nfunction __exportStar(m, o) {\r\n    for (var p in m) if (p !== \"default\" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);\r\n}\r\n\r\nfunction __values(o) {\r\n    var s = typeof Symbol === \"function\" && Symbol.iterator, m = s && o[s], i = 0;\r\n    if (m) return m.call(o);\r\n    if (o && typeof o.length === \"number\") return {\r\n        next: function () {\r\n            if (o && i >= o.length) o = void 0;\r\n            return { value: o && o[i++], done: !o };\r\n        }\r\n    };\r\n    throw new TypeError(s ? \"Object is not iterable.\" : \"Symbol.iterator is not defined.\");\r\n}\r\n\r\nfunction __read(o, n) {\r\n    var m = typeof Symbol === \"function\" && o[Symbol.iterator];\r\n    if (!m) return o;\r\n    var i = m.call(o), r, ar = [], e;\r\n    try {\r\n        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);\r\n    }\r\n    catch (error) { e = { error: error }; }\r\n    finally {\r\n        try {\r\n            if (r && !r.done && (m = i[\"return\"])) m.call(i);\r\n        }\r\n        finally { if (e) throw e.error; }\r\n    }\r\n    return ar;\r\n}\r\n\r\n/** @deprecated */\r\nfunction __spread() {\r\n    for (var ar = [], i = 0; i < arguments.length; i++)\r\n        ar = ar.concat(__read(arguments[i]));\r\n    return ar;\r\n}\r\n\r\n/** @deprecated */\r\nfunction __spreadArrays() {\r\n    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;\r\n    for (var r = Array(s), k = 0, i = 0; i < il; i++)\r\n        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)\r\n            r[k] = a[j];\r\n    return r;\r\n}\r\n\r\nfunction __spreadArray(to, from, pack) {\r\n    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {\r\n        if (ar || !(i in from)) {\r\n            if (!ar) ar = Array.prototype.slice.call(from, 0, i);\r\n            ar[i] = from[i];\r\n        }\r\n    }\r\n    return to.concat(ar || Array.prototype.slice.call(from));\r\n}\r\n\r\nfunction __await(v) {\r\n    return this instanceof __await ? (this.v = v, this) : new __await(v);\r\n}\r\n\r\nfunction __asyncGenerator(thisArg, _arguments, generator) {\r\n    if (!Symbol.asyncIterator) throw new TypeError(\"Symbol.asyncIterator is not defined.\");\r\n    var g = generator.apply(thisArg, _arguments || []), i, q = [];\r\n    return i = {}, verb(\"next\"), verb(\"throw\"), verb(\"return\"), i[Symbol.asyncIterator] = function () { return this; }, i;\r\n    function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }\r\n    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }\r\n    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }\r\n    function fulfill(value) { resume(\"next\", value); }\r\n    function reject(value) { resume(\"throw\", value); }\r\n    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }\r\n}\r\n\r\nfunction __asyncDelegator(o) {\r\n    var i, p;\r\n    return i = {}, verb(\"next\"), verb(\"throw\", function (e) { throw e; }), verb(\"return\"), i[Symbol.iterator] = function () { return this; }, i;\r\n    function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }\r\n}\r\n\r\nfunction __asyncValues(o) {\r\n    if (!Symbol.asyncIterator) throw new TypeError(\"Symbol.asyncIterator is not defined.\");\r\n    var m = o[Symbol.asyncIterator], i;\r\n    return m ? m.call(o) : (o = typeof __values === \"function\" ? __values(o) : o[Symbol.iterator](), i = {}, verb(\"next\"), verb(\"throw\"), verb(\"return\"), i[Symbol.asyncIterator] = function () { return this; }, i);\r\n    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }\r\n    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }\r\n}\r\n\r\nfunction __makeTemplateObject(cooked, raw) {\r\n    if (Object.defineProperty) { Object.defineProperty(cooked, \"raw\", { value: raw }); } else { cooked.raw = raw; }\r\n    return cooked;\r\n};\r\n\r\nvar __setModuleDefault = Object.create ? (function(o, v) {\r\n    Object.defineProperty(o, \"default\", { enumerable: true, value: v });\r\n}) : function(o, v) {\r\n    o[\"default\"] = v;\r\n};\r\n\r\nfunction __importStar(mod) {\r\n    if (mod && mod.__esModule) return mod;\r\n    var result = {};\r\n    if (mod != null) for (var k in mod) if (k !== \"default\" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);\r\n    __setModuleDefault(result, mod);\r\n    return result;\r\n}\r\n\r\nfunction __importDefault(mod) {\r\n    return (mod && mod.__esModule) ? mod : { default: mod };\r\n}\r\n\r\nfunction __classPrivateFieldGet(receiver, state, kind, f) {\r\n    if (kind === \"a\" && !f) throw new TypeError(\"Private accessor was defined without a getter\");\r\n    if (typeof state === \"function\" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError(\"Cannot read private member from an object whose class did not declare it\");\r\n    return kind === \"m\" ? f : kind === \"a\" ? f.call(receiver) : f ? f.value : state.get(receiver);\r\n}\r\n\r\nfunction __classPrivateFieldSet(receiver, state, value, kind, f) {\r\n    if (kind === \"m\") throw new TypeError(\"Private method is not writable\");\r\n    if (kind === \"a\" && !f) throw new TypeError(\"Private accessor was defined without a setter\");\r\n    if (typeof state === \"function\" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError(\"Cannot write private member to an object whose class did not declare it\");\r\n    return (kind === \"a\" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;\r\n}\r\n\r\nfunction __classPrivateFieldIn(state, receiver) {\r\n    if (receiver === null || (typeof receiver !== \"object\" && typeof receiver !== \"function\")) throw new TypeError(\"Cannot use 'in' operator on non-object\");\r\n    return typeof state === \"function\" ? receiver === state : state.has(receiver);\r\n}\r\n\n\n/***/ }),\n\n/***/ 154:\n/***/ ((__unused_webpack_module, exports, __webpack_require__) => {\n\n\"use strict\";\n\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.ZipFS = exports.LibzipError = exports.makeEmptyArchive = exports.DEFAULT_COMPRESSION_LEVEL = void 0;\nconst tslib_1 = __webpack_require__(240);\nconst fslib_1 = __webpack_require__(382);\nconst fslib_2 = __webpack_require__(382);\nconst fslib_3 = __webpack_require__(382);\nconst fslib_4 = __webpack_require__(382);\nconst fslib_5 = __webpack_require__(382);\nconst fslib_6 = __webpack_require__(382);\nconst fs_1 = __webpack_require__(147);\nconst stream_1 = __webpack_require__(955);\nconst util_1 = __webpack_require__(837);\nconst zlib_1 = tslib_1.__importDefault(__webpack_require__(796));\nconst instance_1 = __webpack_require__(309);\nexports.DEFAULT_COMPRESSION_LEVEL = `mixed`;\nfunction toUnixTimestamp(time) {\n    if (typeof time === `string` && String(+time) === time)\n        return +time;\n    if (typeof time === `number` && Number.isFinite(time)) {\n        if (time < 0) {\n            return Date.now() / 1000;\n        }\n        else {\n            return time;\n        }\n    }\n    // convert to 123.456 UNIX timestamp\n    if (util_1.types.isDate(time))\n        return time.getTime() / 1000;\n    throw new Error(`Invalid time`);\n}\nfunction makeEmptyArchive() {\n    return Buffer.from([\n        0x50, 0x4B, 0x05, 0x06,\n        0x00, 0x00, 0x00, 0x00,\n        0x00, 0x00, 0x00, 0x00,\n        0x00, 0x00, 0x00, 0x00,\n        0x00, 0x00, 0x00, 0x00,\n        0x00, 0x00,\n    ]);\n}\nexports.makeEmptyArchive = makeEmptyArchive;\nclass LibzipError extends Error {\n    constructor(message, code) {\n        super(message);\n        this.name = `Libzip Error`;\n        this.code = code;\n    }\n}\nexports.LibzipError = LibzipError;\nclass ZipFS extends fslib_1.BasePortableFakeFS {\n    constructor(source, opts = {}) {\n        super();\n        this.listings = new Map();\n        this.entries = new Map();\n        /**\n         * A cache of indices mapped to file sources.\n         * Populated by `setFileSource` calls.\n         * Required for supporting read after write.\n         */\n        this.fileSources = new Map();\n        this.fds = new Map();\n        this.nextFd = 0;\n        this.ready = false;\n        this.readOnly = false;\n        const pathOptions = opts;\n        this.level = typeof pathOptions.level !== `undefined`\n            ? pathOptions.level\n            : exports.DEFAULT_COMPRESSION_LEVEL;\n        source !== null && source !== void 0 ? source : (source = makeEmptyArchive());\n        if (typeof source === `string`) {\n            const { baseFs = new fslib_2.NodeFS() } = pathOptions;\n            this.baseFs = baseFs;\n            this.path = source;\n        }\n        else {\n            this.path = null;\n            this.baseFs = null;\n        }\n        if (opts.stats) {\n            this.stats = opts.stats;\n        }\n        else {\n            if (typeof source === `string`) {\n                try {\n                    this.stats = this.baseFs.statSync(source);\n                }\n                catch (error) {\n                    if (error.code === `ENOENT` && pathOptions.create) {\n                        this.stats = fslib_5.statUtils.makeDefaultStats();\n                    }\n                    else {\n                        throw error;\n                    }\n                }\n            }\n            else {\n                this.stats = fslib_5.statUtils.makeDefaultStats();\n            }\n        }\n        this.libzip = (0, instance_1.getInstance)();\n        const errPtr = this.libzip.malloc(4);\n        try {\n            let flags = 0;\n            if (opts.readOnly) {\n                flags |= this.libzip.ZIP_RDONLY;\n                this.readOnly = true;\n            }\n            if (typeof source === `string`)\n                source = pathOptions.create\n                    ? makeEmptyArchive()\n                    : this.baseFs.readFileSync(source);\n            const lzSource = this.allocateUnattachedSource(source);\n            try {\n                this.zip = this.libzip.openFromSource(lzSource, flags, errPtr);\n                this.lzSource = lzSource;\n            }\n            catch (error) {\n                this.libzip.source.free(lzSource);\n                throw error;\n            }\n            if (this.zip === 0) {\n                const error = this.libzip.struct.errorS();\n                this.libzip.error.initWithCode(error, this.libzip.getValue(errPtr, `i32`));\n                throw this.makeLibzipError(error);\n            }\n        }\n        finally {\n            this.libzip.free(errPtr);\n        }\n        this.listings.set(fslib_6.PortablePath.root, new Set());\n        const entryCount = this.libzip.getNumEntries(this.zip, 0);\n        for (let t = 0; t < entryCount; ++t) {\n            const raw = this.libzip.getName(this.zip, t, 0);\n            if (fslib_6.ppath.isAbsolute(raw))\n                continue;\n            const p = fslib_6.ppath.resolve(fslib_6.PortablePath.root, raw);\n            this.registerEntry(p, t);\n            // If the raw path is a directory, register it\n            // to prevent empty folder being skipped\n            if (raw.endsWith(`/`)) {\n                this.registerListing(p);\n            }\n        }\n        this.symlinkCount = this.libzip.ext.countSymlinks(this.zip);\n        if (this.symlinkCount === -1)\n            throw this.makeLibzipError(this.libzip.getError(this.zip));\n        this.ready = true;\n    }\n    makeLibzipError(error) {\n        const errorCode = this.libzip.struct.errorCodeZip(error);\n        const strerror = this.libzip.error.strerror(error);\n        const libzipError = new LibzipError(strerror, this.libzip.errors[errorCode]);\n        // This error should never come up because of the file source cache\n        if (errorCode === this.libzip.errors.ZIP_ER_CHANGED)\n            throw new Error(`Assertion failed: Unexpected libzip error: ${libzipError.message}`);\n        return libzipError;\n    }\n    getExtractHint(hints) {\n        for (const fileName of this.entries.keys()) {\n            const ext = this.pathUtils.extname(fileName);\n            if (hints.relevantExtensions.has(ext)) {\n                return true;\n            }\n        }\n        return false;\n    }\n    getAllFiles() {\n        return Array.from(this.entries.keys());\n    }\n    getRealPath() {\n        if (!this.path)\n            throw new Error(`ZipFS don't have real paths when loaded from a buffer`);\n        return this.path;\n    }\n    prepareClose() {\n        if (!this.ready)\n            throw fslib_5.errors.EBUSY(`archive closed, close`);\n        (0, fslib_4.unwatchAllFiles)(this);\n    }\n    getBufferAndClose() {\n        this.prepareClose();\n        // zip_source_open on an unlink-after-write empty archive fails with \"Entry has been deleted\"\n        if (this.entries.size === 0) {\n            this.discardAndClose();\n            return makeEmptyArchive();\n        }\n        try {\n            // Prevent close from cleaning up the source\n            this.libzip.source.keep(this.lzSource);\n            // Close the zip archive\n            if (this.libzip.close(this.zip) === -1)\n                throw this.makeLibzipError(this.libzip.getError(this.zip));\n            // Open the source for reading\n            if (this.libzip.source.open(this.lzSource) === -1)\n                throw this.makeLibzipError(this.libzip.source.error(this.lzSource));\n            // Move to the end of source\n            if (this.libzip.source.seek(this.lzSource, 0, 0, this.libzip.SEEK_END) === -1)\n                throw this.makeLibzipError(this.libzip.source.error(this.lzSource));\n            // Get the size of source\n            const size = this.libzip.source.tell(this.lzSource);\n            if (size === -1)\n                throw this.makeLibzipError(this.libzip.source.error(this.lzSource));\n            // Move to the start of source\n            if (this.libzip.source.seek(this.lzSource, 0, 0, this.libzip.SEEK_SET) === -1)\n                throw this.makeLibzipError(this.libzip.source.error(this.lzSource));\n            const buffer = this.libzip.malloc(size);\n            if (!buffer)\n                throw new Error(`Couldn't allocate enough memory`);\n            try {\n                const rc = this.libzip.source.read(this.lzSource, buffer, size);\n                if (rc === -1)\n                    throw this.makeLibzipError(this.libzip.source.error(this.lzSource));\n                else if (rc < size)\n                    throw new Error(`Incomplete read`);\n                else if (rc > size)\n                    throw new Error(`Overread`);\n                const memory = this.libzip.HEAPU8.subarray(buffer, buffer + size);\n                return Buffer.from(memory);\n            }\n            finally {\n                this.libzip.free(buffer);\n            }\n        }\n        finally {\n            this.libzip.source.close(this.lzSource);\n            this.libzip.source.free(this.lzSource);\n            this.ready = false;\n        }\n    }\n    discardAndClose() {\n        this.prepareClose();\n        this.libzip.discard(this.zip);\n        this.ready = false;\n    }\n    saveAndClose() {\n        if (!this.path || !this.baseFs)\n            throw new Error(`ZipFS cannot be saved and must be discarded when loaded from a buffer`);\n        if (this.readOnly) {\n            this.discardAndClose();\n            return;\n        }\n        const newMode = this.baseFs.existsSync(this.path) || this.stats.mode === fslib_5.statUtils.DEFAULT_MODE\n            ? undefined\n            : this.stats.mode;\n        this.baseFs.writeFileSync(this.path, this.getBufferAndClose(), { mode: newMode });\n        this.ready = false;\n    }\n    resolve(p) {\n        return fslib_6.ppath.resolve(fslib_6.PortablePath.root, p);\n    }\n    async openPromise(p, flags, mode) {\n        return this.openSync(p, flags, mode);\n    }\n    openSync(p, flags, mode) {\n        const fd = this.nextFd++;\n        this.fds.set(fd, { cursor: 0, p });\n        return fd;\n    }\n    hasOpenFileHandles() {\n        return !!this.fds.size;\n    }\n    async opendirPromise(p, opts) {\n        return this.opendirSync(p, opts);\n    }\n    opendirSync(p, opts = {}) {\n        const resolvedP = this.resolveFilename(`opendir '${p}'`, p);\n        if (!this.entries.has(resolvedP) && !this.listings.has(resolvedP))\n            throw fslib_5.errors.ENOENT(`opendir '${p}'`);\n        const directoryListing = this.listings.get(resolvedP);\n        if (!directoryListing)\n            throw fslib_5.errors.ENOTDIR(`opendir '${p}'`);\n        const entries = [...directoryListing];\n        const fd = this.openSync(resolvedP, `r`);\n        const onClose = () => {\n            this.closeSync(fd);\n        };\n        return (0, fslib_3.opendir)(this, resolvedP, entries, { onClose });\n    }\n    async readPromise(fd, buffer, offset, length, position) {\n        return this.readSync(fd, buffer, offset, length, position);\n    }\n    readSync(fd, buffer, offset = 0, length = buffer.byteLength, position = -1) {\n        const entry = this.fds.get(fd);\n        if (typeof entry === `undefined`)\n            throw fslib_5.errors.EBADF(`read`);\n        const realPosition = position === -1 || position === null\n            ? entry.cursor\n            : position;\n        const source = this.readFileSync(entry.p);\n        source.copy(buffer, offset, realPosition, realPosition + length);\n        const bytesRead = Math.max(0, Math.min(source.length - realPosition, length));\n        if (position === -1 || position === null)\n            entry.cursor += bytesRead;\n        return bytesRead;\n    }\n    async writePromise(fd, buffer, offset, length, position) {\n        if (typeof buffer === `string`) {\n            return this.writeSync(fd, buffer, position);\n        }\n        else {\n            return this.writeSync(fd, buffer, offset, length, position);\n        }\n    }\n    writeSync(fd, buffer, offset, length, position) {\n        const entry = this.fds.get(fd);\n        if (typeof entry === `undefined`)\n            throw fslib_5.errors.EBADF(`read`);\n        throw new Error(`Unimplemented`);\n    }\n    async closePromise(fd) {\n        return this.closeSync(fd);\n    }\n    closeSync(fd) {\n        const entry = this.fds.get(fd);\n        if (typeof entry === `undefined`)\n            throw fslib_5.errors.EBADF(`read`);\n        this.fds.delete(fd);\n    }\n    createReadStream(p, { encoding } = {}) {\n        if (p === null)\n            throw new Error(`Unimplemented`);\n        const fd = this.openSync(p, `r`);\n        const stream = Object.assign(new stream_1.PassThrough({\n            emitClose: true,\n            autoDestroy: true,\n            destroy: (error, callback) => {\n                clearImmediate(immediate);\n                this.closeSync(fd);\n                callback(error);\n            },\n        }), {\n            close() {\n                stream.destroy();\n            },\n            bytesRead: 0,\n            path: p,\n            // \"This property is `true` if the underlying file has not been opened yet\"\n            pending: false,\n        });\n        const immediate = setImmediate(async () => {\n            try {\n                const data = await this.readFilePromise(p, encoding);\n                stream.bytesRead = data.length;\n                stream.end(data);\n            }\n            catch (error) {\n                stream.destroy(error);\n            }\n        });\n        return stream;\n    }\n    createWriteStream(p, { encoding } = {}) {\n        if (this.readOnly)\n            throw fslib_5.errors.EROFS(`open '${p}'`);\n        if (p === null)\n            throw new Error(`Unimplemented`);\n        const chunks = [];\n        const fd = this.openSync(p, `w`);\n        const stream = Object.assign(new stream_1.PassThrough({\n            autoDestroy: true,\n            emitClose: true,\n            destroy: (error, callback) => {\n                try {\n                    if (error) {\n                        callback(error);\n                    }\n                    else {\n                        this.writeFileSync(p, Buffer.concat(chunks), encoding);\n                        callback(null);\n                    }\n                }\n                catch (err) {\n                    callback(err);\n                }\n                finally {\n                    this.closeSync(fd);\n                }\n            },\n        }), {\n            close() {\n                stream.destroy();\n            },\n            bytesWritten: 0,\n            path: p,\n            // \"This property is `true` if the underlying file has not been opened yet\"\n            pending: false,\n        });\n        stream.on(`data`, chunk => {\n            const chunkBuffer = Buffer.from(chunk);\n            stream.bytesWritten += chunkBuffer.length;\n            chunks.push(chunkBuffer);\n        });\n        return stream;\n    }\n    async realpathPromise(p) {\n        return this.realpathSync(p);\n    }\n    realpathSync(p) {\n        const resolvedP = this.resolveFilename(`lstat '${p}'`, p);\n        if (!this.entries.has(resolvedP) && !this.listings.has(resolvedP))\n            throw fslib_5.errors.ENOENT(`lstat '${p}'`);\n        return resolvedP;\n    }\n    async existsPromise(p) {\n        return this.existsSync(p);\n    }\n    existsSync(p) {\n        if (!this.ready)\n            throw fslib_5.errors.EBUSY(`archive closed, existsSync '${p}'`);\n        if (this.symlinkCount === 0) {\n            const resolvedP = fslib_6.ppath.resolve(fslib_6.PortablePath.root, p);\n            return this.entries.has(resolvedP) || this.listings.has(resolvedP);\n        }\n        let resolvedP;\n        try {\n            resolvedP = this.resolveFilename(`stat '${p}'`, p, undefined, false);\n        }\n        catch (error) {\n            return false;\n        }\n        if (resolvedP === undefined)\n            return false;\n        return this.entries.has(resolvedP) || this.listings.has(resolvedP);\n    }\n    async accessPromise(p, mode) {\n        return this.accessSync(p, mode);\n    }\n    accessSync(p, mode = fs_1.constants.F_OK) {\n        const resolvedP = this.resolveFilename(`access '${p}'`, p);\n        if (!this.entries.has(resolvedP) && !this.listings.has(resolvedP))\n            throw fslib_5.errors.ENOENT(`access '${p}'`);\n        if (this.readOnly && (mode & fs_1.constants.W_OK)) {\n            throw fslib_5.errors.EROFS(`access '${p}'`);\n        }\n    }\n    async statPromise(p, opts = { bigint: false }) {\n        if (opts.bigint)\n            return this.statSync(p, { bigint: true });\n        return this.statSync(p);\n    }\n    statSync(p, opts = { bigint: false, throwIfNoEntry: true }) {\n        const resolvedP = this.resolveFilename(`stat '${p}'`, p, undefined, opts.throwIfNoEntry);\n        if (resolvedP === undefined)\n            return undefined;\n        if (!this.entries.has(resolvedP) && !this.listings.has(resolvedP)) {\n            if (opts.throwIfNoEntry === false)\n                return undefined;\n            throw fslib_5.errors.ENOENT(`stat '${p}'`);\n        }\n        if (p[p.length - 1] === `/` && !this.listings.has(resolvedP))\n            throw fslib_5.errors.ENOTDIR(`stat '${p}'`);\n        return this.statImpl(`stat '${p}'`, resolvedP, opts);\n    }\n    async fstatPromise(fd, opts) {\n        return this.fstatSync(fd, opts);\n    }\n    fstatSync(fd, opts) {\n        const entry = this.fds.get(fd);\n        if (typeof entry === `undefined`)\n            throw fslib_5.errors.EBADF(`fstatSync`);\n        const { p } = entry;\n        const resolvedP = this.resolveFilename(`stat '${p}'`, p);\n        if (!this.entries.has(resolvedP) && !this.listings.has(resolvedP))\n            throw fslib_5.errors.ENOENT(`stat '${p}'`);\n        if (p[p.length - 1] === `/` && !this.listings.has(resolvedP))\n            throw fslib_5.errors.ENOTDIR(`stat '${p}'`);\n        return this.statImpl(`fstat '${p}'`, resolvedP, opts);\n    }\n    async lstatPromise(p, opts = { bigint: false }) {\n        if (opts.bigint)\n            return this.lstatSync(p, { bigint: true });\n        return this.lstatSync(p);\n    }\n    lstatSync(p, opts = { bigint: false, throwIfNoEntry: true }) {\n        const resolvedP = this.resolveFilename(`lstat '${p}'`, p, false, opts.throwIfNoEntry);\n        if (resolvedP === undefined)\n            return undefined;\n        if (!this.entries.has(resolvedP) && !this.listings.has(resolvedP)) {\n            if (opts.throwIfNoEntry === false)\n                return undefined;\n            throw fslib_5.errors.ENOENT(`lstat '${p}'`);\n        }\n        if (p[p.length - 1] === `/` && !this.listings.has(resolvedP))\n            throw fslib_5.errors.ENOTDIR(`lstat '${p}'`);\n        return this.statImpl(`lstat '${p}'`, resolvedP, opts);\n    }\n    statImpl(reason, p, opts = {}) {\n        const entry = this.entries.get(p);\n        // File, or explicit directory\n        if (typeof entry !== `undefined`) {\n            const stat = this.libzip.struct.statS();\n            const rc = this.libzip.statIndex(this.zip, entry, 0, 0, stat);\n            if (rc === -1)\n                throw this.makeLibzipError(this.libzip.getError(this.zip));\n            const uid = this.stats.uid;\n            const gid = this.stats.gid;\n            const size = (this.libzip.struct.statSize(stat) >>> 0);\n            const blksize = 512;\n            const blocks = Math.ceil(size / blksize);\n            const mtimeMs = (this.libzip.struct.statMtime(stat) >>> 0) * 1000;\n            const atimeMs = mtimeMs;\n            const birthtimeMs = mtimeMs;\n            const ctimeMs = mtimeMs;\n            const atime = new Date(atimeMs);\n            const birthtime = new Date(birthtimeMs);\n            const ctime = new Date(ctimeMs);\n            const mtime = new Date(mtimeMs);\n            const type = this.listings.has(p)\n                ? fs_1.constants.S_IFDIR\n                : this.isSymbolicLink(entry)\n                    ? fs_1.constants.S_IFLNK\n                    : fs_1.constants.S_IFREG;\n            const defaultMode = type === fs_1.constants.S_IFDIR\n                ? 0o755\n                : 0o644;\n            const mode = type | (this.getUnixMode(entry, defaultMode) & 0o777);\n            const crc = this.libzip.struct.statCrc(stat);\n            const statInstance = Object.assign(new fslib_5.statUtils.StatEntry(), { uid, gid, size, blksize, blocks, atime, birthtime, ctime, mtime, atimeMs, birthtimeMs, ctimeMs, mtimeMs, mode, crc });\n            return opts.bigint === true ? fslib_5.statUtils.convertToBigIntStats(statInstance) : statInstance;\n        }\n        // Implicit directory\n        if (this.listings.has(p)) {\n            const uid = this.stats.uid;\n            const gid = this.stats.gid;\n            const size = 0;\n            const blksize = 512;\n            const blocks = 0;\n            const atimeMs = this.stats.mtimeMs;\n            const birthtimeMs = this.stats.mtimeMs;\n            const ctimeMs = this.stats.mtimeMs;\n            const mtimeMs = this.stats.mtimeMs;\n            const atime = new Date(atimeMs);\n            const birthtime = new Date(birthtimeMs);\n            const ctime = new Date(ctimeMs);\n            const mtime = new Date(mtimeMs);\n            const mode = fs_1.constants.S_IFDIR | 0o755;\n            const crc = 0;\n            const statInstance = Object.assign(new fslib_5.statUtils.StatEntry(), { uid, gid, size, blksize, blocks, atime, birthtime, ctime, mtime, atimeMs, birthtimeMs, ctimeMs, mtimeMs, mode, crc });\n            return opts.bigint === true ? fslib_5.statUtils.convertToBigIntStats(statInstance) : statInstance;\n        }\n        throw new Error(`Unreachable`);\n    }\n    getUnixMode(index, defaultMode) {\n        const rc = this.libzip.file.getExternalAttributes(this.zip, index, 0, 0, this.libzip.uint08S, this.libzip.uint32S);\n        if (rc === -1)\n            throw this.makeLibzipError(this.libzip.getError(this.zip));\n        const opsys = this.libzip.getValue(this.libzip.uint08S, `i8`) >>> 0;\n        if (opsys !== this.libzip.ZIP_OPSYS_UNIX)\n            return defaultMode;\n        return this.libzip.getValue(this.libzip.uint32S, `i32`) >>> 16;\n    }\n    registerListing(p) {\n        const existingListing = this.listings.get(p);\n        if (existingListing)\n            return existingListing;\n        const parentListing = this.registerListing(fslib_6.ppath.dirname(p));\n        parentListing.add(fslib_6.ppath.basename(p));\n        const newListing = new Set();\n        this.listings.set(p, newListing);\n        return newListing;\n    }\n    registerEntry(p, index) {\n        const parentListing = this.registerListing(fslib_6.ppath.dirname(p));\n        parentListing.add(fslib_6.ppath.basename(p));\n        this.entries.set(p, index);\n    }\n    unregisterListing(p) {\n        this.listings.delete(p);\n        const parentListing = this.listings.get(fslib_6.ppath.dirname(p));\n        parentListing === null || parentListing === void 0 ? void 0 : parentListing.delete(fslib_6.ppath.basename(p));\n    }\n    unregisterEntry(p) {\n        this.unregisterListing(p);\n        const entry = this.entries.get(p);\n        this.entries.delete(p);\n        if (typeof entry === `undefined`)\n            return;\n        this.fileSources.delete(entry);\n        if (this.isSymbolicLink(entry)) {\n            this.symlinkCount--;\n        }\n    }\n    deleteEntry(p, index) {\n        this.unregisterEntry(p);\n        const rc = this.libzip.delete(this.zip, index);\n        if (rc === -1) {\n            throw this.makeLibzipError(this.libzip.getError(this.zip));\n        }\n    }\n    resolveFilename(reason, p, resolveLastComponent = true, throwIfNoEntry = true) {\n        if (!this.ready)\n            throw fslib_5.errors.EBUSY(`archive closed, ${reason}`);\n        let resolvedP = fslib_6.ppath.resolve(fslib_6.PortablePath.root, p);\n        if (resolvedP === `/`)\n            return fslib_6.PortablePath.root;\n        const fileIndex = this.entries.get(resolvedP);\n        if (resolveLastComponent && fileIndex !== undefined) {\n            if (this.symlinkCount !== 0 && this.isSymbolicLink(fileIndex)) {\n                const target = this.getFileSource(fileIndex).toString();\n                return this.resolveFilename(reason, fslib_6.ppath.resolve(fslib_6.ppath.dirname(resolvedP), target), true, throwIfNoEntry);\n            }\n            else {\n                return resolvedP;\n            }\n        }\n        while (true) {\n            const parentP = this.resolveFilename(reason, fslib_6.ppath.dirname(resolvedP), true, throwIfNoEntry);\n            if (parentP === undefined)\n                return parentP;\n            const isDir = this.listings.has(parentP);\n            const doesExist = this.entries.has(parentP);\n            if (!isDir && !doesExist) {\n                if (throwIfNoEntry === false)\n                    return undefined;\n                throw fslib_5.errors.ENOENT(reason);\n            }\n            if (!isDir)\n                throw fslib_5.errors.ENOTDIR(reason);\n            resolvedP = fslib_6.ppath.resolve(parentP, fslib_6.ppath.basename(resolvedP));\n            if (!resolveLastComponent || this.symlinkCount === 0)\n                break;\n            const index = this.libzip.name.locate(this.zip, resolvedP.slice(1), 0);\n            if (index === -1)\n                break;\n            if (this.isSymbolicLink(index)) {\n                const target = this.getFileSource(index).toString();\n                resolvedP = fslib_6.ppath.resolve(fslib_6.ppath.dirname(resolvedP), target);\n            }\n            else {\n                break;\n            }\n        }\n        return resolvedP;\n    }\n    allocateBuffer(content) {\n        if (!Buffer.isBuffer(content))\n            content = Buffer.from(content);\n        const buffer = this.libzip.malloc(content.byteLength);\n        if (!buffer)\n            throw new Error(`Couldn't allocate enough memory`);\n        // Copy the file into the Emscripten heap\n        const heap = new Uint8Array(this.libzip.HEAPU8.buffer, buffer, content.byteLength);\n        heap.set(content);\n        return { buffer, byteLength: content.byteLength };\n    }\n    allocateUnattachedSource(content) {\n        const error = this.libzip.struct.errorS();\n        const { buffer, byteLength } = this.allocateBuffer(content);\n        const source = this.libzip.source.fromUnattachedBuffer(buffer, byteLength, 0, 1, error);\n        if (source === 0) {\n            this.libzip.free(error);\n            throw this.makeLibzipError(error);\n        }\n        return source;\n    }\n    allocateSource(content) {\n        const { buffer, byteLength } = this.allocateBuffer(content);\n        const source = this.libzip.source.fromBuffer(this.zip, buffer, byteLength, 0, 1);\n        if (source === 0) {\n            this.libzip.free(buffer);\n            throw this.makeLibzipError(this.libzip.getError(this.zip));\n        }\n        return source;\n    }\n    setFileSource(p, content) {\n        const buffer = Buffer.isBuffer(content) ? content : Buffer.from(content);\n        const target = fslib_6.ppath.relative(fslib_6.PortablePath.root, p);\n        const lzSource = this.allocateSource(content);\n        try {\n            const newIndex = this.libzip.file.add(this.zip, target, lzSource, this.libzip.ZIP_FL_OVERWRITE);\n            if (newIndex === -1)\n                throw this.makeLibzipError(this.libzip.getError(this.zip));\n            if (this.level !== `mixed`) {\n                // Use store for level 0, and deflate for 1..9\n                const method = this.level === 0\n                    ? this.libzip.ZIP_CM_STORE\n                    : this.libzip.ZIP_CM_DEFLATE;\n                const rc = this.libzip.file.setCompression(this.zip, newIndex, 0, method, this.level);\n                if (rc === -1) {\n                    throw this.makeLibzipError(this.libzip.getError(this.zip));\n                }\n            }\n            this.fileSources.set(newIndex, buffer);\n            return newIndex;\n        }\n        catch (error) {\n            this.libzip.source.free(lzSource);\n            throw error;\n        }\n    }\n    isSymbolicLink(index) {\n        if (this.symlinkCount === 0)\n            return false;\n        const attrs = this.libzip.file.getExternalAttributes(this.zip, index, 0, 0, this.libzip.uint08S, this.libzip.uint32S);\n        if (attrs === -1)\n            throw this.makeLibzipError(this.libzip.getError(this.zip));\n        const opsys = this.libzip.getValue(this.libzip.uint08S, `i8`) >>> 0;\n        if (opsys !== this.libzip.ZIP_OPSYS_UNIX)\n            return false;\n        const attributes = this.libzip.getValue(this.libzip.uint32S, `i32`) >>> 16;\n        return (attributes & fs_1.constants.S_IFMT) === fs_1.constants.S_IFLNK;\n    }\n    getFileSource(index, opts = { asyncDecompress: false }) {\n        const cachedFileSource = this.fileSources.get(index);\n        if (typeof cachedFileSource !== `undefined`)\n            return cachedFileSource;\n        const stat = this.libzip.struct.statS();\n        const rc = this.libzip.statIndex(this.zip, index, 0, 0, stat);\n        if (rc === -1)\n            throw this.makeLibzipError(this.libzip.getError(this.zip));\n        const size = this.libzip.struct.statCompSize(stat);\n        const compressionMethod = this.libzip.struct.statCompMethod(stat);\n        const buffer = this.libzip.malloc(size);\n        try {\n            const file = this.libzip.fopenIndex(this.zip, index, 0, this.libzip.ZIP_FL_COMPRESSED);\n            if (file === 0)\n                throw this.makeLibzipError(this.libzip.getError(this.zip));\n            try {\n                const rc = this.libzip.fread(file, buffer, size, 0);\n                if (rc === -1)\n                    throw this.makeLibzipError(this.libzip.file.getError(file));\n                else if (rc < size)\n                    throw new Error(`Incomplete read`);\n                else if (rc > size)\n                    throw new Error(`Overread`);\n                const memory = this.libzip.HEAPU8.subarray(buffer, buffer + size);\n                const data = Buffer.from(memory);\n                if (compressionMethod === 0) {\n                    this.fileSources.set(index, data);\n                    return data;\n                }\n                else if (opts.asyncDecompress) {\n                    return new Promise((resolve, reject) => {\n                        zlib_1.default.inflateRaw(data, (error, result) => {\n                            if (error) {\n                                reject(error);\n                            }\n                            else {\n                                this.fileSources.set(index, result);\n                                resolve(result);\n                            }\n                        });\n                    });\n                }\n                else {\n                    const decompressedData = zlib_1.default.inflateRawSync(data);\n                    this.fileSources.set(index, decompressedData);\n                    return decompressedData;\n                }\n            }\n            finally {\n                this.libzip.fclose(file);\n            }\n        }\n        finally {\n            this.libzip.free(buffer);\n        }\n    }\n    async fchmodPromise(fd, mask) {\n        return this.chmodPromise(this.fdToPath(fd, `fchmod`), mask);\n    }\n    fchmodSync(fd, mask) {\n        return this.chmodSync(this.fdToPath(fd, `fchmodSync`), mask);\n    }\n    async chmodPromise(p, mask) {\n        return this.chmodSync(p, mask);\n    }\n    chmodSync(p, mask) {\n        if (this.readOnly)\n            throw fslib_5.errors.EROFS(`chmod '${p}'`);\n        // We don't allow to make the extracted entries group-writable\n        mask &= 0o755;\n        const resolvedP = this.resolveFilename(`chmod '${p}'`, p, false);\n        const entry = this.entries.get(resolvedP);\n        if (typeof entry === `undefined`)\n            throw new Error(`Assertion failed: The entry should have been registered (${resolvedP})`);\n        const oldMod = this.getUnixMode(entry, fs_1.constants.S_IFREG | 0o000);\n        const newMod = oldMod & (~0o777) | mask;\n        const rc = this.libzip.file.setExternalAttributes(this.zip, entry, 0, 0, this.libzip.ZIP_OPSYS_UNIX, newMod << 16);\n        if (rc === -1) {\n            throw this.makeLibzipError(this.libzip.getError(this.zip));\n        }\n    }\n    async fchownPromise(fd, uid, gid) {\n        return this.chownPromise(this.fdToPath(fd, `fchown`), uid, gid);\n    }\n    fchownSync(fd, uid, gid) {\n        return this.chownSync(this.fdToPath(fd, `fchownSync`), uid, gid);\n    }\n    async chownPromise(p, uid, gid) {\n        return this.chownSync(p, uid, gid);\n    }\n    chownSync(p, uid, gid) {\n        throw new Error(`Unimplemented`);\n    }\n    async renamePromise(oldP, newP) {\n        return this.renameSync(oldP, newP);\n    }\n    renameSync(oldP, newP) {\n        throw new Error(`Unimplemented`);\n    }\n    async copyFilePromise(sourceP, destP, flags) {\n        const { indexSource, indexDest, resolvedDestP } = this.prepareCopyFile(sourceP, destP, flags);\n        const source = await this.getFileSource(indexSource, { asyncDecompress: true });\n        const newIndex = this.setFileSource(resolvedDestP, source);\n        if (newIndex !== indexDest) {\n            this.registerEntry(resolvedDestP, newIndex);\n        }\n    }\n    copyFileSync(sourceP, destP, flags = 0) {\n        const { indexSource, indexDest, resolvedDestP } = this.prepareCopyFile(sourceP, destP, flags);\n        const source = this.getFileSource(indexSource);\n        const newIndex = this.setFileSource(resolvedDestP, source);\n        if (newIndex !== indexDest) {\n            this.registerEntry(resolvedDestP, newIndex);\n        }\n    }\n    prepareCopyFile(sourceP, destP, flags = 0) {\n        if (this.readOnly)\n            throw fslib_5.errors.EROFS(`copyfile '${sourceP} -> '${destP}'`);\n        if ((flags & fs_1.constants.COPYFILE_FICLONE_FORCE) !== 0)\n            throw fslib_5.errors.ENOSYS(`unsupported clone operation`, `copyfile '${sourceP}' -> ${destP}'`);\n        const resolvedSourceP = this.resolveFilename(`copyfile '${sourceP} -> ${destP}'`, sourceP);\n        const indexSource = this.entries.get(resolvedSourceP);\n        if (typeof indexSource === `undefined`)\n            throw fslib_5.errors.EINVAL(`copyfile '${sourceP}' -> '${destP}'`);\n        const resolvedDestP = this.resolveFilename(`copyfile '${sourceP}' -> ${destP}'`, destP);\n        const indexDest = this.entries.get(resolvedDestP);\n        if ((flags & (fs_1.constants.COPYFILE_EXCL | fs_1.constants.COPYFILE_FICLONE_FORCE)) !== 0 && typeof indexDest !== `undefined`)\n            throw fslib_5.errors.EEXIST(`copyfile '${sourceP}' -> '${destP}'`);\n        return {\n            indexSource,\n            resolvedDestP,\n            indexDest,\n        };\n    }\n    async appendFilePromise(p, content, opts) {\n        if (this.readOnly)\n            throw fslib_5.errors.EROFS(`open '${p}'`);\n        if (typeof opts === `undefined`)\n            opts = { flag: `a` };\n        else if (typeof opts === `string`)\n            opts = { flag: `a`, encoding: opts };\n        else if (typeof opts.flag === `undefined`)\n            opts = { flag: `a`, ...opts };\n        return this.writeFilePromise(p, content, opts);\n    }\n    appendFileSync(p, content, opts = {}) {\n        if (this.readOnly)\n            throw fslib_5.errors.EROFS(`open '${p}'`);\n        if (typeof opts === `undefined`)\n            opts = { flag: `a` };\n        else if (typeof opts === `string`)\n            opts = { flag: `a`, encoding: opts };\n        else if (typeof opts.flag === `undefined`)\n            opts = { flag: `a`, ...opts };\n        return this.writeFileSync(p, content, opts);\n    }\n    fdToPath(fd, reason) {\n        var _a;\n        const path = (_a = this.fds.get(fd)) === null || _a === void 0 ? void 0 : _a.p;\n        if (typeof path === `undefined`)\n            throw fslib_5.errors.EBADF(reason);\n        return path;\n    }\n    async writeFilePromise(p, content, opts) {\n        const { encoding, mode, index, resolvedP } = this.prepareWriteFile(p, opts);\n        if (index !== undefined && typeof opts === `object` && opts.flag && opts.flag.includes(`a`))\n            content = Buffer.concat([await this.getFileSource(index, { asyncDecompress: true }), Buffer.from(content)]);\n        if (encoding !== null)\n            // @ts-expect-error: toString ignores unneeded arguments\n            content = content.toString(encoding);\n        const newIndex = this.setFileSource(resolvedP, content);\n        if (newIndex !== index)\n            this.registerEntry(resolvedP, newIndex);\n        if (mode !== null) {\n            await this.chmodPromise(resolvedP, mode);\n        }\n    }\n    writeFileSync(p, content, opts) {\n        const { encoding, mode, index, resolvedP } = this.prepareWriteFile(p, opts);\n        if (index !== undefined && typeof opts === `object` && opts.flag && opts.flag.includes(`a`))\n            content = Buffer.concat([this.getFileSource(index), Buffer.from(content)]);\n        if (encoding !== null)\n            // @ts-expect-error: toString ignores unneeded arguments\n            content = content.toString(encoding);\n        const newIndex = this.setFileSource(resolvedP, content);\n        if (newIndex !== index)\n            this.registerEntry(resolvedP, newIndex);\n        if (mode !== null) {\n            this.chmodSync(resolvedP, mode);\n        }\n    }\n    prepareWriteFile(p, opts) {\n        if (typeof p === `number`)\n            p = this.fdToPath(p, `read`);\n        if (this.readOnly)\n            throw fslib_5.errors.EROFS(`open '${p}'`);\n        const resolvedP = this.resolveFilename(`open '${p}'`, p);\n        if (this.listings.has(resolvedP))\n            throw fslib_5.errors.EISDIR(`open '${p}'`);\n        let encoding = null, mode = null;\n        if (typeof opts === `string`) {\n            encoding = opts;\n        }\n        else if (typeof opts === `object`) {\n            ({\n                encoding = null,\n                mode = null,\n            } = opts);\n        }\n        const index = this.entries.get(resolvedP);\n        return {\n            encoding,\n            mode,\n            resolvedP,\n            index,\n        };\n    }\n    async unlinkPromise(p) {\n        return this.unlinkSync(p);\n    }\n    unlinkSync(p) {\n        if (this.readOnly)\n            throw fslib_5.errors.EROFS(`unlink '${p}'`);\n        const resolvedP = this.resolveFilename(`unlink '${p}'`, p);\n        if (this.listings.has(resolvedP))\n            throw fslib_5.errors.EISDIR(`unlink '${p}'`);\n        const index = this.entries.get(resolvedP);\n        if (typeof index === `undefined`)\n            throw fslib_5.errors.EINVAL(`unlink '${p}'`);\n        this.deleteEntry(resolvedP, index);\n    }\n    async utimesPromise(p, atime, mtime) {\n        return this.utimesSync(p, atime, mtime);\n    }\n    utimesSync(p, atime, mtime) {\n        if (this.readOnly)\n            throw fslib_5.errors.EROFS(`utimes '${p}'`);\n        const resolvedP = this.resolveFilename(`utimes '${p}'`, p);\n        this.utimesImpl(resolvedP, mtime);\n    }\n    async lutimesPromise(p, atime, mtime) {\n        return this.lutimesSync(p, atime, mtime);\n    }\n    lutimesSync(p, atime, mtime) {\n        if (this.readOnly)\n            throw fslib_5.errors.EROFS(`lutimes '${p}'`);\n        const resolvedP = this.resolveFilename(`utimes '${p}'`, p, false);\n        this.utimesImpl(resolvedP, mtime);\n    }\n    utimesImpl(resolvedP, mtime) {\n        if (this.listings.has(resolvedP))\n            if (!this.entries.has(resolvedP))\n                this.hydrateDirectory(resolvedP);\n        const entry = this.entries.get(resolvedP);\n        if (entry === undefined)\n            throw new Error(`Unreachable`);\n        const rc = this.libzip.file.setMtime(this.zip, entry, 0, toUnixTimestamp(mtime), 0);\n        if (rc === -1) {\n            throw this.makeLibzipError(this.libzip.getError(this.zip));\n        }\n    }\n    async mkdirPromise(p, opts) {\n        return this.mkdirSync(p, opts);\n    }\n    mkdirSync(p, { mode = 0o755, recursive = false } = {}) {\n        if (recursive)\n            return this.mkdirpSync(p, { chmod: mode });\n        if (this.readOnly)\n            throw fslib_5.errors.EROFS(`mkdir '${p}'`);\n        const resolvedP = this.resolveFilename(`mkdir '${p}'`, p);\n        if (this.entries.has(resolvedP) || this.listings.has(resolvedP))\n            throw fslib_5.errors.EEXIST(`mkdir '${p}'`);\n        this.hydrateDirectory(resolvedP);\n        this.chmodSync(resolvedP, mode);\n        return undefined;\n    }\n    async rmdirPromise(p, opts) {\n        return this.rmdirSync(p, opts);\n    }\n    rmdirSync(p, { recursive = false } = {}) {\n        if (this.readOnly)\n            throw fslib_5.errors.EROFS(`rmdir '${p}'`);\n        if (recursive) {\n            this.removeSync(p);\n            return;\n        }\n        const resolvedP = this.resolveFilename(`rmdir '${p}'`, p);\n        const directoryListing = this.listings.get(resolvedP);\n        if (!directoryListing)\n            throw fslib_5.errors.ENOTDIR(`rmdir '${p}'`);\n        if (directoryListing.size > 0)\n            throw fslib_5.errors.ENOTEMPTY(`rmdir '${p}'`);\n        const index = this.entries.get(resolvedP);\n        if (typeof index === `undefined`)\n            throw fslib_5.errors.EINVAL(`rmdir '${p}'`);\n        this.deleteEntry(p, index);\n    }\n    hydrateDirectory(resolvedP) {\n        const index = this.libzip.dir.add(this.zip, fslib_6.ppath.relative(fslib_6.PortablePath.root, resolvedP));\n        if (index === -1)\n            throw this.makeLibzipError(this.libzip.getError(this.zip));\n        this.registerListing(resolvedP);\n        this.registerEntry(resolvedP, index);\n        return index;\n    }\n    async linkPromise(existingP, newP) {\n        return this.linkSync(existingP, newP);\n    }\n    linkSync(existingP, newP) {\n        // Zip archives don't support hard links:\n        // https://stackoverflow.com/questions/8859616/are-hard-links-possible-within-a-zip-archive\n        throw fslib_5.errors.EOPNOTSUPP(`link '${existingP}' -> '${newP}'`);\n    }\n    async symlinkPromise(target, p) {\n        return this.symlinkSync(target, p);\n    }\n    symlinkSync(target, p) {\n        if (this.readOnly)\n            throw fslib_5.errors.EROFS(`symlink '${target}' -> '${p}'`);\n        const resolvedP = this.resolveFilename(`symlink '${target}' -> '${p}'`, p);\n        if (this.listings.has(resolvedP))\n            throw fslib_5.errors.EISDIR(`symlink '${target}' -> '${p}'`);\n        if (this.entries.has(resolvedP))\n            throw fslib_5.errors.EEXIST(`symlink '${target}' -> '${p}'`);\n        const index = this.setFileSource(resolvedP, target);\n        this.registerEntry(resolvedP, index);\n        const rc = this.libzip.file.setExternalAttributes(this.zip, index, 0, 0, this.libzip.ZIP_OPSYS_UNIX, (fs_1.constants.S_IFLNK | 0o777) << 16);\n        if (rc === -1)\n            throw this.makeLibzipError(this.libzip.getError(this.zip));\n        this.symlinkCount += 1;\n    }\n    async readFilePromise(p, encoding) {\n        // This is messed up regarding the TS signatures\n        if (typeof encoding === `object`)\n            // @ts-expect-error\n            encoding = encoding ? encoding.encoding : undefined;\n        const data = await this.readFileBuffer(p, { asyncDecompress: true });\n        return encoding ? data.toString(encoding) : data;\n    }\n    readFileSync(p, encoding) {\n        // This is messed up regarding the TS signatures\n        if (typeof encoding === `object`)\n            // @ts-expect-error\n            encoding = encoding ? encoding.encoding : undefined;\n        const data = this.readFileBuffer(p);\n        return encoding ? data.toString(encoding) : data;\n    }\n    readFileBuffer(p, opts = { asyncDecompress: false }) {\n        if (typeof p === `number`)\n            p = this.fdToPath(p, `read`);\n        const resolvedP = this.resolveFilename(`open '${p}'`, p);\n        if (!this.entries.has(resolvedP) && !this.listings.has(resolvedP))\n            throw fslib_5.errors.ENOENT(`open '${p}'`);\n        // Ensures that the last component is a directory, if the user said so (even if it is we'll throw right after with EISDIR anyway)\n        if (p[p.length - 1] === `/` && !this.listings.has(resolvedP))\n            throw fslib_5.errors.ENOTDIR(`open '${p}'`);\n        if (this.listings.has(resolvedP))\n            throw fslib_5.errors.EISDIR(`read`);\n        const entry = this.entries.get(resolvedP);\n        if (entry === undefined)\n            throw new Error(`Unreachable`);\n        return this.getFileSource(entry, opts);\n    }\n    async readdirPromise(p, opts) {\n        return this.readdirSync(p, opts);\n    }\n    readdirSync(p, opts) {\n        const resolvedP = this.resolveFilename(`scandir '${p}'`, p);\n        if (!this.entries.has(resolvedP) && !this.listings.has(resolvedP))\n            throw fslib_5.errors.ENOENT(`scandir '${p}'`);\n        const directoryListing = this.listings.get(resolvedP);\n        if (!directoryListing)\n            throw fslib_5.errors.ENOTDIR(`scandir '${p}'`);\n        const entries = [...directoryListing];\n        if (!(opts === null || opts === void 0 ? void 0 : opts.withFileTypes))\n            return entries;\n        return entries.map(name => {\n            return Object.assign(this.statImpl(`lstat`, fslib_6.ppath.join(p, name)), {\n                name,\n            });\n        });\n    }\n    async readlinkPromise(p) {\n        const entry = this.prepareReadlink(p);\n        return (await this.getFileSource(entry, { asyncDecompress: true })).toString();\n    }\n    readlinkSync(p) {\n        const entry = this.prepareReadlink(p);\n        return this.getFileSource(entry).toString();\n    }\n    prepareReadlink(p) {\n        const resolvedP = this.resolveFilename(`readlink '${p}'`, p, false);\n        if (!this.entries.has(resolvedP) && !this.listings.has(resolvedP))\n            throw fslib_5.errors.ENOENT(`readlink '${p}'`);\n        // Ensure that the last component is a directory (if it is we'll throw right after with EISDIR anyway)\n        if (p[p.length - 1] === `/` && !this.listings.has(resolvedP))\n            throw fslib_5.errors.ENOTDIR(`open '${p}'`);\n        if (this.listings.has(resolvedP))\n            throw fslib_5.errors.EINVAL(`readlink '${p}'`);\n        const entry = this.entries.get(resolvedP);\n        if (entry === undefined)\n            throw new Error(`Unreachable`);\n        if (!this.isSymbolicLink(entry))\n            throw fslib_5.errors.EINVAL(`readlink '${p}'`);\n        return entry;\n    }\n    async truncatePromise(p, len = 0) {\n        const resolvedP = this.resolveFilename(`open '${p}'`, p);\n        const index = this.entries.get(resolvedP);\n        if (typeof index === `undefined`)\n            throw fslib_5.errors.EINVAL(`open '${p}'`);\n        const source = await this.getFileSource(index, { asyncDecompress: true });\n        const truncated = Buffer.alloc(len, 0x00);\n        source.copy(truncated);\n        return await this.writeFilePromise(p, truncated);\n    }\n    truncateSync(p, len = 0) {\n        const resolvedP = this.resolveFilename(`open '${p}'`, p);\n        const index = this.entries.get(resolvedP);\n        if (typeof index === `undefined`)\n            throw fslib_5.errors.EINVAL(`open '${p}'`);\n        const source = this.getFileSource(index);\n        const truncated = Buffer.alloc(len, 0x00);\n        source.copy(truncated);\n        return this.writeFileSync(p, truncated);\n    }\n    async ftruncatePromise(fd, len) {\n        return this.truncatePromise(this.fdToPath(fd, `ftruncate`), len);\n    }\n    ftruncateSync(fd, len) {\n        return this.truncateSync(this.fdToPath(fd, `ftruncateSync`), len);\n    }\n    watch(p, a, b) {\n        let persistent;\n        switch (typeof a) {\n            case `function`:\n            case `string`:\n            case `undefined`:\n                {\n                    persistent = true;\n                }\n                break;\n            default:\n                {\n                    ({ persistent = true } = a);\n                }\n                break;\n        }\n        if (!persistent)\n            return { on: () => { }, close: () => { } };\n        const interval = setInterval(() => { }, 24 * 60 * 60 * 1000);\n        return { on: () => { }, close: () => {\n                clearInterval(interval);\n            } };\n    }\n    watchFile(p, a, b) {\n        const resolvedP = fslib_6.ppath.resolve(fslib_6.PortablePath.root, p);\n        return (0, fslib_4.watchFile)(this, resolvedP, a, b);\n    }\n    unwatchFile(p, cb) {\n        const resolvedP = fslib_6.ppath.resolve(fslib_6.PortablePath.root, p);\n        return (0, fslib_4.unwatchFile)(this, resolvedP, cb);\n    }\n}\nexports.ZipFS = ZipFS;\n\n\n/***/ }),\n\n/***/ 256:\n/***/ ((__unused_webpack_module, exports, __webpack_require__) => {\n\n\"use strict\";\n\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.ZipOpenFS = exports.getArchivePart = void 0;\nconst fslib_1 = __webpack_require__(382);\nconst fslib_2 = __webpack_require__(382);\nconst libzip_1 = __webpack_require__(32);\n/**\n * Extracts the archive part (ending in the first instance of `extension`) from a path.\n *\n * The indexOf-based implementation is ~3.7x faster than a RegExp-based implementation.\n */\nfunction getArchivePart(path, extension) {\n    let idx = path.indexOf(extension);\n    if (idx <= 0)\n        return null;\n    let nextCharIdx = idx;\n    while (idx >= 0) {\n        nextCharIdx = idx + extension.length;\n        if (path[nextCharIdx] === fslib_2.ppath.sep)\n            break;\n        // Disallow files named \".zip\"\n        if (path[idx - 1] === fslib_2.ppath.sep)\n            return null;\n        idx = path.indexOf(extension, nextCharIdx);\n    }\n    // The path either has to end in \".zip\" or contain an archive subpath (\".zip/...\")\n    if (path.length > nextCharIdx && path[nextCharIdx] !== fslib_2.ppath.sep)\n        return null;\n    return path.slice(0, nextCharIdx);\n}\nexports.getArchivePart = getArchivePart;\nclass ZipOpenFS extends fslib_1.MountFS {\n    static async openPromise(fn, opts) {\n        const zipOpenFs = new ZipOpenFS(opts);\n        try {\n            return await fn(zipOpenFs);\n        }\n        finally {\n            zipOpenFs.saveAndClose();\n        }\n    }\n    constructor(opts = {}) {\n        const fileExtensions = opts.fileExtensions;\n        const readOnlyArchives = opts.readOnlyArchives;\n        const getMountPoint = typeof fileExtensions === `undefined`\n            ? path => getArchivePart(path, `.zip`)\n            : path => {\n                for (const extension of fileExtensions) {\n                    const result = getArchivePart(path, extension);\n                    if (result) {\n                        return result;\n                    }\n                }\n                return null;\n            };\n        const factorySync = (baseFs, p) => {\n            return new libzip_1.ZipFS(p, {\n                baseFs,\n                readOnly: readOnlyArchives,\n                stats: baseFs.statSync(p),\n            });\n        };\n        const factoryPromise = async (baseFs, p) => {\n            const zipOptions = {\n                baseFs,\n                readOnly: readOnlyArchives,\n                stats: await baseFs.statPromise(p),\n            };\n            return () => {\n                return new libzip_1.ZipFS(p, zipOptions);\n            };\n        };\n        super({\n            ...opts,\n            factorySync,\n            factoryPromise,\n            getMountPoint,\n        });\n    }\n}\nexports.ZipOpenFS = ZipOpenFS;\n\n\n/***/ }),\n\n/***/ 763:\n/***/ ((__unused_webpack_module, exports, __webpack_require__) => {\n\n\"use strict\";\n\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.mountMemoryDrive = void 0;\nconst tslib_1 = __webpack_require__(240);\ntslib_1.__exportStar(__webpack_require__(256), exports);\ntslib_1.__exportStar(__webpack_require__(154), exports);\nvar mountMemoryDrive_1 = __webpack_require__(650);\nObject.defineProperty(exports, \"mountMemoryDrive\", ({ enumerable: true, get: function () { return mountMemoryDrive_1.mountMemoryDrive; } }));\n\n\n/***/ }),\n\n/***/ 309:\n/***/ ((__unused_webpack_module, exports) => {\n\n\"use strict\";\n\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.tryInstance = exports.getInstance = exports.setFactory = exports.cachedInstance = void 0;\nlet registeredFactory = () => {\n    throw new Error(`Assertion failed: No libzip instance is available, and no factory was configured`);\n};\nfunction setFactory(factory) {\n    registeredFactory = factory;\n}\nexports.setFactory = setFactory;\nfunction getInstance() {\n    if (typeof exports.cachedInstance === `undefined`)\n        exports.cachedInstance = registeredFactory();\n    return exports.cachedInstance;\n}\nexports.getInstance = getInstance;\nfunction tryInstance() {\n    return exports.cachedInstance;\n}\nexports.tryInstance = tryInstance;\n\n\n/***/ }),\n\n/***/ 161:\n/***/ ((module, __unused_webpack_exports, __webpack_require__) => {\n\nvar frozenFs = Object.assign({}, __webpack_require__(147));\n\nvar createModule = (function() {\n  var _scriptDir =\n    typeof document !== \"undefined\" && document.currentScript\n      ? document.currentScript.src\n      : undefined;\n  if (typeof __filename !== \"undefined\") _scriptDir = _scriptDir || __filename;\n  return function(createModule) {\n    createModule = createModule || {};\n\n    null;\n    var Module = typeof createModule !== \"undefined\" ? createModule : {};\n    var readyPromiseResolve, readyPromiseReject;\n    Module[\"ready\"] = new Promise(function(resolve, reject) {\n      readyPromiseResolve = resolve;\n      readyPromiseReject = reject;\n    });\n    var moduleOverrides = {};\n    var key;\n    for (key in Module) {\n      if (Module.hasOwnProperty(key)) {\n        moduleOverrides[key] = Module[key];\n      }\n    }\n    var arguments_ = [];\n    var thisProgram = \"./this.program\";\n    var quit_ = function(status, toThrow) {\n      throw toThrow;\n    };\n    var ENVIRONMENT_IS_WORKER = false;\n    var ENVIRONMENT_IS_NODE = true;\n    var scriptDirectory = \"\";\n    function locateFile(path) {\n      if (Module[\"locateFile\"]) {\n        return Module[\"locateFile\"](path, scriptDirectory);\n      }\n      return scriptDirectory + path;\n    }\n    var read_, readBinary;\n    var nodeFS;\n    var nodePath;\n    if (ENVIRONMENT_IS_NODE) {\n      if (ENVIRONMENT_IS_WORKER) {\n        scriptDirectory = (__webpack_require__(17).dirname)(scriptDirectory) + \"/\";\n      } else {\n        scriptDirectory = __dirname + \"/\";\n      }\n      read_ = function shell_read(filename, binary) {\n        var ret = tryParseAsDataURI(filename);\n        if (ret) {\n          return binary ? ret : ret.toString();\n        }\n        if (!nodeFS) nodeFS = frozenFs;\n        if (!nodePath) nodePath = __webpack_require__(17);\n        filename = nodePath[\"normalize\"](filename);\n        return nodeFS[\"readFileSync\"](filename, binary ? null : \"utf8\");\n      };\n      readBinary = function readBinary(filename) {\n        var ret = read_(filename, true);\n        if (!ret.buffer) {\n          ret = new Uint8Array(ret);\n        }\n        assert(ret.buffer);\n        return ret;\n      };\n      if (process[\"argv\"].length > 1) {\n        thisProgram = process[\"argv\"][1].replace(/\\\\/g, \"/\");\n      }\n      arguments_ = process[\"argv\"].slice(2);\n      quit_ = function(status) {\n        process[\"exit\"](status);\n      };\n      Module[\"inspect\"] = function() {\n        return \"[Emscripten Module object]\";\n      };\n    } else {\n    }\n    var out = Module[\"print\"] || console.log.bind(console);\n    var err = Module[\"printErr\"] || console.warn.bind(console);\n    for (key in moduleOverrides) {\n      if (moduleOverrides.hasOwnProperty(key)) {\n        Module[key] = moduleOverrides[key];\n      }\n    }\n    moduleOverrides = null;\n    if (Module[\"arguments\"]) arguments_ = Module[\"arguments\"];\n    if (Module[\"thisProgram\"]) thisProgram = Module[\"thisProgram\"];\n    if (Module[\"quit\"]) quit_ = Module[\"quit\"];\n    var tempRet0 = 0;\n    var setTempRet0 = function(value) {\n      tempRet0 = value;\n    };\n    var wasmBinary;\n    if (Module[\"wasmBinary\"]) wasmBinary = Module[\"wasmBinary\"];\n    var noExitRuntime = Module[\"noExitRuntime\"] || true;\n    if (typeof WebAssembly !== \"object\") {\n      abort(\"no native wasm support detected\");\n    }\n    function getValue(ptr, type, noSafe) {\n      type = type || \"i8\";\n      if (type.charAt(type.length - 1) === \"*\") type = \"i32\";\n      switch (type) {\n        case \"i1\":\n          return HEAP8[ptr >> 0];\n        case \"i8\":\n          return HEAP8[ptr >> 0];\n        case \"i16\":\n          return LE_HEAP_LOAD_I16((ptr >> 1) * 2);\n        case \"i32\":\n          return LE_HEAP_LOAD_I32((ptr >> 2) * 4);\n        case \"i64\":\n          return LE_HEAP_LOAD_I32((ptr >> 2) * 4);\n        case \"float\":\n          return LE_HEAP_LOAD_F32((ptr >> 2) * 4);\n        case \"double\":\n          return LE_HEAP_LOAD_F64((ptr >> 3) * 8);\n        default:\n          abort(\"invalid type for getValue: \" + type);\n      }\n      return null;\n    }\n    var wasmMemory;\n    var ABORT = false;\n    var EXITSTATUS;\n    function assert(condition, text) {\n      if (!condition) {\n        abort(\"Assertion failed: \" + text);\n      }\n    }\n    function getCFunc(ident) {\n      var func = Module[\"_\" + ident];\n      assert(\n        func,\n        \"Cannot call unknown function \" + ident + \", make sure it is exported\"\n      );\n      return func;\n    }\n    function ccall(ident, returnType, argTypes, args, opts) {\n      var toC = {\n        string: function(str) {\n          var ret = 0;\n          if (str !== null && str !== undefined && str !== 0) {\n            var len = (str.length << 2) + 1;\n            ret = stackAlloc(len);\n            stringToUTF8(str, ret, len);\n          }\n          return ret;\n        },\n        array: function(arr) {\n          var ret = stackAlloc(arr.length);\n          writeArrayToMemory(arr, ret);\n          return ret;\n        }\n      };\n      function convertReturnValue(ret) {\n        if (returnType === \"string\") return UTF8ToString(ret);\n        if (returnType === \"boolean\") return Boolean(ret);\n        return ret;\n      }\n      var func = getCFunc(ident);\n      var cArgs = [];\n      var stack = 0;\n      if (args) {\n        for (var i = 0; i < args.length; i++) {\n          var converter = toC[argTypes[i]];\n          if (converter) {\n            if (stack === 0) stack = stackSave();\n            cArgs[i] = converter(args[i]);\n          } else {\n            cArgs[i] = args[i];\n          }\n        }\n      }\n      var ret = func.apply(null, cArgs);\n      ret = convertReturnValue(ret);\n      if (stack !== 0) stackRestore(stack);\n      return ret;\n    }\n    function cwrap(ident, returnType, argTypes, opts) {\n      argTypes = argTypes || [];\n      var numericArgs = argTypes.every(function(type) {\n        return type === \"number\";\n      });\n      var numericRet = returnType !== \"string\";\n      if (numericRet && numericArgs && !opts) {\n        return getCFunc(ident);\n      }\n      return function() {\n        return ccall(ident, returnType, argTypes, arguments, opts);\n      };\n    }\n    var UTF8Decoder = new TextDecoder(\"utf8\");\n    function UTF8ToString(ptr, maxBytesToRead) {\n      if (!ptr) return \"\";\n      var maxPtr = ptr + maxBytesToRead;\n      for (var end = ptr; !(end >= maxPtr) && HEAPU8[end]; ) ++end;\n      return UTF8Decoder.decode(HEAPU8.subarray(ptr, end));\n    }\n    function stringToUTF8Array(str, heap, outIdx, maxBytesToWrite) {\n      if (!(maxBytesToWrite > 0)) return 0;\n      var startIdx = outIdx;\n      var endIdx = outIdx + maxBytesToWrite - 1;\n      for (var i = 0; i < str.length; ++i) {\n        var u = str.charCodeAt(i);\n        if (u >= 55296 && u <= 57343) {\n          var u1 = str.charCodeAt(++i);\n          u = (65536 + ((u & 1023) << 10)) | (u1 & 1023);\n        }\n        if (u <= 127) {\n          if (outIdx >= endIdx) break;\n          heap[outIdx++] = u;\n        } else if (u <= 2047) {\n          if (outIdx + 1 >= endIdx) break;\n          heap[outIdx++] = 192 | (u >> 6);\n          heap[outIdx++] = 128 | (u & 63);\n        } else if (u <= 65535) {\n          if (outIdx + 2 >= endIdx) break;\n          heap[outIdx++] = 224 | (u >> 12);\n          heap[outIdx++] = 128 | ((u >> 6) & 63);\n          heap[outIdx++] = 128 | (u & 63);\n        } else {\n          if (outIdx + 3 >= endIdx) break;\n          heap[outIdx++] = 240 | (u >> 18);\n          heap[outIdx++] = 128 | ((u >> 12) & 63);\n          heap[outIdx++] = 128 | ((u >> 6) & 63);\n          heap[outIdx++] = 128 | (u & 63);\n        }\n      }\n      heap[outIdx] = 0;\n      return outIdx - startIdx;\n    }\n    function stringToUTF8(str, outPtr, maxBytesToWrite) {\n      return stringToUTF8Array(str, HEAPU8, outPtr, maxBytesToWrite);\n    }\n    function lengthBytesUTF8(str) {\n      var len = 0;\n      for (var i = 0; i < str.length; ++i) {\n        var u = str.charCodeAt(i);\n        if (u >= 55296 && u <= 57343)\n          u = (65536 + ((u & 1023) << 10)) | (str.charCodeAt(++i) & 1023);\n        if (u <= 127) ++len;\n        else if (u <= 2047) len += 2;\n        else if (u <= 65535) len += 3;\n        else len += 4;\n      }\n      return len;\n    }\n    function allocateUTF8(str) {\n      var size = lengthBytesUTF8(str) + 1;\n      var ret = _malloc(size);\n      if (ret) stringToUTF8Array(str, HEAP8, ret, size);\n      return ret;\n    }\n    function writeArrayToMemory(array, buffer) {\n      HEAP8.set(array, buffer);\n    }\n    function alignUp(x, multiple) {\n      if (x % multiple > 0) {\n        x += multiple - (x % multiple);\n      }\n      return x;\n    }\n    var buffer,\n      HEAP8,\n      HEAPU8,\n      HEAP16,\n      HEAPU16,\n      HEAP32,\n      HEAPU32,\n      HEAPF32,\n      HEAPF64;\n    var HEAP_DATA_VIEW;\n    function updateGlobalBufferAndViews(buf) {\n      buffer = buf;\n      Module[\"HEAP_DATA_VIEW\"] = HEAP_DATA_VIEW = new DataView(buf);\n      Module[\"HEAP8\"] = HEAP8 = new Int8Array(buf);\n      Module[\"HEAP16\"] = HEAP16 = new Int16Array(buf);\n      Module[\"HEAP32\"] = HEAP32 = new Int32Array(buf);\n      Module[\"HEAPU8\"] = HEAPU8 = new Uint8Array(buf);\n      Module[\"HEAPU16\"] = HEAPU16 = new Uint16Array(buf);\n      Module[\"HEAPU32\"] = HEAPU32 = new Uint32Array(buf);\n      Module[\"HEAPF32\"] = HEAPF32 = new Float32Array(buf);\n      Module[\"HEAPF64\"] = HEAPF64 = new Float64Array(buf);\n    }\n    var INITIAL_MEMORY = Module[\"INITIAL_MEMORY\"] || 16777216;\n    var wasmTable;\n    var __ATPRERUN__ = [];\n    var __ATINIT__ = [];\n    var __ATPOSTRUN__ = [];\n    var runtimeInitialized = false;\n    function preRun() {\n      if (Module[\"preRun\"]) {\n        if (typeof Module[\"preRun\"] == \"function\")\n          Module[\"preRun\"] = [Module[\"preRun\"]];\n        while (Module[\"preRun\"].length) {\n          addOnPreRun(Module[\"preRun\"].shift());\n        }\n      }\n      callRuntimeCallbacks(__ATPRERUN__);\n    }\n    function initRuntime() {\n      runtimeInitialized = true;\n      callRuntimeCallbacks(__ATINIT__);\n    }\n    function postRun() {\n      if (Module[\"postRun\"]) {\n        if (typeof Module[\"postRun\"] == \"function\")\n          Module[\"postRun\"] = [Module[\"postRun\"]];\n        while (Module[\"postRun\"].length) {\n          addOnPostRun(Module[\"postRun\"].shift());\n        }\n      }\n      callRuntimeCallbacks(__ATPOSTRUN__);\n    }\n    function addOnPreRun(cb) {\n      __ATPRERUN__.unshift(cb);\n    }\n    function addOnInit(cb) {\n      __ATINIT__.unshift(cb);\n    }\n    function addOnPostRun(cb) {\n      __ATPOSTRUN__.unshift(cb);\n    }\n    var runDependencies = 0;\n    var runDependencyWatcher = null;\n    var dependenciesFulfilled = null;\n    function addRunDependency(id) {\n      runDependencies++;\n      if (Module[\"monitorRunDependencies\"]) {\n        Module[\"monitorRunDependencies\"](runDependencies);\n      }\n    }\n    function removeRunDependency(id) {\n      runDependencies--;\n      if (Module[\"monitorRunDependencies\"]) {\n        Module[\"monitorRunDependencies\"](runDependencies);\n      }\n      if (runDependencies == 0) {\n        if (runDependencyWatcher !== null) {\n          clearInterval(runDependencyWatcher);\n          runDependencyWatcher = null;\n        }\n        if (dependenciesFulfilled) {\n          var callback = dependenciesFulfilled;\n          dependenciesFulfilled = null;\n          callback();\n        }\n      }\n    }\n    Module[\"preloadedImages\"] = {};\n    Module[\"preloadedAudios\"] = {};\n    function abort(what) {\n      if (Module[\"onAbort\"]) {\n        Module[\"onAbort\"](what);\n      }\n      what += \"\";\n      err(what);\n      ABORT = true;\n      EXITSTATUS = 1;\n      what = \"abort(\" + what + \"). Build with -s ASSERTIONS=1 for more info.\";\n      var e = new WebAssembly.RuntimeError(what);\n      readyPromiseReject(e);\n      throw e;\n    }\n    var dataURIPrefix = \"data:application/octet-stream;base64,\";\n    function isDataURI(filename) {\n      return filename.startsWith(dataURIPrefix);\n    }\n    var wasmBinaryFile =\n      \"data:application/octet-stream;base64,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\";\n    if (!isDataURI(wasmBinaryFile)) {\n      wasmBinaryFile = locateFile(wasmBinaryFile);\n    }\n    function getBinary(file) {\n      try {\n        if (file == wasmBinaryFile && wasmBinary) {\n          return new Uint8Array(wasmBinary);\n        }\n        var binary = tryParseAsDataURI(file);\n        if (binary) {\n          return binary;\n        }\n        if (readBinary) {\n          return readBinary(file);\n        } else {\n          throw \"sync fetching of the wasm failed: you can preload it to Module['wasmBinary'] manually, or emcc.py will do that for you when generating HTML (but not JS)\";\n        }\n      } catch (err) {\n        abort(err);\n      }\n    }\n    function instantiateSync(file, info) {\n      var instance;\n      var module;\n      var binary;\n      try {\n        binary = getBinary(file);\n        module = new WebAssembly.Module(binary);\n        instance = new WebAssembly.Instance(module, info);\n      } catch (e) {\n        var str = e.toString();\n        err(\"failed to compile wasm module: \" + str);\n        if (str.includes(\"imported Memory\") || str.includes(\"memory import\")) {\n          err(\n            \"Memory size incompatibility issues may be due to changing INITIAL_MEMORY at runtime to something too large. Use ALLOW_MEMORY_GROWTH to allow any size memory (and also make sure not to set INITIAL_MEMORY at runtime to something smaller than it was at compile time).\"\n          );\n        }\n        throw e;\n      }\n      return [instance, module];\n    }\n    function createWasm() {\n      var info = { a: asmLibraryArg };\n      function receiveInstance(instance, module) {\n        var exports = instance.exports;\n        Module[\"asm\"] = exports;\n        wasmMemory = Module[\"asm\"][\"g\"];\n        updateGlobalBufferAndViews(wasmMemory.buffer);\n        wasmTable = Module[\"asm\"][\"$\"];\n        addOnInit(Module[\"asm\"][\"h\"]);\n        removeRunDependency(\"wasm-instantiate\");\n      }\n      addRunDependency(\"wasm-instantiate\");\n      if (Module[\"instantiateWasm\"]) {\n        try {\n          var exports = Module[\"instantiateWasm\"](info, receiveInstance);\n          return exports;\n        } catch (e) {\n          err(\"Module.instantiateWasm callback failed with error: \" + e);\n          return false;\n        }\n      }\n      var result = instantiateSync(wasmBinaryFile, info);\n      receiveInstance(result[0]);\n      return Module[\"asm\"];\n    }\n    function LE_HEAP_LOAD_F32(byteOffset) {\n      return HEAP_DATA_VIEW.getFloat32(byteOffset, true);\n    }\n    function LE_HEAP_LOAD_F64(byteOffset) {\n      return HEAP_DATA_VIEW.getFloat64(byteOffset, true);\n    }\n    function LE_HEAP_LOAD_I16(byteOffset) {\n      return HEAP_DATA_VIEW.getInt16(byteOffset, true);\n    }\n    function LE_HEAP_LOAD_I32(byteOffset) {\n      return HEAP_DATA_VIEW.getInt32(byteOffset, true);\n    }\n    function LE_HEAP_STORE_I32(byteOffset, value) {\n      HEAP_DATA_VIEW.setInt32(byteOffset, value, true);\n    }\n    function callRuntimeCallbacks(callbacks) {\n      while (callbacks.length > 0) {\n        var callback = callbacks.shift();\n        if (typeof callback == \"function\") {\n          callback(Module);\n          continue;\n        }\n        var func = callback.func;\n        if (typeof func === \"number\") {\n          if (callback.arg === undefined) {\n            wasmTable.get(func)();\n          } else {\n            wasmTable.get(func)(callback.arg);\n          }\n        } else {\n          func(callback.arg === undefined ? null : callback.arg);\n        }\n      }\n    }\n    function _gmtime_r(time, tmPtr) {\n      var date = new Date(LE_HEAP_LOAD_I32((time >> 2) * 4) * 1e3);\n      LE_HEAP_STORE_I32((tmPtr >> 2) * 4, date.getUTCSeconds());\n      LE_HEAP_STORE_I32(((tmPtr + 4) >> 2) * 4, date.getUTCMinutes());\n      LE_HEAP_STORE_I32(((tmPtr + 8) >> 2) * 4, date.getUTCHours());\n      LE_HEAP_STORE_I32(((tmPtr + 12) >> 2) * 4, date.getUTCDate());\n      LE_HEAP_STORE_I32(((tmPtr + 16) >> 2) * 4, date.getUTCMonth());\n      LE_HEAP_STORE_I32(((tmPtr + 20) >> 2) * 4, date.getUTCFullYear() - 1900);\n      LE_HEAP_STORE_I32(((tmPtr + 24) >> 2) * 4, date.getUTCDay());\n      LE_HEAP_STORE_I32(((tmPtr + 36) >> 2) * 4, 0);\n      LE_HEAP_STORE_I32(((tmPtr + 32) >> 2) * 4, 0);\n      var start = Date.UTC(date.getUTCFullYear(), 0, 1, 0, 0, 0, 0);\n      var yday = ((date.getTime() - start) / (1e3 * 60 * 60 * 24)) | 0;\n      LE_HEAP_STORE_I32(((tmPtr + 28) >> 2) * 4, yday);\n      if (!_gmtime_r.GMTString) _gmtime_r.GMTString = allocateUTF8(\"GMT\");\n      LE_HEAP_STORE_I32(((tmPtr + 40) >> 2) * 4, _gmtime_r.GMTString);\n      return tmPtr;\n    }\n    function ___gmtime_r(a0, a1) {\n      return _gmtime_r(a0, a1);\n    }\n    function _emscripten_memcpy_big(dest, src, num) {\n      HEAPU8.copyWithin(dest, src, src + num);\n    }\n    function emscripten_realloc_buffer(size) {\n      try {\n        wasmMemory.grow((size - buffer.byteLength + 65535) >>> 16);\n        updateGlobalBufferAndViews(wasmMemory.buffer);\n        return 1;\n      } catch (e) {}\n    }\n    function _emscripten_resize_heap(requestedSize) {\n      var oldSize = HEAPU8.length;\n      requestedSize = requestedSize >>> 0;\n      var maxHeapSize = 2147483648;\n      if (requestedSize > maxHeapSize) {\n        return false;\n      }\n      for (var cutDown = 1; cutDown <= 4; cutDown *= 2) {\n        var overGrownHeapSize = oldSize * (1 + 0.2 / cutDown);\n        overGrownHeapSize = Math.min(\n          overGrownHeapSize,\n          requestedSize + 100663296\n        );\n        var newSize = Math.min(\n          maxHeapSize,\n          alignUp(Math.max(requestedSize, overGrownHeapSize), 65536)\n        );\n        var replacement = emscripten_realloc_buffer(newSize);\n        if (replacement) {\n          return true;\n        }\n      }\n      return false;\n    }\n    function _setTempRet0(val) {\n      setTempRet0(val);\n    }\n    function _time(ptr) {\n      var ret = (Date.now() / 1e3) | 0;\n      if (ptr) {\n        LE_HEAP_STORE_I32((ptr >> 2) * 4, ret);\n      }\n      return ret;\n    }\n    function _tzset() {\n      if (_tzset.called) return;\n      _tzset.called = true;\n      var currentYear = new Date().getFullYear();\n      var winter = new Date(currentYear, 0, 1);\n      var summer = new Date(currentYear, 6, 1);\n      var winterOffset = winter.getTimezoneOffset();\n      var summerOffset = summer.getTimezoneOffset();\n      var stdTimezoneOffset = Math.max(winterOffset, summerOffset);\n      LE_HEAP_STORE_I32((__get_timezone() >> 2) * 4, stdTimezoneOffset * 60);\n      LE_HEAP_STORE_I32(\n        (__get_daylight() >> 2) * 4,\n        Number(winterOffset != summerOffset)\n      );\n      function extractZone(date) {\n        var match = date.toTimeString().match(/\\(([A-Za-z ]+)\\)$/);\n        return match ? match[1] : \"GMT\";\n      }\n      var winterName = extractZone(winter);\n      var summerName = extractZone(summer);\n      var winterNamePtr = allocateUTF8(winterName);\n      var summerNamePtr = allocateUTF8(summerName);\n      if (summerOffset < winterOffset) {\n        LE_HEAP_STORE_I32((__get_tzname() >> 2) * 4, winterNamePtr);\n        LE_HEAP_STORE_I32(((__get_tzname() + 4) >> 2) * 4, summerNamePtr);\n      } else {\n        LE_HEAP_STORE_I32((__get_tzname() >> 2) * 4, summerNamePtr);\n        LE_HEAP_STORE_I32(((__get_tzname() + 4) >> 2) * 4, winterNamePtr);\n      }\n    }\n    function _timegm(tmPtr) {\n      _tzset();\n      var time = Date.UTC(\n        LE_HEAP_LOAD_I32(((tmPtr + 20) >> 2) * 4) + 1900,\n        LE_HEAP_LOAD_I32(((tmPtr + 16) >> 2) * 4),\n        LE_HEAP_LOAD_I32(((tmPtr + 12) >> 2) * 4),\n        LE_HEAP_LOAD_I32(((tmPtr + 8) >> 2) * 4),\n        LE_HEAP_LOAD_I32(((tmPtr + 4) >> 2) * 4),\n        LE_HEAP_LOAD_I32((tmPtr >> 2) * 4),\n        0\n      );\n      var date = new Date(time);\n      LE_HEAP_STORE_I32(((tmPtr + 24) >> 2) * 4, date.getUTCDay());\n      var start = Date.UTC(date.getUTCFullYear(), 0, 1, 0, 0, 0, 0);\n      var yday = ((date.getTime() - start) / (1e3 * 60 * 60 * 24)) | 0;\n      LE_HEAP_STORE_I32(((tmPtr + 28) >> 2) * 4, yday);\n      return (date.getTime() / 1e3) | 0;\n    }\n    var decodeBase64 =\n      typeof atob === \"function\"\n        ? atob\n        : function(input) {\n            var keyStr =\n              \"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\";\n            var output = \"\";\n            var chr1, chr2, chr3;\n            var enc1, enc2, enc3, enc4;\n            var i = 0;\n            input = input.replace(/[^A-Za-z0-9\\+\\/\\=]/g, \"\");\n            do {\n              enc1 = keyStr.indexOf(input.charAt(i++));\n              enc2 = keyStr.indexOf(input.charAt(i++));\n              enc3 = keyStr.indexOf(input.charAt(i++));\n              enc4 = keyStr.indexOf(input.charAt(i++));\n              chr1 = (enc1 << 2) | (enc2 >> 4);\n              chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);\n              chr3 = ((enc3 & 3) << 6) | enc4;\n              output = output + String.fromCharCode(chr1);\n              if (enc3 !== 64) {\n                output = output + String.fromCharCode(chr2);\n              }\n              if (enc4 !== 64) {\n                output = output + String.fromCharCode(chr3);\n              }\n            } while (i < input.length);\n            return output;\n          };\n    function intArrayFromBase64(s) {\n      if (typeof ENVIRONMENT_IS_NODE === \"boolean\" && ENVIRONMENT_IS_NODE) {\n        var buf;\n        try {\n          buf = Buffer.from(s, \"base64\");\n        } catch (_) {\n          buf = new Buffer(s, \"base64\");\n        }\n        return new Uint8Array(\n          buf[\"buffer\"],\n          buf[\"byteOffset\"],\n          buf[\"byteLength\"]\n        );\n      }\n      try {\n        var decoded = decodeBase64(s);\n        var bytes = new Uint8Array(decoded.length);\n        for (var i = 0; i < decoded.length; ++i) {\n          bytes[i] = decoded.charCodeAt(i);\n        }\n        return bytes;\n      } catch (_) {\n        throw new Error(\"Converting base64 string to bytes failed.\");\n      }\n    }\n    function tryParseAsDataURI(filename) {\n      if (!isDataURI(filename)) {\n        return;\n      }\n      return intArrayFromBase64(filename.slice(dataURIPrefix.length));\n    }\n    var asmLibraryArg = {\n      e: ___gmtime_r,\n      c: _emscripten_memcpy_big,\n      d: _emscripten_resize_heap,\n      a: _setTempRet0,\n      b: _time,\n      f: _timegm\n    };\n    var asm = createWasm();\n    var ___wasm_call_ctors = (Module[\"___wasm_call_ctors\"] = asm[\"h\"]);\n    var _zip_ext_count_symlinks = (Module[\"_zip_ext_count_symlinks\"] =\n      asm[\"i\"]);\n    var _zip_file_get_external_attributes = (Module[\n      \"_zip_file_get_external_attributes\"\n    ] = asm[\"j\"]);\n    var _zipstruct_stat = (Module[\"_zipstruct_stat\"] = asm[\"k\"]);\n    var _zipstruct_statS = (Module[\"_zipstruct_statS\"] = asm[\"l\"]);\n    var _zipstruct_stat_name = (Module[\"_zipstruct_stat_name\"] = asm[\"m\"]);\n    var _zipstruct_stat_index = (Module[\"_zipstruct_stat_index\"] = asm[\"n\"]);\n    var _zipstruct_stat_size = (Module[\"_zipstruct_stat_size\"] = asm[\"o\"]);\n    var _zipstruct_stat_mtime = (Module[\"_zipstruct_stat_mtime\"] = asm[\"p\"]);\n    var _zipstruct_stat_crc = (Module[\"_zipstruct_stat_crc\"] = asm[\"q\"]);\n    var _zipstruct_error = (Module[\"_zipstruct_error\"] = asm[\"r\"]);\n    var _zipstruct_errorS = (Module[\"_zipstruct_errorS\"] = asm[\"s\"]);\n    var _zipstruct_error_code_zip = (Module[\"_zipstruct_error_code_zip\"] =\n      asm[\"t\"]);\n    var _zipstruct_stat_comp_size = (Module[\"_zipstruct_stat_comp_size\"] =\n      asm[\"u\"]);\n    var _zipstruct_stat_comp_method = (Module[\"_zipstruct_stat_comp_method\"] =\n      asm[\"v\"]);\n    var _zip_close = (Module[\"_zip_close\"] = asm[\"w\"]);\n    var _zip_delete = (Module[\"_zip_delete\"] = asm[\"x\"]);\n    var _zip_dir_add = (Module[\"_zip_dir_add\"] = asm[\"y\"]);\n    var _zip_discard = (Module[\"_zip_discard\"] = asm[\"z\"]);\n    var _zip_error_init_with_code = (Module[\"_zip_error_init_with_code\"] =\n      asm[\"A\"]);\n    var _zip_get_error = (Module[\"_zip_get_error\"] = asm[\"B\"]);\n    var _zip_file_get_error = (Module[\"_zip_file_get_error\"] = asm[\"C\"]);\n    var _zip_error_strerror = (Module[\"_zip_error_strerror\"] = asm[\"D\"]);\n    var _zip_fclose = (Module[\"_zip_fclose\"] = asm[\"E\"]);\n    var _zip_file_add = (Module[\"_zip_file_add\"] = asm[\"F\"]);\n    var _free = (Module[\"_free\"] = asm[\"G\"]);\n    var _malloc = (Module[\"_malloc\"] = asm[\"H\"]);\n    var _zip_source_error = (Module[\"_zip_source_error\"] = asm[\"I\"]);\n    var _zip_source_seek = (Module[\"_zip_source_seek\"] = asm[\"J\"]);\n    var _zip_file_set_external_attributes = (Module[\n      \"_zip_file_set_external_attributes\"\n    ] = asm[\"K\"]);\n    var _zip_file_set_mtime = (Module[\"_zip_file_set_mtime\"] = asm[\"L\"]);\n    var _zip_fopen = (Module[\"_zip_fopen\"] = asm[\"M\"]);\n    var _zip_fopen_index = (Module[\"_zip_fopen_index\"] = asm[\"N\"]);\n    var _zip_fread = (Module[\"_zip_fread\"] = asm[\"O\"]);\n    var _zip_get_name = (Module[\"_zip_get_name\"] = asm[\"P\"]);\n    var _zip_get_num_entries = (Module[\"_zip_get_num_entries\"] = asm[\"Q\"]);\n    var _zip_source_read = (Module[\"_zip_source_read\"] = asm[\"R\"]);\n    var _zip_name_locate = (Module[\"_zip_name_locate\"] = asm[\"S\"]);\n    var _zip_open_from_source = (Module[\"_zip_open_from_source\"] = asm[\"T\"]);\n    var _zip_set_file_compression = (Module[\"_zip_set_file_compression\"] =\n      asm[\"U\"]);\n    var _zip_source_buffer = (Module[\"_zip_source_buffer\"] = asm[\"V\"]);\n    var _zip_source_buffer_create = (Module[\"_zip_source_buffer_create\"] =\n      asm[\"W\"]);\n    var _zip_source_close = (Module[\"_zip_source_close\"] = asm[\"X\"]);\n    var _zip_source_free = (Module[\"_zip_source_free\"] = asm[\"Y\"]);\n    var _zip_source_keep = (Module[\"_zip_source_keep\"] = asm[\"Z\"]);\n    var _zip_source_open = (Module[\"_zip_source_open\"] = asm[\"_\"]);\n    var _zip_source_set_mtime = (Module[\"_zip_source_set_mtime\"] = asm[\"aa\"]);\n    var _zip_source_tell = (Module[\"_zip_source_tell\"] = asm[\"ba\"]);\n    var _zip_stat = (Module[\"_zip_stat\"] = asm[\"ca\"]);\n    var _zip_stat_index = (Module[\"_zip_stat_index\"] = asm[\"da\"]);\n    var __get_tzname = (Module[\"__get_tzname\"] = asm[\"ea\"]);\n    var __get_daylight = (Module[\"__get_daylight\"] = asm[\"fa\"]);\n    var __get_timezone = (Module[\"__get_timezone\"] = asm[\"ga\"]);\n    var stackSave = (Module[\"stackSave\"] = asm[\"ha\"]);\n    var stackRestore = (Module[\"stackRestore\"] = asm[\"ia\"]);\n    var stackAlloc = (Module[\"stackAlloc\"] = asm[\"ja\"]);\n    Module[\"cwrap\"] = cwrap;\n    Module[\"getValue\"] = getValue;\n    var calledRun;\n    dependenciesFulfilled = function runCaller() {\n      if (!calledRun) run();\n      if (!calledRun) dependenciesFulfilled = runCaller;\n    };\n    function run(args) {\n      args = args || arguments_;\n      if (runDependencies > 0) {\n        return;\n      }\n      preRun();\n      if (runDependencies > 0) {\n        return;\n      }\n      function doRun() {\n        if (calledRun) return;\n        calledRun = true;\n        Module[\"calledRun\"] = true;\n        if (ABORT) return;\n        initRuntime();\n        readyPromiseResolve(Module);\n        if (Module[\"onRuntimeInitialized\"]) Module[\"onRuntimeInitialized\"]();\n        postRun();\n      }\n      if (Module[\"setStatus\"]) {\n        Module[\"setStatus\"](\"Running...\");\n        setTimeout(function() {\n          setTimeout(function() {\n            Module[\"setStatus\"](\"\");\n          }, 1);\n          doRun();\n        }, 1);\n      } else {\n        doRun();\n      }\n    }\n    Module[\"run\"] = run;\n    if (Module[\"preInit\"]) {\n      if (typeof Module[\"preInit\"] == \"function\")\n        Module[\"preInit\"] = [Module[\"preInit\"]];\n      while (Module[\"preInit\"].length > 0) {\n        Module[\"preInit\"].pop()();\n      }\n    }\n    run();\n\n    return createModule;\n  };\n})();\nif (true)\n  module.exports = createModule;\nelse {}\n\n\n/***/ }),\n\n/***/ 815:\n/***/ ((__unused_webpack_module, exports) => {\n\n\"use strict\";\n\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.makeInterface = exports.Errors = void 0;\nconst number64 = [\n    `number`,\n    `number`, // high\n];\nvar Errors;\n(function (Errors) {\n    Errors[Errors[\"ZIP_ER_OK\"] = 0] = \"ZIP_ER_OK\";\n    Errors[Errors[\"ZIP_ER_MULTIDISK\"] = 1] = \"ZIP_ER_MULTIDISK\";\n    Errors[Errors[\"ZIP_ER_RENAME\"] = 2] = \"ZIP_ER_RENAME\";\n    Errors[Errors[\"ZIP_ER_CLOSE\"] = 3] = \"ZIP_ER_CLOSE\";\n    Errors[Errors[\"ZIP_ER_SEEK\"] = 4] = \"ZIP_ER_SEEK\";\n    Errors[Errors[\"ZIP_ER_READ\"] = 5] = \"ZIP_ER_READ\";\n    Errors[Errors[\"ZIP_ER_WRITE\"] = 6] = \"ZIP_ER_WRITE\";\n    Errors[Errors[\"ZIP_ER_CRC\"] = 7] = \"ZIP_ER_CRC\";\n    Errors[Errors[\"ZIP_ER_ZIPCLOSED\"] = 8] = \"ZIP_ER_ZIPCLOSED\";\n    Errors[Errors[\"ZIP_ER_NOENT\"] = 9] = \"ZIP_ER_NOENT\";\n    Errors[Errors[\"ZIP_ER_EXISTS\"] = 10] = \"ZIP_ER_EXISTS\";\n    Errors[Errors[\"ZIP_ER_OPEN\"] = 11] = \"ZIP_ER_OPEN\";\n    Errors[Errors[\"ZIP_ER_TMPOPEN\"] = 12] = \"ZIP_ER_TMPOPEN\";\n    Errors[Errors[\"ZIP_ER_ZLIB\"] = 13] = \"ZIP_ER_ZLIB\";\n    Errors[Errors[\"ZIP_ER_MEMORY\"] = 14] = \"ZIP_ER_MEMORY\";\n    Errors[Errors[\"ZIP_ER_CHANGED\"] = 15] = \"ZIP_ER_CHANGED\";\n    Errors[Errors[\"ZIP_ER_COMPNOTSUPP\"] = 16] = \"ZIP_ER_COMPNOTSUPP\";\n    Errors[Errors[\"ZIP_ER_EOF\"] = 17] = \"ZIP_ER_EOF\";\n    Errors[Errors[\"ZIP_ER_INVAL\"] = 18] = \"ZIP_ER_INVAL\";\n    Errors[Errors[\"ZIP_ER_NOZIP\"] = 19] = \"ZIP_ER_NOZIP\";\n    Errors[Errors[\"ZIP_ER_INTERNAL\"] = 20] = \"ZIP_ER_INTERNAL\";\n    Errors[Errors[\"ZIP_ER_INCONS\"] = 21] = \"ZIP_ER_INCONS\";\n    Errors[Errors[\"ZIP_ER_REMOVE\"] = 22] = \"ZIP_ER_REMOVE\";\n    Errors[Errors[\"ZIP_ER_DELETED\"] = 23] = \"ZIP_ER_DELETED\";\n    Errors[Errors[\"ZIP_ER_ENCRNOTSUPP\"] = 24] = \"ZIP_ER_ENCRNOTSUPP\";\n    Errors[Errors[\"ZIP_ER_RDONLY\"] = 25] = \"ZIP_ER_RDONLY\";\n    Errors[Errors[\"ZIP_ER_NOPASSWD\"] = 26] = \"ZIP_ER_NOPASSWD\";\n    Errors[Errors[\"ZIP_ER_WRONGPASSWD\"] = 27] = \"ZIP_ER_WRONGPASSWD\";\n    Errors[Errors[\"ZIP_ER_OPNOTSUPP\"] = 28] = \"ZIP_ER_OPNOTSUPP\";\n    Errors[Errors[\"ZIP_ER_INUSE\"] = 29] = \"ZIP_ER_INUSE\";\n    Errors[Errors[\"ZIP_ER_TELL\"] = 30] = \"ZIP_ER_TELL\";\n    Errors[Errors[\"ZIP_ER_COMPRESSED_DATA\"] = 31] = \"ZIP_ER_COMPRESSED_DATA\";\n})(Errors = exports.Errors || (exports.Errors = {}));\nconst makeInterface = (emZip) => ({\n    // Those are getters because they can change after memory growth\n    get HEAP8() {\n        return emZip.HEAP8;\n    },\n    get HEAPU8() {\n        return emZip.HEAPU8;\n    },\n    errors: Errors,\n    SEEK_SET: 0,\n    SEEK_CUR: 1,\n    SEEK_END: 2,\n    ZIP_CHECKCONS: 4,\n    ZIP_EXCL: 2,\n    ZIP_RDONLY: 16,\n    ZIP_FL_OVERWRITE: 8192,\n    ZIP_FL_COMPRESSED: 4,\n    ZIP_OPSYS_DOS: 0x00,\n    ZIP_OPSYS_AMIGA: 0x01,\n    ZIP_OPSYS_OPENVMS: 0x02,\n    ZIP_OPSYS_UNIX: 0x03,\n    ZIP_OPSYS_VM_CMS: 0x04,\n    ZIP_OPSYS_ATARI_ST: 0x05,\n    ZIP_OPSYS_OS_2: 0x06,\n    ZIP_OPSYS_MACINTOSH: 0x07,\n    ZIP_OPSYS_Z_SYSTEM: 0x08,\n    ZIP_OPSYS_CPM: 0x09,\n    ZIP_OPSYS_WINDOWS_NTFS: 0x0a,\n    ZIP_OPSYS_MVS: 0x0b,\n    ZIP_OPSYS_VSE: 0x0c,\n    ZIP_OPSYS_ACORN_RISC: 0x0d,\n    ZIP_OPSYS_VFAT: 0x0e,\n    ZIP_OPSYS_ALTERNATE_MVS: 0x0f,\n    ZIP_OPSYS_BEOS: 0x10,\n    ZIP_OPSYS_TANDEM: 0x11,\n    ZIP_OPSYS_OS_400: 0x12,\n    ZIP_OPSYS_OS_X: 0x13,\n    ZIP_CM_DEFAULT: -1,\n    ZIP_CM_STORE: 0,\n    ZIP_CM_DEFLATE: 8,\n    uint08S: emZip._malloc(1),\n    uint16S: emZip._malloc(2),\n    uint32S: emZip._malloc(4),\n    uint64S: emZip._malloc(8),\n    malloc: emZip._malloc,\n    free: emZip._free,\n    getValue: emZip.getValue,\n    openFromSource: emZip.cwrap(`zip_open_from_source`, `number`, [`number`, `number`, `number`]),\n    close: emZip.cwrap(`zip_close`, `number`, [`number`]),\n    discard: emZip.cwrap(`zip_discard`, null, [`number`]),\n    getError: emZip.cwrap(`zip_get_error`, `number`, [`number`]),\n    getName: emZip.cwrap(`zip_get_name`, `string`, [`number`, `number`, `number`]),\n    getNumEntries: emZip.cwrap(`zip_get_num_entries`, `number`, [`number`, `number`]),\n    delete: emZip.cwrap(`zip_delete`, `number`, [`number`, `number`]),\n    stat: emZip.cwrap(`zip_stat`, `number`, [`number`, `string`, `number`, `number`]),\n    statIndex: emZip.cwrap(`zip_stat_index`, `number`, [`number`, ...number64, `number`, `number`]),\n    fopen: emZip.cwrap(`zip_fopen`, `number`, [`number`, `string`, `number`]),\n    fopenIndex: emZip.cwrap(`zip_fopen_index`, `number`, [`number`, ...number64, `number`]),\n    fread: emZip.cwrap(`zip_fread`, `number`, [`number`, `number`, `number`, `number`]),\n    fclose: emZip.cwrap(`zip_fclose`, `number`, [`number`]),\n    dir: {\n        add: emZip.cwrap(`zip_dir_add`, `number`, [`number`, `string`]),\n    },\n    file: {\n        add: emZip.cwrap(`zip_file_add`, `number`, [`number`, `string`, `number`, `number`]),\n        getError: emZip.cwrap(`zip_file_get_error`, `number`, [`number`]),\n        getExternalAttributes: emZip.cwrap(`zip_file_get_external_attributes`, `number`, [`number`, ...number64, `number`, `number`, `number`]),\n        setExternalAttributes: emZip.cwrap(`zip_file_set_external_attributes`, `number`, [`number`, ...number64, `number`, `number`, `number`]),\n        setMtime: emZip.cwrap(`zip_file_set_mtime`, `number`, [`number`, ...number64, `number`, `number`]),\n        setCompression: emZip.cwrap(`zip_set_file_compression`, `number`, [`number`, ...number64, `number`, `number`]),\n    },\n    ext: {\n        countSymlinks: emZip.cwrap(`zip_ext_count_symlinks`, `number`, [`number`]),\n    },\n    error: {\n        initWithCode: emZip.cwrap(`zip_error_init_with_code`, null, [`number`, `number`]),\n        strerror: emZip.cwrap(`zip_error_strerror`, `string`, [`number`]),\n    },\n    name: {\n        locate: emZip.cwrap(`zip_name_locate`, `number`, [`number`, `string`, `number`]),\n    },\n    source: {\n        fromUnattachedBuffer: emZip.cwrap(`zip_source_buffer_create`, `number`, [`number`, ...number64, `number`, `number`]),\n        fromBuffer: emZip.cwrap(`zip_source_buffer`, `number`, [`number`, `number`, ...number64, `number`]),\n        free: emZip.cwrap(`zip_source_free`, null, [`number`]),\n        keep: emZip.cwrap(`zip_source_keep`, null, [`number`]),\n        open: emZip.cwrap(`zip_source_open`, `number`, [`number`]),\n        close: emZip.cwrap(`zip_source_close`, `number`, [`number`]),\n        seek: emZip.cwrap(`zip_source_seek`, `number`, [`number`, ...number64, `number`]),\n        tell: emZip.cwrap(`zip_source_tell`, `number`, [`number`]),\n        read: emZip.cwrap(`zip_source_read`, `number`, [`number`, `number`, `number`]),\n        error: emZip.cwrap(`zip_source_error`, `number`, [`number`]),\n        setMtime: emZip.cwrap(`zip_source_set_mtime`, `number`, [`number`, `number`]),\n    },\n    struct: {\n        stat: emZip.cwrap(`zipstruct_stat`, `number`, []),\n        statS: emZip.cwrap(`zipstruct_statS`, `number`, []),\n        statName: emZip.cwrap(`zipstruct_stat_name`, `string`, [`number`]),\n        statIndex: emZip.cwrap(`zipstruct_stat_index`, `number`, [`number`]),\n        statSize: emZip.cwrap(`zipstruct_stat_size`, `number`, [`number`]),\n        statCompSize: emZip.cwrap(`zipstruct_stat_comp_size`, `number`, [`number`]),\n        statCompMethod: emZip.cwrap(`zipstruct_stat_comp_method`, `number`, [`number`]),\n        statMtime: emZip.cwrap(`zipstruct_stat_mtime`, `number`, [`number`]),\n        statCrc: emZip.cwrap(`zipstruct_stat_crc`, `number`, [`number`]),\n        error: emZip.cwrap(`zipstruct_error`, `number`, []),\n        errorS: emZip.cwrap(`zipstruct_errorS`, `number`, []),\n        errorCodeZip: emZip.cwrap(`zipstruct_error_code_zip`, `number`, [`number`]),\n    },\n});\nexports.makeInterface = makeInterface;\n\n\n/***/ }),\n\n/***/ 650:\n/***/ ((__unused_webpack_module, exports, __webpack_require__) => {\n\n\"use strict\";\n\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.mountMemoryDrive = void 0;\nconst tslib_1 = __webpack_require__(240);\nconst fslib_1 = __webpack_require__(382);\nconst fs_1 = tslib_1.__importDefault(__webpack_require__(147));\nconst ZipFS_1 = __webpack_require__(154);\nfunction mountMemoryDrive(origFs, mountPoint, source = Buffer.alloc(0), opts) {\n    const archive = new ZipFS_1.ZipFS(source);\n    const getMountPoint = (p) => {\n        const detectedMountPoint = p === mountPoint || p.startsWith(`${mountPoint}/`) ? p.slice(0, mountPoint.length) : null;\n        return detectedMountPoint;\n    };\n    const factoryPromise = async (baseFs, p) => {\n        return () => archive;\n    };\n    const factorySync = (baseFs, p) => {\n        return archive;\n    };\n    // We must copy the fs into a local, because otherwise\n    // 1. we would make the NodeFS instance use the function that we patched (infinite loop)\n    // 2. Object.create(fs) isn't enough, since it won't prevent the proto from being modified\n    const localFs = { ...origFs };\n    const nodeFs = new fslib_1.NodeFS(localFs);\n    const mountFs = new fslib_1.MountFS({\n        baseFs: nodeFs,\n        getMountPoint,\n        factoryPromise,\n        factorySync,\n        magicByte: 21,\n        maxAge: Infinity,\n        typeCheck: opts === null || opts === void 0 ? void 0 : opts.typeCheck,\n    });\n    (0, fslib_1.patchFs)(fs_1.default, new fslib_1.PosixFS(mountFs));\n    return archive;\n}\nexports.mountMemoryDrive = mountMemoryDrive;\n\n\n/***/ }),\n\n/***/ 32:\n/***/ ((__unused_webpack_module, exports, __webpack_require__) => {\n\n\"use strict\";\n\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.getLibzipPromise = exports.getLibzipSync = void 0;\nconst tslib_1 = __webpack_require__(240);\nconst instance_1 = __webpack_require__(309);\nconst libzipSync_1 = tslib_1.__importDefault(__webpack_require__(161));\nconst makeInterface_1 = __webpack_require__(815);\ntslib_1.__exportStar(__webpack_require__(763), exports);\n(0, instance_1.setFactory)(() => {\n    const emZip = (0, libzipSync_1.default)();\n    return (0, makeInterface_1.makeInterface)(emZip);\n});\nfunction getLibzipSync() {\n    return (0, instance_1.getInstance)();\n}\nexports.getLibzipSync = getLibzipSync;\nasync function getLibzipPromise() {\n    return (0, instance_1.getInstance)();\n}\nexports.getLibzipPromise = getLibzipPromise;\n\n\n/***/ }),\n\n/***/ 240:\n/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {\n\n\"use strict\";\n__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"__assign\": () => (/* binding */ __assign),\n/* harmony export */   \"__asyncDelegator\": () => (/* binding */ __asyncDelegator),\n/* harmony export */   \"__asyncGenerator\": () => (/* binding */ __asyncGenerator),\n/* harmony export */   \"__asyncValues\": () => (/* binding */ __asyncValues),\n/* harmony export */   \"__await\": () => (/* binding */ __await),\n/* harmony export */   \"__awaiter\": () => (/* binding */ __awaiter),\n/* harmony export */   \"__classPrivateFieldGet\": () => (/* binding */ __classPrivateFieldGet),\n/* harmony export */   \"__classPrivateFieldIn\": () => (/* binding */ __classPrivateFieldIn),\n/* harmony export */   \"__classPrivateFieldSet\": () => (/* binding */ __classPrivateFieldSet),\n/* harmony export */   \"__createBinding\": () => (/* binding */ __createBinding),\n/* harmony export */   \"__decorate\": () => (/* binding */ __decorate),\n/* harmony export */   \"__esDecorate\": () => (/* binding */ __esDecorate),\n/* harmony export */   \"__exportStar\": () => (/* binding */ __exportStar),\n/* harmony export */   \"__extends\": () => (/* binding */ __extends),\n/* harmony export */   \"__generator\": () => (/* binding */ __generator),\n/* harmony export */   \"__importDefault\": () => (/* binding */ __importDefault),\n/* harmony export */   \"__importStar\": () => (/* binding */ __importStar),\n/* harmony export */   \"__makeTemplateObject\": () => (/* binding */ __makeTemplateObject),\n/* harmony export */   \"__metadata\": () => (/* binding */ __metadata),\n/* harmony export */   \"__param\": () => (/* binding */ __param),\n/* harmony export */   \"__propKey\": () => (/* binding */ __propKey),\n/* harmony export */   \"__read\": () => (/* binding */ __read),\n/* harmony export */   \"__rest\": () => (/* binding */ __rest),\n/* harmony export */   \"__runInitializers\": () => (/* binding */ __runInitializers),\n/* harmony export */   \"__setFunctionName\": () => (/* binding */ __setFunctionName),\n/* harmony export */   \"__spread\": () => (/* binding */ __spread),\n/* harmony export */   \"__spreadArray\": () => (/* binding */ __spreadArray),\n/* harmony export */   \"__spreadArrays\": () => (/* binding */ __spreadArrays),\n/* harmony export */   \"__values\": () => (/* binding */ __values)\n/* harmony export */ });\n/******************************************************************************\r\nCopyright (c) Microsoft Corporation.\r\n\r\nPermission to use, copy, modify, and/or distribute this software for any\r\npurpose with or without fee is hereby granted.\r\n\r\nTHE SOFTWARE IS PROVIDED \"AS IS\" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH\r\nREGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY\r\nAND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,\r\nINDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM\r\nLOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR\r\nOTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR\r\nPERFORMANCE OF THIS SOFTWARE.\r\n***************************************************************************** */\r\n/* global Reflect, Promise */\r\n\r\nvar extendStatics = function(d, b) {\r\n    extendStatics = Object.setPrototypeOf ||\r\n        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||\r\n        function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };\r\n    return extendStatics(d, b);\r\n};\r\n\r\nfunction __extends(d, b) {\r\n    if (typeof b !== \"function\" && b !== null)\r\n        throw new TypeError(\"Class extends value \" + String(b) + \" is not a constructor or null\");\r\n    extendStatics(d, b);\r\n    function __() { this.constructor = d; }\r\n    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());\r\n}\r\n\r\nvar __assign = function() {\r\n    __assign = Object.assign || function __assign(t) {\r\n        for (var s, i = 1, n = arguments.length; i < n; i++) {\r\n            s = arguments[i];\r\n            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];\r\n        }\r\n        return t;\r\n    }\r\n    return __assign.apply(this, arguments);\r\n}\r\n\r\nfunction __rest(s, e) {\r\n    var t = {};\r\n    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)\r\n        t[p] = s[p];\r\n    if (s != null && typeof Object.getOwnPropertySymbols === \"function\")\r\n        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {\r\n            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))\r\n                t[p[i]] = s[p[i]];\r\n        }\r\n    return t;\r\n}\r\n\r\nfunction __decorate(decorators, target, key, desc) {\r\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\r\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\r\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\r\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\r\n}\r\n\r\nfunction __param(paramIndex, decorator) {\r\n    return function (target, key) { decorator(target, key, paramIndex); }\r\n}\r\n\r\nfunction __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {\r\n    function accept(f) { if (f !== void 0 && typeof f !== \"function\") throw new TypeError(\"Function expected\"); return f; }\r\n    var kind = contextIn.kind, key = kind === \"getter\" ? \"get\" : kind === \"setter\" ? \"set\" : \"value\";\r\n    var target = !descriptorIn && ctor ? contextIn[\"static\"] ? ctor : ctor.prototype : null;\r\n    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});\r\n    var _, done = false;\r\n    for (var i = decorators.length - 1; i >= 0; i--) {\r\n        var context = {};\r\n        for (var p in contextIn) context[p] = p === \"access\" ? {} : contextIn[p];\r\n        for (var p in contextIn.access) context.access[p] = contextIn.access[p];\r\n        context.addInitializer = function (f) { if (done) throw new TypeError(\"Cannot add initializers after decoration has completed\"); extraInitializers.push(accept(f || null)); };\r\n        var result = (0, decorators[i])(kind === \"accessor\" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);\r\n        if (kind === \"accessor\") {\r\n            if (result === void 0) continue;\r\n            if (result === null || typeof result !== \"object\") throw new TypeError(\"Object expected\");\r\n            if (_ = accept(result.get)) descriptor.get = _;\r\n            if (_ = accept(result.set)) descriptor.set = _;\r\n            if (_ = accept(result.init)) initializers.push(_);\r\n        }\r\n        else if (_ = accept(result)) {\r\n            if (kind === \"field\") initializers.push(_);\r\n            else descriptor[key] = _;\r\n        }\r\n    }\r\n    if (target) Object.defineProperty(target, contextIn.name, descriptor);\r\n    done = true;\r\n};\r\n\r\nfunction __runInitializers(thisArg, initializers, value) {\r\n    var useValue = arguments.length > 2;\r\n    for (var i = 0; i < initializers.length; i++) {\r\n        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);\r\n    }\r\n    return useValue ? value : void 0;\r\n};\r\n\r\nfunction __propKey(x) {\r\n    return typeof x === \"symbol\" ? x : \"\".concat(x);\r\n};\r\n\r\nfunction __setFunctionName(f, name, prefix) {\r\n    if (typeof name === \"symbol\") name = name.description ? \"[\".concat(name.description, \"]\") : \"\";\r\n    return Object.defineProperty(f, \"name\", { configurable: true, value: prefix ? \"\".concat(prefix, \" \", name) : name });\r\n};\r\n\r\nfunction __metadata(metadataKey, metadataValue) {\r\n    if (typeof Reflect === \"object\" && typeof Reflect.metadata === \"function\") return Reflect.metadata(metadataKey, metadataValue);\r\n}\r\n\r\nfunction __awaiter(thisArg, _arguments, P, generator) {\r\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\r\n    return new (P || (P = Promise))(function (resolve, reject) {\r\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\r\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\r\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\r\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\r\n    });\r\n}\r\n\r\nfunction __generator(thisArg, body) {\r\n    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;\r\n    return g = { next: verb(0), \"throw\": verb(1), \"return\": verb(2) }, typeof Symbol === \"function\" && (g[Symbol.iterator] = function() { return this; }), g;\r\n    function verb(n) { return function (v) { return step([n, v]); }; }\r\n    function step(op) {\r\n        if (f) throw new TypeError(\"Generator is already executing.\");\r\n        while (g && (g = 0, op[0] && (_ = 0)), _) try {\r\n            if (f = 1, y && (t = op[0] & 2 ? y[\"return\"] : op[0] ? y[\"throw\"] || ((t = y[\"return\"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;\r\n            if (y = 0, t) op = [op[0] & 2, t.value];\r\n            switch (op[0]) {\r\n                case 0: case 1: t = op; break;\r\n                case 4: _.label++; return { value: op[1], done: false };\r\n                case 5: _.label++; y = op[1]; op = [0]; continue;\r\n                case 7: op = _.ops.pop(); _.trys.pop(); continue;\r\n                default:\r\n                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }\r\n                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }\r\n                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }\r\n                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }\r\n                    if (t[2]) _.ops.pop();\r\n                    _.trys.pop(); continue;\r\n            }\r\n            op = body.call(thisArg, _);\r\n        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }\r\n        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };\r\n    }\r\n}\r\n\r\nvar __createBinding = Object.create ? (function(o, m, k, k2) {\r\n    if (k2 === undefined) k2 = k;\r\n    var desc = Object.getOwnPropertyDescriptor(m, k);\r\n    if (!desc || (\"get\" in desc ? !m.__esModule : desc.writable || desc.configurable)) {\r\n        desc = { enumerable: true, get: function() { return m[k]; } };\r\n    }\r\n    Object.defineProperty(o, k2, desc);\r\n}) : (function(o, m, k, k2) {\r\n    if (k2 === undefined) k2 = k;\r\n    o[k2] = m[k];\r\n});\r\n\r\nfunction __exportStar(m, o) {\r\n    for (var p in m) if (p !== \"default\" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);\r\n}\r\n\r\nfunction __values(o) {\r\n    var s = typeof Symbol === \"function\" && Symbol.iterator, m = s && o[s], i = 0;\r\n    if (m) return m.call(o);\r\n    if (o && typeof o.length === \"number\") return {\r\n        next: function () {\r\n            if (o && i >= o.length) o = void 0;\r\n            return { value: o && o[i++], done: !o };\r\n        }\r\n    };\r\n    throw new TypeError(s ? \"Object is not iterable.\" : \"Symbol.iterator is not defined.\");\r\n}\r\n\r\nfunction __read(o, n) {\r\n    var m = typeof Symbol === \"function\" && o[Symbol.iterator];\r\n    if (!m) return o;\r\n    var i = m.call(o), r, ar = [], e;\r\n    try {\r\n        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);\r\n    }\r\n    catch (error) { e = { error: error }; }\r\n    finally {\r\n        try {\r\n            if (r && !r.done && (m = i[\"return\"])) m.call(i);\r\n        }\r\n        finally { if (e) throw e.error; }\r\n    }\r\n    return ar;\r\n}\r\n\r\n/** @deprecated */\r\nfunction __spread() {\r\n    for (var ar = [], i = 0; i < arguments.length; i++)\r\n        ar = ar.concat(__read(arguments[i]));\r\n    return ar;\r\n}\r\n\r\n/** @deprecated */\r\nfunction __spreadArrays() {\r\n    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;\r\n    for (var r = Array(s), k = 0, i = 0; i < il; i++)\r\n        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)\r\n            r[k] = a[j];\r\n    return r;\r\n}\r\n\r\nfunction __spreadArray(to, from, pack) {\r\n    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {\r\n        if (ar || !(i in from)) {\r\n            if (!ar) ar = Array.prototype.slice.call(from, 0, i);\r\n            ar[i] = from[i];\r\n        }\r\n    }\r\n    return to.concat(ar || Array.prototype.slice.call(from));\r\n}\r\n\r\nfunction __await(v) {\r\n    return this instanceof __await ? (this.v = v, this) : new __await(v);\r\n}\r\n\r\nfunction __asyncGenerator(thisArg, _arguments, generator) {\r\n    if (!Symbol.asyncIterator) throw new TypeError(\"Symbol.asyncIterator is not defined.\");\r\n    var g = generator.apply(thisArg, _arguments || []), i, q = [];\r\n    return i = {}, verb(\"next\"), verb(\"throw\"), verb(\"return\"), i[Symbol.asyncIterator] = function () { return this; }, i;\r\n    function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }\r\n    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }\r\n    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }\r\n    function fulfill(value) { resume(\"next\", value); }\r\n    function reject(value) { resume(\"throw\", value); }\r\n    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }\r\n}\r\n\r\nfunction __asyncDelegator(o) {\r\n    var i, p;\r\n    return i = {}, verb(\"next\"), verb(\"throw\", function (e) { throw e; }), verb(\"return\"), i[Symbol.iterator] = function () { return this; }, i;\r\n    function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }\r\n}\r\n\r\nfunction __asyncValues(o) {\r\n    if (!Symbol.asyncIterator) throw new TypeError(\"Symbol.asyncIterator is not defined.\");\r\n    var m = o[Symbol.asyncIterator], i;\r\n    return m ? m.call(o) : (o = typeof __values === \"function\" ? __values(o) : o[Symbol.iterator](), i = {}, verb(\"next\"), verb(\"throw\"), verb(\"return\"), i[Symbol.asyncIterator] = function () { return this; }, i);\r\n    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }\r\n    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }\r\n}\r\n\r\nfunction __makeTemplateObject(cooked, raw) {\r\n    if (Object.defineProperty) { Object.defineProperty(cooked, \"raw\", { value: raw }); } else { cooked.raw = raw; }\r\n    return cooked;\r\n};\r\n\r\nvar __setModuleDefault = Object.create ? (function(o, v) {\r\n    Object.defineProperty(o, \"default\", { enumerable: true, value: v });\r\n}) : function(o, v) {\r\n    o[\"default\"] = v;\r\n};\r\n\r\nfunction __importStar(mod) {\r\n    if (mod && mod.__esModule) return mod;\r\n    var result = {};\r\n    if (mod != null) for (var k in mod) if (k !== \"default\" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);\r\n    __setModuleDefault(result, mod);\r\n    return result;\r\n}\r\n\r\nfunction __importDefault(mod) {\r\n    return (mod && mod.__esModule) ? mod : { default: mod };\r\n}\r\n\r\nfunction __classPrivateFieldGet(receiver, state, kind, f) {\r\n    if (kind === \"a\" && !f) throw new TypeError(\"Private accessor was defined without a getter\");\r\n    if (typeof state === \"function\" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError(\"Cannot read private member from an object whose class did not declare it\");\r\n    return kind === \"m\" ? f : kind === \"a\" ? f.call(receiver) : f ? f.value : state.get(receiver);\r\n}\r\n\r\nfunction __classPrivateFieldSet(receiver, state, value, kind, f) {\r\n    if (kind === \"m\") throw new TypeError(\"Private method is not writable\");\r\n    if (kind === \"a\" && !f) throw new TypeError(\"Private accessor was defined without a setter\");\r\n    if (typeof state === \"function\" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError(\"Cannot write private member to an object whose class did not declare it\");\r\n    return (kind === \"a\" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;\r\n}\r\n\r\nfunction __classPrivateFieldIn(state, receiver) {\r\n    if (receiver === null || (typeof receiver !== \"object\" && typeof receiver !== \"function\")) throw new TypeError(\"Cannot use 'in' operator on non-object\");\r\n    return typeof state === \"function\" ? receiver === state : state.has(receiver);\r\n}\r\n\n\n/***/ }),\n\n/***/ 113:\n/***/ ((module) => {\n\n\"use strict\";\nmodule.exports = require(\"crypto\");\n\n/***/ }),\n\n/***/ 361:\n/***/ ((module) => {\n\n\"use strict\";\nmodule.exports = require(\"events\");\n\n/***/ }),\n\n/***/ 147:\n/***/ ((module) => {\n\n\"use strict\";\nmodule.exports = require(\"fs\");\n\n/***/ }),\n\n/***/ 37:\n/***/ ((module) => {\n\n\"use strict\";\nmodule.exports = require(\"os\");\n\n/***/ }),\n\n/***/ 17:\n/***/ ((module) => {\n\n\"use strict\";\nmodule.exports = require(\"path\");\n\n/***/ }),\n\n/***/ 521:\n/***/ ((module) => {\n\n\"use strict\";\nmodule.exports = require(\"readline\");\n\n/***/ }),\n\n/***/ 955:\n/***/ ((module) => {\n\n\"use strict\";\nmodule.exports = require(\"stream\");\n\n/***/ }),\n\n/***/ 310:\n/***/ ((module) => {\n\n\"use strict\";\nmodule.exports = require(\"url\");\n\n/***/ }),\n\n/***/ 837:\n/***/ ((module) => {\n\n\"use strict\";\nmodule.exports = require(\"util\");\n\n/***/ }),\n\n/***/ 796:\n/***/ ((module) => {\n\n\"use strict\";\nmodule.exports = require(\"zlib\");\n\n/***/ })\n\n/******/ \t});\n/************************************************************************/\n/******/ \t// The module cache\n/******/ \tvar __webpack_module_cache__ = {};\n/******/ \t\n/******/ \t// The require function\n/******/ \tfunction __webpack_require__(moduleId) {\n/******/ \t\t// Check if module is in cache\n/******/ \t\tvar cachedModule = __webpack_module_cache__[moduleId];\n/******/ \t\tif (cachedModule !== undefined) {\n/******/ \t\t\treturn cachedModule.exports;\n/******/ \t\t}\n/******/ \t\t// Create a new module (and put it into the cache)\n/******/ \t\tvar module = __webpack_module_cache__[moduleId] = {\n/******/ \t\t\t// no module.id needed\n/******/ \t\t\t// no module.loaded needed\n/******/ \t\t\texports: {}\n/******/ \t\t};\n/******/ \t\n/******/ \t\t// Execute the module function\n/******/ \t\t__webpack_modules__[moduleId](module, module.exports, __webpack_require__);\n/******/ \t\n/******/ \t\t// Return the exports of the module\n/******/ \t\treturn module.exports;\n/******/ \t}\n/******/ \t\n/************************************************************************/\n/******/ \t/* webpack/runtime/define property getters */\n/******/ \t(() => {\n/******/ \t\t// define getter functions for harmony exports\n/******/ \t\t__webpack_require__.d = (exports, definition) => {\n/******/ \t\t\tfor(var key in definition) {\n/******/ \t\t\t\tif(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {\n/******/ \t\t\t\t\tObject.defineProperty(exports, key, { enumerable: true, get: definition[key] });\n/******/ \t\t\t\t}\n/******/ \t\t\t}\n/******/ \t\t};\n/******/ \t})();\n/******/ \t\n/******/ \t/* webpack/runtime/hasOwnProperty shorthand */\n/******/ \t(() => {\n/******/ \t\t__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))\n/******/ \t})();\n/******/ \t\n/******/ \t/* webpack/runtime/make namespace object */\n/******/ \t(() => {\n/******/ \t\t// define __esModule on exports\n/******/ \t\t__webpack_require__.r = (exports) => {\n/******/ \t\t\tif(typeof Symbol !== 'undefined' && Symbol.toStringTag) {\n/******/ \t\t\t\tObject.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });\n/******/ \t\t\t}\n/******/ \t\t\tObject.defineProperty(exports, '__esModule', { value: true });\n/******/ \t\t};\n/******/ \t})();\n/******/ \t\n/************************************************************************/\nvar __webpack_exports__ = {};\n// This entry need to be wrapped in an IIFE because it need to be in strict mode.\n(() => {\n\"use strict\";\n// ESM COMPAT FLAG\n__webpack_require__.r(__webpack_exports__);\n\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"restoreFs\": () => (/* binding */ restoreFs),\n  \"shimFs\": () => (/* binding */ shimFs)\n});\n\n// EXTERNAL MODULE: ./node_modules/@yarnpkg/libzip/lib/sync.js\nvar sync = __webpack_require__(32);\n// EXTERNAL MODULE: ./node_modules/@yarnpkg/fslib/lib/index.js\nvar lib = __webpack_require__(382);\n// EXTERNAL MODULE: external \"path\"\nvar external_path_ = __webpack_require__(17);\n// EXTERNAL MODULE: external \"fs\"\nvar external_fs_ = __webpack_require__(147);\n;// CONCATENATED MODULE: ./src/fs/SnapshotZipFS.ts\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\nconst uniqBy = (arr, pick) => {\n    const seen = new Set();\n    return arr.filter((x) => {\n        const key = pick(x);\n        if (seen.has(key))\n            return false;\n        seen.add(key);\n        return true;\n    });\n};\nfunction uniqReaddir(arr) {\n    return uniqBy(arr, (s) => (typeof s === 'string' ? s : s.name));\n}\nclass SnapshotZipFS extends lib.BasePortableFakeFS {\n    constructor(opts) {\n        super();\n        this.fdMap = new Map();\n        this.nextFd = 3;\n        this.accessPromise = sync.ZipOpenFS.prototype.accessPromise;\n        this.accessSync = sync.ZipOpenFS.prototype.accessSync;\n        this.appendFilePromise = sync.ZipOpenFS.prototype.appendFilePromise;\n        this.appendFileSync = sync.ZipOpenFS.prototype.appendFileSync;\n        this.chmodPromise = sync.ZipOpenFS.prototype.chmodPromise;\n        this.chmodSync = sync.ZipOpenFS.prototype.chmodSync;\n        this.fchmodPromise = sync.ZipOpenFS.prototype.fchmodPromise;\n        this.fchmodSync = sync.ZipOpenFS.prototype.fchmodSync;\n        this.chownPromise = sync.ZipOpenFS.prototype.chownPromise;\n        this.chownSync = sync.ZipOpenFS.prototype.chownSync;\n        this.fchownPromise = sync.ZipOpenFS.prototype.fchownPromise;\n        this.fchownSync = sync.ZipOpenFS.prototype.fchownSync;\n        this.closePromise = sync.ZipOpenFS.prototype.closePromise;\n        this.closeSync = sync.ZipOpenFS.prototype.closeSync;\n        this.createReadStream = sync.ZipOpenFS.prototype.createReadStream;\n        this.createWriteStream = sync.ZipOpenFS.prototype.createWriteStream;\n        this.existsPromise = sync.ZipOpenFS.prototype.existsPromise;\n        this.existsSync = sync.ZipOpenFS.prototype.existsSync;\n        this.fstatPromise = sync.ZipOpenFS.prototype.fstatPromise;\n        this.fstatSync = sync.ZipOpenFS.prototype.fstatSync;\n        this.getExtractHint = sync.ZipOpenFS.prototype.getExtractHint;\n        this.getRealPath = sync.ZipOpenFS.prototype.getRealPath;\n        this.linkPromise = sync.ZipOpenFS.prototype.linkPromise;\n        this.linkSync = sync.ZipOpenFS.prototype.linkSync;\n        this.lstatPromise = sync.ZipOpenFS.prototype.lstatPromise;\n        this.lstatSync = sync.ZipOpenFS.prototype.lstatSync;\n        this.openPromise = sync.ZipOpenFS.prototype.openPromise;\n        this.openSync = sync.ZipOpenFS.prototype.openSync;\n        this.readFilePromise = sync.ZipOpenFS.prototype.readFilePromise;\n        this.readFileSync = sync.ZipOpenFS.prototype.readFileSync;\n        this.readlinkPromise = sync.ZipOpenFS.prototype.readlinkPromise;\n        this.readlinkSync = sync.ZipOpenFS.prototype.readlinkSync;\n        this.readPromise = sync.ZipOpenFS.prototype.readPromise;\n        this.readSync = sync.ZipOpenFS.prototype.readSync;\n        this.renamePromise = sync.ZipOpenFS.prototype.renamePromise;\n        this.renameSync = sync.ZipOpenFS.prototype.renameSync;\n        this.resolve = sync.ZipOpenFS.prototype.resolve;\n        this.statPromise = sync.ZipOpenFS.prototype.statPromise;\n        this.statSync = sync.ZipOpenFS.prototype.statSync;\n        this.symlinkPromise = sync.ZipOpenFS.prototype.symlinkPromise;\n        this.symlinkSync = sync.ZipOpenFS.prototype.symlinkSync;\n        this.truncatePromise = sync.ZipOpenFS.prototype.truncatePromise;\n        this.truncateSync = sync.ZipOpenFS.prototype.truncateSync;\n        this.ftruncatePromise = sync.ZipOpenFS.prototype.ftruncatePromise;\n        this.ftruncateSync = sync.ZipOpenFS.prototype.ftruncateSync;\n        this.unlinkPromise = sync.ZipOpenFS.prototype.unlinkPromise;\n        this.unlinkSync = sync.ZipOpenFS.prototype.unlinkSync;\n        this.unwatchFile = sync.ZipOpenFS.prototype.unwatchFile;\n        this.utimesPromise = sync.ZipOpenFS.prototype.utimesPromise;\n        this.utimesSync = sync.ZipOpenFS.prototype.utimesSync;\n        this.lutimesPromise = sync.ZipOpenFS.prototype.utimesPromise;\n        this.lutimesSync = sync.ZipOpenFS.prototype.utimesSync;\n        this.watch = sync.ZipOpenFS.prototype.watch;\n        this.watchFile = sync.ZipOpenFS.prototype.watchFile;\n        this.writeFilePromise = sync.ZipOpenFS.prototype.writeFilePromise;\n        this.writeFileSync = sync.ZipOpenFS.prototype.writeFileSync;\n        this.writePromise = sync.ZipOpenFS.prototype.writePromise;\n        this.writeSync = sync.ZipOpenFS.prototype.writeSync;\n        // @ts-ignore\n        this.remapFd = sync.ZipOpenFS.prototype.remapFd;\n        this.zipFs = opts.zipFs;\n        this.baseFs = opts.baseFs;\n        this.root = opts.root;\n        this.magic = 0x2a << 24;\n    }\n    makeCallPromise(p, discard, accept, { requireSubpath = true } = {}) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (typeof p !== 'string')\n                return yield discard();\n            const normalizedP = this.resolve(p);\n            const zipInfo = this.findZip(normalizedP);\n            if (!zipInfo)\n                return yield discard();\n            if (requireSubpath && zipInfo.subPath === '/')\n                return yield discard();\n            return yield accept(this.zipFs, zipInfo);\n        });\n    }\n    makeCallSync(p, discard, accept, { requireSubpath = true } = {}) {\n        if (typeof p !== 'string')\n            return discard();\n        const normalizedP = this.resolve(p);\n        const zipInfo = this.findZip(normalizedP);\n        if (!zipInfo)\n            return discard();\n        if (requireSubpath && zipInfo.subPath === '/')\n            return discard();\n        return accept(this.zipFs, Object.assign({ archivePath: '' }, zipInfo));\n    }\n    realpathPromise(p) {\n        return __awaiter(this, void 0, void 0, function* () {\n            return yield this.realpathSync(p);\n        });\n    }\n    realpathSync(p) {\n        return this.makeCallSync(p, () => this.baseFs.realpathSync(p), (zipFs, { subPath }) => {\n            if (zipFs.lstatSync(subPath).isSymbolicLink()) {\n                return zipFs.realpathSync(subPath);\n            }\n            else {\n                // return the original path in case it wasn't under /snapshot, e.g. if it was for a node module - otherwise the node module parent path is the wrong one (and other things resolve relative to that)\n                return p;\n            }\n        });\n    }\n    findZip(p) {\n        p = this.resolve(p);\n        const snapshotPP = lib.npath.toPortablePath('/snapshot');\n        const pathsToTry = Array.from(new Set([\n            p,\n            (0,external_path_.resolve)('/snapshot', p),\n            lib.ppath.resolve(snapshotPP, lib.npath.toPortablePath(lib.npath.relative(lib.npath.fromPortablePath(this.root), lib.npath.fromPortablePath(p)))),\n            lib.ppath.resolve(snapshotPP, lib.npath.toPortablePath(lib.npath.relative((0,external_path_.toNamespacedPath)(lib.npath.fromPortablePath(this.root)), (0,external_path_.toNamespacedPath)(lib.npath.fromPortablePath(p))))),\n            lib.ppath.resolve(snapshotPP, lib.npath.toPortablePath(lib.npath.relative(lib.npath.fromPortablePath(process.cwd()), lib.npath.fromPortablePath(p)))),\n            lib.ppath.resolve(snapshotPP, lib.npath.toPortablePath(lib.npath.relative((0,external_path_.toNamespacedPath)(lib.npath.fromPortablePath(process.cwd())), (0,external_path_.toNamespacedPath)(lib.npath.fromPortablePath(p))))),\n        ]));\n        for (const path of pathsToTry) {\n            const portablePath = lib.npath.toPortablePath(path);\n            if (this.zipFs.existsSync(portablePath)) {\n                return {\n                    subPath: portablePath,\n                };\n            }\n        }\n    }\n    copyFilePromise(sourceP, destP, flags = 0) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const fallback = (sourceFs, sourceP, destFs, destP) => __awaiter(this, void 0, void 0, function* () {\n                if ((flags & external_fs_.constants.COPYFILE_FICLONE_FORCE) !== 0)\n                    throw Object.assign(new Error(`EXDEV: cross-device clone not permitted, copyfile '${sourceP}' -> ${destP}'`), { code: `EXDEV` });\n                if (flags & external_fs_.constants.COPYFILE_EXCL && (yield this.existsPromise(sourceP)))\n                    throw Object.assign(new Error(`EEXIST: file already exists, copyfile '${sourceP}' -> '${destP}'`), { code: `EEXIST` });\n                let content;\n                try {\n                    content = yield sourceFs.readFilePromise(sourceP);\n                }\n                catch (error) {\n                    throw Object.assign(new Error(`EINVAL: invalid argument, copyfile '${sourceP}' -> '${destP}'`), { code: `EINVAL` });\n                }\n                yield destFs.writeFilePromise(destP, content);\n            });\n            return yield this.makeCallPromise(sourceP, () => __awaiter(this, void 0, void 0, function* () {\n                return yield this.baseFs.copyFilePromise(sourceP, destP, flags);\n            }), (zipFsS, { subPath: subPathS }) => __awaiter(this, void 0, void 0, function* () {\n                return yield fallback(zipFsS, subPathS, this.baseFs, destP);\n            }));\n        });\n    }\n    copyFileSync(sourceP, destP, flags = 0) {\n        const fallback = (sourceFs, sourceP, destFs, destP) => {\n            if ((flags & external_fs_.constants.COPYFILE_FICLONE_FORCE) !== 0)\n                throw Object.assign(new Error(`EXDEV: cross-device clone not permitted, copyfile '${sourceP}' -> ${destP}'`), { code: `EXDEV` });\n            if (flags & external_fs_.constants.COPYFILE_EXCL && this.existsSync(sourceP))\n                throw Object.assign(new Error(`EEXIST: file already exists, copyfile '${sourceP}' -> '${destP}'`), { code: `EEXIST` });\n            let content;\n            try {\n                content = sourceFs.readFileSync(sourceP);\n            }\n            catch (error) {\n                throw Object.assign(new Error(`EINVAL: invalid argument, copyfile '${sourceP}' -> '${destP}'`), { code: `EINVAL` });\n            }\n            destFs.writeFileSync(destP, content);\n        };\n        return this.makeCallSync(sourceP, () => {\n            return this.baseFs.copyFileSync(sourceP, destP, flags);\n        }, (zipFsS, { subPath: subPathS }) => {\n            return fallback(zipFsS, subPathS, this.baseFs, destP);\n        });\n    }\n    readdirPromise(p, opts) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const fallback = () => __awaiter(this, void 0, void 0, function* () {\n                return yield this.baseFs.readdirPromise(p, opts);\n            });\n            return yield this.makeCallPromise(p, fallback, (zipFs, { subPath }) => __awaiter(this, void 0, void 0, function* () {\n                const fallbackPaths = yield fallback().catch(() => []);\n                return Promise.resolve(uniqReaddir(fallbackPaths.concat(yield zipFs.readdirPromise(subPath, opts))));\n            }), {\n                requireSubpath: false,\n            });\n        });\n    }\n    readdirSync(p, opts) {\n        const fallback = () => {\n            return this.baseFs.readdirSync(p, opts);\n        };\n        return this.makeCallSync(p, fallback, (zipFs, { subPath }) => {\n            let fallbackPaths = [];\n            try {\n                fallbackPaths = fallback();\n            }\n            catch (e) { }\n            return fallbackPaths.concat(uniqReaddir(zipFs.readdirSync(subPath, opts)));\n        }, {\n            requireSubpath: false,\n        });\n    }\n    mkdirPromise(p, opts) {\n        return __awaiter(this, void 0, void 0, function* () {\n            return yield this.baseFs.mkdirPromise(p, opts);\n        });\n    }\n    mkdirSync(p, opts) {\n        return this.baseFs.mkdirSync(p, opts);\n    }\n    rmdirPromise(p, opts) {\n        return __awaiter(this, void 0, void 0, function* () {\n            return yield this.baseFs.rmdirPromise(p, opts);\n        });\n    }\n    rmdirSync(p, opts) {\n        return this.baseFs.rmdirSync(p, opts);\n    }\n    opendirPromise(p, opts) {\n        return __awaiter(this, void 0, void 0, function* () {\n            return this.opendirSync(p, opts);\n        });\n    }\n    opendirSync(p, opts) {\n        const zipInfo = this.findZip(p);\n        let zipFsDir = null;\n        if (zipInfo) {\n            zipFsDir = this.zipFs.opendirSync(zipInfo.subPath);\n        }\n        let realFsDir = null;\n        try {\n            realFsDir = this.baseFs.opendirSync(p);\n        }\n        catch (e) {\n            if (!zipFsDir)\n                throw e;\n        }\n        const seen = new Set();\n        const nextDirent = () => {\n            const entry = (realFsDir === null || realFsDir === void 0 ? void 0 : realFsDir.readSync()) || (zipFsDir === null || zipFsDir === void 0 ? void 0 : zipFsDir.readSync());\n            if (entry && !seen.has(entry.name)) {\n                seen.add(entry.name);\n                return entry;\n            }\n            return null;\n        };\n        const onClose = () => {\n            zipFsDir === null || zipFsDir === void 0 ? void 0 : zipFsDir.closeSync();\n            realFsDir === null || realFsDir === void 0 ? void 0 : realFsDir.closeSync();\n        };\n        return new lib.CustomDir(p, nextDirent, { onClose });\n    }\n}\n\n;// CONCATENATED MODULE: external \"assert\"\nconst external_assert_namespaceObject = require(\"assert\");\n;// CONCATENATED MODULE: external \"constants\"\nconst external_constants_namespaceObject = require(\"constants\");\n;// CONCATENATED MODULE: ./src/fs/patch.ts\n\n\n\n\n\n\nlet originalFsMethods = null;\nlet lazyRestoreFs = () => { };\nconst patches = process.nexe.patches || {};\nconst originalPatches = Object.assign({}, patches);\ndelete process.nexe;\nfunction shimFs(binary, fs = __webpack_require__(147)) {\n    if (originalFsMethods !== null) {\n        return;\n    }\n    originalFsMethods = Object.assign({}, fs);\n    const realFs = Object.assign({}, fs);\n    const nodeFs = new lib.NodeFS(realFs);\n    const blob = Buffer.allocUnsafe(binary.layout.resourceSize);\n    const blobFd = realFs.openSync(binary.blobPath, 'r');\n    const bytesRead = realFs.readSync(blobFd, blob, 0, binary.layout.resourceSize, binary.layout.resourceStart);\n    external_assert_namespaceObject.equal(bytesRead, binary.layout.resourceSize);\n    const zipFs = new sync.ZipFS(blob, { readOnly: true });\n    const snapshotZipFS = new SnapshotZipFS({\n        libzip: (0,sync.getLibzipSync)(),\n        zipFs,\n        baseFs: nodeFs,\n        root: (0,external_path_.dirname)(process.argv[0]),\n    });\n    const posixSnapshotZipFs = new lib.PosixFS(snapshotZipFS);\n    (0,lib.patchFs)(fs, posixSnapshotZipFs);\n    let log = (_) => true;\n    if ((process.env.DEBUG || '').toLowerCase().includes('nexe:require')) {\n        process.stderr.write(\n        // @ts-ignore\n        `[nexe] - FILES ${JSON.stringify(Array.from(zipFs.entries.keys()), null, 4)}\\n`);\n        process.stderr.write(\n        // @ts-ignore\n        `[nexe] - DIRECTORIES ${JSON.stringify(Array.from(zipFs.listings.keys()), null, 4)}\\n`);\n        log = (text) => {\n            return process.stderr.write(`[nexe] - ${text}\\n`);\n        };\n    }\n    function internalModuleReadFile(original, ...args) {\n        log(`internalModuleReadFile ${args[0]}`);\n        try {\n            return posixSnapshotZipFs.readFileSync(args[0], 'utf-8');\n        }\n        catch (e) {\n            return '';\n        }\n    }\n    if (patches.internalModuleReadFile) {\n        patches.internalModuleReadFile = internalModuleReadFile;\n    }\n    let returningArray;\n    patches.internalModuleReadJSON = function (original, ...args) {\n        if (returningArray == null)\n            returningArray = Array.isArray(original.call(this, ''));\n        const res = internalModuleReadFile.call(this, original, ...args);\n        return returningArray && !Array.isArray(res)\n            ? res === ''\n                ? []\n                : [res, /\"(main|name|type|exports|imports)\"/.test(res)]\n            : res;\n    };\n    patches.internalModuleStat = function (original, ...args) {\n        let statPath = args[0];\n        //in node 22, the path arg moved to arg[1]\n        if (typeof args[0] !== 'string')\n            statPath = args[1];\n        let result = 0;\n        try {\n            const stat = posixSnapshotZipFs.statSync(statPath);\n            if (stat.isDirectory())\n                result = 1;\n            else\n                result = 0;\n        }\n        catch (e) {\n            result = -external_constants_namespaceObject.ENOENT;\n        }\n        log(`internalModuleStat ${result} ${statPath}`);\n        return result;\n    };\n    lazyRestoreFs = () => {\n        Object.assign(fs, originalFsMethods);\n        Object.assign(patches, originalPatches);\n        lazyRestoreFs = () => { };\n    };\n}\nfunction restoreFs() {\n    lazyRestoreFs();\n}\n\n\n})();\n\nmodule.exports = __webpack_exports__;\n/******/ })()\n;\n//# sourceMappingURL=patch.bundle.js.map",
            'return module.exports;',
            '})()',
            'fsPatcher.shimFs(process.__nexe);',
            compiler.options.fs ? '' : 'restoreFs();',
        ].join('\n')
        //TODO support only restoring specific methods
        ));
        compiler.shims.push((0, util_1.wrap)(`
    if (process.argv[1] && process.env.NODE_UNIQUE_ID) {
      const cluster = require('cluster')
      cluster._setupWorker()
      delete process.env.NODE_UNIQUE_ID
    }
  `));
        compiler.shims.push((0, util_1.wrap)(`
      if (!process.send) {
        const path = require('path')
        const entry = path.resolve(path.dirname(process.execPath),${JSON.stringify(compiler.entrypoint)})
        process.argv.splice(1,0, entry)
      }
    `));
    });
}
exports.default = default_1;
