export declare function isScript(code: string): boolean;
export declare function hasModuleGlobs(file: Pick<File, 'package' | 'belongsTo'>): boolean;
export declare function extraGlobs(file: Pick<File, 'package' | 'belongsTo'>): string[];
export declare function nodeModuleGlobs(file: Pick<File, 'package' | 'belongsTo'>, useDefault?: boolean): string[];
export type JsLoaderOptions = {
    loadContent: boolean;
    isEntry: boolean;
    type: 'module' | 'commonjs';
    context?: {
        moduleRoot: string;
        package: any;
        expanded?: boolean;
        globs?: string[];
    };
    expand: 'all' | 'variable' | 'none';
};
export type FileMap = {
    [key: string]: File | null;
};
export type Files = {
    [key: string]: File;
};
export interface File {
    deps: FileMap;
    belongsTo?: File;
    realSize?: number;
    realPath?: string;
    size: number;
    absPath: string;
    moduleType: 'module' | 'commonjs';
    contents: string | null;
    contextExpanded?: boolean;
    variableImports?: boolean;
    moduleRoot?: string;
    package?: any;
}
export declare function isNodeModule(request: string): boolean;
export declare function ensureDottedRelative(from: string, to: string): string;
export declare function createFile(absPath: string): File;
