"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createFile = exports.ensureDottedRelative = exports.isNodeModule = exports.nodeModuleGlobs = exports.extraGlobs = exports.hasModuleGlobs = exports.isScript = void 0;
const path_1 = require("path");
const esmRegex = /(^\s*|[}\);\n]\s*)(import\s*(['"]|(\*\s+as\s+)?(?!type)([^"'\(\)\n; ]+)\s*from\s*['"]|\{)|export\s+\*\s+from\s+["']|export\s*(\{|default|function|class|var|const|let|async\s+function))/, moduleGlob = ['**/*', '!node_modules', '!test', '!**/*.d.ts'];
function isScript(code) {
    return !Boolean(code.match(esmRegex));
}
exports.isScript = isScript;
function hasModuleGlobs(file) {
    return nodeModuleGlobs(file) !== moduleGlob;
}
exports.hasModuleGlobs = hasModuleGlobs;
function extraGlobs(file) {
    var _a, _b, _c, _d;
    const globs = ['**/package.json', '!node_modules'];
    return globs
        .concat(...[((_b = (_a = file.package) === null || _a === void 0 ? void 0 : _a.pkg) === null || _b === void 0 ? void 0 : _b.scripts) || []])
        .concat(...[((_d = (_c = file.package) === null || _c === void 0 ? void 0 : _c.pkg) === null || _d === void 0 ? void 0 : _d.assets) || []]);
}
exports.extraGlobs = extraGlobs;
function nodeModuleGlobs(file, useDefault = true) {
    var _a;
    const normalGlobs = [].concat(...(((_a = file.package) === null || _a === void 0 ? void 0 : _a.files) || []));
    if (useDefault && !normalGlobs.length) {
        return moduleGlob;
    }
    return normalGlobs;
}
exports.nodeModuleGlobs = nodeModuleGlobs;
const notNodeModule = /^\.|^\//;
function isNodeModule(request) {
    return !notNodeModule.test(request);
}
exports.isNodeModule = isNodeModule;
function ensureDottedRelative(from, to) {
    let rel = (0, path_1.relative)(from, to);
    if (!rel.startsWith('.' + path_1.sep)) {
        rel = './' + rel;
    }
    return rel.split(path_1.sep).join('/');
}
exports.ensureDottedRelative = ensureDottedRelative;
function createFile(absPath) {
    return {
        size: 0,
        deps: {},
        absPath,
        moduleType: 'commonjs',
        contents: null,
        variableImports: false,
    };
}
exports.createFile = createFile;
//# sourceMappingURL=data:application/json;base64,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