"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.gatherDependencies = void 0;
const meriyah_1 = require("meriyah");
function isNodeAString(node) {
    return Boolean(node && (node.type === 'Literal' || node.type === 'StringLiteral'));
}
function isRequire(node) {
    return node.callee.type === 'Identifier' && node.callee.name === 'require';
}
function isImport(node) {
    return node.callee.type === 'Import';
}
function walk(node, visit) {
    if (!node || typeof node.type !== 'string' || node._visited) {
        return;
    }
    visit(node);
    node._visited = true;
    for (const childNode in node) {
        const child = node[childNode];
        if (Array.isArray(child)) {
            for (let i = 0; i < child.length; i++) {
                walk(child[i], visit);
            }
        }
        else {
            walk(child, visit);
        }
    }
}
function gatherDependencies(code, isModule) {
    const result = {
        variable: false,
        deps: {},
    };
    if (!code) {
        return result;
    }
    const visit = (node) => {
        if (node.type === 'CallExpression' &&
            (isRequire(node) || isImport(node) || node.type === 'ImportExpression')) {
            const request = node.arguments[0];
            if (isNodeAString(request)) {
                result.deps[request.value] = null;
            }
            else {
                result.variable = true;
            }
        }
        if (node.type === 'ImportDeclaration' && isNodeAString(node.source)) {
            result.deps[node.source.value] = null;
        }
    }, options = {
        globalReturn: true,
        next: true,
        module: isModule,
        specDeviation: true,
    };
    walk((0, meriyah_1.parse)(code, options), visit);
    return result;
}
exports.gatherDependencies = gatherDependencies;
//# sourceMappingURL=data:application/json;base64,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