"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Loader = void 0;
const path_1 = require("path");
const node_builtins_1 = __importDefault(require("./node-builtins"));
const loader = __importStar(require("./node-loader"));
const file_1 = require("./file");
class Loader {
    constructor(options) {
        this.options = options;
    }
    loadEntry(workingDirectory, request, files = {}, warnings = []) {
        const mainFile = (0, file_1.ensureDottedRelative)(workingDirectory, (0, path_1.resolve)(workingDirectory, request));
        const entry = this.load(workingDirectory, mainFile, files, warnings);
        return { entry: entry, files, warnings };
    }
    load(cd, request, files = {}, warnings, context) {
        var _a;
        const options = { ...this.options };
        if (context) {
            Object.assign(options, { context });
        }
        const file = loader.load(cd, request, options);
        if ('warning' in file) {
            warnings.push(file.warning);
            return null;
        }
        if (files[file.absPath] !== undefined) {
            return files[file.absPath];
        }
        else {
            files[file.absPath] = file;
        }
        const packageGlobs = [];
        if (file.moduleRoot && (0, file_1.hasModuleGlobs)(file)) {
            packageGlobs.push(...(0, file_1.nodeModuleGlobs)(file, false));
        }
        if (!packageGlobs.length && (0, file_1.hasModuleGlobs)((file === null || file === void 0 ? void 0 : file.belongsTo) || {})) {
            packageGlobs.push(...(0, file_1.nodeModuleGlobs)(file.belongsTo || {}, false));
        }
        const fileDir = (0, path_1.dirname)(file.absPath), ctx = {
            moduleRoot: file.moduleRoot || ((_a = file.belongsTo) === null || _a === void 0 ? void 0 : _a.moduleRoot) || undefined,
            package: file.package,
            expanded: Boolean(file.contextExpanded),
            globs: packageGlobs,
        }, rejectBuiltins = (req) => {
            if (~node_builtins_1.default.indexOf(req)) {
                file.deps[req] = null;
                return false;
            }
            return true;
        };
        Object.keys(file.deps)
            .sort()
            .filter(rejectBuiltins)
            .map((req) => {
            const dep = (file.deps[req] = this.load(fileDir, req, files, warnings, ctx));
            if (dep) {
                dep.belongsTo = file.moduleRoot ? file : file.belongsTo;
            }
        });
        return file;
    }
}
exports.Loader = Loader;
//# sourceMappingURL=data:application/json;base64,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