"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.load = exports.resolveSync = void 0;
const fs = __importStar(require("fs"));
const fast_glob_1 = require("fast-glob");
const path_1 = require("path");
const gather_deps_1 = require("./gather-deps");
const file_1 = require("./file");
const enhanced_resolve_1 = require("enhanced-resolve");
const { readFileSync, lstatSync, statSync, realpathSync } = fs;
const supportedJsExtensions = ['.js', '.cjs', '.mjs'];
const fileSystem = new enhanced_resolve_1.CachedInputFileSystem(fs, 4000), esmResolver = enhanced_resolve_1.ResolverFactory.createResolver({
    extensions: ['.js', '.cjs', '.mjs', '.json', '.node'],
    conditionNames: ['node', 'import', 'require', 'default'],
    useSyncFileSystemCalls: true,
    symlinks: false,
    fileSystem,
}), cjsResolver = enhanced_resolve_1.ResolverFactory.createResolver({
    extensions: ['.js', '.cjs', '.mjs', '.json', '.node'],
    conditionNames: ['node', 'require', 'default'],
    useSyncFileSystemCalls: true,
    symlinks: false,
    fileSystem,
}), defaultOptions = {
    loadContent: true,
    expand: 'none',
    isEntry: false,
    type: 'commonjs',
};
const ModulesDir = 'node_modules';
function stripControlCharacters(path) {
    return path && path.replace(/[\u0000-\u001F\u007F-\u009F]/g, '');
}
const emptyContext = {}, emptyResolveContext = {};
function resolveSync(from, request, resolver = cjsResolver) {
    const result = {
        absPath: '',
        pkgPath: '',
        pkg: null,
        warning: '',
    };
    resolver.resolve(emptyContext, from, request, emptyResolveContext, (err, path, data) => {
        if (err) {
            result.warning = err.message;
            return;
        }
        result.absPath = stripControlCharacters(path);
        result.pkgPath = stripControlCharacters(data.descriptionFilePath);
        result.pkg = data.descriptionFileData;
        return;
    });
    return result;
}
exports.resolveSync = resolveSync;
async function expand(file, fileDir, baseDir, globs) {
    const files = (0, fast_glob_1.sync)(globs, {
        onlyFiles: true,
        cwd: baseDir,
        followSymbolicLinks: false,
    });
    files
        .sort() //glob search is width first and not deterministic
        .map((dep) => (0, file_1.ensureDottedRelative)(fileDir, (0, path_1.join)(baseDir, dep)))
        .filter((relDep) => file.absPath !== (0, path_1.join)(baseDir, relDep))
        .forEach((relDep) => {
        file.deps[relDep] = file.deps[relDep] || null;
    });
    const currentDeps = Object.keys(file.deps);
    file.package &&
        file.package.dependencies &&
        Object.keys(file.package.dependencies || {}).forEach((dependency) => {
            if (!currentDeps.some((curDep) => curDep.startsWith(dependency))) {
                file.deps[dependency] = file.deps[dependency] || null;
            }
        });
}
function load(workingDirectory, request, options = defaultOptions) {
    var _a;
    const resolver = options.type === 'module' ? esmResolver : cjsResolver, { absPath, pkg, pkgPath, warning } = resolveSync(workingDirectory, request, resolver);
    if (!absPath) {
        return { warning: warning };
    }
    const file = (0, file_1.createFile)(absPath), isJs = options.isEntry || supportedJsExtensions.some((x) => absPath.endsWith(x));
    file.absPath = absPath;
    if (isJs || absPath.endsWith('json')) {
        file.contents = readFileSync(absPath, 'utf-8');
    }
    if (isJs) {
        try {
            const isModule = absPath.endsWith('.mjs') || !(0, file_1.isScript)(file.contents);
            const parseResult = (0, gather_deps_1.gatherDependencies)(file.contents, isModule);
            Object.assign(file.deps, parseResult.deps);
            file.moduleType = isModule ? 'module' : 'commonjs';
            file.variableImports = parseResult.variable;
        }
        catch (e) {
            return { warning: `Error parsing file: "${file.absPath}"\n${e.stack}` };
        }
    }
    const fileDir = (0, path_1.dirname)(file.absPath), expandVariable = Boolean(options.expand === 'variable' && file.variableImports);
    if ((0, file_1.isNodeModule)(request) && pkg && pkgPath) {
        file.package = pkg;
        file.deps[(0, file_1.ensureDottedRelative)(fileDir, pkgPath)] = null;
        const pkgDir = (file.moduleRoot = (0, path_1.dirname)(pkgPath)), expandAll = options.expand === 'all';
        const pkgPathParts = pkgPath.split(ModulesDir);
        const [_, ...pkgRootPrefix] = pkgPathParts.slice().reverse();
        const rootPkgDir = pkgPathParts[pkgRootPrefix.length].split(/\\|\//).filter((x) => x)[0];
        const pkgRoot = (0, path_1.join)(pkgRootPrefix.join(ModulesDir), ModulesDir, rootPkgDir);
        if (expandVariable || expandAll) {
            expand(file, fileDir, pkgDir, (0, file_1.nodeModuleGlobs)(file));
            file.contextExpanded = true;
        }
        expand(file, fileDir, pkgRoot, (0, file_1.extraGlobs)(file));
    }
    else if (expandVariable && ((_a = options.context) === null || _a === void 0 ? void 0 : _a.moduleRoot) && !options.context.expanded) {
        expand(file, fileDir, options.context.moduleRoot, (0, file_1.nodeModuleGlobs)({ package: { files: options.context.globs } }));
        file.contextExpanded = true;
    }
    if (!options.loadContent) {
        file.contents = null;
    }
    const stats = lstatSync(file.absPath);
    if (stats.isSymbolicLink()) {
        const path = realpathSync(file.absPath);
        const absStat = statSync(file.absPath);
        file.realPath = path;
        file.realSize = absStat.size;
    }
    file.size = stats.size;
    return file;
}
exports.load = load;
//# sourceMappingURL=data:application/json;base64,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