"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.normalizeOptions = void 0;
function normalizeOptions(args) {
    const options = {
        entries: [],
        cwd: process.cwd(),
        loadContent: true,
        expand: 'none',
        files: {},
        type: 'commonjs',
    };
    args.forEach((x) => {
        if (typeof x === 'string')
            return options.entries.push(x);
        if (x.cwd)
            options.cwd = x.cwd;
        if (Array.isArray(x.entries))
            options.entries.push(...x.entries);
        if ('expand' in x)
            options.expand = x.expand || 'none';
        if ('loadContent' in x)
            options.loadContent = Boolean(x.loadContent);
        if ('files' in x)
            Object.assign(options.files, x.files);
        if ('type' in x)
            options.type = x.type || 'commonjs';
    });
    options.entries = Array.from(new Set(options.entries));
    if (!options.entries.length) {
        try {
            options.entries.push(require.resolve(options.cwd));
        }
        catch (e) {
            throw new Error('No entry file found');
        }
    }
    return options;
}
exports.normalizeOptions = normalizeOptions;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoib3B0aW9ucy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9vcHRpb25zLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQWFBLFNBQWdCLGdCQUFnQixDQUFDLElBQTJDO0lBQzFFLE1BQU0sT0FBTyxHQUFzQjtRQUNqQyxPQUFPLEVBQUUsRUFBYztRQUN2QixHQUFHLEVBQUUsT0FBTyxDQUFDLEdBQUcsRUFBRTtRQUNsQixXQUFXLEVBQUUsSUFBSTtRQUNqQixNQUFNLEVBQUUsTUFBbUI7UUFDM0IsS0FBSyxFQUFFLEVBQWE7UUFDcEIsSUFBSSxFQUFFLFVBQVU7S0FDakIsQ0FBQTtJQUVELElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRTtRQUNqQixJQUFJLE9BQU8sQ0FBQyxLQUFLLFFBQVE7WUFBRSxPQUFPLE9BQU8sQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFBO1FBQ3pELElBQUksQ0FBQyxDQUFDLEdBQUc7WUFBRSxPQUFPLENBQUMsR0FBRyxHQUFHLENBQUMsQ0FBQyxHQUFHLENBQUE7UUFDOUIsSUFBSSxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUM7WUFBRSxPQUFPLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQyxPQUFPLENBQUMsQ0FBQTtRQUNoRSxJQUFJLFFBQVEsSUFBSSxDQUFDO1lBQUUsT0FBTyxDQUFDLE1BQU0sR0FBRyxDQUFDLENBQUMsTUFBTSxJQUFJLE1BQU0sQ0FBQTtRQUN0RCxJQUFJLGFBQWEsSUFBSSxDQUFDO1lBQUUsT0FBTyxDQUFDLFdBQVcsR0FBRyxPQUFPLENBQUMsQ0FBQyxDQUFDLFdBQVcsQ0FBQyxDQUFBO1FBQ3BFLElBQUksT0FBTyxJQUFJLENBQUM7WUFBRSxNQUFNLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxLQUFLLEVBQUUsQ0FBQyxDQUFDLEtBQUssQ0FBQyxDQUFBO1FBQ3ZELElBQUksTUFBTSxJQUFJLENBQUM7WUFBRSxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsQ0FBQyxJQUFJLElBQUksVUFBVSxDQUFBO0lBQ3RELENBQUMsQ0FBQyxDQUFBO0lBRUYsT0FBTyxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDLElBQUksR0FBRyxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFBO0lBRXRELElBQUksQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLE1BQU0sRUFBRTtRQUMzQixJQUFJO1lBQ0YsT0FBTyxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQTtTQUNuRDtRQUFDLE9BQU8sQ0FBQyxFQUFFO1lBQ1YsTUFBTSxJQUFJLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyxDQUFBO1NBQ3ZDO0tBQ0Y7SUFDRCxPQUFPLE9BQU8sQ0FBQTtBQUNoQixDQUFDO0FBOUJELDRDQThCQyJ9