"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveEntries = exports.resolveSync = void 0;
const loader_1 = require("./loader");
const options_1 = require("./options");
const node_loader_1 = require("./node-loader");
Object.defineProperty(exports, "resolveSync", { enumerable: true, get: function () { return node_loader_1.resolveSync; } });
function resolveEntries(...options) {
    const opts = (0, options_1.normalizeOptions)(options), loader = new loader_1.Loader(opts), res = opts.entries.map((request) => loader.loadEntry(opts.cwd, request, opts.files)), warnings = [], entries = opts.entries.sort().reduce((entryMap, entry, i) => {
        entryMap[entry] = res[i].entry;
        warnings.push(...res[i].warnings);
        return entryMap;
    }, {}), files = opts.files;
    return { files: files, entries, warnings };
}
exports.default = resolveEntries;
exports.resolveEntries = resolveEntries;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVzb2x2ZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9yZXNvbHZlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHFDQUFpQztBQUVqQyx1Q0FBK0Q7QUFDL0QsK0NBQTJDO0FBcUJyQiw0RkFyQmIseUJBQVcsT0FxQmE7QUFuQmpDLFNBQXdCLGNBQWMsQ0FBQyxHQUFHLE9BQWdEO0lBS3hGLE1BQU0sSUFBSSxHQUFHLElBQUEsMEJBQWdCLEVBQUMsT0FBTyxDQUFDLEVBQ3BDLE1BQU0sR0FBRyxJQUFJLGVBQU0sQ0FBQyxJQUFJLENBQUMsRUFDekIsR0FBRyxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLENBQUMsT0FBTyxFQUFFLEVBQUUsQ0FBQyxNQUFNLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxHQUFHLEVBQUUsT0FBTyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxFQUNwRixRQUFRLEdBQWEsRUFBRSxFQUN2QixPQUFPLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEVBQUUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxRQUFRLEVBQUUsS0FBSyxFQUFFLENBQUMsRUFBRSxFQUFFO1FBQzFELFFBQVEsQ0FBQyxLQUFLLENBQUMsR0FBRyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBYSxDQUFBO1FBQ3RDLFFBQVEsQ0FBQyxJQUFJLENBQUMsR0FBRyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsUUFBUSxDQUFDLENBQUE7UUFDakMsT0FBTyxRQUFRLENBQUE7SUFDakIsQ0FBQyxFQUFFLEVBQTBCLENBQUMsRUFDOUIsS0FBSyxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUE7SUFFcEIsT0FBTyxFQUFFLEtBQUssRUFBRSxLQUFjLEVBQUUsT0FBTyxFQUFFLFFBQVEsRUFBRSxDQUFBO0FBQ3JELENBQUM7QUFqQkQsaUNBaUJDO0FBRWtDLHdDQUFjIn0=