import { Configuration as WebpackConfiguration } from 'webpack';
interface FullNodeLibraryOptions extends Pick<WebpackConfiguration, 'entry'> {
    /** We only support a single string at the moment, not arrays, functions, or anything else allowed by webpack */
    entry: string;
    outputFilepath: string;
    /** Enable .ts, .tsx, and .jsx files */
    enableTypescript: boolean;
    /** Emit a sourcemap */
    sourceMap: boolean;
    /** Use source-map-loader to parse input sourcemaps */
    ingestSourceMaps: boolean;
    /** external modules to exclude from bundling */
    noBundle: Array<string>;
    /**
     * Set to false to disable minification and preserve readability of the
     * bundle.
     * Sets `optimization: {minimize: false}`
     */
    minimize: boolean;
}
declare const defaultOptions: {
    entry: string;
    outputFilepath: string;
    enableTypescript: boolean;
    sourceMap: boolean;
    noBundle: never[];
    ingestSourceMaps: boolean;
    minimize: boolean;
};
declare type NodeLibraryOptions = {
    [K in Extract<keyof FullNodeLibraryOptions, keyof typeof defaultOptions>]?: FullNodeLibraryOptions[K];
} & {
    [K in Exclude<keyof FullNodeLibraryOptions, keyof typeof defaultOptions>]: FullNodeLibraryOptions[K];
};
/** We only need a few fields from the `module` object. */
declare type NodeJSModuleFields = {
    filename: string;
};
/**
 * Sensible webpack configuration for bundling a node library into a single file.
 *
 * Usage: module.exports = nodeLibrary(module, {/* override defaults here * /});
 *
 * The first argument is your `module` object, which is a convenient way for us to
 * get your `__dirname` and perhaps other bits of metadata in the future.
 */
export declare function nodeLibrary(module: NodeJSModuleFields, options: NodeLibraryOptions): WebpackConfiguration;
export {};
//# sourceMappingURL=index.d.ts.map