"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var path_1 = tslib_1.__importDefault(require("path"));
var fs_1 = tslib_1.__importDefault(require("fs"));
var webpack_1 = require("webpack");
var lodash_1 = require("lodash");
var defaultOptions = {
    entry: './src/index.ts',
    outputFilepath: './dist/bundle.js',
    enableTypescript: true,
    sourceMap: true,
    noBundle: [],
    ingestSourceMaps: true,
    minimize: true
};
var _assertDefaultsHaveCorrectPropertyNames = null;
/**
 * Sensible webpack configuration for bundling a node library into a single file.
 *
 * Usage: module.exports = nodeLibrary(module, {/* override defaults here * /});
 *
 * The first argument is your `module` object, which is a convenient way for us to
 * get your `__dirname` and perhaps other bits of metadata in the future.
 */
function nodeLibrary(module, options) {
    var __dirname = path_1.default.dirname(module.filename);
    var opts = tslib_1.__assign(tslib_1.__assign({}, defaultOptions), options);
    var enableTypescript = opts.enableTypescript, entry = opts.entry, outputFilepath = opts.outputFilepath, sourceMap = opts.sourceMap, noBundle = opts.noBundle, ingestSourceMaps = opts.ingestSourceMaps, minimize = opts.minimize;
    var entryAbs = path_1.default.resolve(__dirname, entry);
    var outputFilepathAbs = path_1.default.resolve(__dirname, outputFilepath);
    var outputDir = path_1.default.dirname(outputFilepathAbs);
    var outputName = path_1.default.basename(outputFilepathAbs);
    // Detect entry-point shebang
    var shebang = fs_1.default.readFileSync(entryAbs, 'utf8').split('\n')[0];
    var nodeRequireBoilerplate = 'var __node_require__ = require, __node_module__ = module;';
    var bannerPlugin = shebang.slice(0, 2) === '#!'
        ? [new webpack_1.BannerPlugin({ banner: shebang + "\n" + nodeRequireBoilerplate, raw: true })]
        : [new webpack_1.BannerPlugin({ banner: nodeRequireBoilerplate, raw: true })];
    // TODO add __rootname
    // TODO copy from my npm-pwsh and strip-ts-types configs
    var config = {
        target: 'node',
        context: __dirname,
        entry: entry,
        output: {
            path: outputDir,
            filename: outputName,
            libraryTarget: "commonjs2",
            // compute relative path from bundle dirname to entrypoint dirname.  That's the prefix.
            // special-case the webpack and internals stuff
            devtoolModuleFilenameTemplate: function (info) {
                if (path_1.default.isAbsolute(info.absoluteResourcePath)) {
                    var relative = "" + path_1.default.relative(outputDir, info.absoluteResourcePath);
                    return relative[0] === '.' ? relative : "./" + relative;
                }
                return info.absoluteResourcePath;
                // return `webpack:///${info.resourcePath}?${info.loaders}`;
                // "../[resource-path]",
            }
        },
        mode: 'production',
        devtool: sourceMap ? 'source-map' : false,
        optimization: {
            minimize: minimize
        },
        externals: tslib_1.__assign({}, lodash_1.fromPairs(noBundle.map(function (v) { return [v, "commonjs " + v]; }))),
        // Do not provide fake versions of process, __dirname, etc.
        node: false,
        resolve: {
            extensions: tslib_1.__spread(['.js', '.json'], (enableTypescript ? ['.ts', '.tsx', '.jsx'] : []))
        },
        module: {
            rules: tslib_1.__spread(enableTypescript ? [T({
                    test: /\.ts$/,
                    exclude: /node_modules/,
                    use: [{
                            loader: require.resolve('ts-loader'),
                            options: {
                                transpileOnly: true,
                                compilerOptions: {
                                    module: 'esnext',
                                    // Must be manually set to avoid transpileOnly errors,
                                    // b/c TS compiler's transpileModule doesn't always
                                    // disable them itself.
                                    composite: undefined,
                                    incremental: undefined,
                                    declaration: undefined,
                                    declarationMap: undefined
                                }
                            }
                        }]
                })] : [], [
                // Replace all shebangs with an empty line
                // Can't use shebang-loader because it changes line numbers and
                // doesn't pass through sourcemaps
                {
                    test: /\.(?:tsx?|jsx?)$/,
                    loader: require.resolve('string-replace-loader'),
                    options: {
                        search: '^#![^\n]*?\n',
                        replace: '\n',
                        flags: ''
                    }
                }
            ], ingestSourceMaps ? [T({
                    test: /\.(js|ts|tsx|jsx)$/,
                    use: [require.resolve("source-map-loader")],
                    enforce: "pre"
                })] : [])
        },
        plugins: tslib_1.__spread(bannerPlugin)
    };
    return config;
}
exports.nodeLibrary = nodeLibrary;
function T(a) { return a; }
//# sourceMappingURL=index.js.map