/**
 * RepairIQ Sync Agent - Windows Service Installer
 *
 * Installs the RepairIQ Sync Agent as a Windows Service
 * that automatically starts on boot.
 */

const Service = require('node-windows').Service;
const path = require('path');

// Create a new service object
const svc = new Service({
  name: 'RepairIQSyncAgent',
  description: 'RepairIQ Sync Agent - Automatically uploads CCC ONE EMS files to RepairIQ',
  script: path.join(__dirname, 'dist', 'index.js'),
  nodeOptions: [
    '--harmony',
    '--max_old_space_size=4096'
  ],
  env: [
    {
      name: 'NODE_ENV',
      value: 'production'
    }
  ]
});

// Listen for the "install" event
svc.on('install', () => {
  console.log('✅ RepairIQ Sync Agent service installed successfully!');
  console.log('   Service Name: RepairIQSyncAgent');
  console.log('   Status: Ready to start');
  console.log('');
  console.log('Starting service...');
  svc.start();
});

// Listen for the "start" event
svc.on('start', () => {
  console.log('✅ RepairIQ Sync Agent service started!');
  console.log('');
  console.log('The service is now running and will:');
  console.log('  • Watch C:\\RepairIQ-EMS for new files');
  console.log('  • Automatically upload to https://repairiq.app');
  console.log('  • Start automatically on system boot');
  console.log('');
  console.log('You can check the service status in Windows Services (services.msc)');
  console.log('Look for "RepairIQSyncAgent"');
  console.log('');
  console.log('Installation complete! You can close this window.');
});

// Listen for the "alreadyinstalled" event
svc.on('alreadyinstalled', () => {
  console.log('⚠️  RepairIQ Sync Agent service is already installed.');
  console.log('');
  console.log('To reinstall:');
  console.log('  1. Run Uninstall-Service.bat');
  console.log('  2. Run Install-Service.bat again');
});

// Listen for errors
svc.on('error', (err) => {
  console.error('❌ Error installing service:', err);
  process.exit(1);
});

// Install the service
console.log('=====================================');
console.log('RepairIQ Sync Agent - Service Installer');
console.log('=====================================');
console.log('');
console.log('Installing Windows Service...');
console.log('');

svc.install();
