/**
 * RepairIQ Sync Agent - Windows Service Uninstaller
 *
 * Removes the RepairIQ Sync Agent Windows Service
 */

const Service = require('node-windows').Service;
const path = require('path');

// Create a new service object
const svc = new Service({
  name: 'RepairIQSyncAgent',
  script: path.join(__dirname, 'dist', 'index.js')
});

// Listen for the "uninstall" event
svc.on('uninstall', () => {
  console.log('✅ RepairIQ Sync Agent service uninstalled successfully!');
  console.log('');
  console.log('The service has been removed from Windows Services.');
  console.log('');
  console.log('Note: Your data folders have NOT been deleted:');
  console.log('  • C:\\RepairIQ-EMS (watch folder)');
  console.log('  • C:\\RepairIQ-EMS\\Processed (processed files)');
  console.log('  • C:\\RepairIQ-EMS\\logs (log files)');
  console.log('');
  console.log('To remove these folders, delete them manually.');
  console.log('');
  console.log('Uninstallation complete! You can close this window.');
});

// Listen for the "alreadyuninstalled" event
svc.on('alreadyuninstalled', () => {
  console.log('⚠️  RepairIQ Sync Agent service is not installed.');
  console.log('');
  console.log('Nothing to uninstall.');
});

// Listen for errors
svc.on('error', (err) => {
  console.error('❌ Error uninstalling service:', err);
  process.exit(1);
});

// Uninstall the service
console.log('=====================================');
console.log('RepairIQ Sync Agent - Service Uninstaller');
console.log('=====================================');
console.log('');
console.log('Stopping and uninstalling Windows Service...');
console.log('');

svc.uninstall();
